<?php

Redux::setSection( $opt_name, array(
    'title'  => esc_html__( 'Footer', 'edumodo' ),
    'id'     => 'edumodo-footer',
    'icon'   => 'el el-hand-down',
    'fields' => array(

        array(
            'id'       => 'edumodo_footer_layout_style',
            'type'     => 'select',
            'title'    => esc_html__('Footer Layout', 'edumodo'),
            'options'  => array(
                'layout-one'      => esc_html__('Layout 1', 'edumodo'),
                'layout-two'      => esc_html__('Layout 2', 'edumodo'),
            ),
            'default' => 'layout-one'
        ),

        array(
            'id'       => 'edumodo-footer-layout',
            'type'     => 'select',
            'title'    => esc_html__('Footer Columns', 'edumodo'),
            'options'  => array(
                'column-1'      => esc_html__('Column 1', 'edumodo'),
                'column-2'      => esc_html__('Column 2', 'edumodo'),
                'column-3'      => esc_html__('Column 3', 'edumodo'),
                'column-4'      => esc_html__('Column 4', 'edumodo'),
            ),
            'default' => 'column-4'
        ),
        array(
            'id'       => 'edumodo-footer-widget-style',
            'type'     => 'select',
            'title'    => esc_html__('Wiget List Style', 'edumodo'),
            'options'  => array(
                'block'         => esc_html__('1 Column', 'edumodo'),
                'inline-block'  => esc_html__('2 Column', 'edumodo'),
                
            ),
            'default' => 'inline-block'
        ),

        array(
            'id'       => 'enable-social',
            'type'     => 'switch',
            'title'    => esc_html__('Footer Social', 'edumodo'),
            'default'  => 1,
            'on'       => 'Enabled',
            'off'      => 'Disabled',
            'required' => array( 'edumodo_footer_layout_style' , '=' , 'layout-one' )
        ), 
        array(
            'id'    => 'footer-text-color',
            'type'  => 'color',
            'title' => esc_html__('Text Color', 'edumodo'),
            'default'  => '',
            'validate' => 'color',
        ),
        array(
            'id'    => 'footer-background-color',
            'type'  => 'color',
            'title' => esc_html__('Footer Background', 'edumodo'),
            'default'  => '',
            'validate' => 'color',
        ),
        array(
            'id'    => 'copyright-text-color',
            'type'  => 'color',
            'title' => esc_html__('Copyright Hover Text', 'edumodo'),
            'default'  => '',
            'validate' => 'color',
        ),
        array(
            'id'    => 'copyright-link-color',
            'type'  => 'color',
            'title' => esc_html__('Copyright Link Text', 'edumodo'),
            'default'  => '',
            'validate' => 'color',
        ), 
        array(
            'id'    => 'copyright-background-color',
            'type'  => 'color',
            'title' => esc_html__('Copyright Background', 'edumodo'),
            'default'  => '',
            'validate' => 'color',
        ),

        array(
            'id'       => 'edumodo-footer-social',
            'type'     => 'switch',
            'title'    => esc_html__('Footer Social', 'edumodo'),
            'default'  => true,
            'required' => array( 'edumodo_footer_layout_style' , '=' , 'layout-two' )
        ),

        array(
            'id'=>'edumodo-user-copyright-text',
            'type' => 'textarea',
            'title' => esc_html__('Copyright Text', 'edumodo'),
            'subtitle' => esc_html__('Allow html is a, br, em, strong tag', 'edumodo'),
            'default'  => esc_html__('&copy; edumodo 2020', 'edumodo'),
            'validate' => 'html_custom',
            'allowed_html' => array(
                'a' => array(
                    'href' => array(),
                    'title' => array()
                ),
                'br' => array(),
                'em' => array(),
                'strong' => array()
            ),
            // 'required' => array( 'edumodo-credit-switcher' , '=' , 0 )
        ),  

        array(
            'id'       => 'edumodo-credit-switcher',
            'type'     => 'switch',
            'title'    => esc_html__('Show Credit?', 'edumodo'),
            'subtitle' => esc_html__('Show or hide credit.', 'edumodo'),
            'default'  => true,
        ), 

        array(
            'id'=>'edumodo-user-credit-text',
            'type' => 'text',
            'title' => esc_html__('Credit Text', 'edumodo'),
            'validate' => 'html_custom',
            'required' => array( 'edumodo-credit-switcher' , '=' , 1 )
        ), 

        array(
            'id'=>'edumodo-user-credit-url',
            'type' => 'text',
            'title' => esc_html__('Credit URL', 'edumodo'),
            'validate' => 'html_custom',
            'required' => array( 'edumodo-credit-switcher' , '=' , 1 )
        ), 
  
        
    )
) );
