<?php

Redux::setSection( $opt_name, array(
    'title'  => esc_html__( 'Blog', 'edumodo' ),
    'id'     => 'edumodo-blog-options',
    'icon'   => 'el el-book',
    'fields' => array(

        array(
            'id'       => 'select_blog_layout',
            'type'     => 'select',
            'title'    => esc_html__('Blog Layout', 'edumodo'),
            'options'  => array(
                'blog_layout_list' => esc_html__('List View', 'edumodo'),
                'blog_layout_grid' => esc_html__('Grid View', 'edumodo'),
            ),
            'default'  => 'blog_layout_list',
        ),

        array(
            'id'       => 'blog_grid_column',
            'type'     => 'select',
            'title'    => esc_html__('Grid View Columns', 'edumodo'),
            'options'  => array(
                'col-md-12'      => esc_html__('Column 1', 'edumodo'),
                'col-md-6 col-sm-6'      => esc_html__('Column 2', 'edumodo'),
                'col-md-4 col-sm-6'      => esc_html__('Column 3', 'edumodo'),
                'col-md-3 col-sm-4'      => esc_html__('Column 4', 'edumodo'),
            ),
            'default' => 'col-md-12',
            'required' => array('select_blog_layout','=','blog_layout_grid'),
        ),

        array(
            'id'       => 'default-sidebar-select',
            'type'     => 'select',
            'title'    => esc_html__('Blog Page Sidebar', 'edumodo'),
            'options'  => array(
                'sidebar_left' => esc_html__('Left Sidebar', 'edumodo'),
                'sidebar_right' => esc_html__('Right Sidebar', 'edumodo'),
                'no_sidebar' => esc_html__('No Sidebar', 'edumodo'),
            ),
            'default'  => 'sidebar_right',
        ),

        array(
            'id'       => 'details-sidebar-select',
            'type'     => 'select',
            'title'    => esc_html__('Single Page Sidebar', 'edumodo'),
            'options'  => array(
                'sidebar_left' => esc_html__('Left Sidebar', 'edumodo'),
                'sidebar_right' => esc_html__('Right Sidebar', 'edumodo'),
                'no_sidebar' => esc_html__('No Sidebar', 'edumodo'),
            ),
            'default'  => 'sidebar_right',
        ),
        array(
            'id'       => 'enable-related-post',
            'type'     => 'switch',
            'title'    => esc_html__('Related Post', 'edumodo'),
            'default'  => 1,
            'on'       => 'Enabled',
            'off'      => 'Disabled',
        ),

         array(
                'id'       => 'social-share',
                'type'     => 'switch',
                'title'    => esc_html__('Single Page Social Share', 'edumodo'),
                'default'  => 1,
                'on'       => 'Enabled',
                'off'      => 'Disabled',
        ),
    )
) );
