<?php

function edumodo_import_files() {
    return array(
        array(
            'import_file_name'             => 'University V1',
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-01/content.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-01/widget_data.json',
            'local_import_redux'           => array(
                array(
                    'file_path'   => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-01/options.json',
                    'option_name' => 'edumodo_options',
                ),
            ),
            'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'screenshot.png',
            'import_notice'                => __( '<h2>Required Plugins</h2><p style="color:red">All plugins must be installed and activated if you want your site to look exactly like demo</p> <ol>
                <li>Edumodo Core</li>
                <li>CMB2</li>
                <li>Elementor</li>
                <li>Redux Framework</li>
                <li>Revolution Slider</li>
                <li>One Click Demo Import</li>
                <li>WooCommerce</li>
                <li>The Events Calendar</li>
                <li>Contact Form by WPForms</li>
                <li>MailChimp for WordPress</li>
                <li>Instagram Gallery</li>
                </ol>', 'edumodo' ),
            'preview_url'                  => 'http://edumodowp.demo.themexpert.com/university-v1/',
        ),
        array(
            'import_file_name'             => 'LearnPress V1',
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-02/content.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-02/widget_data.json',
            'local_import_redux'           => array(
                array(
                    'file_path'   => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-02/options.json',
                    'option_name' => 'edumodo_options',
                ),
            ),
            'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/data/demos/demo-02/screenshot.jpg',
            'import_notice'                => __( '<h2>Required Plugins</h2><p style="color:red">All plugins must be installed and activated if you want your site to look exactly like demo</p> <ol>
                <li>Edumodo Core</li>
                <li>LearnPress</li>
                <li>LearnPress - Course Review</li>
                <li>CMB2</li>
                <li>Elementor</li>
                <li>Redux Framework</li>
                <li>Revolution Slider</li>
                <li>One Click Demo Import</li>
                <li>WooCommerce</li>
                <li>The Events Calendar</li>
                <li>Contact Form by WPForms</li>
                <li>MailChimp for WordPress</li>
                <li>Instagram Gallery</li>
                </ol>', 'edumodo' ),
            'preview_url'                  => 'http://edumodowp.demo.themexpert.com/learnpress-v1/',
        ),
        array(
            'import_file_name'             => 'Sensei',
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-03/content.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-03/widget_data.json',
            'local_import_redux'           => array(
                array(
                    'file_path'   => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-03/options.json',
                    'option_name' => 'edumodo_options',
                ),
            ),
            'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/data/demos/demo-03/screenshot.jpg',
            'import_notice'                => __( '<h2>Required Plugins</h2><p style="color:red">All plugins must be installed and activated if you want your site to look exactly like demo</p> <ol>
                <li>Edumodo Core</li>
                <li>Sensei</li>
                <li>CMB2</li>
                <li>Elementor</li>
                <li>Redux Framework</li>
                <li>Revolution Slider</li>
                <li>One Click Demo Import</li>
                <li>WooCommerce</li>
                <li>The Events Calendar</li>
                <li>Contact Form by WPForms</li>
                <li>MailChimp for WordPress</li>
                <li>Instagram Gallery</li>
                </ol>', 'edumodo' ),
            'preview_url'                  => 'http://edumodowp.demo.themexpert.com/sensei-v1/',
        ),
        array(
            'import_file_name'             => 'LearnDash',
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-04/content.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-04/widget_data.json',
            'local_import_redux'           => array(
                array(
                    'file_path'   => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-04/options.json',
                    'option_name' => 'edumodo_options',
                ),
            ),
            'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/data/demos/demo-04/screenshot.jpg',
            'import_notice'                => __( '<h2>Required Plugins</h2><p style="color:red">All plugins must be installed and activated if you want your site to look exactly like demo</p> <ol>
                <li>Edumodo Core</li>
                <li>LearnDash LMS</li>
                <li>LearnDash Course Grid</li>
                <li>CMB2</li>
                <li>Elementor</li>
                <li>Redux Framework</li>
                <li>One Click Demo Import</li>
                <li>WooCommerce</li>
                <li>The Events Calendar</li>
                <li>Contact Form by WPForms</li>
                <li>MailChimp for WordPress</li>
                <li>Instagram Gallery</li>
                </ol>', 'edumodo' ),
            'preview_url'                  => 'http://edumodowp.demo.themexpert.com/learndash-v1/',
        ),
        array(
            'import_file_name'             => 'LearnPress V2',
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-05/content.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-05/widget_data.json',
            'local_import_redux'           => array(
                array(
                    'file_path'   => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-05/options.json',
                    'option_name' => 'edumodo_options',
                ),
            ),
            'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/data/demos/demo-05/screenshot.jpg',
            'import_notice'                => __( '<h2>Required Plugins</h2><p style="color:red">All plugins must be installed and activated if you want your site to look exactly like demo</p> <ol>
                <li>Edumodo Core</li>
                <li>LearnPress</li>
                <li>LearnPress - Course Review</li>
                <li>CMB2</li>
                <li>Elementor</li>
                <li>Redux Framework</li>
                <li>One Click Demo Import</li>
                <li>WooCommerce</li>
                <li>The Events Calendar</li>
                <li>Contact Form by WPForms</li>
                <li>MailChimp for WordPress</li>
                <li>Instagram Gallery</li>
                </ol>', 'edumodo' ),
            'preview_url'                  => 'http://edumodowp.demo.themexpert.com/learnpress-v2/',
        ),
        array(
            'import_file_name'             => 'University V2',
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-06/content.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-06/widget_data.json',
            'local_import_redux'           => array(
                array(
                    'file_path'   => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-06/options.json',
                    'option_name' => 'edumodo_options',
                ),
            ),
            'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/data/demos/demo-06/screenshot.jpg',
            'import_notice'                => __( '<h2>Required Plugins</h2><p style="color:red">All plugins must be installed and activated if you want your site to look exactly like demo</p> <ol>
                <li>Edumodo Core</li>
                <li>WidgetKit for Elementor</li>
                <li>CMB2</li>
                <li>Elementor</li>
                <li>Redux Framework</li>
                <li>One Click Demo Import</li>
                <li>WooCommerce</li>
                <li>The Events Calendar</li>
                <li>Contact Form by WPForms</li>
                <li>MailChimp for WordPress</li>
                <li>Instagram Gallery</li>
                </ol>', 'edumodo' ),
            'preview_url'                  => 'http://edumodowp.demo.themexpert.com/university-v2/',
        ),
        array(
            'import_file_name'             => 'Kids/School',
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-07/content.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-07/widget_data.json',
            'local_import_redux'           => array(
                array(
                    'file_path'   => trailingslashit( get_template_directory() ) . 'inc/data/demos/demo-07/options.json',
                    'option_name' => 'edumodo_options',
                ),
            ),
            'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/data/demos/demo-07/screenshot.jpg',
            'import_notice'                => __( '<h2>Required Plugins</h2><p style="color:red">Note: You must need edumodo-kids.zip child theme for this demo </p> <p style="color:red">All plugins must be installed and activated if you want your site to look exactly like demo</p> <ol>
                <li>Edumodo Core</li>
                <li>WidgetKit for Elementor</li>
                <li>CMB2</li>
                <li>Elementor</li>
                <li>Redux Framework</li>
                <li>One Click Demo Import</li>
                <li>WooCommerce</li>
                <li>Contact Form by WPForms</li>
                <li>Instagram Gallery</li>
                </ol>', 'edumodo' ),
            'preview_url'                  => 'http://edumodowp.demo.themexpert.com/kindergarten/',
        ),

    );
}
add_filter( 'pt-ocdi/import_files', 'edumodo_import_files' );

function edumodo_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Primary', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
            'primary' => $main_menu->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'pt-ocdi/after_import', 'edumodo_after_import_setup' );

function edumodo_demo_page_setup( $default_settings ) {
    $default_settings['parent_slug'] = 'themes.php';
    $default_settings['page_title']  = esc_html__( 'One Click Demo Import' , 'edumodo' );
    $default_settings['menu_title']  = esc_html__( 'Import Demo Data' , 'edumodo' );
    $default_settings['capability']  = 'import';
    $default_settings['menu_slug']   = 'ev-one-click-demo-import';

    return $default_settings;
}
add_filter( 'pt-ocdi/plugin_page_setup', 'edumodo_demo_page_setup' );
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );
