<?php
/**
 * Gutenberg Support
 * =================
 * responsive-embeds
 * align-wide
 * dark-editor-style
 * disable-custom-colors
 * disable-custom-font-sizes
 * editor-color-pallete
 * editor-font-sizes
 * editor-styles
 * wp-block-styles
 * ===============
 */
function edumodo_theme_supported_colors() {
    add_theme_support( 'editor-color-palette', array(
        array(
            'name' => __( 'Brand Primary', 'edumodo' ),
            'slug' => 'brand-primary',
            'color' => '#f71111',
        ),
        array(
            'name' => __( 'Brand Secondary', 'edumodo' ),
            'slug' => 'brand-secondary',
            'color' => '#ff731c',
        ),
        array(
            'name' => __( 'Purple', 'edumodo' ),
            'slug' => 'purple',
            'color' => '#9800ff',
        ),
        array(
            'name' => __( 'Body Background Color', 'edumodo' ),
            'slug' => 'body-bg',
            'color' => '#ffffff',
        ),
        array(
            'name' => __( 'Primary Text Color', 'edumodo' ),
            'slug' => 'primary-text',
            'color' => '#444444',
        ),
        array(
            'name' => __( 'Secondary Text Color', 'edumodo' ),
            'slug' => 'secondary-text',
            'color' => '#000',
        ),

    ) );
}
add_action( 'after_setup_theme', 'edumodo_theme_supported_colors' );

function edumodo_gutenberg_support(){
    add_theme_support('editor-styles');
    add_theme_support( 'align-wide' );
    add_theme_support( 'responsive-embeds' );
    add_theme_support( 'wp-block-styles' );
}
add_action( 'after_setup_theme', 'edumodo_gutenberg_support' );
/**
 * Gutenberg scripts and styles
 */
function edumodo_gutenberg_editor_scripts() {
    wp_enqueue_script(
        'be-editor',
        get_template_directory_uri() . '/dist/js/gutenberg-editor.js',
        array( 'wp-blocks', 'wp-dom' ),
        filemtime( get_stylesheet_directory() . '/dist/js/gutenberg-editor.js' ),
        true
    );
}
add_action( 'enqueue_block_editor_assets', 'edumodo_gutenberg_editor_scripts' );
function edumodo_add_editor_style(){
    wp_enqueue_style(
        'edumodo-block-editor-css',
        get_template_directory_uri(). '/dist/css/editor-style.css',
        array( 'wp-edit-blocks' )
    );
}
add_action('enqueue_block_assets', 'edumodo_add_editor_style');
/**
 * ========================
 * end of gutenberg support
 */