<?php
/**
 * Edumodo functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Edumodo
 */

define('EDUMODO_VERSION', '2.6.4');

/**
 * Twenty Edumodo only works in WordPress 4.7 or later.
 */
if (version_compare($GLOBALS['wp_version'], '4.7-alpha', '<')) {
    require get_template_directory() . '/inc/back-compat.php';
    return;
}

if (!function_exists('edumodo_setup')):
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function edumodo_setup(){
        /*
         * Make theme available for translation.
         * Translations can be filed in the /languages/ directory.
         * If you're building a theme based on edumodo, use a find and replace
         * to change 'edumodo' to the name of your theme in all the template files.
         */
        load_theme_textdomain('edumodo', get_template_directory() . '/languages');

        // Add default posts and comments RSS feed links to head.
        add_theme_support('automatic-feed-links');

        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support('title-tag');

        /*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */
        add_theme_support('post-thumbnails');

        // This theme uses wp_nav_menu() in one location.
        register_nav_menus(array(
            'primary'     => esc_html__('Primary', 'edumodo'),
            'mobile_menu' => esc_html__('Mobile Menu', 'edumodo'),
        ));

        /*
         * Enable support for Post Formats.
         * See https://developer.wordpress.org/themes/functionality/post-formats/
         */
        add_theme_support('post-formats', array(
            'image',
            'video',
            'audio',
            'gallery',
            'link',
            'quote',
        ));

        /*
         * edumodo default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
        add_theme_support('html5', array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
        ));

        // Set up the WordPress core custom background feature.
        add_theme_support('custom-background', apply_filters('edumodo_custom_background_args', array(
            'default-color' => 'ffffff',
            'default-image' => '',
        )));

        // Add theme support for selective refresh for widgets.
        add_theme_support('customize-selective-refresh-widgets');

        // Load regular editor styles into the new block-based editor.
        add_theme_support( 'editor-styles' );

        // Load default block styles.
        add_theme_support( 'wp-block-styles' );

        // Add support for full and wide align images.
        add_theme_support( 'align-wide' );

        // Add support for responsive embeds.
        add_theme_support( 'responsive-embeds' );

        // Add theme support for customizer logo
        add_theme_support('custom-logo');
        
    }
endif;
add_action('after_setup_theme', 'edumodo_setup');


/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
if (!function_exists('edumodo_content_width')) {
    function edumodo_content_width()
    {
        $GLOBALS['content_width'] = apply_filters('edumodo_content_width', 640);
    }
    add_action('after_setup_theme', 'edumodo_content_width', 0);
}

/**
 * Register custom fonts.
 */
if (!function_exists('edumodo_google_fonts_url')) {
    function edumodo_google_fonts_url()
    {
        $font_url = '';

        /* Translators: If there are any character that are
         * not supported by Poppins, translate this to off, do not
         * translate into your own language.
         */
        $poppins = _x('on', 'Poppins font:on or off', 'edumodo');

        /* Translators: If there are any character that are
         * not supported by Roboto, translate this to off, do not
         * translate into your own language.
         */
        $roboto = _x('on', 'Roboto font:on or off', 'edumodo');

        if ('off' !== $poppins || 'off' !== $roboto) {
            $font_family = array();

            if ('off' !== $poppins) {
                $font_family[] = 'Poppins:400,500,500i,700,800';
            }

            if ('off' !== $roboto) {
                $font_family[] = 'Roboto:400,400i,500,700';
            }

            $query_args = array(
                'family' => urlencode(implode('|', $font_family)),
            );

            $font_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css');
        }

        return $font_url;
    }
}
/*
 * This theme styles the visual editor to resemble the theme style,
 * specifically font, colors, and column width.
 */
add_editor_style(array('dist/css/editor-style.css', edumodo_google_fonts_url()));

/*=============================================
 * Enqueue scripts and styles
=============================================*/


if (!function_exists('edumodo_scripts')) {
    function edumodo_scripts()
    {
        global $edumodo_options;
        $enable_rtl = edumodo_array_get($edumodo_options, 'enable_rtl') ? $edumodo_options['enable_rtl'] : '';
        // Stytlesheet
        wp_enqueue_style('bootstrap', get_template_directory_uri() . '/dist/css/bootstrap.css', array(), '3.3.7', 'all');
        wp_enqueue_style('owlcarousel', get_template_directory_uri() . '/dist/css/owl.carousel.css', array(), '2.2.1', 'all');
        wp_enqueue_style('font-awesome', get_template_directory_uri() . '/dist/css/fontawesome.min.css', array(), EDUMODO_VERSION, 'all');
        wp_enqueue_style('animate-css', get_template_directory_uri() . '/dist/css/animate.min.css', array(), EDUMODO_VERSION, 'all');
        wp_enqueue_style('edubin-flaticon', get_template_directory_uri() . '/dist/fonts/flaticon.css', array(), EDUMODO_VERSION, 'all');
        wp_enqueue_style('atvimg', get_template_directory_uri() . '/dist/css/atvImg.css', array(), EDUMODO_VERSION, 'all');
        wp_enqueue_style('magnific-popup', get_template_directory_uri() . '/dist/css/magnific-popup.css', array(), EDUMODO_VERSION, 'all');
        wp_enqueue_style('edumodo-style', get_stylesheet_uri());
        wp_enqueue_style('edumodo-main-style', get_template_directory_uri() . '/dist/css/style.css', array(), EDUMODO_VERSION, 'all');

        if ($enable_rtl == true) {
            wp_enqueue_style('edumodo-main-style-rtl', get_template_directory_uri() . '/rtl.css', array(), EDUMODO_VERSION);
        }

        // Script Load
        wp_enqueue_script('classie', get_template_directory_uri() . '/dist/js/classie.js', array(), EDUMODO_VERSION, true);
        wp_enqueue_script('bootstrap', get_template_directory_uri() . '/dist/js/bootstrap.min.js', array(), EDUMODO_VERSION, true);
        wp_enqueue_script('jquery.nav-js', get_template_directory_uri() . '/dist/js/jquery.nav.js', array(), EDUMODO_VERSION, true);
        wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/dist/js/owl.carousel.min.js', array('jquery'), EDUMODO_VERSION, true);
        wp_enqueue_script('atvimg', get_template_directory_uri() . '/dist/js/atvImg-min.js', array(), EDUMODO_VERSION, true);
        wp_enqueue_script('magnific-popup', get_template_directory_uri() . '/dist/js/jquery.magnific-popup.js', array('jquery'), EDUMODO_VERSION, true);
        wp_enqueue_script('jquery-mmenu', get_template_directory_uri() . '/dist/js/jquery.mmenu.js', array('jquery'), EDUMODO_VERSION, true);
        wp_enqueue_script('edumodo', get_template_directory_uri() . '/dist/js/theme.main.js', array('jquery'), EDUMODO_VERSION, true);

        // Overright css/js
        if (class_exists('ReduxFrameworkInstances')):
            wp_add_inline_style('edumodo-main-style', esc_html(edumodo_array_get($edumodo_options, 'edumodo_custom_css')));
            wp_add_inline_script('edumodo', esc_js(edumodo_array_get($edumodo_options, 'edumodo_custom_js')));
        endif;

        if (is_singular() && comments_open() && get_option('thread_comments')) {
            wp_enqueue_script('comment-reply');
        }
    }
    add_action('wp_enqueue_scripts', 'edumodo_scripts');

}

/*=============================================
=   Gutenberg Blocks enqueue style
=============================================*/

function gutenberg_blocks_editor_assets() {

    wp_enqueue_style('editor-blocks.css', get_template_directory_uri() . '/dist/css/editor-blocks.css', array(), EDUMODO_VERSION, 'all');
};

add_action( 'enqueue_block_editor_assets', 'gutenberg_blocks_editor_assets');


/*=============================================
=   Custom image size for theme options and others
=============================================*/

if (!function_exists('edumodo_image_sizes_by_array')) {
    function edumodo_image_sizes_by_array(){

        $get_intermediate_image_sizes = get_intermediate_image_sizes();
        $get_intermediate_image_sizes = array_merge($get_intermediate_image_sizes, array('full', 'tx_course_archive'));

        $all_sizes = array();

        foreach ($get_intermediate_image_sizes as $size_key) {

            $size_key_title       = str_replace('_', ' ', $size_key);
            $size_key_title       = str_replace('-', ' ', $size_key_title);
            $all_sizes[$size_key] = ucwords($size_key_title);
        }

        return $all_sizes;

    }
    add_image_size('tx_course_archive', 380, 230, true);
}

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * Load edumodo widgets
 */
require get_template_directory() . '/inc/widgets/widgets.php';

/**
 * Load Redux framework
 */

require_once get_template_directory() . '/inc/theme-options.php';

/**
 * Edumodo theme support
 */
require get_template_directory() . '/inc/theme-support.php';

/**
 * theme primary style
 */
require get_template_directory() . '/inc/style.php';

/**
 * TX Megamenu
 */
require get_template_directory() . '/inc/tx-megamenu/tx_mega_menu.php';

/*
 * tgm plugin class
 * */
require get_template_directory() . '/plugin/class-tgm-plugin-activation.php';

/*
 * TGM plugin activation
 * */
require get_template_directory() . '/inc/plugin-activation.php';

/**
 *  TX Wizard importer
 */
require_once get_template_directory() . '/inc/wizard/wizard.php';

/**
 * Gutenberg Support
 */
require get_template_directory() . '/inc/gutenberg-support.php';



