<?php 
    $post_id = edumodo_get_id();
    // Global Options
    global $edumodo_options;
    // Prefix
    $prefix = '_edumodo_';
    // view counter
    setPostViews(get_the_ID());
    // Page title enable
    $title_enable = get_post_meta($post_id, $prefix . 'title_enable', true);

    // sidebar position
    $sidebar_details   = edumodo_array_get($edumodo_options, 'details-sidebar-select') ? $edumodo_options['details-sidebar-select'] : '';
    
    // LearnDash single course page
    $learndash_single_layout_select   = edumodo_array_get($edumodo_options, 'learndash_single_layout_select') ? $edumodo_options['learndash_single_layout_select'] : '';
    $learndash_single_sidebar_style   = edumodo_array_get($edumodo_options, 'learndash_single_sidebar_style') ? $edumodo_options['learndash_single_sidebar_style'] : '';
    $enable_learndash_single_related_courses   = edumodo_array_get($edumodo_options, 'enable_learndash_single_related_courses') ? $edumodo_options['enable_learndash_single_related_courses'] : '';
    $related_see_more_text   = edumodo_array_get($edumodo_options, 'related_see_more_text') ? $edumodo_options['related_see_more_text'] : '';
    $enable_learndash_single_related_dsc   = edumodo_array_get($edumodo_options, 'enable_learndash_single_related_dsc') ? $edumodo_options['enable_learndash_single_related_dsc'] : '';
    $learndash_single_related_dsc_length   = edumodo_array_get($edumodo_options, 'learndash_single_related_dsc_length') ? $edumodo_options['learndash_single_related_dsc_length'] : '';
    $enable_learndash_single_last_update   = edumodo_array_get($edumodo_options, 'enable_learndash_single_last_update') ? $edumodo_options['enable_learndash_single_last_update'] : '';
    $enable_learndash_single_tags   = edumodo_array_get($edumodo_options, 'enable_learndash_single_tags') ? $edumodo_options['enable_learndash_single_tags'] : '';
$learndash_single_related_course_layout   = edumodo_array_get($edumodo_options, 'learndash_single_related_course_layout') ? $edumodo_options['learndash_single_related_course_layout'] : '';
?>

<?php
    while ( have_posts() ) : the_post();
       $img_category  = get_post_meta( get_the_ID(), '_edumodo_header_img', true ); 
       global $post; $post_id = $post->ID;
       $course_id = $post_id;
       $user_id   = get_current_user_id();
       $current_id = $post->ID;

       $enable_video = get_post_meta( $post->ID, '_learndash_course_grid_enable_video_preview', true );
       $embed_code   = get_post_meta( $post->ID, '_learndash_course_grid_video_embed_code', true );
       $button_text  = get_post_meta( $post->ID, '_learndash_course_grid_custom_button_text', true );

                                // Retrive oembed HTML if URL provided
       if ( preg_match( '/^http/', $embed_code ) ) {
        $embed_code = wp_oembed_get( $embed_code, array( 'height' => 600, 'width' => 400 ) );
    }

    $button_text = isset( $button_text ) && ! empty( $button_text ) ? $button_text : __( 'See more...', 'edumodo' );

    $button_text = apply_filters( 'learndash_course_grid_custom_button_text', $button_text, $post_id );

    $options = get_option('sfwd_cpt_options');
    $currency = null;

    if ( ! is_null( $options ) ) {
        if ( isset($options['modules'] ) && isset( $options['modules']['sfwd-courses_options'] ) && isset( $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'] ) )
            $currency = $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'];
    }

    if( is_null( $currency ) )
        $currency = 'USD';

    $course_options = get_post_meta($post_id, "_sfwd-courses", true);
    $price = $course_options && isset($course_options['sfwd-courses_course_price']) ? $course_options['sfwd-courses_course_price'] : __( 'Free', 'edumodo' );
    $short_description = @$course_options['sfwd-courses_course_short_description'];

    $has_access   = sfwd_lms_has_access( $course_id, $user_id );
    $is_completed = learndash_course_completed( $user_id, $course_id );

    if( $price == '' )
        $price .= __( 'Free', 'edumodo' );

    if ( is_numeric( $price ) ) {
        if ( $currency == "USD" )
            $price = '$' . $price;
        else
            $price .= ' ' . $currency;
    }

    $class       = '';
    $ribbon_text = '';

    if ( $has_access && ! $is_completed ) {
        $class = 'ld_course_grid_price ribbon-enrolled';
        $ribbon_text = __( 'Enrolled', 'edumodo' );
    } elseif ( $has_access && $is_completed ) {
        $class = 'ld_course_grid_price';
        $ribbon_text = __( 'Completed', 'edumodo' );
    } else {
        $class = ! empty( $course_options['sfwd-courses_course_price'] ) ? 'ld_course_grid_price price_' . $currency : 'ld_course_grid_price free';
        $ribbon_text = $price;
    }

    ?>


    <div class="lp-course3-heading" style="background-image: url('<?php echo esc_url($img_category); ?>');"> 
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <h2 class="lp-title"><?php the_title(); ?></h2>
                    <div class="lp_excerpt">
                        <div class="single-excerpt">
                            <?php echo $short_description; ?>
                        </div>
                        
                        <div class="course-meta-top ld-course-meta-top">
                            <?php if ( 1 == $enable_learndash_single_tags): ?>
                                <?php $post_tags = get_the_tags();
                                if ( $post_tags ) { ?>
                                    <span class="ld-post-by">
                                        <?php
                                        esc_html_e( 'Post in : ', 'edumodo' );
                                        $i=5;
                                        foreach( $post_tags as $tag ) {
                                            echo $tag->name; 
                                            ?>
                                        </span> 
                                    <?php       }
                                } 
                                ?> 
                            <?php endif ?>

                            <?php if ( 1 == $enable_learndash_single_last_update): ?>
                                <span class="lp-update ld-update">
                                    <?php esc_html_e( 'Last updated: ', 'edumodo' ); ?> 
                                    <?php the_modified_date(); ?>   
                                </span>
                            <?php endif ?>
                        </div>
                    </div>
                </div>
                <div class="col-md-4"></div>
            </div>
        </div>
    </div>      

    <div class="container">
        <div class="row">
            <div class="lpcourse-course-wapper-3 ld-lpcourse-course-wapper ld-single-layout-2">
                <div class="lpcourse-main">
            <div class="col-md-8"> 
                <div id="learn-press-course" class="course-summary ld-course-summary">
                    <?php the_content(); ?>
                </div>
                <?php if ($learndash_single_related_course_layout == 'ld_related_grid') {
                        edumodo_learndash_related_courses_grid(); 
                    }
                ?>
            </div>

            <div class="col-md-4"> 
                
                <div class="lpcourse-sidebar ldcourse-sidebar <?php if ( 1 == $learndash_single_sidebar_style): echo 'sidebar-devider'; endif; ?> <?php if (!has_post_thumbnail()) : echo 'hidden'; endif; ?> ?>">
                    <div class="course-video">

                    <?php if (has_post_thumbnail()) { ?>
                        <figure class="post-thumbnail">
                            <a href="<?php the_permalink(); ?>">
                                <?php the_post_thumbnail();?>
                            </a>
                        </figure>
                    <?php } ?>

                        <div class="lp-course-meta">
                            <div class="single-price">  
                                <div class="course-price">
                                    <?php if ( $post->post_type == 'sfwd-courses' ) : ?>
                                        <div class="<?php echo esc_attr( $class ); ?>">
                                            <?php echo esc_attr( $ribbon_text ); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>                      
                            </div>

                            <div class="lp-course-buttons"> 
                                <?php echo do_shortcode('[learndash_payment_buttons course_id="'.$current_id.'"]'); ?>
                            </div>  
                        </div>

                        <?php if ( 0 == $learndash_single_sidebar_style): ?>
                         <?php get_sidebar(); ?>
                         <?php if ($learndash_single_related_course_layout == 'ld_related_list') :
                            edumodo_learndash_related_courses();  
                            endif; endif; 
                        ?> 
                    </div>
                </div>

                <?php if ( 1 == $learndash_single_sidebar_style): ?>
                 <?php get_sidebar(); ?>
                <?php if ($learndash_single_related_course_layout == 'ld_related_list') :
                    edumodo_learndash_related_courses(); 
                    endif; endif; 
                ?> 

           </div>

       </div>
   </div>
</div>
</div><!-- .container -->

<?php endwhile; // End of the loop. ?>