<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
/**
 * Class Wizard
 */
if ( ! class_exists( 'Wizard' ) ) {
	class Wizard {
		/**
		 * @var null
		 */
		protected static $_instance = null;

		/**
		 * @var string
		 */
		public static $prefix = 'tx_';

		/**
		 * @var string
		 */
		public static $slug = 'edumodo';

		/**
		 * @var string
		 */
		private static $option_version = 'tx_wizard_version';

		/**
		 * Return unique instance of TP.
		 */
		static function instance() {
			if ( ! self::$_instance ) {
				self::$_instance = new self();
			}

			return self::$_instance;
		}

		/**
		 * TX_Framework constructor.
		 */
		private function __construct() {
			$this->init();

			do_action( 'tx_wizard_loaded' );
		}

		/**
		 * Init class.
		 */
		public function init() {
			do_action( 'before_tx_wizard_init' );

			$this->define_constants();
			$this->providers();

			spl_autoload_register( array( $this, 'autoload' ) );

			$this->admin();

			add_action('after_switch_theme', array($this, 'redirect_to_get_started'));

			do_action( 'tx_wizard_init' );
		}

		/**
		 * Define constants.
		 */
		private function define_constants() {
			$this->define( 'TX_WIZARD_FILE', __FILE__ );
			$this->define( 'TX_WIZARD_PATH', dirname( __FILE__ ) );

			$this->define( 'TX_WIZARD_URI', get_theme_file_uri('inc/wizard') );
			$this->define( 'TX_WIZARD_ASSETS_URI', TX_WIZARD_URI . '/assets' );
			$this->define( 'TX_WIZARD_VERSION', '2.3' );

			$this->define( 'TX_WIZARD_ADMIN_PATH', TX_WIZARD_PATH . '/admin' );
			$this->define( 'TX_WIZARD_ADMIN_URI', TX_WIZARD_URI . '/admin' );
		}

		/**
		 * Define constant.
		 *
		 * @param $name
		 * @param $value
		 */
		private function define( $name, $value ) {
			if ( ! defined( $name ) ) {
				define( $name, $value );
			}
		}


		/**
		 * Autoload classes.
		 *
		 * @param $class
		 *
		 * @return bool
		 */
		public function autoload( $class ) {
			$class = strtolower( $class );

			$file_name = 'class-' . str_replace( '_', '-', $class ) . '.php';

			/**
			 * Helper classes.
			 */
			if ( strpos( $class, 'helper' ) !== false ) {
				$path = TX_WIZARD_PATH . '/helpers/' . $file_name;

				return $this->_require( $path );
			}


			/**
			 * Admin
			 */
			$path = TX_WIZARD_ADMIN_PATH . DIRECTORY_SEPARATOR . $file_name;
			if ( is_readable( $path ) ) {
				return $this->_require( $path );
			}

			return false;
		}

		/**
		 * Require file.
		 *
		 * @param $path
		 *
		 * @return bool
		 */
		private function _require( $path ) {
			if ( ! is_readable( $path ) ) {
				return false;
			}

			require_once $path;

			return true;
		}

		/**
		 * Providers.
		 */
		private function providers() {
			require_once TX_WIZARD_PATH . '/providers/class-tx-singleton.php';
		}

		/**
		 * Admin.
		 */
		private function admin() {
			require_once TX_WIZARD_PATH . '/admin/class-tx-wizard-admin.php';
		}

		/**
		 * Redirect to Get Started.
		 */
		public function redirect_to_get_started() {
			if( ! TX_Getting_Started::already_visited() ) {
				wp_redirect(admin_url('admin.php?page=tx-getting-started'));
			}
		}


	}

	Wizard::instance();
}// End if().
