<?php

/**
 * Class TX_Modal.
 */
class TX_Modal extends TX_Singleton {
	/**
	 * TX_Modal constructor.
	 */
	protected function __construct() {
		$this->init_hooks();
	}

	/**
	 * Init hooks.
	 */
	private function init_hooks() {
		add_action( 'admin_footer', array( $this, 'add_iframe_template' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'admin_footer', array( $this, 'register_modal_place' ) );
	}

	/**
	 * Register modal place.
	 */
	public function register_modal_place() {
		?>
        <div class="txw-modals-wrapper">
			<?php
			do_action( 'tx_wizard_list_modals' );
			?>
        </div>
		<?php
	}

	/**
	 * Enqueue scripts.
	 */
	public function enqueue_scripts() {
		wp_register_script( 'tx-modal', TX_WIZARD_ADMIN_URI . '/assets/js/modal.js', array( 'jquery', 'backbone' ), TX_WIZARD_VERSION );
		wp_register_script( 'tx-modal-v2', TX_WIZARD_ADMIN_URI . '/assets/js/modal-v2.js', array( 'jquery', 'backbone' ), TX_WIZARD_VERSION );
	}

	/**
	 * Add iframe template.
	 */
	public function add_iframe_template() {
		TX_Template_Helper::template( 'modals/iframe.php', array(), true );
	}

	/**
	 * Add modal.
	 *
	 * @param array $args
	 *
	 * @return bool
	 */
	public static function render_modal( $args ) {
		$args = wp_parse_args( $args, array(
			'template' => '',
			'id'       => '',
		) );

		$html = TX_Template_Helper::template( $args['template'], $args );
		if ( ! $html ) {
			return false;
		}
		$args['html'] = $html;

		return TX_Template_Helper::template( 'modals/master.php', $args, true );
	}

	/**
	 * Enqueue script thim modal. You need call this function if you want to add modal.
	 */
	public static function enqueue_modal() {
		wp_enqueue_script( 'tx-modal' );
	}
}
