<?php

/**
 * Class TX_Error
 *
 */
class TX_Error extends Exception {
	/**
	 * @var string
	 */
	private $how_to = '';

	/**
	 * List error code.
	 *
	 * @var array
	 */
	public static $errors_code = array(
		'#000_UNKNOWN_ERROR',
		'#001_REQUEST_ERROR',
		'#002_SERVER_ERROR',
		'#003_STEP_NOT_FOUND',
		'#004_BAD_REQUEST',
		'#005_FILE_NOT_FOUND',
		'#006_PERMISSION_DENIED',
		'#007_FILE_BROKEN',
		'#008_DOWNLOAD_FAILED',
		'#009_INSTALL_PLUGIN'
	);

	/**
	 * Set text how to.
	 *
	 * @param $how_to
	 */
	public function setHowTo( $how_to ) {
		$this->how_to = $how_to;
	}

	/**
	 * Get text how to fixes error.
	 *
	 * @return string
	 */
	public function getHowTo() {
		return $this->how_to;
	}

	/**
	 * Get error code.
	 *
	 * @return string
	 */
	public function getErrorCode() {
		$error_code_index = $this->getCode();

		if ( $error_code_index >= count( self::$errors_code ) ) {
			return self::$errors_code[0];
		}

		return self::$errors_code[ $error_code_index ];
	}

	/**
	 * Create TX_Error.
	 *
	 * @param string $message
	 * @param int $code
	 * @param string $how_to
	 *
	 * @return TX_Error
	 */
	public static function create( $message, $code = 0, $how_to = '' ) {
		$exception = new self( $message, $code );
		$exception->setHowTo( $how_to );

		return $exception;
	}
}
