<?php

/**
 * Class TX_Admin_Sub_Page
 */
abstract class TX_Admin_Sub_Page extends TX_Singleton {
	/**
	 * Get template in dashboard.
	 *
	 * @param $template
	 * @param null $args
	 *
	 * @return bool
	 */
	public static function get_template( $template, $args = null ) {
		return TX_Dashboard::get_template( $template, $args );
	}

	/**
	 * @var null
	 */
	public $key_page = null;

	/**
	 * @return bool
	 */
	protected function is_myself() {
		return $this->is_page( $this->key_page );
	}

	/**
	 * Get link page myself.
	 *
	 * @return string
	 */
	protected function get_link_myself() {
		return TX_Dashboard::get_link_page_by_slug( $this->key_page );
	}

	/**
	 * Is page?
	 *
	 * @param $key_page
	 *
	 * @return bool
	 */
	protected function is_page( $key_page ) {
		$current_page = TX_Dashboard::get_current_page_key();

		if ( $current_page == $key_page ) {
			return true;
		}

		return false;
	}

	/**
	 * TX_Admin_Sub_Page constructor.
	 */
	protected function __construct() {
		if ( is_null( $this->key_page ) ) {
			wp_die( __( 'variable <strong>key_page</strong> must be over-ridden in a sub-class.', 'edumodo' ) );
		}

		$this->hooks();
	}

	/**
	 * Initialize hooks.
	 */
	private function hooks() {
		add_action( "tx_dashboard_main_page_$this->key_page", array( $this, 'main_template' ) );
	}

	/**
	 * Main template for this page.
	 */
	public function main_template() {
		$file_template = "$this->key_page.php";

		self::get_template( $file_template, $this->get_template_args() );
	}

	/**
	 * Get arguments for template.
	 *
	 * @return null
	 */
	protected function get_template_args() {
		return null;
	}
}
