(function ($) {
    var TX_Modal_Wrapper = Backbone.View.extend({
        el: '.txw-modals-wrapper',

        events: {
            'click .close': 'onClickClose'
        },

        initialize: function () {
            $(document).on('click', '.tx-wizard-open-modal', this.onClickOpen.bind(this));
            $(window).on('tx_wizard_trigger_open_modal', this.onTriggerClickOpen.bind(this));
        },

        onTriggerClickOpen: function (e, id) {
            if (!id) {
                return;
            }

            this.open(id);
        },

        onClickOpen: function (e) {
            e.preventDefault();
            var $current = $(e.currentTarget);

            var refModal = $current.attr('data-modal');
            if (!refModal) {
                return;
            }

            this.open(refModal);
        },

        onClickClose: function (e) {
            var $modal = this.$(e.currentTarget).closest('.txw-modal');
            var id = '#' + $modal.attr('id');
            this.close(id);
        },

        open: function (id) {
            var $modal = this.$('#' + id);
            if (!$modal.length) {
                return;
            }

            this.render(id);
            $modal.addClass('md-show');
            $(window).trigger('tx_wizard_open_modal', id);
        },

        close: function (selector) {
            $(selector).removeClass('md-show');
            $(window).trigger('tx_wizard_close_modal', selector);
        },

        template: function (id, data) {
            return wp.template(id)(data);
        },

        render: function (id) {
            this.$('#' + id).html(this.template(id, null));
        }
    });

    window.TX_Core_Modal = (function () {

    })();

    $(document).ready(function () {
        new TX_Modal_Wrapper();
    });
})(jQuery);
