<?php
/**
 * 
 *
 * @package WordPress
 * @subpackage Edumodo Stylesheet..
 * @since edumodo 1.0.0
 */


if(class_exists( 'ReduxFrameworkInstances')):
	add_action( 'wp_head', 'edumodo_stylesheet' );
endif;

function edumodo_stylesheet() {
	global $edumodo_options;
	// Theem color
	$enable_edumodo_custom_style   = edumodo_array_get($edumodo_options, 'enable-edumodo-custom-style') ? $edumodo_options['enable-edumodo-custom-style'] : '';
	$body_color   = edumodo_array_get($edumodo_options, 'body_color') ? $edumodo_options['body_color'] : '';
	$theme_primary_color   = edumodo_array_get($edumodo_options, 'primary_color') ? $edumodo_options['primary_color'] : '';
	$theme_secondary_color   = edumodo_array_get($edumodo_options, 'secondary_color') ? $edumodo_options['secondary_color'] : '';
	// Theme fonts
	$body_font   = edumodo_array_get($edumodo_options, 'body_font') ? $edumodo_options['body_font'] : '';
	$menu_font   = edumodo_array_get($edumodo_options, 'menu_font') ? $edumodo_options['menu_font'] : '';
	$heading_font   = edumodo_array_get($edumodo_options, 'heading_font') ? $edumodo_options['heading_font'] : '';
	// Theme menu
	$menu_active_color   = edumodo_array_get($edumodo_options, 'menu_active_color') ? $edumodo_options['menu_active_color'] : '';
	$menu_area_height   = edumodo_array_get($edumodo_options, 'menu_area_height') ? $edumodo_options['menu_area_height'] : '';
	$header_area_height   = edumodo_array_get($edumodo_options, 'header_area_height') ? $edumodo_options['header_area_height'] : '';
	$enable_custom_header_height   = edumodo_array_get($edumodo_options, 'enable_custom_header_height') ? $edumodo_options['enable_custom_header_height'] : '';
	$enable_scroll_top   = edumodo_array_get($edumodo_options, 'enable_scroll_top') ? $edumodo_options['enable_scroll_top'] : '';
	$scroll_top_style   = edumodo_array_get($edumodo_options, 'scroll_top_style') ? $edumodo_options['scroll_top_style'] : '';
	$hide_scroll_top_mobile   = edumodo_array_get($edumodo_options, 'hide_scroll_top_mobile') ? $edumodo_options['hide_scroll_top_mobile'] : '';

	// Footer widget column
	$footer_widget_column   = edumodo_array_get($edumodo_options, 'edumodo-footer-widget-style') ? $edumodo_options['edumodo-footer-widget-style'] : '';

	// Footer color
	$footer_text_color   = edumodo_array_get($edumodo_options, 'footer-text-color') ? $edumodo_options['footer-text-color'] : '';
	// Footer Bg color
	$footer_bg_color   = edumodo_array_get($edumodo_options, 'footer-background-color') ? $edumodo_options['footer-background-color'] : '';
	$copyright_text_color   = edumodo_array_get($edumodo_options, 'copyright-text-color') ? $edumodo_options['copyright-text-color'] : '';
	$copyright_link_color   = edumodo_array_get($edumodo_options, 'copyright-link-color') ? $edumodo_options['copyright-link-color'] : '';
	$copyright_background_color   = edumodo_array_get($edumodo_options, 'copyright-background-color') ? $edumodo_options['copyright-background-color'] : '';
	$hide_mobile_learndash_single_related_courses   = edumodo_array_get($edumodo_options, 'hide_mobile_learndash_single_related_courses') ? $edumodo_options['hide_mobile_learndash_single_related_courses'] : '';
	// LearnDash
	$enable_learndash_single_last_update   = edumodo_array_get($edumodo_options, 'enable_learndash_single_last_update') ? $edumodo_options['enable_learndash_single_last_update'] : '';
	$enable_learndash_single_tags   = edumodo_array_get($edumodo_options, 'enable_learndash_single_tags') ? $edumodo_options['enable_learndash_single_tags'] : '';
	$edumodo_lp_grid_column   = edumodo_array_get($edumodo_options, 'edumodo_lp_grid_column') ? $edumodo_options['edumodo_lp_grid_column'] : ''; 

	// Preloader
	$enable_preloader   = edumodo_array_get($edumodo_options, 'enable_preloader') ? $edumodo_options['enable_preloader'] : '';
	$preloder_background   = edumodo_array_get($edumodo_options, 'preloder_background') ? $edumodo_options['preloder_background'] : '';
	$preloder_color   = edumodo_array_get($edumodo_options, 'preloder_color') ? $edumodo_options['preloder_color'] : '';

?>

<style>
	/* Preloader */
	<?php if ($enable_preloader == true ) : ?>
		.edumodo-preloader{
			background: <?php echo esc_attr($preloder_background);?>;
		}
		.edumodoloader{
			border-color:<?php echo esc_attr($preloder_color);?>;
		}
		.edumodoloader-inner{
			background-color:<?php echo esc_attr($preloder_color);?>;
		}
	<?php endif; ?>

	<?php //if($enable_mega_menu == '1') : ?>
		   
	.edumodo-header li.tx_megamenu.row .nav {
	  position: relative !important;
	}

/*	.edumodo-header li.tx_megamenu.row {
	  position: static !important;
	}*/

/*	.edumodo-header li.tx_megamenu.row ul.dropdown-menu {
	  width: 100%;
	  z-index: 100000;
	}*/

/*	.edumodo-header .navbar-v1 .navigation-main li.tx_megamenu.row ul {
	    top: 100%;;
	}*/

	.edumodo-header .navbar-v1 .navigation-main li.tx_megamenu.row li > ul.dropdown-menu {
	  position: relative;
	  left: 0;
	  top: 100%;
	  background: transparent;
	  display: block;
	  padding: 0;
	  -moz-animation: fadeInDownMenu 0s ease-in;
	  -webkit-animation: fadeInDownMenu 0s ease-in;
	  animation: fadeInDownMenu 0s ease-in;
	  -webkit-transition: all 0s ease;
	  -moz-transition: all 0s ease;
	  -o-transition: all 0s ease;
	  transition: all 0s ease;

	}

	.edumodo-header .navbar-v1 .navigation-main li.tx_megamenu.row ul.edumodo-sub-menu {
	  border: 0px solid #fff;
	  border-radius: 0;
	  background: #fff;
	}

/*	.edumodo-header .navbar-v1 .navigation-main li.tx_megamenu.row ul.edumodo-sub-menu li{
	   border-top: 1px solid #f5f5f5;
	}*/

	.edumodo-header .navbar-v1 .navigation-main li.tx_megamenu.row ul li {
	  margin: 0;
	  padding: 0;
	}

	.edumodo-header span.logout-btn{
	    background: <?php echo esc_attr($menu_active_color);?>;
	    border: 2px solid <?php echo esc_attr($menu_active_color);?>;
	}
	.edumodo-header span.logout-btn:hover{
	    color: <?php echo esc_attr($menu_active_color);?> !important;
	    border-color: <?php echo esc_attr($menu_active_color);?>;
	    
	}


	.edumodo-header .navbar-v1 .navigation-main li.tx_megamenu.row ul.edumodo-sub-menu li.dropdown.tx_megamenu > li.tx_megamenu_heading > a {
	  padding: 8px 15px 8px 15px;
	}

/*	.edumodo-header .navbar-v1 .navigation-main li.tx_megamenu.row li{
	  border-bottom: none;
	}*/

	.edumodo-header .navbar-v1 .navigation-main li.tx_megamenu.row ul.edumodo-sub-menu > li.tx_megamenu_heading .sub-heading{
	  	font-weight: 500;
	  	color: inherit;
	    text-transform: uppercase;
    	letter-spacing: 1px;
    	font-size: 12px;;
	}

	.edumodo-header .navbar-v1 .navigation-main li.tx_megamenu.row ul.edumodo-sub-menu li.dropdown.tx_megamenu{
		padding: 0 12px 12px 12px;
    	box-shadow: inset 0 0 1px #f5f5f5;
	}

	.edumodo-header .navbar-v1 .navigation-main > li > a:first-child {
	    padding-left: 8px;
	    padding-right: 8px;
	    line-height: 55px;

	}
/*
	.edumodo-header .dropdown.tx_megamenu.row {
		padding-right: 15px;
	    padding-left: 15px;
	}*/
	.edumodo-header .navbar-v1 .navigation-main li.tx_megamenu.row ul.edumodo-sub-menu li.tx_megamenu_border_right {
	    border-right: 1px solid #f5f5f5;
	}

	/* menu widget Style*/
	.edumodo-header li.tx_megamenu.row .tx_megamenu_widget_area {
	  padding: 0;
	}
	.edumodo-header .navbar-v1 .navigation-main li.tx_megamenu.row .tx_megamenu_widget_area a {
    	padding: 10px 15px 10px 15px;
	}
	.edumodo-header .navbar-v1 .navigation-main li.tx_megamenu.row ul.edumodo-sub-menu > li.tx_megamenu_heading.tx_megamenu_heading_hide > a:last-child{
	    display: none !important;
	}
	.edumodo-header li.tx_megamenu.row .dropdown-menu > li > a {
	    line-height: inherit;
	    font-weight: 700;
	}
	.edumodo-header .navbar-v1 .navigation-main li.tx_megamenu.row ul{
	  box-shadow: none;
	}
	.edumodo-header .navbar-v1 .navigation-main li.tx_megamenu.row .tx_megamenu_widget_area h3.widget-title {
		font-size: 13px;
	    padding-left: 15px;
	    font-weight: 500;
	    letter-spacing: 0.5px
	}

<?php// endif; // Mega menu end ?>


	.edumodo-header .navbar-v1 .navigation-main a:hover, 
	.edumodo-header .navbar-v1 .navigation-main li:hover > a, 
	.edumodo-header .navbar-v1 .navigation-main .current-menu-item > a, 
	.edumodo-header .navbar-v1 .navigation-main .current-menu-ancestor > a{
		color: <?php echo esc_attr($theme_primary_color);?>;
	}
/*	.edumodo-header .navbar-v1 .active a, .navigation-main .active .menu-indicate{
		color: <?php echo esc_attr($menu_active_color);?>;
	} */
	


	.edumodo-header .navbar-v1 li.current-menu-item.active > a{
		color: <?php echo esc_attr($menu_active_color);?>;
	}  


	<?php if (class_exists( 'LearnPress' ) && $edumodo_lp_grid_column == 'column_4'): ?>
			@media (min-width:992px) {
			    .learn-press-courses li.course {
			        width: 23% !important;
			    }
			}
	<?php endif; ?>

	<?php if (1 == $hide_mobile_learndash_single_related_courses):?> 
		/* --- Learndash single page releted course  -- */ 
		@media (max-width: 767px) {
			.leaarndash-releted-course{
				display: none;
			}
		}
	<?php endif; ?>

	<?php if (1 == $enable_learndash_single_last_update and 0 == $enable_learndash_single_tags):?> 
		/* --- Learndash single page last update tag :before-- */ 
			.lp-course3-heading .course-meta-top .lp-update.ld-update::before{
				content: none;
			}
			.lp-course3-heading .course-meta-top .lp-update.ld-update {
			    margin-left: 0;
			}
	<?php endif; ?>

	<?php if ($theme_primary_color):?> 
			/* --- Video Play btn-- */ 
			.edumodo-play-btn{
			    background: radial-gradient(<?php echo esc_attr($theme_primary_color);?> 60%, #ffffff 62%);
			}
	<?php endif; ?>
	<?php if ($theme_primary_color):?> 
		/* --- scrollTop -- */ 
	.comments-area .comment-respond input[type="text"]:focus, .comments-area .comment-respond input[type="email"]:focus, .comments-area .comment-respond input[type="url"]:focus, .comments-area .comment-respond input[type="password"]:focus, .comments-area .comment-respond input[type="search"]:focus, .comments-area .comment-respond input[type="number"]:focus, .comments-area .comment-respond input[type="tel"]:focus, .comments-area .comment-respond input[type="range"]:focus, .comments-area .comment-respond input[type="date"]:focus, .comments-area .comment-respond input[type="month"]:focus, .comments-area .comment-respond input[type="week"]:focus, .comments-area .comment-respond input[type="time"]:focus, .comments-area .comment-respond input[type="datetime"]:focus, .comments-area .comment-respond input[type="datetime-local"]:focus, .comments-area .comment-respond input[type="color"]:focus, .comments-area .comment-respond textarea:focus{
	border-color: <?php echo esc_attr($theme_primary_color);?>;
    outline-color: <?php echo esc_attr($theme_primary_color);?>;
    border: 1px solid <?php echo esc_attr($theme_primary_color);?>;
}
	<?php endif; ?>	
	<?php if ($theme_primary_color):?> 
		/* --- scrollTop -- */ 
		#scrollTop{
			background-color: <?php echo esc_attr($theme_primary_color);?>;
			border-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		#scrollTop:hover{
			background-color: <?php echo esc_attr($theme_primary_color);?>90;
			border-color: <?php echo esc_attr($theme_primary_color);?>90;
		}
	<?php endif; ?>	

	<?php if ($scroll_top_style == 'style_2') : ?>
		#scrollTop {
		    border-radius: 100%;
		}
	<?php endif; ?>

	<?php if ($enable_scroll_top == true and $hide_scroll_top_mobile == true) : ?>
		@media (max-width: 767px) {
		 #scrollTop.show{
		 	display:none !important;
		 }
		}
	<?php endif; ?>
	
		<?php if($enable_custom_header_height == true) :?>
			.edumodo-header div#edumodo-mainnav{
				height: <?php echo esc_attr($menu_area_height);?>px;
			}
		<?php endif; ?>

		<?php if(!empty($menu_active_color)) :?>
			#tophead a.topbar-btn, span.register-btn{
				background-color: <?php echo esc_attr($menu_active_color);?> !important;
				border-color: <?php echo esc_attr($menu_active_color);?> !important;
			}
		<?php endif; ?>	

		<?php if(!empty($menu_active_color)) :?>
			span.register-btn:hover{
				border-color: <?php echo esc_attr($menu_active_color);?> !important;
				background:#fff !important;
				color:<?php echo esc_attr($menu_active_color);?> !important;
			}
		<?php endif; ?>				
		<?php if(!empty($menu_active_color)) :?>
			.edumodo-header a.micon{
				background-color: <?php echo esc_attr($menu_active_color);?>;
			}
		<?php endif; ?>		
		<?php if(!empty($menu_active_color)) :?>
			#tophead .tophead-contact .fa, #tophead .tophead-address .fa, #tophead .tophead-contact a:hover, #tophead .tophead-right.top-v4 a:hover, span.register-btn:hover a{
				color: <?php echo esc_attr($menu_active_color);?>;
			}
		<?php endif; ?>

		<?php if($enable_custom_header_height == true) :?>
		header .page-details{
				min-height: <?php echo esc_attr($header_area_height);?>px;
			}
		<?php endif; ?>

		<?php if(!empty($body_color)) :?>
			body{
				background: <?php echo esc_attr($body_color);?> !important;
			}
		<?php endif; ?>

		<?php if(!empty($body_font)) :?>
			body{
			 	font-family: 'Roboto', sans-serif;
				font-size: 16px;
			}
		<?php endif; ?>
		<?php if(!empty($heading_font)) :?>
			.h1,.h2,.h3,.h4,.h5,.h5, .h6, h1, h2, h3, h4, h5, h6{
				font-family: 'Poppins', sans-serif;
			}
		<?php endif; ?>
		<?php if(!empty($menu_active_color)) :?>
			#menu-primary-1 > li.current-menu-parent > a, #menu-primary-2 > li.current-menu-parent > a, .navbar-default .navbar-nav > li > a:hover, .edumodo-current-menu-item > a, .edumodo-header .navbar-v1 .navigation-main > li.current-menu-parent > a:first-child{
				color: <?php echo esc_attr($menu_active_color);?> !important;
			}
		<?php endif; ?>
		.edumodo-top-search input[type="submit"]{
			color: <?php echo esc_attr($theme_primary_color);?>;
			border-color: white;
		}
		.edumodo-top-search input[type="submit"]:hover{
			border-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		<?php if ($theme_primary_color):?> 
		.site-title{color: <?php echo esc_attr($theme_primary_color);?>;}
		button,
		input[type="button"], input[type="reset"], input[type="submit"]{
		    background: <?php echo esc_attr($theme_primary_color);?>;
		    border-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.btn{
			background: <?php echo esc_attr($theme_primary_color);?>;
			border-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.mc4wp-form-fields input[type="button"], 
		.mc4wp-form-fields input[type="reset"], 
		.mc4wp-form-fields input[type="submit"]{
			background: <?php echo esc_attr($theme_primary_color);?>;
			border-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		span.post-date a:hover{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.search-form label > input:focus{
			border-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.edumodo-course-1 article.tx-course .course-details .course-meta .post-date a:hover{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.comment-author.vcard a:hover{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.comments-area .comment-metadata a:hover{
		color: <?php echo esc_attr($theme_primary_color);?>;	
		}
		.enter-related-course .edumodo-related-course-1 article.tx-course .course-details .course-meta span.course-cost{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.archive .entry-header a:hover{
			color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.single-notice .post-cat a:hover{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.main-post.has-post-thumbnail .edumodo-post-img .entry-meta .post-cat a:hover{
			color: <?php echo esc_attr($theme_primary_color);?> 
		}
		.main-post.link-formate .link-content .icon-link{
			color: <?php echo esc_attr($theme_primary_color);?> 
		}
		.quote-format .entry-content.quote-content.quote:before{
			color: <?php echo esc_attr($theme_primary_color);?> 
		}
		.main-post .edit span.edit-link a:hover{
			color: <?php echo esc_attr($theme_primary_color);?> 
		}
		.main-post .content-body .entry-meta .post-cat a:hover{
			color: <?php echo esc_attr($theme_primary_color);?> 
		}
		.site-main .comment-navigation .nav-previous a:hover{
			color: <?php echo esc_attr($theme_primary_color);?> 
		}
		.single-post .entry-meta span.post-author a:hover, 
		.single-post ul.post-categories li a:hover, 
		.site-main .post-navigation .nav-next a:hover, 
		.site-main .posts-navigation .nav-next a:hover, 
		.site-main .comment-navigation .nav-next a:hover, 
		.site-main .post-navigation .nav-previous a:hover, 
		.site-main .posts-navigation .nav-previous a:hover{
			color: <?php echo esc_attr($theme_primary_color);?> 
		}
		#mc_embed_signup #tx-subscribe{
			border-color: <?php echo esc_attr($theme_primary_color);?> 
		}
		.widget-area .widget .tagcloud > a:hover{
			color: <?php echo esc_attr($theme_primary_color);?> 
		}
		.widget_calendar div.calendar_wrap table thead tr th, .widget_calendar div.calendar_wrap table tbody tr td#today{
			background-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.widget_calendar div.calendar_wrap table thead tr th, .widget_calendar div.calendar_wrap table tbody tr td {
			border-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.widget_calendar div.calendar_wrap table thead tr th{
			border-color: <?php echo esc_attr($theme_primary_color);?>90;
		}
		.single-post .entry-meta span a:hover{
			color: <?php echo esc_attr($theme_primary_color);?> 
		}
		.post-tags a:hover{
			color: <?php echo esc_attr($theme_primary_color);?> 
		}
		.single-post .edit a.post-edit-link:hover{
			color: <?php echo esc_attr($theme_primary_color);?> 
		}
		.single-post .post-tags a:hover{
			color: <?php echo esc_attr($theme_primary_color);?> 
		}
		.edumodo-pagination .page-numbers:hover{
			border-left-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.edumodo-pagination .page-numbers:hover{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.edumodo-pagination .page-numbers.current:hover{
			color: white;
		}
		.edumodo-top-search input[type="submit"]:hover{
			background-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.copyright a:hover, .copyright .social-icon a:hover{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.post-password-form input[type="submit"]{
			background-color: <?php echo esc_attr($theme_primary_color);?>;
			border-color: <?php echo esc_attr($theme_primary_color);?>;
		}

		.edumodo-teacher-1 .teacher-person .overlay .person-info .social-links-teacher a:hover, 
		.edumodo-teacher-1 .teacher-person .overlay .person-info .teacher-title a:hover{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.widget-area .edumodo-social a{
			background-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.single-course-post .course-content .course-meta span a:hover{
			color:<?php echo esc_attr($theme_primary_color);?>;
		}
		.widget-area .widget a:hover{
			color:<?php echo esc_attr($theme_primary_color);?>;
		}
		.footer .tagcloud a:hover, .footer .widget ul li a:hover, .footer .widget ul li:hover a, .footer .widget ul li:hover:before{
			color:<?php echo esc_attr($theme_primary_color);?>;
		}
		.footer .widget_calendar div.calendar_wrap table tfoot #prev a:hover, .widget_calendar td#next a:hover{
			color:<?php echo esc_attr($theme_primary_color);?>;
		}
		.widget-area .edumodo-recent-post .recent-post .recent-entry-header .recent-entry-title a:hover{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.course-teacher-carousel .owl-nav div, .content-list .owl-nav div{
			 background-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.single-course-post .course-content .course-meta .post-cat a:hover{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.pingback .edit-link a:hover{
			 background-color: <?php echo esc_attr($theme_primary_color);?>;
			 border-color: <?php echo esc_attr($theme_primary_color);?>;
		}

		.edumodo-teacher-2 .teacher-2 .teacher-container .teacher-block .teacher-image:before{
			background:<?php echo esc_attr($theme_primary_color);?>;
		}

		/*	Woocommerce */
		.woocommerce .star-rating span::before{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.woocommerce .woocommerce-message:before, 
		.woocommerce-cart .woocommerce-message:before, 
		.woocommerce-checkout .woocommerce-message:before, 
		.woocommerce-account .woocommerce-message:before, 
		.woocommerce .woocommerce-info:before, 
		.woocommerce-cart .woocommerce-info:before, 
		.woocommerce-checkout .woocommerce-info:before, 
		.woocommerce-account .woocommerce-info:before, .woocommerce .woocommerce-breadcrumb a:hover, nav.woocommerce-breadcrumb a:hover, ul.learn-press-courses .course .course-title:hover, ul.learn-press-courses .course .course-info .course-instructor a:hover{
			color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.woocommerce main#main .woocommerce-tabs input[name="submit"], .woocommerce-cart main#main .woocommerce-tabs input[name="submit"], .woocommerce-checkout main#main .woocommerce-tabs input[name="submit"], .woocommerce-account main#main .woocommerce-tabs input[name="submit"]{
			background-color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.woocommerce .woocommerce-message, .woocommerce-cart .woocommerce-message, .woocommerce-checkout .woocommerce-message, .woocommerce-account .woocommerce-message, .woocommerce .woocommerce-info, .woocommerce-cart .woocommerce-info, .woocommerce-checkout .woocommerce-info, .woocommerce-account .woocommerce-info{
		 		border-top-color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.woocommerce .woocommerce-MyAccount-navigation ul li.is-active{
			border-left-color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.woocommerce main#main .price, .woocommerce-cart main#main .price, .woocommerce-checkout main#main .price, .woocommerce-account main#main .price{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.tribe-events-read-more, 
		.tribe-events-day .type-tribe_events .edumodo-day-view .day-event-contant .tribe-events-list-event-title a:hover, 
		#tribe-events-footer a:hover
		{
			color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.post-type-archive-tribe_events #tribe-events-content .tribe-events-loop .type-tribe_events .edumodo-event-loop-content-wrapper .edumodo-event-image .tribe-events-event-cost .ticket-cost{
			background-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.post-type-archive-tribe_events table.tribe-events-calendar .tribe-events-present div[id*=tribe-events-daynum-]{
			background-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		#tribe-events-bar .tribe-bar-filters .tribe-bar-filters-inner input[type="text"]:focus{
			border-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.post-type-archive-tribe_events table.tribe-events-calendar .tribe-event-featured{
			border-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.datepicker table tr td span.active.active, .datepicker table tr td span.active.disabled, .datepicker table tr td span.active.disabled.active, .datepicker table tr td span.active.disabled.disabled, .datepicker table tr td span.active.disabled:active, .datepicker table tr td span.active.disabled:hover, .datepicker table tr td span.active.disabled:hover.active, .datepicker table tr td span.active.disabled:hover.disabled, .datepicker table tr td span.active.disabled:hover:active, .datepicker table tr td span.active.disabled:hover:hover, .datepicker table tr td span.active.disabled:hover[disabled], .datepicker table tr td span.active.disabled[disabled], .datepicker table tr td span.active:active, .datepicker table tr td span.active:hover, .datepicker table tr td span.active:hover.active, .datepicker table tr td span.active:hover.disabled, .datepicker table tr td span.active:hover:active, .datepicker table tr td span.active:hover:hover, .datepicker table tr td span.active:hover[disabled], .datepicker table tr td span.active[disabled]{
			background-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.post-type-archive-tribe_events #tribe-events-content .tribe-events-loop .e-event-featured .edumodo-event-loop-content-wrapper .tribe-events-list-event-title a:before, .post-type-archive-tribe_events #tribe-events-content .tribe-events-loop .tribe-event-featured .edumodo-event-loop-content-wrapper .tribe-events-list-event-title a:before{
			background-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.post-type-archive-tribe_events #tribe-events-content .tribe-events-loop .type-tribe_events .edumodo-event-loop-content-wrapper:after{
			background-color: <?php echo esc_attr($theme_primary_color);?>15;
		}
		.post-type-archive-tribe_events #tribe-events-content .tribe-events-loop .type-tribe_events .edumodo-event-loop-content-wrapper .edumodo-event-loop-content .tribe-events-list-event-title a:hover{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.i-override-default-template .upper-part-of-single-event-featured-image .tribe-events-schedule .tribe-events-cost:after{
			background-color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.i-override-default-template .organizer-list .organizer-list-wrapper .single-organizer .organizer-meta-wrapper h3:after{
			background-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		/* ---Sensei -- */ 
		.single-course .i-am-course-lesson-wrapper .type-lesson:hover h2 a, .single-course .i-am-single-course-header-row .edumodo-sensi-course-header .header-meta-wrapper .single-course-enroll-and-send-message-wrapper button[type="submit"]:hover, .single-course .i-am-single-course-header-row .edumodo-sensi-course-header .header-meta-wrapper .single-course-enroll-and-send-message-wrapper button.single_add_to_cart_button{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.single-course .i-am-course-content-wrapper .type-lesson:hover:before, .single-lesson .i-am-course-content-wrapper .type-lesson:hover:before, .single-quiz .i-am-course-content-wrapper .type-lesson:hover:before, .single-course .i-am-course-lesson-wrapper .type-lesson:hover:before, .single-lesson .i-am-course-lesson-wrapper .type-lesson:hover:before, .single-quiz .i-am-course-lesson-wrapper .type-lesson:hover:before, .single-course .i-am-lesson-content-wrapper .type-lesson:hover:before, .single-lesson .i-am-lesson-content-wrapper .type-lesson:hover:before, .single-quiz .i-am-lesson-content-wrapper .type-lesson:hover:before, .single-course .i-am-lesson-meta-data .type-lesson:hover:before, .single-lesson .i-am-lesson-meta-data .type-lesson:hover:before, .single-quiz .i-am-lesson-meta-data .type-lesson:hover:before, 

			.single-course .i-am-course-content-wrapper .type-lesson:before, .single-lesson .i-am-course-content-wrapper .type-lesson:before, .single-quiz .i-am-course-content-wrapper .type-lesson:before, .single-course .i-am-course-lesson-wrapper .type-lesson:before, .single-lesson .i-am-course-lesson-wrapper .type-lesson:before, .single-quiz .i-am-course-lesson-wrapper .type-lesson:before, .single-course .i-am-lesson-content-wrapper .type-lesson:before, .single-lesson .i-am-lesson-content-wrapper .type-lesson:before, .single-quiz .i-am-lesson-content-wrapper .type-lesson:before, .single-course .i-am-lesson-meta-data .type-lesson:before, .single-lesson .i-am-lesson-meta-data .type-lesson:before, .single-quiz .i-am-lesson-meta-data .type-lesson:before{
			border-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.sensei-main-content .course-container .grid-enable .grid-course-content .link-to-the-full-course a, 
		.sensei-main-content .sensei-course-filters a.active, 
		.sensei-main-content .sensei-course-filters a:hover, 
		.sensei-main-content .sensei-course-filters a.active:hover, 
		.sensei-main-content a:hover, .lesson.type-lesson.status-publish.has-post-thumbnail.hentry.post h2 a{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.single-course .i-am-course-content-wrapper .type-lesson header h2 a:after, .single-lesson .i-am-course-content-wrapper .type-lesson header h2 a:after, .single-quiz .i-am-course-content-wrapper .type-lesson header h2 a:after, .single-course .i-am-course-lesson-wrapper .type-lesson header h2 a:after, .single-lesson .i-am-course-lesson-wrapper .type-lesson header h2 a:after, .single-quiz .i-am-course-lesson-wrapper .type-lesson header h2 a:after, .single-course .i-am-lesson-content-wrapper .type-lesson header h2 a:after, .single-lesson .i-am-lesson-content-wrapper .type-lesson header h2 a:after, .single-quiz .i-am-lesson-content-wrapper .type-lesson header h2 a:after, .single-course .i-am-lesson-meta-data .type-lesson header h2 a:after, .single-lesson .i-am-lesson-meta-data .type-lesson header h2 a:after, .single-quiz .i-am-lesson-meta-data .type-lesson header h2 a:after, .sensei-main-content .course-container .sensei-course-meta .course-price .woocommerce-Price-amount, ul.learn-press-nav-tabs .course-nav.active:after, ul.learn-press-nav-tabs .course-nav:hover:after, .sensei-main-content .sensei-pagination .current, .sensei-main-content .sensei-pagination a:hover{
			 background-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.sensei-main-content .woocommerce-message, .sensei-main-content .woocommerce-info, .sensei-main-content .sensei-pagination .current, .sensei-main-content .sensei-pagination a:hover{
			border-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.sensei-main-content .woocommerce-message:before, .sensei-main-content .woocommerce-info:before{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		/* //---Sensei -- */ 
		.sensei-main-content .columns-1 li.course .course-content .link-to-the-full-course a{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.list-enable .list-course-content .link-to-the-full-course a:after{
			background-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.lp-tab-sections .section-tab.active span{
			 border-color: <?php echo esc_attr($theme_primary_color);?>;
		}		
		#learn-press-checkout > p > a:nth-child(1), #learn-press-profile-nav .tabs > li ul li.active a, .lpcourse-course-wapper-3 .lp-related-course .lp-course-1 .lp-course-thumbnail a:after, .lpcourse-course-wapper-3 .lp-related-course .lp-course-1 .course-content-body .footer-body span.lp-enroll-btn a:hover{
			 color: <?php echo esc_attr($theme_primary_color);?>;
		}

		.course .weforms-popup .weforms-popup-wrapper .popup-dismiss, .lp-list-table thead tr th{
			background-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.course .weforms-popup .weforms-popup-wrapper .wpuf-form input[type="submit"]{
			background-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.single-course .i-am-single-course-header-row .edumodo-sensi-course-header .header-meta-wrapper .single-course-enroll-and-send-message-wrapper input[type="submit"]:hover, .single-course .i-am-single-course-header-row .edumodo-sensi-course-header .header-meta-wrapper .sensei-course-meta a:hover, .single-lesson .i-am-single-course-header-row .edumodo-sensi-course-header .header-meta-wrapper .sensei-course-meta a:hover{
			color: <?php echo esc_attr($theme_primary_color);?> !important;
		}

		input[type="text"]:focus, input[type="email"]:focus, input[type="url"]:focus, input[type="password"]:focus, input[type="search"]:focus, input[type="number"]:focus, input[type="tel"]:focus, input[type="range"]:focus, input[type="date"]:focus, input[type="month"]:focus, input[type="week"]:focus, input[type="time"]:focus, input[type="datetime"]:focus, input[type="datetime-local"]:focus, input[type="color"]:focus, textarea:focus{
			    border-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		ul.wpuf-form li .wpuf-fields input[type=text]:focus, ul.wpuf-form li .wpuf-fields input[type=password]:focus, ul.wpuf-form li .wpuf-fields input[type=email]:focus, ul.wpuf-form li .wpuf-fields input[type=url]:focus, ul.wpuf-form li .wpuf-fields input[type=number]:focus, ul.wpuf-form li .wpuf-fields textarea:focus{
			outline-color: <?php echo esc_attr($theme_primary_color);?>;
    		border-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.mc4wp-form-fields input[type="button"]:hover, 
		.mc4wp-form-fields input[type="reset"]:hover, 
		.mc4wp-form-fields input[type="submit"]:hover{
			background-color: <?php echo esc_attr($theme_primary_color);?>;
			border-color:  <?php echo esc_attr($theme_primary_color);?>; 
		}
		.comments-area .comment-respond textarea:focus{
			outline-color: <?php echo esc_attr($theme_primary_color);?>; 
			border-color:  <?php echo esc_attr($theme_primary_color);?>; 
		}
		.single-post .related-post .entry-header .entry-title a:hover{
			color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.main-post .content-body .entry-header .entry-title a:hover{
			color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.related-post-body .entry-header a:hover{
			color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.single-post.format-gallery .owl-nav div, .woocommerce .checkout .place-order input.button.alt, .woocommerce-cart .checkout .place-order input.button.alt, .woocommerce-checkout .checkout .place-order input.button.alt, .woocommerce-account .checkout .place-order input.button.alt, .i-am-course-lesson-wrapper .sticky a:after{
			background-color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.sensei-main-content button[type="submit"], .sensei-main-content a.send-message-button, .sensei-main-content input[type="submit"], .sensei-main-content .view-results, .sensei-main-content a.button{
			background-color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		 .teacher-info .teachers-bio .teachers-name, .teacher-info .social a, .sensei-main-content .course-container .grid-enable .free-tag, .sensei-main-content .featured .course-title:before, .sensei-main-content .featured .header-meta-wrapper h1:before{
			background-color:<?php echo esc_attr($theme_primary_color);?> !important;
		}
		.single-post .post-thumbnail .post-triangle,
		.main-post .post-triangle{
			 border-right-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.comments-area .comment-content:before, .main-post.sticky .entry-header .sticky-post .post-round, 
		.widget-area .widget .widget-title:before, 
		.edumodo-header-2 .login-reg .register, .tribe-events-day .type-tribe_events .edumodo-day-view .day-event-contant .title-price .tribe-events-event-cost{
			background: <?php echo esc_attr($theme_primary_color);?> ;
		}

		.lp-archive-courses .tx-course-list .tx-couse-title a:hover{
		    color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.learn-press-message {
		    border-left: 5px solid <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.learn-press-tabs .learn-press-nav-tabs .learn-press-nav-tab.active a {
		    color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.learn-press-tabs .learn-press-nav-tabs .learn-press-nav-tab.active {
		    border-bottom: 4px solid <?php echo esc_attr($theme_primary_color);?> !important;
		}
		#learn-press-course-curriculum .section-header .meta .collapse{
			background-color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		#learn-press-course-curriculum .course-item .item-status{
			color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.single.single-lp_course .learn-press-message{
			color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		body.course-item-popup .learn-press-content-protected-message a{
		    color: <?php echo esc_attr($theme_primary_color);?>;
		}
		#course-curriculum-popup #popup-main #popup-header{
			background:<?php echo esc_attr($theme_primary_color);?> !important;
	    	border-bottom: 1px solid <?php echo esc_attr($theme_primary_color);?> !important
		}
		.learnpress .learn-press-pagination ul li span.page-numbers.current{
			background:<?php echo esc_attr($theme_primary_color);?> !important;
		}
		.learnpress .learn-press-pagination ul li a:hover{
			color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.lpcourse-course-wapper-3 .lp-related-course .lp-course-1 .course-content-body .footer-body .lp-enroll{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.single-lp_course .lpcourse-course-wapper-2 .edumodo-course-info .title:before, .lp-single-course .tx-course-main .edumodo-course-info .title:before, 
		.learnp-ralated-course .title:before, 
		.lpcourse-sidebar .edumodo-course-info .title:before, .lp-single-course .tx-course-main .edumodo-course-author .title:before{
			background:<?php echo esc_attr($theme_primary_color);?> !important;
		}
		.lp-single-course .course-top .course-info .learn-press-course-buttons .purchase-course button.button.purchase-button, 
		.lp-single-course .course-top .course-info .learn-press-course-buttons .purchase-course button.button.enroll-button{
			    border-color: <?php echo esc_attr($theme_primary_color);?>;
	    		color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.entry-header a:hover, .lpcourse-sidebar .edumodo-course-info ul.course-info-list li i, .lpcourse-top-button .lp-button, .learnp-ralated-course .learnp-ralated-course-wrapper article.learnp-ralated-item .learnp-ralated-content .learnp-course-title a:hover{
				color: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.single-lp_course .lpcourse-course-wapper .edumodo-course-info .title:before{
			background:<?php echo esc_attr($theme_primary_color);?>;
		}
		.single-lp_course .lpcourse-course-wapper-2 .lpcourse-top-2 .lpcourse-top-button .lp-button:hover{
			background:<?php echo esc_attr($theme_secondary_color);?>;
		}
		.single-lp_course .lpcourse-course-wapper .lpcourse-top .lpcourse-top-button .lp-button:hover {
		   background:<?php echo esc_attr($theme_secondary_color);?>;
		}
		.woocommerce main#main button[type="submit"], .woocommerce-cart main#main button[type="submit"], .woocommerce-checkout main#main button[type="submit"], .woocommerce-account main#main button[type="submit"], .woocommerce main#main a.button, .woocommerce-cart main#main a.button, .woocommerce-checkout main#main a.button, .woocommerce-account main#main a.button, .woocommerce main#main input[name="submit"], .woocommerce-cart main#main input[name="submit"], .woocommerce-checkout main#main input[name="submit"], .woocommerce-account main#main input[name="submit"], .woocommerce .woocommerce-cart-form input[type="submit"], .woocommerce-cart .woocommerce-cart-form input[type="submit"], .woocommerce-checkout .woocommerce-cart-form input[type="submit"], .woocommerce-account .woocommerce-cart-form input[type="submit"]{
			background-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.woocommerce main#main span.onsale, .woocommerce-cart main#main span.onsale, .woocommerce-checkout main#main span.onsale, .woocommerce-account main#main span.onsale{
			background:<?php echo esc_attr($theme_primary_color);?>;
		}
		.woocommerce .woocommerce-pagination .page-numbers li span.current, .woocommerce-cart .woocommerce-pagination .page-numbers li span.current, .woocommerce-checkout .woocommerce-pagination .page-numbers li span.current, .woocommerce-account .woocommerce-pagination .page-numbers li span.current{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.woocommerce .woocommerce-pagination .page-numbers li:hover, .woocommerce-cart .woocommerce-pagination .page-numbers li:hover, .woocommerce-checkout .woocommerce-pagination .page-numbers li:hover, .woocommerce-account .woocommerce-pagination .page-numbers li:hover{
			background:<?php echo esc_attr($theme_primary_color);?>;
		}
		.edumodo-from ul.wpuf-form .wpuf-submit input[type=submit]{
			border-color: <?php echo esc_attr($theme_primary_color);?> !important;
			background-color:<?php echo esc_attr($theme_primary_color);?> !important;
		}		
		.i-override-default-template a.tribe-events-button, .post-type-archive-tribe_events #tribe-events-content .tribe-events-loop .type-tribe_events .edumodo-event-loop-content-wrapper .edumodo-event-loop-content .edumodo-event-content-wrapper a:after, .post-type-archive-tribe_events input[type="submit"]{
			background-color:<?php echo esc_attr($theme_primary_color);?> !important;
		}		
		div#mobile-menu{
			background-color:<?php echo esc_attr($theme_primary_color);?> !important;
		}
		/*Learndash*/
		.leaarndash-releted-course-two .lp-enroll{
			color:<?php echo esc_attr($theme_primary_color);?>;
		}
		.leaarndash-releted-course-two .title:hover{
			color:<?php echo esc_attr($theme_primary_color);?>;
		}
		.sfwd-courses .ld_course_grid_price{
			background:<?php echo esc_attr($theme_primary_color);?>;
		}
	 <?php endif;?>

	<?php if ($theme_secondary_color):?> 
	button:hover, input[type="button"]:hover, 
	input[type="reset"]:hover, 
	input[type="submit"]:hover{
  		background: <?php echo esc_attr($theme_secondary_color);?>;
	    border-color: <?php echo esc_attr($theme_secondary_color);?>;
	}
	.btn:hover{
		background: <?php echo esc_attr($theme_secondary_color);?>;
		border-color: <?php echo esc_attr($theme_secondary_color);?>;
	}
	.btn:hover, .btn:focus, .btn.focus{
		background: <?php echo esc_attr($theme_secondary_color);?>;
	}
	.btn:hover, .btn:focus, .btn.focus{
		border-color: <?php echo esc_attr($theme_secondary_color);?>;
	}
	.main-post .entry-meta{
		background:<?php echo esc_attr($theme_secondary_color);?>;
	}
	.enter-related-course .edumodo-related-course-1 article.tx-course figure a:before, .edumodo-course-1 article.tx-course figure a:before {
	    background-color: <?php echo esc_attr($theme_secondary_color);?>80;
	}
	.course-teacher-carousel .owl-nav .owl-prev:hover, .content-list .owl-nav .owl-next:hover, {
		background-color: <?php echo esc_attr($theme_secondary_color);?> !important;
	}

	.teacher-2 .teacher-container .teacher-block .teacher-image:before{
		background-color: <?php echo esc_attr($theme_secondary_color);?>90;
	}
	.edumodo-course-1 article.tx-course figure a:after{
		color: <?php echo esc_attr($theme_secondary_color);?>;
	}

	#course-curriculum-popup #popup-main #popup-header .popup-close:hover, #course-curriculum-popup #popup-main #popup-header .sidebar-hide-btn:hover, #course-curriculum-popup #popup-main #popup-header .sidebar-show-btn:hover{
		background:<?php echo esc_attr($theme_secondary_color);?> !important;
	}
	.lpcourse-course-wapper-3 .lp-related-course .lp-course-1 .lp-course-thumbnail a:before, .lp-course3-heading:before, #learn-press-course-curriculum .course-item .item-status.item-status-completed, #learn-press-course-curriculum .course-item .item-status.item-status-passed{
		background:<?php echo esc_attr($theme_secondary_color);?> !important;
	}
	.lp-single-course .course-top .course-info .learn-press-course-buttons .purchase-course button.button.purchase-button:hover, .lp-single-course .course-top .course-info .learn-press-course-buttons .purchase-course button.button.enroll-button:hover{
		  border-color: <?php echo esc_attr($theme_secondary_color);?>;
		  background:<?php echo esc_attr($theme_secondary_color);?>;
	}
	.woocommerce main#main button[type="submit"]:hover, .woocommerce-cart main#main button[type="submit"]:hover, .woocommerce-checkout main#main button[type="submit"]:hover, .woocommerce-account main#main button[type="submit"]:hover, .woocommerce main#main a.button:hover, .woocommerce-cart main#main a.button:hover, .woocommerce-checkout main#main a.button:hover, .woocommerce-account main#main a.button:hover, .woocommerce main#main input[name="submit"]:hover, .woocommerce-cart main#main input[name="submit"]:hover, .woocommerce-checkout main#main input[name="submit"]:hover, .woocommerce-account main#main input[name="submit"]:hover, .woocommerce .woocommerce-cart-form input[type="submit"]:hover, .woocommerce-cart .woocommerce-cart-form input[type="submit"]:hover, .woocommerce-checkout .woocommerce-cart-form input[type="submit"]:hover, .woocommerce-account .woocommerce-cart-form input[type="submit"]:hover, .woocommerce .checkout .place-order input.button.alt:hover, .woocommerce-cart .checkout .place-order input.button.alt:hover, .woocommerce-checkout .checkout .place-order input.button.alt:hover, .woocommerce-account .checkout .place-order input.button.alt:hover{
		 background:<?php echo esc_attr($theme_secondary_color);?> !important;
	}
		.edumodo-from ul.wpuf-form .wpuf-submit input[type=submit]:hover, .edumodo-from ul.wpuf-form .wpuf-submit input[type=submit]:focus, .edumodo-from ul.wpuf-form .wpuf-submit input[type=submit].focus{
			border-color: <?php echo esc_attr($theme_secondary_color);?> !important;
			background-color:<?php echo esc_attr($theme_secondary_color);?> !important;
		}
		.edumodo-header-2 .login-reg .register:hover{
			background-color:<?php echo esc_attr($theme_secondary_color);?>;
		}
		.i-override-default-template a.tribe-events-button:hover, .post-type-archive-tribe_events input[type="submit"]:hover{
			background-color:<?php echo esc_attr($theme_secondary_color);?> !important;
		}
		.sensei-main-content button[type="submit"]:hover, .sensei-main-content a.send-message-button:hover, .sensei-main-content input[type="submit"]:hover{
			background-color: <?php echo esc_attr($theme_secondary_color);?>!important;
		}
		.single-course .i-am-single-course-header-row .edumodo-sensi-course-header .header-meta-wrapper .single-course-enroll-and-send-message-wrapper a.button:hover{
			color:<?php echo esc_attr($theme_primary_color);?>;
		}
		.edumodo-lesson-send-message .button.send-message-button:hover{
			color: white !important;
		}
		.course-teacher-carousel .owl-nav .owl-prev:hover, .content-list .owl-nav .owl-prev:hover{
			background-color:<?php echo esc_attr($theme_secondary_color);?>;
		}
		.widget-area .edumodo-social a:hover{
			background-color:<?php echo esc_attr($theme_secondary_color);?>;
		}
		.course-teacher-carousel .owl-nav .owl-next:hover, .content-list .owl-nav .owl-next:hover{
			background-color:<?php echo esc_attr($theme_secondary_color);?>;
		}
		.enter-related-course .edumodo-related-course-1 article.tx-course figure a:after{
			color: <?php echo esc_attr($theme_secondary_color);?>;
		}
		.edumodo-notice-1 article.notice figure a:before{
			 background-color: <?php echo esc_attr($theme_secondary_color);?>80;
		}
		.edumodo-notice-1 article.notice figure a:after{
			color: <?php echo esc_attr($theme_secondary_color);?>;
		}
		.edumodo-top-search input[type="search"]{
			background-color: <?php echo esc_attr($theme_secondary_color);?>50;
		}
		.content-field .owl-nav .owl-prev:hover{
			 background-color: <?php echo esc_attr($theme_secondary_color);?>;
		}
		.post-password-form input[type="submit"]:hover{
			background-color: <?php echo esc_attr($theme_secondary_color);?>;
			border-color: <?php echo esc_attr($theme_secondary_color);?>;
		}
	 <?php endif;?>
	<?php if ($footer_bg_color or $footer_text_color):?> 
		.footer{
			background-color:<?php echo esc_attr($footer_bg_color);?>;
			color:<?php echo esc_attr($footer_text_color);?>;
			padding: 50px 0 30px;
		}
	<?php endif;?>

	<?php if ($footer_text_color):?> 
		.footer .widget ul li a, .footer .widget-title{
			color:<?php echo esc_attr($footer_text_color);?>;
		}
	<?php endif;?>
	<?php if ($footer_widget_column):?> 
		.footer .widget ul li{
			display: <?php echo esc_attr($footer_widget_column);?>;
		}
	<?php endif;?>

	<?php if ($footer_text_color):?> 
		.footer .edumodo-quickinfo i{
			color:<?php echo esc_attr($footer_text_color);?>;
		}
		.footer .widget ul li:before{
			color:<?php echo esc_attr($footer_text_color);?>;
			transition: all 0.3s ease;
		}
	<?php endif;?>
	<?php if ($footer_bg_color or $copyright_text_color or $copyright_link_color):?> 
		.copyright{
			background-color:<?php echo esc_attr($copyright_background_color);?>;
			color:<?php echo esc_attr($copyright_text_color);?>;
		}
		.copyright a{
			color:<?php echo esc_attr($copyright_link_color);?>;
		}
	<?php endif;?>

    .site-info{
	    padding: 30px 0 0px;
	}

<?php if ($enable_edumodo_custom_style == true && $theme_secondary_color):?> 
	/* --- Star New Styling -- */ 
	/* --- bbPress -- */ 
	#bbpress-forums li.bbp-header, #bbpress-forums li.bbp-footer{
		background-color: <?php echo esc_attr($theme_secondary_color);?>;
		border-color: <?php echo esc_attr($theme_secondary_color);?>;
	}
	.bbp-breadcrumb a:hover{
		color: <?php echo esc_attr($theme_primary_color);?>;
	}
	div.bbp-template-notice.info, div.bbp-template-notice.important{
		background-color: <?php echo esc_attr($theme_secondary_color);?>;
		border-color: <?php echo esc_attr($theme_secondary_color);?>;
	}
	#bbpress-forums ul.bbp-lead-topic, 
	#bbpress-forums ul.bbp-topics, 
	#bbpress-forums ul.bbp-forums, 
	#bbpress-forums ul.bbp-replies, 
	#bbpress-forums ul.bbp-search-results, 
	#bbpress-forums li.bbp-body ul.forum, 
	#bbpress-forums li.bbp-body ul.topic, 
	#bbpress-forums .bbp-forums-list{
		border-color: <?php echo esc_attr($theme_secondary_color);?>;
	}

	div.bbp-template-notice.error, 
	div.bbp-template-notice.warning, 
	div.bbp-template-notice, 
	div.indicator-hint{
		background-color: <?php echo esc_attr($theme_secondary_color);?>;
		border-color: <?php echo esc_attr($theme_secondary_color);?>;
	}
	#bbpress-forums li a:hover, div.bbp-template-notice a:hover{
		color: <?php echo esc_attr($theme_primary_color);?>;
	}

	/*BuddyPress*/
	.buddypress .buddypress-wrap .activity-read-more a:focus, .buddypress .buddypress-wrap .activity-read-more a:hover, .buddypress .buddypress-wrap .button-nav li a:focus, .buddypress .buddypress-wrap .button-nav li a:hover, .buddypress .buddypress-wrap .button-nav li.current a, .buddypress .buddypress-wrap .comment-reply-link:focus, .buddypress .buddypress-wrap .comment-reply-link:hover, .buddypress .buddypress-wrap .generic-button a:focus, .buddypress .buddypress-wrap .generic-button a:hover, .buddypress .buddypress-wrap a.button:focus, .buddypress .buddypress-wrap a.button:hover, .buddypress .buddypress-wrap button:focus, .buddypress .buddypress-wrap button:hover, .buddypress .buddypress-wrap input[type=button]:focus, .buddypress .buddypress-wrap input[type=button]:hover, .buddypress .buddypress-wrap input[type=reset]:focus, .buddypress .buddypress-wrap input[type=reset]:hover, .buddypress .buddypress-wrap input[type=submit]:focus, .buddypress .buddypress-wrap input[type=submit]:hover{
		color: <?php echo esc_attr($theme_primary_color);?>;
		}
	.activity-list .activity-item .activity-header .time-since:hover{
		color: <?php echo esc_attr($theme_primary_color);?>;
	}
	.buddypress-wrap .main-navs:not(.dir-navs) li.current a, .buddypress-wrap .main-navs:not(.dir-navs) li.selected a{
		color: <?php echo esc_attr($theme_primary_color);?>;
	}
	.buddypress-wrap .bp-navs li.current a, .buddypress-wrap .bp-navs li.current a:focus, .buddypress-wrap .bp-navs li.current a:hover, .buddypress-wrap .bp-navs li.selected a, .buddypress-wrap .bp-navs li.selected a:focus, .buddypress-wrap .bp-navs li.selected a:hover{
		color: <?php echo esc_attr($theme_primary_color);?>;
	}
	.buddypress-wrap .bp-feedback.help .bp-icon, .buddypress-wrap .bp-feedback.info .bp-icon{
		background: <?php echo esc_attr($theme_primary_color);?>;
	}
	.buddypress-wrap .standard-form div.submit input{
		background: <?php echo esc_attr($theme_primary_color);?>;
	}
	.learnpress #learn-press-profile-nav .tabs > li.active > a{
		background: <?php echo esc_attr($theme_primary_color);?> !important;
	}
	.buddypress-wrap.bp-dir-hori-nav:not(.bp-vertical-navs) nav:not(.tabbed-links){
		background-color: <?php echo esc_attr($theme_secondary_color);?>;
	}
	.buddypress-wrap .standard-form div.submit input:hover{
		background-color: <?php echo esc_attr($theme_secondary_color);?>;
	}
	.buddypress-wrap .profile.edit .button-nav{
		background: <?php echo esc_attr($theme_secondary_color);?>;
	}
	.button.acomment-reply.bp-primary-action.bp-tooltip, a.button.bp-secondary-action.bp-tooltip{
		color: <?php echo esc_attr($theme_secondary_color);?>;
	}
	.activity-list .activity-item .activity-header a{
		color: <?php echo esc_attr($theme_secondary_color);?>;
	}

	.activity-list .activity-item .activity-header .time-since{
		color: <?php echo esc_attr($theme_secondary_color);?>;
	}
	ul.leanpress-buddpress-list-filters{
		background: <?php echo esc_attr($theme_secondary_color);?>;
	}
	.lp-list-table thead tr th{
		background: <?php echo esc_attr($theme_secondary_color);?> !important;
	}
	<?php /* LearnPress Login*/ if( class_exists( 'LearnPress' ) ) : ?>
	
		#learn-press-profile-nav .tabs > li.active > a {
		    background: <?php echo esc_attr($theme_primary_color);?> !important;
		}
		.course-item-nav .prev a:hover, .course-item-nav .next a:hover{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.course-curriculum ul.curriculum-sections .section-content .course-item.item-preview .course-item-status{
			background-color: <?php echo esc_attr($theme_secondary_color);?>;
		}
		.course-curriculum ul.curriculum-sections .section-content .course-item .course-item-meta .count-questions{
			background-color: <?php echo esc_attr($theme_secondary_color);?>;
		}
		.course-curriculum ul.curriculum-sections .section-content .course-item .course-item-meta .duration{
			background-color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.course-curriculum ul.curriculum-sections .section-content .course-item.item-locked .course-item-status:before{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.edumodo-popup-login-register .lp-register-link{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}
		.edumodo-popup-login-register a.back_btn{
			color: <?php echo esc_attr($theme_primary_color);?>;
		}

		.edumodo-popup-login-register .lp-register-link:hover{
			color: <?php echo esc_attr($theme_secondary_color);?>;
		}
		.edumodo-popup-login-register a.back_btn:hover{
			color: <?php echo esc_attr($theme_secondary_color);?>;
		}
	<?php endif; ?>

   <?php /* LearnDash Start*/ if( class_exists( 'SFWD_LMS' ) ) : ?>
	
	.btn-join, #btn-join, .learndash_checkout_buttons input.btn-join[type="button"], a#quiz_continue_link{
		background-color: <?php echo esc_attr($theme_primary_color);?>;
	}
	.btn-join:hover, #btn-join:hover, .learndash_checkout_buttons input.btn-join[type="button"]:hover, a#quiz_continue_link:hover{
		background-color: <?php echo esc_attr($theme_secondary_color);?>;
	}

	#ld_course_list .btn, .ld_course_grid_button .btn{
	   color: <?php echo esc_attr($theme_primary_color);?>;
	}
	#ld_course_list .btn-primary, .ld_course_grid_button .btn-primary{
	    border-color: <?php echo esc_attr($theme_primary_color);?>!important;
	}
	#ld_course_list .btn-primary:hover, .ld_course_grid_button .btn-primary:hover{
	    background-color: <?php echo esc_attr($theme_primary_color);?>;
	    border-color:<?php echo esc_attr($theme_primary_color);?>;
	}
	.learndash-pager a{
	      background-color:<?php echo esc_attr($theme_primary_color);?> !important;
	}
	#ld_course_list .thumbnail.course .ld_course_grid_price:before, .ld_course_grid_button .thumbnail.course .ld_course_grid_price:before{
	border-top-color: <?php echo esc_attr($theme_primary_color);?> !important;
    border-right-color: <?php echo esc_attr($theme_primary_color);?> !important;
	}
	#ld_course_list .thumbnail.course .ld_course_grid_price, .ld_course_grid_button .thumbnail.course .ld_course_grid_price, #ld_course_list .thumbnail.course .ld_course_grid_price.ribbon-enrolled, .ld_course_grid_button .thumbnail.course .ld_course_grid_price.ribbon-enrolled{
		background-color:<?php echo esc_attr($theme_primary_color);?> !important;
	}
	<?php /* LearnDash End */ endif; ?>

<?php endif;?>
	
/* WeFrom Start */
div.wpforms-container-full .wpforms-form input[type=submit], div.wpforms-container-full .wpforms-form button[type=submit], div.wpforms-container-full .wpforms-form .wpforms-page-button{
	background-color: <?php echo esc_attr($theme_primary_color);?>;
	border-color: <?php echo esc_attr($theme_primary_color);?>;
}
div.wpforms-container-full .wpforms-form input[type=submit]:hover, div.wpforms-container-full .wpforms-form button[type=submit]:hover, div.wpforms-container-full .wpforms-form .wpforms-page-button:hover{
	background-color: <?php echo esc_attr($theme_secondary_color);?>;
	border-color: <?php echo esc_attr($theme_secondary_color);?>;
}
/* WeFrom End */


/*The Event Calemder*/
#tribe-bar-views .tribe-bar-views-option.tribe-bar-active{
	background: <?php echo esc_attr($theme_primary_color);?>;
}
#tribe-bar-views .tribe-bar-views-option:hover{
	background-color: <?php echo esc_attr($theme_secondary_color);?>;
}
.tribe-events-day .type-tribe_events .featured-event .tribe-events-list-event-title:before{
	background: <?php echo esc_attr($theme_primary_color);?>;
}
</style>


<?php 
}
