<?php
Redux::setSection($opt_name, array(
    'desc'   => __('', 'edumodo'),
    'title'  => esc_html__('LearnPress', 'edumodo'),
    'id'     => 'learnpress-options-id',
    'icon'   => 'el el-lines',
    'fields' => array(
        array(
            'id'      => 'enroll_btn_popup',
            'type'    => 'switch',
            'title'   => esc_html__('Popup Login/Registration', 'edumodo'),
            'default' => 1,
            'on'      => 'Enabled',
            'off'     => 'Disabled',
        ),
    ),
));

Redux::setSection($opt_name, array(
    'desc'       => __('', 'edumodo'),
    'title'      => esc_html__('Archive Page', 'edumodo'),
    'id'         => 'learnpress-archive-page',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'      => 'edumodo_lp_grid_column',
            'type'    => 'select',
            'title'   => esc_html__('Column', 'edumodo'),
            'options' => array(
                'column_3'   => esc_html__('3 Column', 'edumodo'),
                'column_4'   => esc_html__('4 Column', 'edumodo'),
            ),
            'default' => 'column_4',
        ),
    ),
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Single Page', 'edumodo'),
    'id'         => 'learnpress-single-page-options',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'      => 'learnpress_select',
            'type'    => 'select',
            'title'   => esc_html__('Single Course Layout', 'edumodo'),
            'options' => array(
                'learnpress_single_one'   => esc_html__('Layout 1', 'edumodo'),
                'learnpress_single_two'   => esc_html__('Layout 2', 'edumodo'),
                'learnpress_single_three' => esc_html__('Layout 3', 'edumodo'),
            ),
            'default' => 'learnpress_single_three',
        ),

        array(
            'id'       => 'lp_single_page_bg',
            'type'     => 'color',
            'title'    => esc_html__('Page Background Color', 'edumodo'),
            'desc'     => esc_html__('Pick a color for theme secondary.', 'edumodo'),
            'compiler' => true,
            'default'  => "#fff",
            'output'   => array(
                'background' => '.single-lp_course',
            ),
            'required' => array('learnpress_select', '=', 'learnpress_single_three'),
        ),

        array(
            'id'      => 'edumodo_lp_excerpt_length',
            'type'    => 'spinner',
            'title'   => __( 'Excerpt Length', 'edumodo' ),
            'default' => '20',
            'min'     => '1',
            'step'    => '1',
            'max'     => '150',
        ),

        array(
            'id'      => 'edumodo_lp_created_by',
            'type'    => 'switch',
            'title'   => esc_html__('Created by', 'edumodo'),
            'default' => 1,
            'on'      => 'Enabled',
            'off'     => 'Disabled',
           'required' => array('learnpress_select', '=', 'learnpress_single_three'),
        ),

        array(
            'id'      => 'edumodo_lp_last_update_date',
            'type'    => 'switch',
            'title'   => esc_html__('Last Update', 'edumodo'),
            'default' => 1,
            'on'      => 'Enabled',
            'off'     => 'Disabled',
            'required' => array('learnpress_select', '=', 'learnpress_single_three'),
        ),
        array(
            'id'      => 'edumodo_lp_category',
            'type'    => 'switch',
            'title'   => esc_html__('Category', 'edumodo'),
            'default' => 1,
            'on'      => 'Enabled',
            'off'     => 'Disabled',
        ),
        
        array(
            'id'      => 'edumodo_lp_student_enroll',
            'type'    => 'switch',
            'title'   => esc_html__('Enrolled', 'edumodo'),
            'default' => 1,
            'on'      => 'Enabled',
            'off'     => 'Disabled',
           'required' => array('learnpress_select', '=', 'learnpress_single_three'),
        ),

        array(
            'id'      => 'enable_single_related_courses',
            'type'    => 'switch',
            'title'   => esc_html__('Related Courses', 'edumodo'),
            'default' => 1,
            'on'      => 'Enabled',
            'off'     => 'Disabled',
        ),

    ),
)
);
