(function($) {
    'use strict';


    /* ========================================================================= */
    /*  Header Sticky
    /* ========================================================================= */
    $(window).scroll(function() {
        var sticky = $('.sticky-active'),
            scroll = $(window).scrollTop();
        if (scroll >= 40) {
            sticky.addClass('fixed-header');
        } else {
            sticky.removeClass('fixed-header');
        }
    });
    /* ========================================================================= */
    /*  AppleTV Effect
    /* ========================================================================= */
    jQuery(document).ready(function() {
        // Apple TV Effect
        atvImg();
    });
    /* ========================================================================= */
    /*  Course Teacher Carousel
    /* ========================================================================= */
    jQuery(".course-teacher-carousel").addClass("owl-carousel").owlCarousel({
        margin: 10,
        items: 1,
        nav: true,
        dots: ($(".course-teacher-carousel .item").length > 1) ? true : false,
        navText: ['<i class="glyph-icon flaticon-left-arrow"></i>', '<i class="glyph-icon flaticon-right-arrow"></i>'],
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 1
            },
            1000: {
                items: 1
            }
        }
    });
    /* ========================================================================= */
    /*  Gallery list page
    /* ========================================================================= */
    jQuery(".main-post.gallery-formate .content-list").addClass("owl-carousel").owlCarousel({
        loop: true,
        margin: 10,
        nav: true,
        navText: ['<i class="glyph-icon flaticon-left-arrow"></i>', '<i class="glyph-icon flaticon-right-arrow"></i>'],
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 1
            },
            1000: {
                items: 1
            }
        }
    });
    jQuery(".main-post.gallery-formate .gallery").addClass("owl-carousel").owlCarousel({
        loop: true,
        margin: 10,
        nav: true,
        navText: ['<i class="glyph-icon flaticon-left-arrow"></i>', '<i class="glyph-icon flaticon-right-arrow"></i>'],
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 1
            },
            1000: {
                items: 1
            }
        }
    });
    /* ========================================================================= */
    /*  Gallery single page
    /* ========================================================================= */
    jQuery(".gallery-content-single .content-list").addClass("owl-carousel").owlCarousel({
        loop: true,
        margin: 10,
        nav: true,
        navText: ['<i class="glyph-icon flaticon-left-arrow"></i>', '<i class="glyph-icon flaticon-right-arrow"></i>'],
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 1
            },
            1000: {
                items: 1
            }
        }
    });
    jQuery(".single-post.format-gallery .gallery").addClass("owl-carousel").owlCarousel({
        loop: true,
        margin: 10,
        nav: true,
        navText: ['<i class="glyph-icon flaticon-left-arrow"></i>', '<i class="glyph-icon flaticon-right-arrow"></i>'],
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 1
            },
            1000: {
                items: 1
            }
        }
    });
  // jQuery(".edumodo-header .navigation-main > li").hover(function(){
  //   jQuery(".edumodo-header .navigation-main > li > ul").slideToggle("medium");
  // });

    /* ========================================================================= */
    /*  ScrollTop
    /* ========================================================================= */
    var btn = $('#scrollTop');
    $(window).scroll(function() {
        if ($(window).scrollTop() > 300) {
            btn.addClass('show');
        } else {
            btn.removeClass('show');
        }
    });
    btn.on('click', function(e) {
        e.preventDefault();
        $('html, body').animate({
            scrollTop: 0
        }, '300');
    });
    /* ========================================================================= */
    /* Mobile Menu
    /* ========================================================================= */
    jQuery(function() {
        jQuery('nav#mmenu').mmenu();
    });
    /* ========================================================================= */
    /* Mobile menu icon animation
    /* ========================================================================= */
    $(document).ready(function() {
        $('#nav-icon1,#nav-icon2,#nav-icon3,#nav-icon4').click(function() {
            $(this).toggleClass('open');
        });
    });
    /* ========================================================================= */
    /* Video Pop Up
    /* ========================================================================= */
    // Add url parameter or replace if already exists.
    function addUrlParam(url, key, value) {
        var newParam = key + "=" + value;
        var result = url.replace(new RegExp("(&|\\?)" + key + "=[^\&|#]*"), '$1' + newParam);
        if (result === url) {
            result = (url.indexOf("?") != -1 ? url.split("?")[0] + "?" + newParam + "&" + url.split("?")[1] : (url.indexOf("#") != -1 ? url.split("#")[0] + "?" + newParam + "#" + url.split("#")[1] : url + '?' + newParam));
        }
        return result;
    }
    // Add and remove autoplay on videos opened in modals
    $('.modal.videoModal').on('shown.bs.modal', function() {
        var $iframe = $(this).find('iframe');
        if ($iframe.length) {
            var src = $iframe.attr('src');
            var srcNew = addUrlParam(src, 'autoplay', '1');
            $iframe.attr('src', srcNew);
        }
    });
    $('.modal.videoModal').on('hide.bs.modal', function() {
        var $iframe = $(this).find('iframe');
        if ($iframe.length) {
            var src = $iframe.attr('src');
            var srcNew = addUrlParam(src, 'autoplay', '0');
            $iframe.attr('src', srcNew);
        }
    });
    /* ========================================================================= */
    /* Video popup / Magnific popup
    /* ========================================================================= */
    $('.course-featured-image a').magnificPopup({
        disableOn: 700,
        type: 'iframe',
        mainClass: 'mfp-fade',
        removalDelay: 160,
        preloader: false,
        fixedContentPos: false
    });
    $('.woocommerce-product-gallery__image a').magnificPopup({
        type: 'image'
    });
    /* ========================================================================= */
    /*  Course pop up
    /* ========================================================================= */
    $('.enroll-btn a').on('click', function() {
        $('.weforms-popup').css('display', 'block');
        $('.popup-dismiss').on('click', function() {
            $('.weforms-popup').css('display', 'none');
        });
    });
    /* ========================================================================= */
    /* Mobile menu icon animation
    /* ========================================================================= */
    $('.select_location').on('change', function() {
        window.location = $(this).val();
    });
    /* ========================================================================= */
    /* One page nav menu
    /* ========================================================================= */
    jQuery(".edumodo-header .navbar-v1 .navigation-main").onePageNav({
        currentClass: "current-menu-item",
        changeHash: !1,
        scrollSpeed: 750,
        offsetHeight: 1e3,
        scrollOffset: 67,
        scrollThreshold: .5
    });
    $(document).ready(function() {
        // preloader
        $(window).load(function() {
            $('.edumodo-preloader').delay(400).fadeOut(500);
        })
    })


$('li.dropdown').on('click', function() {
    var $el = $(this);
    if ($el.hasClass('open')) {
        var $a = $el.children('a.dropdown-toggle');
        if ($a.length && $a.attr('href')) {
            location.href = $a.attr('href');
        }
    }
});
}(jQuery));