<?php 
require_once(WKP_PATH. 'inc/woo_query.php');
// $settings = $this->get_settings();
$layout_header = widgetkit_pro_array_get($settings, 'product_layout_header');
$product_layout_style = widgetkit_pro_array_get($settings, 'product_layout_style');
$product_column_image_top = widgetkit_pro_array_get($settings, 'product_column_image_top');
$product_column_image_left = widgetkit_pro_array_get($settings, 'product_column_image_left');
$product_column = $product_layout_style == 'image_left' ? $product_column_image_left : $product_column_image_top;
$show_cart_button = widgetkit_pro_array_get($settings, 'show_cart_button');
$cart_button_layout_style = widgetkit_pro_array_get($settings, 'cart_button_layout_style');
$product_query_type = widgetkit_pro_array_get($settings, 'product_query_type');
$product_num_to_show = widgetkit_pro_array_get($settings, 'product_num_to_show');
$product_order_by = widgetkit_pro_array_get($settings, 'product_order_by');
$show_category = widgetkit_pro_array_get($settings, 'show_category');
$show_product_price = widgetkit_pro_array_get($settings, 'show_product_price');
$show_product_rating = widgetkit_pro_array_get($settings, 'show_product_rating');
$show_short_description = widgetkit_pro_array_get($settings, 'show_short_description');
/**
 * check woocommerce
 */
$woocommerce_main_file = 'woocommerce/woocommerce.php';
$installed_plugins = get_plugins();
$site_has_woocommerce = isset($installed_plugins[$woocommerce_main_file]);
?>

    <?php if($site_has_woocommerce):?>
        <?php if ( class_exists( 'WooCommerce' ) ):  ?>
            <?php if($layout_header):?>
                <h2 class="woo-layout-header"><?php echo $layout_header; ?></h2>
            <?php endif;?>

            <div class="<?php echo $product_layout_style; ?> grid grid-<?php echo $product_column; ?>">
                <?php 
                
                $woo_query = WKP_Woo_Query::init();
                $args = $woo_query->product_query_type($product_query_type, $product_num_to_show, $product_order_by);
                
                $query = new WP_Query($args);

                if($query->have_posts()):
                    while($query->have_posts()):
                        $query->the_post();
                        global $product;
                        $cat_list = get_the_terms(get_the_ID(), 'product_cat');
                        ?>
                        <div class="column">
                            <div class="product-thumb">
                                <?php if(has_post_thumbnail()):?>
                                    <div class="product-thumb-wrapper">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php the_post_thumbnail('full')?>
                                        </a>
                                    </div>
                                    <?php else:?>
                                    <div class="product-thumb-wrapper no-thumbnail">
                                        <a href="<?php the_permalink(); ?>">
                                            <img src="<?php echo esc_url(wc_placeholder_img_src('full'))?>" alt="">
                                        </a>
                                    </div>
                                <?php endif;?>
                                <?php echo $show_product_price ? do_action( 'wkp_woo_product_sale_flash' ) : null ; ?>
                                <div class="overlay">
                                    <?php if($product_layout_style == 'image_top'):?>
                                    <?php echo $show_product_rating ? do_action( 'wkp_woo_product_rating' ) : null ; ?>
                                    <?php endif;?>

                                    <?php if($cart_button_layout_style == 'overlay' && $product_layout_style == 'image_top'):?>
                                    <?php echo $show_cart_button ? do_shortcode('[add_to_cart id="'.get_the_ID().'" style="none" show_price="false"]') : null;?>
                                    <?php endif;?>
                                </div>
                            </div>
                            <div class="product-content">

                                <?php if($product_layout_style == 'image_left'):?>
                                <?php echo $show_product_rating ? do_action( 'wkp_woo_product_rating' ) : null ; ?>
                                <?php endif;?>
                                
                                <h4>
                                    <a href="<?php echo the_permalink();?>">
                                        <?php echo the_title();?>
                                    </a>
                                </h4>

                                <?php if($show_category):?>
                                    <div class="cat-lists">
                                        <ul>
                                            <?php foreach($cat_list as $cat): ?>
                                                <li>
                                                    <a href="<?php echo get_term_link($cat->term_id); ?>">
                                                        <?php echo $cat->name; ?>
                                                    </a>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                <?php endif;?>

                                <?php echo $show_product_price ? do_action( 'wkp_woo_product_price' ) : null ; ?>
                                
                                <?php if($cart_button_layout_style == 'inside_content' || $product_layout_style == 'image_left'):?>
                                <?php echo $show_cart_button ? do_shortcode('[add_to_cart id="'.get_the_ID().'" style="none" show_price="false"]') : null;?>
                                <?php endif;?>

                                <?php if($show_short_description):?>
                                    <p class="excerpt"><?php echo get_the_excerpt(get_the_ID()); ?></p>
                                <?php endif;?>

                            </div>
                        </div>
                        <?php
                    endwhile;
                endif;
                wp_reset_query();
                ?>
            </div>

        <?php else: ?>
            <div class="active-woocommerce">
                <h2>Please Active WooCommerce Plugin First.</h2>
            </div>
        <?php endif;?>
    <?php else: ?>
        <div class="site-has-no-woocommerce">
            <h2>Please Install WooCommerce Plugin First.</h2>
        </div>
    <?php endif;?>