<?php 
use Elementor\Icons_Manager;
require_once(WKP_PATH. 'inc/woo_query.php');
$settings = $this->get_settings();
$layout_header = widgetkit_pro_array_get($settings, 'product_layout_header');
$product_layout_style = widgetkit_pro_array_get($settings, 'product_layout_style');
$product_layout_slider_grid_gap = widgetkit_pro_array_get($settings, 'product_layout_slider_grid_gap');
$product_column_grid = widgetkit_pro_array_get($settings, 'product_column_grid');
$product_column = $product_column_grid;
$show_cart_button = widgetkit_pro_array_get($settings, 'show_cart_button');
$cart_button_layout_style = widgetkit_pro_array_get($settings, 'cart_button_layout_style');
$quick_view_button = widgetkit_pro_array_get($settings, 'quick_view_button');
$show_category = widgetkit_pro_array_get($settings, 'show_category');
$show_product_price = widgetkit_pro_array_get($settings, 'show_product_price');
$show_product_rating = widgetkit_pro_array_get($settings, 'show_product_rating');
$show_short_description = widgetkit_pro_array_get($settings, 'show_short_description');
/**
 * sale badget
 */
$show_product_sale_badge = widgetkit_pro_array_get($settings, 'show_product_sale_badge');
$custom_sale_badge_switcher = widgetkit_pro_array_get($settings, 'custom_sale_badge_switcher');
$custom_sale_badge_text_input = widgetkit_pro_array_get($settings, 'custom_sale_badge_text_input');
/**
 * query parameter
 */
$product_query_type = widgetkit_pro_array_get($settings, 'product_query_type');
$product_num_to_show = widgetkit_pro_array_get($settings, 'product_num_to_show');
$product_category_filter_rule = widgetkit_pro_array_get($settings, 'product_category_filter_rule');
$select_product_category = widgetkit_pro_array_get($settings, 'select_product_category');
$product_offset = widgetkit_pro_array_get($settings, 'product_offset');
$product_exclude_from_query = widgetkit_pro_array_get($settings, 'product_exclude_from_query');
// advance query parameter
$product_query_filterby = widgetkit_pro_array_get($settings, 'product_query_filterby');
$product_query_orderby = widgetkit_pro_array_get($settings, 'product_query_orderby');
$product_query_order = widgetkit_pro_array_get($settings, 'product_query_order');
$product_include_to_query = widgetkit_pro_array_get($settings, 'product_include_to_query');

/**
 * slider control
 */
$slider_auto_play = widgetkit_pro_array_get($settings, 'slider_auto_play');
$slider_auto_play_interval = widgetkit_pro_array_get($settings, 'slider_auto_play_interval');
$slider_pause_on_hover = widgetkit_pro_array_get($settings, 'slider_pause_on_hover');
$slider_slides_on_set = widgetkit_pro_array_get($settings, 'slider_slides_on_set');
$slider_navigation_arrow_position = widgetkit_pro_array_get($settings, 'slider_navigation_arrow_position');
$nav_arrow_view_on_hover = widgetkit_pro_array_get($settings, 'nav_arrow_view_on_hover');
$slider_slides_loop = widgetkit_pro_array_get($settings, 'slider_slides_loop');

$nav_dot_view = widgetkit_pro_array_get($settings, 'nav_dot_view');


$product_query_parameter_arr = [
    $product_query_type,
    $product_num_to_show,
    $product_category_filter_rule,
    $select_product_category,
    $product_offset,
    $product_exclude_from_query,
    $product_query_filterby,
    $product_query_orderby,
    $product_query_order,
    $product_include_to_query,
];
/**
 * check woocommerce
 */
$woocommerce_main_file = 'woocommerce/woocommerce.php';
$installed_plugins = get_plugins();
$site_has_woocommerce = isset($installed_plugins[$woocommerce_main_file]);

$add_custom_icon = widgetkit_pro_array_get($settings, 'add_custom_icon');
$quick_view_icon = widgetkit_pro_array_get($settings, 'quick_view_icon');
$add_custom_cart_icon = widgetkit_pro_array_get($settings, 'add_custom_cart_icon');
$cart_icon = widgetkit_pro_array_get($settings, 'cart_icon');

?>

    <?php if($site_has_woocommerce):?>
        <?php if ( class_exists( 'WooCommerce' ) ):  ?>
            <?php if($layout_header):?>
                <h2 class="woo-layout-header"><?php echo $layout_header; ?></h2>
            <?php endif;?>

            <div id="wk-slider-<?php echo $this->get_id(); ?>" <?php echo $product_layout_style === 'slider' ? 'wk-slider' : ''; ?> >
                <div class="<?php echo $product_layout_style === 'slider' ? 'wk-position-relative wk-visible-toggle' : '' ?>" tabindex="-1">
                    <div class="wk-slider-container">
                    <div 
                    class="<?php 
                        echo $product_layout_style === 'slider' 
                        ? 'wk-grid '.$product_layout_slider_grid_gap.' wk-slider-items wk-child-width-1-1@m wk-child-width-1-2@s wk-child-width-1-'.$product_column.'@l'
                        : 'grid grid-'.$product_column ; ?>"
                    >
                        <?php 
                        /**
                         * product query
                         */
                        $woo_query = WKP_Woo_Query::init();
                        $args = $woo_query->advanced_products_query_type($product_query_parameter_arr);
                        //$woo_query->wk_woo_custom_cart_button();
                        $query = new WP_Query($args);

                        if($query->have_posts()):
                            while($query->have_posts()):
                                $query->the_post();
                                global $product;
                                $cat_list = get_the_terms(get_the_ID(), 'product_cat');
                                $gallery_items = widgetkit_pro_get_woo_product_gallery(get_the_ID());
                                ?>
                                <div class="column">
                                    <div class="product-column-wrapper">
                                    <div class="product-thumb">
                                        
                                        <?php if(has_post_thumbnail()):?>
                                            <div class="product-thumb-wrapper">
                                                <a href="<?php the_permalink(); ?>">
                                                    <?php the_post_thumbnail('full')?>
                                                </a>
                                            </div>
                                            <?php else:?>
                                            <div class="product-thumb-wrapper no-thumbnail">
                                                <a href="<?php the_permalink(); ?>">
                                                    <img src="<?php echo esc_url(wc_placeholder_img_src('full'))?>" alt="">
                                                </a>
                                            </div>
                                        <?php endif;?>
                                        <?php 
                                            if(count($gallery_items) > 0):
                                            ?>
                                            <div class="hover-product-image">
                                                <a href="<?php the_permalink(); ?>">
                                                    <img src="<?php echo esc_url($gallery_items[1])?>" alt="">
                                                </a>
                                            </div>
                                            <?php
                                            endif;
                                        ?>
                                        
                                        <?php 
                                            if( $product->is_on_sale() ) {
                                                if($show_product_sale_badge):
                                                    if($custom_sale_badge_switcher){
                                                        echo '<span class="onsale">'. $custom_sale_badge_text_input .'</span>';
                                                    }else{
                                                        echo do_action( 'wkp_woo_product_sale_flash' );
                                                    }
                                                endif;
                                            }
                                        ?>

                                        <div class="overlay">
                                            <?php if($product_layout_style == 'grid'):?>
                                            <?php echo $show_product_rating ? do_action( 'wkp_woo_product_rating' ) : null ; ?>
                                            <?php endif;?>

                                            <div class="cart-button">
                                                <?php if($quick_view_button):?>
                                                    <a class="wk-button quick-view-button wk-button-default  wk-quick-view-button" href="#modal-center-<?php echo get_the_ID()?>" wk-toggle>
                                                        <?php if($add_custom_icon):?>
                                                            <?php Icons_Manager::render_icon( $settings['quick_view_icon'], [ 'aria-hidden' => 'true', 'class' => 'quick-view-icon' ] ); ?>
                                                        <?php else: ?>
                                                            <?php include(WKP_PATH. 'dist/images/quick-view.svg'); ?>
                                                        <?php endif;?>
                                                    </a>
                                                <?php endif;?>
                                            <?php if($cart_button_layout_style == 'overlay'):?>
                                            <?php echo $show_cart_button ? do_shortcode('[add_to_cart class="only-cart-icon" id="'.get_the_ID().'" style="none" show_price="false"]') : null;?>
                                            <?php endif;?>
                                            
                                            </div>
                                            
                                        </div>
                                        
                                        
                                    </div>
                                    <div class="product-content">
                                        <h4>
                                            <a href="<?php echo the_permalink();?>">
                                                <?php echo the_title();?>
                                            </a>
                                        </h4>
                                        <?php if($show_category):?>
                                            <div class="cat-lists">
                                                <ul>
                                                    <?php foreach($cat_list as $cat): ?>
                                                        <li>
                                                            <a href="<?php echo get_term_link($cat->term_id); ?>">
                                                                <?php echo $cat->name; ?>
                                                            </a>
                                                        </li>
                                                    <?php endforeach; ?>
                                                </ul>
                                            </div>
                                        <?php endif;?>
                                        <?php echo $show_product_price ? do_action( 'wkp_woo_product_price' ) : null ; ?>
                                        <?php if($cart_button_layout_style == 'inside_content'):?>
                                            <?php echo $show_cart_button ? do_shortcode('[add_to_cart id="'.get_the_ID().'" style="none" show_price="false"]') : null;?>
                                        <?php endif;?>
                                        <?php if($show_short_description):?>
                                            <p class="excerpt"><?php echo get_the_excerpt(get_the_ID()); ?></p>
                                        <?php endif;?>
                                    </div>
                                    <?php if($quick_view_button):?>
                                        <div id="modal-center-<?php echo get_the_ID()?>" class="wk-flex-top wk-product-quick-view-modal wk-modal-container" wk-modal>
                                            <div class="wk-modal-dialog wk-modal-body wk-margin-auto-vertical">

                                                <button class="wk-modal-close-default" type="button" wk-close></button>

                                                <div class="wk-child-width-expand@s" wk-grid>
                                                    <div class="wk-grid-item-match">
                                                        <div class="wk-card wk-card-default wk-card-body">
                                                            <?php 
                                                                if(has_post_thumbnail()){
                                                                    the_post_thumbnail('full');
                                                                }else{
                                                                    ?>
                                                                        <img src="<?php echo esc_url(wc_placeholder_img_src('full'))?>" alt="">
                                                                    <?php
                                                                }
                                                            ?>
                                                        </div>
                                                    </div>
                                                    <div>
                                                        <h3><?php echo get_the_title(get_the_ID());?></h3>
                                                        <?php woocommerce_template_single_price();?>
                                                        <?php echo do_shortcode('[add_to_cart id="'.get_the_ID().'" style="none" show_price="false"]')?>
                                                        
                                                        <div class="content">
                                                            <?php woocommerce_template_single_meta();?>
                                                            <?php woocommerce_template_single_excerpt();?>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    <?php endif;?>
                                    </div>
                                </div>
                                <?php
                            endwhile;
                        else:
                            ?>
                            <div>
                                <h2>Please select option from config panel</h2>
                            </div>
                            <?php
                        endif;
                        wp_reset_query();
                        ?>
                    
                        
                    
                    </div>
                    <!-- arrow navigation -->
                    <?php if('slider' === $product_layout_style):?>
                        <?php if('inside' === $slider_navigation_arrow_position):?>
                            <a class="wk-position-center-left wk-position-small <?php echo $nav_arrow_view_on_hover ? 'wk-hidden-hover' : '';?>" href="#" wk-slidenav-previous wk-slider-item="previous"></a>
                            <a class="wk-position-center-right wk-position-small <?php echo $nav_arrow_view_on_hover ? 'wk-hidden-hover' : '';?>" href="#" wk-slidenav-next wk-slider-item="next"></a>
                        <?php elseif('outside' === $slider_navigation_arrow_position):?>
                            <a class="wk-position-center-left-out wk-position-small" href="#" wk-slidenav-previous wk-slider-item="previous"></a>
                            <a class="wk-position-center-right-out wk-position-small" href="#" wk-slidenav-next wk-slider-item="next"></a>
                        <?php endif;?>
                    <?php endif;?>
                    </div>
                </div>
                <!-- dot navigation -->
                <?php if('slider' === $product_layout_style && $nav_dot_view):?>
                    <ul class="wk-slider-nav wk-dotnav wk-flex-center wk-margin"></ul>
                <?php endif;?>
            </div>
            <?php //if('slider' === $product_layout_style):?>
            <script>
                jQuery(function($){
                    $(document).ready(function(){
                        <?php if($product_layout_style == 'slider'):?>
                            wkUIkit.slider('#wk-slider-<?php echo $this->get_id(); ?>', {
                                autoplay: <?php echo $slider_auto_play ? 'true' : 'false'; ?>,
                                autoplayInterval: <?php echo $slider_auto_play  ? $slider_auto_play_interval['size'] : $slider_auto_play_interval['size']; ?>,
                                pauseOnHover: <?php echo $slider_pause_on_hover  ? 'true' : 'false'; ?>,
                                sets: <?php echo $slider_slides_on_set  ? 'true' : 'false'; ?>,
                                finite: <?php echo $slider_slides_loop ? 'true': 'false'; ?>,
                            });
                        <?php endif; ?>
                    });
                    <?php if($add_custom_cart_icon && $cart_icon): ?>
                        $('#woo-products-<?php echo $this->get_id(); ?> .column .product a.button')
                            .append(' <?php Icons_Manager::render_icon( $settings["cart_icon"], [ "aria-hidden" => "true", "class" => "cart_custom_icon" ]); ?>');
                    <?php else: ?>
                        $('#woo-products-<?php echo $this->get_id(); ?> .column .product a.button').append("<span wk-icon='cart'></span>");
                    <?php endif; ?>
                });
            </script>
            <?php //endif;?>
        <?php else: ?>
            <div class="active-woocommerce">
                <h2>Please Active WooCommerce Plugin First.</h2>
            </div>
        <?php endif;?>
    <?php else: ?>
        <div class="site-has-no-woocommerce">
            <h2>Please Install WooCommerce Plugin First.</h2>
        </div>
    <?php endif;?>