<?php 
require_once(WKP_PATH. 'inc/woo_query.php');
$settings = $this->get_settings();
$category_layout_header = widgetkit_pro_array_get($settings, 'category_layout_header');
$num_of_cat = widgetkit_pro_array_get($settings, 'category_num_to_show');
$category_order = widgetkit_pro_array_get($settings, 'category_order');
$category_hide_empty = widgetkit_pro_array_get($settings, 'category_hide_empty');
$primary_column_number = widgetkit_pro_array_get($settings, 'primary_column_number');
$category_hide_empty = $category_hide_empty ? 1 : 0;
$specific_cats_arr = widgetkit_pro_array_get($settings, 'select_specific_category');
$cat_layout = widgetkit_pro_array_get($settings, 'cat_layout');
if($cat_layout === 'grid'){
    $category_column = widgetkit_pro_array_get($settings, 'category_column');
    $num_of_cat = widgetkit_pro_array_get($settings, 'category_num_to_show');
    $show_category_count = widgetkit_pro_array_get($settings, 'show_category_count');
    $grid_text_layout = widgetkit_pro_array_get($settings, 'grid_text_layout');
}else{
    $category_column = widgetkit_pro_array_get($settings, 'layout_skin');
    $num_of_cat = widgetkit_pro_array_get($settings, 'category_num_to_show_for_layout');
}

/**
 * check woocommerce
 */
$woocommerce_main_file = 'woocommerce/woocommerce.php';
$installed_plugins = get_plugins();
$site_has_woocommerce = isset($installed_plugins[$woocommerce_main_file]);
?>
    <?php if($site_has_woocommerce):?>
        <?php if ( class_exists( 'WooCommerce' ) ):  ?>
            <?php if($category_layout_header):?>
                <h2 class="woo-layout-header"><?php echo $category_layout_header; ?></h2>
            <?php endif;?>
            
            <?php if($specific_cats_arr):?>
                
            <div class="product-category-wrapper <?php echo $cat_layout; ?>">
                <div class="grid grid-<?php echo $category_column; ?>">

                    <?php 
                    $count = 0;
                    $woo_cat_query = WKP_Woo_Query::init();
                    $args = $woo_cat_query->category_query($num_of_cat, $category_order, $category_hide_empty);

                    foreach($specific_cats_arr as $cat_id): 
                        $count++;
                        $category = get_term_by( 'id',  $cat_id , 'product_cat' );
                        $cat_thumb = get_term_meta($category->term_id, 'thumbnail_id', true);
                        $cat_thumb_url = $cat_thumb ? wp_get_attachment_url( $cat_thumb ) : null;
                        ?>
                        <div class="column content-<?php echo $grid_text_layout ? $grid_text_layout : 'outside';?> <?php echo $primary_column_number == $count ? 'primary': ''; ?>">
                            <div class="cat-thumb">
                                <a href="<?php echo get_term_link($category->term_id)?>">
                                <?php if($cat_thumb_url):?>
                                    <div class="thumb-wrapper">
                                        <img src="<?php echo esc_url($cat_thumb_url)?>" alt="">
                                    </div>
                                <?php else:?>
                                    <div class="thumb-wrapper no-thumb">
                                        <img src="<?php echo esc_url(wc_placeholder_img_src('full'))?>" alt="">
                                    </div>
                                <?php endif;?>
                                </a>
                            </div>
                            <div class="cat-content">
                                <a href="<?php echo get_term_link($category->term_id)?>">
                                    <h3><?php echo $category->name ?></h3>
                                </a>
                                <?php if( $cat_layout == 'grid' ):?>
                                    <?php if($show_category_count): ?>
                                        <p class="product-count">
                                            <span>
                                                <?php echo $category->count; ?>
                                            </span>
                                            <span><?php esc_html_e($category->count == 1 || $category->count == 0 ? 'Product' : 'products', 'widgetkit-pro' );?></span>
                                        </p>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <p class="product-count">
                                        <span>
                                            <?php echo $category->count; ?>
                                        </span>
                                        <span><?php esc_html_e($category->count == 1 || $category->count == 0 ? 'Product' : 'products', 'widgetkit-pro' );?></span>
                                    </p>
                                <?php endif; ?>
                            </div>
                        </div>

                    <?php
                        // var_dump($count, count($specific_cats_arr));
                        if($count === count($specific_cats_arr)){
                            break;
                        }
                        endforeach;
                    ?>

                </div>
            </div>
            <?php else:?>
                <div class="no-category">
                    <h3 class="no-category-text"><?php esc_html_e('Select a category to display from Query tab.', 'wkpro'); ?></h3>
                </div>
            <?php endif;?>

        <?php else: ?>
            <div class="active-woocommerce">
                <h2><?php esc_html_e('Please Active WooCommerce Plugin First.', 'wkpro');?></h2>
            </div>
        <?php endif;?>
    <?php else: ?>
        <div class="site-has-no-woocommerce">
            <h2><?php esc_html_e('Please Install WooCommerce Plugin First.', 'wkpro');?></h2>
        </div>
    <?php endif;?>