    <?php
        use Elementor\Icons_Manager;

        $wkp_placeholder_image = WKP_URL . 'dist/images/placeholder.jpg';

        $settings = $this->get_settings();
        $read_more_button = $settings['read_more_button'];
        $sensei_instructor = widgetkit_pro_array_get($settings, 'sensei_instructor');
        $show_meta = widgetkit_pro_array_get($settings, 'show_meta');
        $show_description = widgetkit_pro_array_get($settings, 'show_description');
        $excerpt_desc_word = widgetkit_pro_array_get($settings, 'excerpt_desc_word');
        $show_lesson = widgetkit_pro_array_get($settings, 'show_lesson');
        $cat_multi_slug = widgetkit_pro_array_get($settings, 'cat_dynamic_multiple_id');
        $post_num_to_show = widgetkit_pro_array_get($settings, 'post_num_to_show');

        $sensei_lesson_custom_icon = widgetkit_pro_array_get($settings, 'sensei_lesson_add_custom_icon');
        $sensei_lesson_icon = widgetkit_pro_array_get($settings, 'sensei_lesson_icon');
    ?>

    <?php if (class_exists('Sensei_Main')) : // Check LearnDash LMS plugin active?>
        <div class="row">
            <div class="widgetkit-sensei-courses">
                <?php
                /**
                 * Query for the post
                 * custom post type
                 * post type : sensei_course
                 * category taxonomy : course_category
                 */
                $count = 0;
                /**
                * if select any category for drop down
                * then assign that value to the $first_cat_id
                * if not then set it to null
                */
                if (isset($first_cat_ID)) {
                    $first_cat_ID = $first_cat_ID;
                } else {
                    $first_cat_ID = '';
                }
                if ($cat_multi_slug) :
                    $course = array(
                        'post_type' => 'course',
                        'posts_per_page' => $post_num_to_show,
                        'orderby' => $settings['orderby'],
                        'order' => $settings['order'],
                        'tax_query' => array(
                            array(
                                'taxonomy' => 'course-category',
                                'field'    => 'slug',
                                'terms' => $cat_multi_slug,
                            ),
                        ),
                    );

                else :
                    $course = array(
                        'post_type' => 'course',
                        'posts_per_page' => $post_num_to_show,
                        'orderby' => $settings['orderby'],
                        'order' => $settings['order'],
                    );  
                endif;
                

                $course_query = new WP_Query($course);
                if ($course_query->have_posts()):
                    while ($course_query->have_posts()):
                        $course_query->the_post();
                        ?>

                        <div class="sensei_course_list col-md-<?php echo $settings['posts_column']; ?> col-sm-6">
                            <article id="post-<?php the_ID(); ?>" <?php post_class('sensei-single-course'); ?>>
                                <?php //if ( has_post_thumbnail() ):?>
                                    <figure class="sensei-course-thumbnail">
                                        <div class="sensei-img">
                                            <?php if ( has_post_thumbnail() ):?>
                                                <a href="<?php the_permalink(); ?>">
                                                    <?php  the_post_thumbnail();?>
                                                </a>
                                            <?php else: ?>
                                                <a href="<?php the_permalink() ?>">
                                                    <img src="<?php echo esc_url($wkp_placeholder_image);?>" alt="">
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    <?php if($sensei_instructor == 'yes'): ?>
                                        <div class="author-wrapper">
                                            <div class="tx-author-img"><?php echo get_avatar( get_the_author_meta( 'ID' ), 55 ); ?></div>
                                        </div>
                                    <?php endif; ?>
                                    </figure>
                                <?php //endif; ?>

                                <div class="course-content-body">

                                    <header class="wkp-entry-header">
                                        <h4 class="course-entry-title">
                                            <a href="<?php the_permalink();?>">
                                                <?php echo ucfirst(get_the_title(get_the_ID())); ?>                       
                                            </a>
                                        </h4>       
                                    </header><!-- .entry-header -->
                                    
                                    <?php if($show_meta):?>
                                        <div class="post-cat">
                                            <ul>
                                            <?php 
                                            $course_cats = get_the_terms(get_the_ID(), 'course-category');
                                            foreach($course_cats as $cat):
                                            ?>
                                                <li><?php echo $cat->name; ?></li>
                                            <?php endforeach;?>
                                            </ul>
                                        </div>
                                    <?php endif;?>

                                    <?php if ($show_description && $excerpt_desc_word):?>
                                        <div class="wkp-entry-content">
                                            <p><?php esc_html_e(wp_trim_words( get_the_excerpt(), $excerpt_desc_word, ''), 'widgetkit-pro'); ?></p>
                                        </div><!-- .entry-content -->
                                    <?php endif; ?>

                                    <div class="wkp-entry-footer">
                                        <div class="footer-body">
                                            <?php if($show_lesson): ?>
                                                <span class="sensei-enroll">
                                                    <?php if( $sensei_lesson_custom_icon && $sensei_lesson_icon ):?>
                                                        <?php Icons_Manager::render_icon( $sensei_lesson_icon, [ 'aria-hidden' => 'true', 'class' => 'lesson-custom-icon' ] ); ?>
                                                    <?php else: ?>
                                                        <i class="fa fa-play-circle"></i>
                                                    <?php endif;?>
                                                    <!-- <span class="lesson-count"> -->
                                                        <?php echo Sensei()->course->course_lesson_count( get_the_ID() ) . '&nbsp;' . esc_html__( 'Lessons', 'widgetkit-pro' ); ?>
                                                    <!-- </span> -->
                                                </span>
                                            <?php endif; ?>

                                            <?php if($read_more_button): ?>
                                                <span class="sensei-enroll-btn">
                                                    <a href="<?php the_permalink();?>"><?php esc_html_e('Enroll', 'widgetkit-pro') ?></a>   
                                                </span>
                                            <?php endif; ?>
                                        </div><!-- .entry-meta -->
                                    </div>
                                </div><!-- .course details -->

                            </article><!-- #post-## -->

                        </div>

                    <?php 
                    endwhile; 
                    wp_reset_postdata(); 
                    wp_reset_query(); 
                endif;?>
            </div>
        </div>

    <?php else:  ?>
        <div class="plugin-active-massage">
            <h3><?php esc_html_e('Please activate Sensei LMS plugin first', 'widgetkit-pro');?></h3>
        </div>
    <?php endif;  ?>
