<?php ?>
<div class="post-carousel <?php echo esc_html($layout); ?> ">

    <?php
    /**
     * Argument
     * for query post
     * ================
     */
    $count = 1;
    if($query_post_type == 'recent'):
        $args = array(
            'orderby'	=> 'date',
            'order'		=> 'DESC',
            'post_type' =>  'post',
            'showposts'	=> $post_num_to_show,
            'post__not_in' => get_option("sticky_posts"),
        );
    elseif ($query_post_type == 'popular'):
        $args = array(
            'posts_per_page' => $post_num_to_show,
            'meta_key' => 'magmax_post_views_count',
            'orderby' => 'meta_value_num',
            'order' => 'DESC',
            'ignore_sticky_posts' => 1
        );
    elseif ($query_post_type == 'featured'):
        $args = array(
            'posts_per_page' => $post_num_to_show,
            'ignore_sticky_posts' => 1,
            'post_type' => 'post',
            'meta_query' => array(
                array(
                    'key'  => 'post-type',
                    'value' => 'featured',
                    'compare'   => '=',
                )
            )
        );
    elseif ($query_post_type == 'trending'):
        $args = array(
            'posts_per_page' => $post_num_to_show,
            'ignore_sticky_posts' => 1,
            'post_type' => 'post',
            'meta_query' => array(
                array(
                    'key'  => 'post-type',
                    'value' => 'trending',
                    'compare'   => '=',
                )
            )
        );
    endif;
    $query = new WP_Query($args);
    ?>
    <div class="<?php echo $query_post_type; ?>-post-carousel">
    <?php
    if($query->have_posts()):
        ?>
        <?php if($layout_header_enable): ?>
            <div class="layout-header">
                <div class="layout-title">
                    <h4>
                        <?php echo esc_html($layout_title); ?>
                    </h4>
                </div>
            </div>
        <?php endif; ?>
        <div class="cat-post-list-wrapper owl-carousel">

            <?php
            while($query->have_posts()):
                $query->the_post();
                ?>
                    <div class="regular-post">
                        <div class="regular-post-wrapper <?php echo esc_html($regular_post_style); ?>">
                            <?php if(has_post_thumbnail()): ?>
                                <div class="post-thumb">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_post_thumbnail('full' ); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                            <div class="post-data">
                                <div class="post-title">
                                    <?php if($show_cat_tag): ?>
                                        <div class="post-category">
                                            <?php magmax_get_post_category_with_bg(get_the_ID()); ?>
                                        </div>
                                    <?php endif; ?>
                                    <a href="<?php the_permalink(); ?>" class="regular-post-title regular-title">
                                        <h3><?php the_title(); ?></h3>
                                    </a>
                                </div>
                                <div class="post-meta">
                                    <span class="post-author"><?php echo get_the_author(); ?></span>
                                    <span class="seperator"> <span><?php esc_html_e('|', 'widgetkit-pro'); ?></span></span>
                                    <span class="post-date"><?php echo get_the_date(); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php
                $count++;
            endwhile;
            wp_reset_postdata();
            ?>
        </div>
        <?php
    endif;
    ?>
    </div>
    <script>
        jQuery(function($){
            /**
             * Enable Carousel
             * =================
             */
            $(".recent-post-carousel .cat-post-list-wrapper, .popular-post-carousel .cat-post-list-wrapper, .featured-post-carousel .cat-post-list-wrapper, .trending-post-carousel .cat-post-list-wrapper ").owlCarousel({
                pagination: true,
                dots:false,
                loop:true,
                items:<?php echo $post_column; ?>,
                nav: true,
                navClass: ['owl-carousel-left','owl-carousel-right'],
                navText: ['<i class="fa fa-angle-left fa-fw""></i>', '<i class="fa fa-angle-right fa-fw"></i>'],
                margin:15,
                autoplay:false,
                responsive:{
                    0:{
                        items:1
                    },
                    600:{
                        items:1
                    },
                    1000:{
                        items:<?php echo $post_column; ?>
                    }
                }
            });
        });

    </script>

    <?php  //wp_reset_query(); ?>
</div>