<?php ?>
<div class="load-more-posts-layout">
    <?php
    /**
     * Argument
     * for query post
     * ================
     */
    $count = 0;
    $current_page = 1;
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $args = array(
        'orderby'	=> 'date',
        'order'		=> 'DESC',
        'post_type' => 'post',
        'post_status' => 'publish',
        'posts_per_page'	=> $post_num_to_show,
        'paged' => $paged,
    );
    $query = new WP_Query($args);
    ?>

    <?php if($layout_header_enable): ?>
        <div class="layout-header">
            <div class="layout-title">
                <h4>
                    <?php echo esc_html($layout_title); ?>
                </h4>
            </div>
        </div>
    <?php endif; ?>



    <div class="cat-post-list dynamic-cat-post-list <?php echo esc_html($regular_post_style); ?> post-grid-<?php echo $regular_post_style == 'vertical' ? $regular_post_grid : 'no-grid'; ?>">
        <?php if($query->have_posts()): ?>
            <div class="cat-post-list-wrapper">
                <?php while($query->have_posts()): $query->the_post(); ?>

                    <div class="regular-post">
                        <div class="regular-post-wrapper">

                            <?php if(has_post_thumbnail()): ?>
                                <div class="post-thumb">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_post_thumbnail($regular_thumbnail_size ); ?>
                                    </a>
                                </div>
                            <?php endif; ?>

                            <div class="post-data">
                                <div class="post-title">
                                    <div class="post-category">
                                        <?php magmax_get_post_category_with_bg(get_the_ID()); ?>
                                    </div>
                                    <a href="<?php the_permalink(); ?>" class="regular-post-title regular-title">
                                        <h3><?php the_title(); ?></h3>
                                    </a>

                                </div>
                                <div class="post-meta">
                                    <div class="post-author"><?php echo get_the_author(); ?></div>
                                    <div class="seperator"> <span><?php esc_html_e('|', 'widgetkit-pro'); ?></span></div>
                                    <div class="post-date"><?php echo get_the_date(); ?></div>
                                </div>
                                <?php if('yes' == $single_post_link): ?>
                                <div class="post-full-article-link">
                                    <a href="<?php the_permalink() ?>">
                                        <?php esc_html_e('Full Aricle', 'widgetkit-pro'); ?>
                                    </a>
                                </div>
                                <?php endif; ?>
                            </div>

                        </div>
                    </div>

                <?php  endwhile; wp_reset_postdata(); ?>
            </div>

            <?php

            if($post_navigation_style == 'pagination'){
                magmax_numeric_posts_nav_for_custom_query($query->max_num_pages, get_next_posts_link('<i class="fa fa-angle-right"></i>', $query->max_num_pages));
            }else{
                if (  $query->max_num_pages > 1 )
                    echo '<div id="ajax-loading-for-post" class="ajax-load-more-button">More posts</div>';
            }

            ?>

        <?php endif; ?>

    </div>

    <script>
        var ajaxurl = "<?php echo admin_url( 'admin-ajax.php' ); ?>";
        var maxPageNumber = "<?php echo $query->max_num_pages; ?>";
        var postsPerPage = "<?php echo $post_num_to_show; ?>";
        var page = 2;
        jQuery(function($) {
            $('body').on('click', '.ajax-load-more-button', function() {

                $.ajax({
                    url:ajaxurl,
                    type:'post',
                    data:{
                        'action': 'load_posts_by_ajax',
                        'page': page,
                        'security': '<?php echo wp_create_nonce("load_more_posts"); ?>',
                        'postsPerPage': postsPerPage
                    },
                    beforeSend : function() {
                        $('#ajax-loading-for-post').append( '<div class="ajax-content"><div class="lds-ellipsis"><div></div><div></div><div></div><div></div></div></div>' );
                        // change the button text, you can also add a preloader image
                    },
                    success: function(data){
                        $('#ajax-loading-for-post .ajax-content').remove();
                        $('#posts-with-load-more-button .cat-post-list-wrapper').append(data);
                        page++;
                    }
                });
                if(page >= maxPageNumber){
                    $('#ajax-loading-for-post').removeClass('ajax-load-more-button').text('No More Posts');
                }
            });
        });
    </script>
    <?php //wp_reset_query(); ?>
</div>