<?php
?>
<div class="magmax-news-ticker">
    <?php
    $args = array(
        'orderby'	=> 'date',
        'order'		=> 'DESC',
        'showposts'	=> $post_num_to_show,
    );
    $query = new WP_Query($args);

    ?>
    <?php if($query->have_posts()): ?>
        <div class="magmax-news-ticker-1">
            <div class="ticker-title">
                <?php echo esc_html($layout_title); ?>
            </div>

            <div class="magmax-news-post-ticker-wrapper owl-carousel">
                <?php while($query->have_posts()): $query->the_post();?>
                    <div class="recent-post-ticker-title">
                        <div class="recent-post-title-wrapper">
                            <a class="ticker-post-title" href="<?php the_permalink()?>">
                                <?php the_title(); ?>
                            </a>
                        </div>
                    </div>
                <?php endwhile; wp_reset_postdata();?>
            </div>
        </div>
    <?php endif; ?>
    <!-- end of the /.magmax-recent-post-wrapper  -->
    <script>
        jQuery(function($){
            $(".magmax-news-ticker-1 .magmax-news-post-ticker-wrapper").owlCarousel({
                pagination: true,
                dots:false,
                loop:true,
                items:1,
                <?php if ($settings['news_ticker_nav_enable'] == 'yes'): ?>
                    nav: true,
                    navClass: ['owl-carousel-left','owl-carousel-right'],
                    navText: ['<i class="fa fa-angle-left fa-fw"></i>', '<i class="fa fa-angle-right fa-fw"></i>'],
                <?php else: ?>
                    nav:false,
                    navClass: false,
                    navText:false,
                <?php endif; ?>
                <?php if ($settings['ticker_effect'] == 'default'): ?>
                    animateIn: <?php echo 'false';?>,
                    animateOut: <?php echo 'false';?>,
                    <?php else: ?>
                    animateIn: '<?php echo $settings['animation_in_style'];?>',
                    animateOut: '<?php echo $settings['animation_out_style'];?>',
                <?php endif; ?>
                margin: 0,
                autoplay: true,
                autoHeight: true,
                autoHeightClass: 'owl-height',
                smartSpeed:1200,
                slideSpeed: 300,
                autoplayTimeout:<?php echo $settings['news_ticker_content_autoplay'];?>,
                // autoplayHoverPause: true,
                responsive:{
                    0:{
                        items:1
                    },
                    600:{
                        items:1
                    },
                    1000:{
                        items:1
                    }
                }
            });
        });

    </script>
    <?php
    //wp_reset_query();
    ?>
</div>
