<?php
    use Elementor\Icons_Manager;
    $settings = $this->get_settings();
    $id = $this->get_id();
    global $post;
    $prefix = '_edumodo_';

    $lp_course_layout = widgetkit_pro_array_get($settings, 'lp_course_layout');
    $product_layout_slider_grid_gap = widgetkit_pro_array_get($settings, 'product_layout_slider_grid_gap');
    $posts_column = widgetkit_pro_array_get($settings, 'posts_column');
    $slider_navigation_arrow_position = widgetkit_pro_array_get($settings, 'slider_navigation_arrow_position');
    $nav_arrow_view_on_hover = widgetkit_pro_array_get($settings, 'nav_arrow_view_on_hover');
    $nav_dot_view = widgetkit_pro_array_get($settings, 'nav_dot_view');
    $slider_auto_play = widgetkit_pro_array_get($settings, 'slider_auto_play');
    $slider_auto_play_interval = widgetkit_pro_array_get($settings, 'slider_auto_play_interval');
    $slider_pause_on_hover = widgetkit_pro_array_get($settings, 'slider_pause_on_hover');
    $slider_slides_on_set = widgetkit_pro_array_get($settings, 'slider_slides_on_set');
    $slider_slides_loop = widgetkit_pro_array_get($settings, 'slider_slides_loop');

        
    $lp_course_image_overlay = widgetkit_pro_array_get($settings, 'lp_course_image_overlay');
    $lp_course_image_overlay_background = widgetkit_pro_array_get($settings, 'lp_course_image_overlay_background');
    $style_overlay_icon_picker = widgetkit_pro_array_get($settings, 'style_overlay_icon_picker');


    $show_hide_lp_instructor = widgetkit_pro_array_get($settings, 'show_hide_lp_instructor');
    // $excerpt_title_word = widgetkit_pro_array_get($settings, 'excerpt_title_word');
    $show_course_description = widgetkit_pro_array_get($settings, 'show_course_description');
    $excerpt_desc_word = widgetkit_pro_array_get($settings, 'excerpt_desc_word');
    $active_carousel = widgetkit_pro_array_get($settings, 'active_carousel');
    $lp_course_cat = widgetkit_pro_array_get($settings, 'lp_course_cat');
    $lp_course_students_er = widgetkit_pro_array_get($settings, 'lp_course_students_er');
    $lp_course_price = widgetkit_pro_array_get($settings, 'lp_course_price');
    $lp_course_duration = widgetkit_pro_array_get($settings, 'lp_course_duration');
    $lp_course_rating = widgetkit_pro_array_get($settings, 'lp_course_rating');
    $add_custom_enroll_icon = widgetkit_pro_array_get($settings, 'lp_enroll_add_custom_icon');
    $add_custom_duration_icon = widgetkit_pro_array_get($settings, 'lp_duration_custom_icon');

    /**
     * check learnpress
     */
    $learnpress_main_file = 'learnpress/learnpress.php';
    $learnpress_rating_plugin = 'learnpress-course-review/learnpress-course-review.php';
    $installed_plugins = get_plugins();
    $site_has_learnpress = isset($installed_plugins[$learnpress_main_file]);
    $site_has_lp_rating_plugin = isset($installed_plugins[$learnpress_rating_plugin]);
?>
<?php if($site_has_learnpress && $site_has_lp_rating_plugin):?>
    <?php if(class_exists( 'LearnPress' ) && class_exists('LP_Addon_Course_Review_Preload') ):?>
    
    <div id="wk-lp-slider-<?php echo $this->get_id(); ?>"
    <?php echo $lp_course_layout === 'layout_slider' ? 'wk-slider' : ''; ?> 
    class="learnpress-course-list learnpress-course-list-style-2 edumodo-lp-course-1"
    >
        <div class="<?php echo $lp_course_layout === 'layout_slider' ? 'wk-position-relative wk-visible-toggle' : '' ?>" tabindex="-1">
            <div class="<?php echo $lp_course_layout === 'layout_slider' ? ' wk-slider-container'  : null; ?> ">

                <div 
                class="wk-grid wk-child-width-1-1@m wk-child-width-1-2@s 
                <?php echo $product_layout_slider_grid_gap . ' ' .'wk-child-width-1-'.$posts_column.'@l'  ?> 
                <?php echo $lp_course_layout != 'layout_slider' ? "learnpress-course-list-wrapper" : null ; ?> 
                <?php echo $lp_course_layout === 'layout_slider' ? ' wk-slider-items'  : null; ?>"
                >

                    <?php
                        $course = array(
                            'post_type'         => 'lp_course',
                            'posts_per_page'    => $settings['posts_per_page']
                        );

                        $course_query = new WP_Query( $course );
                        
                            if($course_query->have_posts()):
                                while($course_query->have_posts()): 
                                    $course_query->the_post(); 
                                    $lp_cat_list = get_the_terms(get_the_ID(), 'course_category');
                            ?>
                            
                            
                            <div class="course-content-wrapper column col-mdd-<?php echo $settings['posts_column']; ?>">
                                <article id="post-<?php the_ID(); ?>" class="lp-course-1 learnpress-single-course-card" >
                                    
                                    <figure class="lp-course-thumbnail">
                                        <!-- course thumbnail -->
                                        <div class="lp-img">
                                            <?php if ( has_post_thumbnail() ): ?>
                                            <a href="<?php the_permalink(); ?>">
                                                <?php the_post_thumbnail('full');?>
                                                <?php if($lp_course_image_overlay && $style_overlay_icon_picker ):?>
                                                    <span class="overlay-icon">
                                                        <?php Icons_Manager::render_icon( $style_overlay_icon_picker, [ 'aria-hidden' => 'true', 'class' => 'custom-overlay-icon' ] ); ?>
                                                    </span>
                                                <?php endif; ?>
                                            </a>
                                            <?php else:?>
                                            <a href="<?php the_permalink(); ?>">
                                                <img src="<?php echo esc_url(WKP_PLACEHOLDER_URL); ?>" alt="widgetitpro-placeholder">
                                                <?php if($lp_course_image_overlay && $style_overlay_icon_picker ):?>
                                                    <span class="overlay-icon">
                                                        <?php Icons_Manager::render_icon( $style_overlay_icon_picker, [ 'aria-hidden' => 'true', 'class' => 'custom-overlay-icon' ] ); ?>
                                                    </span>
                                                <?php endif; ?>
                                            </a>
                                            <?php endif; ?>
                                        </div>
                                        
                                    </figure>

                                    <div class="course-content-body">
                                        <div class="course-author-and-rating">
                                            <div class="author">
                                                <!-- couser instructor -->
                                                <?php if($show_hide_lp_instructor == 'yes'): ?>
                                                    <div class="author-wrapper">
                                                        <div class="course-author-img"><?php echo get_avatar( get_the_author_meta( 'ID' ), 55 ); ?></div>
                                                        <div class="course-author-name"><?php echo get_the_author_meta( 'display_name'); ?></div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            <?php if($lp_course_rating): ?>
                                                <div class="rating">
                                                    <!-- //rating -->
                                                    <?php
                                                        $course_id       = get_the_ID();
                                                        $course_rate_res = learn_press_get_course_rate( $course_id, false );
                                                        $course_rate     = $course_rate_res['rated'];
                                                        $total           = $course_rate_res['total'];
                                                    ?>

                                                    <?php //if($showRating == 'yes' or $averageRating == 'yes'):  ?>
                                                        <div class="lp-course-rate-wapper">
                                                            <ul class="lp-course-rate clearfix">
                                                                <li>
                                                                <?php //if($showRating == 'yes'):  ?>
                                                                    <?php echo '<div class="star-rating" title="'.sprintf(__( 'Rated %s out of 5', 'widgetkit-pro' ), $course_rate).'"><span style="width:'.( ( $course_rate / 5 ) * 100 ) . '%"><strong itemprop="ratingValue" class="rating">'.$course_rate.'</strong> '.__( 'out of 5', 'widgetkit-pro' ).'</span></div>'; ?>
                                                                <?php //endif; ?>
                                                                <?php //if($averageRating == 'yes'):  ?>
                                                                        <?php printf( __( ' %1.2f ', 'widgetkit-pro'), $course_rate ); ?>
                                                                        <?php //printf( _n( ' %d )', '%d )', $total, 'widgetkit-pro' ), $total ); ?>
                                                                <?php //endif; ?>
                                                                </li>
                                                            </ul> 
                                                        </div>
                                                    <?php //endif; ?>
                                                </div>
                                            <?php endif; ?>
                                        </div>   
                                        <!-- course title -->
                                        <div class="course-title">
                                            <h4 class="course-entry-title">
                                                <a href="<?php the_permalink();?>">
                                                    <?php the_title(); ?>                        
                                                </a>
                                            </h4>       
                                        </div>
                                        <!-- course category -->
                                        <?php if($lp_course_cat == 'yes'): ?>
                                        <div class="course-cat">
                                                <ul class="lp-cat">
                                                    <?php if($lp_cat_list): foreach($lp_cat_list as $cat): ?>
                                                        <li>
                                                            <a href="<?php echo get_term_link($cat->term_id); ?>">
                                                                <?php echo $cat->name; ?>
                                                            </a>
                                                        </li>
                                                    <?php endforeach; endif; ?>
                                                </ul>
                                        </div>
                                        <?php endif; ?>
                                        <!-- couse excerpt -->
                                        <?php if ($show_course_description):?>
                                            <div class="wkp-entry-content">
                                                <p><?php esc_html_e(wp_trim_words( get_the_content(), $excerpt_desc_word, ''), 'widgetkit-pro'); ?></p>
                                            </div>
                                        <?php endif; ?> 
                                        <!-- course meta data -->
                                        <div class="course-meta addons-course-meta">
                                            <!-- enrolled student -->
                                            <?php if($lp_course_students_er == 'yes'): ?>
                                                <div class="enroll-student">
                                                        <?php  $lp_students = get_post_meta(get_the_ID(), '_lp_students'); ?>
                                                        <span class="meta-icon">
                                                            <?php if($add_custom_enroll_icon):?>
                                                                <?php Icons_Manager::render_icon( $settings['lp_enroll_icon'], [ 'aria-hidden' => 'true', 'class' => 'custon-enroll-icon' ] ); ?>
                                                            <?php else: ?>
                                                                <?php include(WKP_PATH. 'dist/images/avatar.svg'); ?>
                                                            <?php endif;?>
                                                        </span>
                                                        <span class="course-user"><?php echo esc_html($lp_students[0]);  ?></span>
                                                </div>
                                            <?php endif; ?>
                                            <!-- duration -->
                                            <?php if($lp_course_duration): ?>
                                                <div class="duraton">
                                                    <?php  $lp_duration = get_post_meta(get_the_ID(), '_lp_duration'); ?>
                                                    <span class="meta-icon">
                                                        <?php if($add_custom_duration_icon):?>
                                                            <?php Icons_Manager::render_icon( $settings['lp_duration_icon'], [ 'aria-hidden' => 'true', 'class' => 'custon-duration-icon' ] ); ?>
                                                        <?php else: ?>
                                                            <?php include(WKP_PATH. 'dist/images/time.svg'); ?>
                                                        <?php endif;?>
                                                    </span>
                                                    <span class="course-duration"><?php echo esc_html($lp_duration[0]);  ?></span>
                                                </div>
                                            <?php endif; ?>
                                            <!-- lesson -->
                                            <!-- <div class="lesson">
                                                <span class="course-lesson-count">
                                                    <i class="fas fa-users"></i><?php //echo esc_html($lp_students[0]);  ?>
                                                </span>
                                            </div> -->
                                            <!-- course price -->
                                            <?php if($lp_course_price == 'yes'): ?>
                                            <div class="course-price">
                                                    <?php $course = LP_Global::course();
                                                    if ( $price_html = $course->get_price_html() ): ?>
                                                        <span class="addon-price">
                                                            <?php echo $price_html; ?>
                                                            <?php if ( $course->get_origin_price() != $course->get_price() ) : ?>
                                                                <?php $origin_price_html = $course->get_origin_price_html(); ?>
                                                                <span class="addon-origin-price"><?php echo $origin_price_html; ?></span>
                                                            <?php endif; ?>
                                                        </span>
                                                    <?php 
                                                    endif;
                                                ?>
                                            </div>
                                            <?php endif; ?>
                                            
                                        </div>
                                                                    
                                    </div>

                                </article>
                            </div>
                    
                    <?php endwhile; wp_reset_postdata(); endif; ?>
                </div> <!-- /.learnpress-course-list-wrapper -->
                <!-- arrow navigation -->
                <?php if('layout_slider' === $lp_course_layout):?>
                    <?php if('inside' === $slider_navigation_arrow_position):?>
                        <a class="wk-position-center-left wk-position-small <?php echo $nav_arrow_view_on_hover ? 'wk-hidden-hover' : '';?>" href="#" wk-slidenav-previous wk-slider-item="previous"></a>
                        <a class="wk-position-center-right wk-position-small <?php echo $nav_arrow_view_on_hover ? 'wk-hidden-hover' : '';?>" href="#" wk-slidenav-next wk-slider-item="next"></a>
                    <?php elseif('outside' === $slider_navigation_arrow_position):?>
                        <a class="wk-position-center-left-out wk-position-small" href="#" wk-slidenav-previous wk-slider-item="previous"></a>
                        <a class="wk-position-center-right-out wk-position-small" href="#" wk-slidenav-next wk-slider-item="next"></a>
                    <?php endif;?>
                <?php endif;?>
            </div> <!-- /.wk-slider-container -->
            <!-- dot navigation -->
            <?php if('layout_slider' === $lp_course_layout && $nav_dot_view):?>
                <ul class="wk-slider-nav wk-dotnav wk-flex-center wk-margin"></ul>
            <?php endif;?>
        </div> <!-- /.layout_slider -->
        <?php if('layout_slider' === $lp_course_layout):?>
        <script>
            jQuery(function($){
                $(document).ready(function(){
                    wkUIkit.slider('#wk-lp-slider-<?php echo $this->get_id(); ?>', {
                        autoplay: <?php echo $slider_auto_play ? 'true' : 'false'; ?>,
                        autoplayInterval: <?php echo $slider_auto_play  ? $slider_auto_play_interval['size'] : $slider_auto_play_interval['size']; ?>,
                        pauseOnHover: <?php echo $slider_pause_on_hover  ? 'true' : 'false'; ?>,
                        sets: <?php echo $slider_slides_on_set  ? 'true' : 'false'; ?>,
                        finite: <?php echo $slider_slides_loop ? 'false': 'true'; ?>,
                    });
                });
            });
        </script>
        <?php endif;?>
    </div> <!-- /.learnpress-course-list -->

    <?php else: ?>
        <div class="plugin-is-deactive">
            <div class="wrapper">
                <?php if(!class_exists('LearnPress')): ?>
                    <h3><?php esc_html_e('Please active LearnPress First', 'widgetkit-pro')?></h3>
                <?php endif; ?>
                <?php if(!class_exists('LP_Addon_Course_Review_Preload')): ?>
                    <h3><?php esc_html_e('Please active learnpress course review plugin for this layout', 'widgetkit-pro')?></h3>
                <?php endif; ?>
            </div>
        </div>   
    <?php endif;?>

<?php else:?>
    <div class="plugin-is-not-exists">
        <div class="wrapper">
            <h3>Please install & active LearnPress First</h3>
        </div>
    </div>
<?php endif;?>