<?php
/**
 * Layout 1
 * =========
 * list style for post
 * ===================
 */
?>
<div class="layout-single-1">
    <?php if($layout_header_enable): ?>
    <div class="layout-header">
        <div class="layout-title">
            <h4 style=" color:<?php echo $tax_tag_bg_color;?>; ">
                <?php echo esc_html($layout_title); ?>
            </h4>
        </div>
        <div class="view-all">
            <a href="<?php echo get_category_link($cat_id); ?>">
                <?php esc_html_e('View All', 'widgetkit-pro'); ?>
                <i class="fa fa-long-arrow-right"></i>
            </a>
        </div>
    </div>
    <?php endif; ?>
    <?php
    /**
     * Argument
     * for query post
     * ================
     */
    $args = array(
        'p' => $single_post_id,
        'post_type' =>  'post',
    );
    $query = new WP_Query($args);
    ?>
    <div class="cat-post-list single-post-list">
    <?php
    if($query->have_posts()):
        ?>
        <div class="cat-post-list-wrapper single-post-list-wrapper">
            <?php
            while($query->have_posts()):
                $query->the_post();

                $content = apply_filters( 'the_content', get_the_content() );
                $video = false;
                /**
                 * Only get video from the content if a playlist isn't present.
                 */
                if (false === strpos($content, 'wp-playlist-script')) {
                    $video = get_media_embedded_in_content($content, array('video', 'object', 'embed', 'iframe'));
                }
                if($video){
                    preg_match('/src="([^"]+)"/', $video[0], $match);
                    $url = $match[1];
                    $new_url = str_replace('embed/', 'watch?v=', $url);
                }else{
                    $new_url = '#';
                }
                ?>

                    <div class="regular-post single-post-by-id">
                        <div class="single-post-wrapper regular-post-wrapper <?php echo esc_html($single_post_style); ?>">

                            <?php if(has_post_thumbnail() && $single_post_show_thumbnail): ?>
                                <div class="post-thumb">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_post_thumbnail('full' ); ?>
                                    </a>
                                    <?php
                                    if('video' == get_post_format(get_the_ID())):?>
                                        <a class="<?php echo $video[0] ? 'video-post-popup' : 'video-post-icon'; ?>"
                                           href="<?php echo $new_url ? $new_url : '#'; ?>">
                                            <img  src="<?php echo get_template_directory_uri(). '/dist/images/play-button-bold.png'; ?>" alt="<?php echo esc_attr('play-button', 'widgetkit-pro'); ?>">
                                        </a>
                                    <?php endif;
                                    ?>
                                </div>
                            <?php endif; ?>

                            <div class="post-data">

                                <div class="post-title">
                                    <?php if($single_post_show_cat): ?>
                                        <div class="post-cat">
                                            <?php magmax_get_post_cateory_for_elements($single_post_id); ?>
                                        </div>
                                    <?php endif; ?>
                                    <a href="<?php the_permalink(); ?>" class="regular-post-title regular-title single-post-title">
                                        <h3><?php the_title(); ?></h3>
                                    </a>
                                </div>

                                <div class="post-meta">
                                    <div class="post-author"><?php echo get_the_author(); ?></div>
                                    <div class="seperator"> <span><?php esc_html_e('|', 'widgetkit-pro'); ?></span></div>
                                    <div class="post-date"><?php echo get_the_date(); ?></div>
                                </div>

                                <?php if($single_post_show_excerpt): ?>
                                    <div class="post-excerpt">
                                        <?php echo wp_trim_words(get_the_excerpt(), $post_excerpt_word_count_layout_1, ''); ?>
                                    </div>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>

                <?php

            endwhile;
            wp_reset_postdata();
            ?>
        </div>
        <?php
    endif;
    ?>
    </div>
    <script>
        jQuery(function($){
            $('.video-post-popup').magnificPopup({
                disableOn: 700,
                type: 'iframe',
                mainClass: 'mfp-fade',
                removalDelay: 160,
                preloader: false,
                fixedContentPos: false
            });
        });
    </script>
    <?php //wp_reset_query(); ?>
</div>