<?php ?>
<div class="dynamic-header-tab row">

    <?php
    /**
     * Argument
     * for query post
     * ================
     */
    $count = 1;
    $args = array(
        'orderby'	=> 'date',
        'order'		=> 'DESC',
        'post_type' =>  'post',
        'showposts'	=> $post_num_to_show,
        'post__not_in' => get_option("sticky_posts"),
    );
    $query = new WP_Query($args);
    ?>
    <div class="dynamic-recent-post-tab container">
        <div class="active-post-content">
            <a href=""> </a>
        </div>
    <?php
    if($query->have_posts()):
        ?>
        <div class="cat-post-list-wrapper owl-carousel">
            <?php
            while($query->have_posts()):
                $query->the_post();
                ?>
                    <div class="regular-post <?php echo ( 1 == $count ) ? 'active' : ''; ?>">
                        <div class="regular-post-wrapper <?php echo esc_html($regular_post_style); ?>">
                            <?php if(has_post_thumbnail()): ?>
                                <div class="post-thumb">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_post_thumbnail('full' ); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                            <div class="post-data">
                                <div class="post-title">
                                    <a href="<?php the_permalink(); ?>" class="regular-post-title regular-title">
                                        <h3><?php the_title(); ?></h3>
                                    </a>
                                </div>
                                <div class="post-meta">
                                    <span class="post-author"><?php echo get_the_author(); ?></span>
                                    <span class="seperator"> <span><?php esc_html_e('|', 'widgetkit-pro'); ?></span></span>
                                    <span class="post-date"><?php echo get_the_date(); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php
                $count++;
            endwhile;
            wp_reset_postdata();
            ?>
        </div>
        <?php
    endif;
    ?>
    </div>
    <script>
        jQuery(function($){
            /**
             * Enable Carousel
             * =================
             */
            $(".dynamic-header-tab .cat-post-list-wrapper").owlCarousel({
                pagination: true,
                dots:false,
                loop:true,
                items:<?php echo $post_column; ?>,
                nav: false,
                navClass: ['owl-carousel-left','owl-carousel-right'],
                navText: ['<i class="fa fa-angle-left fa-fw""></i>', '<i class="fa fa-angle-right fa-fw"></i>'],
                margin:15,
                autoplay:false,
                responsive:{
                    0:{
                        items:1
                    },
                    600:{
                        items:1
                    },
                    1000:{
                        items:<?php echo $post_column; ?>
                    }
                }
            });
            /**
             * Tab function
             * ==============
             */
            if($('.dynamic-header-tab .regular-post').hasClass('active')){
                var activePost = $('.dynamic-header-tab .regular-post.active');

                var imageUrl = $(activePost).find('.post-thumb a img').attr('src');
                var postLink = $(activePost).find('.post-data .post-title a').attr('href');
                var postText = $(activePost).find('.post-data  a.regular-title').html();


                $('.dynamic-header-tab').css('background-image', 'url("' + imageUrl + '")');
                $('.dynamic-header-tab').find('.active-post-content a').attr("href", postLink);
                $('.dynamic-header-tab').find('.active-post-content a').append(postText);
            }

            $('.dynamic-header-tab .regular-post').on('click', function(e){
                e.preventDefault(); // prevent execute

                var imageUrl = $(this).find('.post-thumb a img').attr('src');
                var postLink = $(this).find('.post-data .post-title a').attr('href');
                var postText = $(this).find('.post-data .post-title a').html();

                $('.dynamic-header-tab').find('.regular-post').removeClass('active'); // remove existing content
                $(this).addClass('active'); // add active class to existing item

                setTimeout(function(){
                    $('.dynamic-header-tab').find('.active-post-content a h3').remove(); // remove existing content

                    $('.dynamic-header-tab').css('background-image', 'url("' + imageUrl + '")');
                    $('.dynamic-header-tab').find('.active-post-content a').attr("href", postLink).fadeIn('slow');
                    $('.dynamic-header-tab').find('.active-post-content a').append(postText).fadeIn('slow');
                }, 300)


            });
        });

    </script>

    <?php  //wp_reset_query(); ?>
</div>