    <?php ?>
    <div class="multiple-layout dynamic-layout dynamic-layout-<?php echo $this->get_id(); ?>">
        <?php if(empty($cat_id)):?>
            <div class="empty-cat">
                <h3>Please pick some categories first</h3>
            </div>
        <?php endif;?>
        <?php
        /**
         * Argument
         * for query post
         * ================
         */
        $count = 0;
        $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        $args = array(
            'cat' => $cat_id,
            'posts_per_page' => $post_num_to_show,
            'paged' => $paged,
            'post_type' => 'post'
        );
        $query = new WP_Query($args);
        ?>

        <?php if($layout_title): ?>
            <div class="layout-header">
                <div class="layout-title">
                    <h4>
                        <?php echo esc_html($layout_title); ?>
                    </h4>
                </div>
            </div>
        <?php endif; ?>
        <?php if($navigation_show):?>
        <nav class="multiple-category-navigation <?php echo ($paged == $query->max_num_pages) ? 'last-page' : ''; ?> <?php echo ($paged == 1) ? 'first-page': ''; ?>">
            <ul data-page="<?php echo $paged ?>"
                class="multiple-category-navigation-wrapper"

                data-sectionId="<?php echo $this->get_id(); ?>"
                data-catId="<?php echo $cat_multiple_id; ?>"
                data-highlightFirstPost="<?php echo $highlight_first_post; ?>"
                data-highlightCatTag="<?php echo $show_highlight_cat_tag; ?>"
                data-regularThumbnail="<?php echo $show_regular_thumbnail; ?>"
                data-regularCatTag="<?php echo $show_cat_tag; ?>"
                data-postNumber="<?php echo $post_num_to_show; ?>"
                data-featuredThumbSize="<?php echo $featured_thumbnail_size; ?>"
                data-regularThumbSize="<?php echo $regular_thumbnail_size; ?>"
                data-regularTitleWordCount="<?php echo $title_word; ?>"
                data-showFeaturedExcerpt="<?php echo $show_featured_excerpt; ?>"
                data-featuredExcerptWordCount="<?php echo $featured_excerpt_word_count; ?>"
                data-showRegularExcerpt="<?php echo $show_regular_excerpt; ?>"
                data-regularExcerptWordCount="<?php echo $regular_excerpt_word_count; ?>"
            >

                <li class="multiple-cateogry-prev">
                    <span><i class="fa fa-angle-left"></i></span>
                </li>

                <li class="multiple-cateogry-next">
                    <span><i class="fa fa-angle-right"></i></span>
                </li>
            </ul>
        </nav>
        <?php endif; ?>

        <div data-layout="<?php echo $layout; ?>" data-grid="<?php echo $regular_post_grid; ?>" data-style="<?php echo $regular_post_style; ?>"
             class="cat-post-list dynamic-cat-post-list <?php echo 'grid-'.$regular_post_grid; ?> <?php echo $regular_post_style; ?>">
            <?php if($query->have_posts()): ?>
                <div class="cat-post-list-wrapper">
                    <?php while($query->have_posts()): $query->the_post(); ?>
                    <?php if($count == 0 && ($highlight_first_post == 'yes')): ?>
                        <div class="featured-post">

                            <?php if(has_post_thumbnail()): ?>
                                <div class="post-thumb">
                                    <a href="<?php the_permalink() ?>">
                                        <?php the_post_thumbnail($featured_thumbnail_size); ?>
                                    </a>
                                </div>
                            <?php else: ?>
                                <div class="post-thumb">
                                    <a href="<?php the_permalink() ?>">
                                        <img src="<?php echo esc_url(WKP_PLACEHOLDER_URL); ?>" alt="">
                                    </a>
                                </div>
                            <?php endif; ?>
                            <div class="post-data">
                                <?php if('multiple-category-dynamic-carousel-layout-2' == $layout): ?>
                                    <?php if($show_highlight_cat_tag): ?>
                                        <div class="post-cat">
                                            <?php magmax_limited_cateory_with_seperator_for_elements(get_the_ID()); ?>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <div class="post-title">
                                    <a href="<?php the_permalink(); ?>" class="highlight-post-title highlight-title">
                                        <h3><?php the_title(); ?></h3>
                                    </a>
                                </div>
                                <div class="post-meta">
                                    <div class="post-author"><?php echo get_the_author(); ?></div>
                                    <div class="seperator"> <span><?php esc_html_e('|', 'widgetkit-pro'); ?></span></div>
                                    <div class="post-date"><?php echo get_the_date(); ?></div>
                                </div>
                                <?php if($show_featured_excerpt):?>
                                <div class="post-excerpt">
                                    <?php echo wp_trim_words(get_the_excerpt(), $featured_excerpt_word_count, '');?>
                                </div>
                                <?php endif;?>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="regular-post">
                            <div class="regular-post-wrapper">
                                <?php if(has_post_thumbnail() && ('yes' == $show_regular_thumbnail)): ?>
                                    <div class="post-thumb">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php the_post_thumbnail($regular_thumbnail_size ); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>

                                <div class="post-data">
                                    <?php if($show_cat_tag): ?>
                                    <div class="post-cat">
                                        <?php magmax_limited_cateory_with_seperator_for_elements(get_the_ID()); ?>
                                    </div>
                                    <?php endif; ?>
                                    <div class="post-title">
                                        <a href="<?php the_permalink(); ?>" class="regular-post-title regular-title">
                                            <h3>
                                                <?php magmax_title($title_word); ?>
                                            </h3>
                                        </a>
                                    </div>
                                    <div class="post-meta">
                                        <div class="post-author"><?php echo get_the_author(); ?></div>
                                        <div class="seperator"> <span><?php esc_html_e('|', 'widgetkit-pro'); ?></span></div>
                                        <div class="post-date"><?php echo get_the_date(); ?></div>
                                    </div>
                                    <?php if($show_regular_excerpt):?>
                                    <div class="post-excerpt">
                                        <?php echo wp_trim_words(get_the_excerpt(), $regular_excerpt_word_count, '');?>
                                    </div>
                                    <?php endif;?>
                                </div>

                            </div>
                        </div>
                    <?php endif; ?>
                    <?php $count++; endwhile; wp_reset_postdata(); ?>
                </div>
            <?php endif; ?>

        </div>
        <?php //wp_reset_query(); ?>
    </div>