<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Widgetkit_Pro_Woo_Recent_Product extends Widget_Base
{

    public function get_name()
    {
        return 'widgetkit-pro-woo-recent_product';
    }

    public function get_title()
    {
        return __('Woo Recent Product', 'widgetkit-pro');
    }

    public function get_icon()
    {
        return 'eicon-woocommerce';
    }

    public function get_categories()
    {
        return ['widgetkit_pro'];
    }

    /**
	 * A list of style that the widgets is depended in
	 **/
	public function get_style_depends() {
        return [
            'widgetkit_bs',
            'widgetkit_pro_default',
        ];
    }
	/**
	 * A list of scripts that the widgets is depended in
	 **/
	public function get_script_depends() {
		return [ 
			'wk-pro-tilt-js',
		 ];
	}

    protected function _register_controls()
    {
#   region header        
        /**
         * Header
         */
        $this->start_controls_section(
            'section_control_header',
            [
                'label' => __('Header', 'widgetkit-pro'),
            ]
        );
            $this->add_control(
                'product_layout_header',
                [
                    'label'       => __( 'Header', 'widgetkit-pro' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __( 'Recent Product', 'widgetkit-pro' ),
                    'placeholder' => __( 'Recent Product', 'widgetkit-pro' ),
                ]
            );
        $this->end_controls_section();
#   endregion 

#   region Query 
        /**
         * product 
         */
        $this->start_controls_section(
            'section_control_product',
            [
                'label' => __('Query', 'widgetkit-pro'),
            ]
        );
            $this->add_control(
                'product_query_type',
                [
                    'label'       => __( 'Type', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'latest',
                    'options' => [
                        'latest'  => __( 'Latest', 'widgetkit-pro' ),
                        'featured'  => __( 'Featured', 'widgetkit-pro' ),
                        'best_selling'  => __( 'Best Selling', 'widgetkit-pro' ),
                        'sale'  => __( 'Sale', 'widgetkit-pro' ),
                        'top_rated'  => __( 'Top Rated', 'widgetkit-pro' ),
                    ],
                ]
            );
            $this->add_control(
                'product_order_by',
                [
                    'label'       => __( 'Orderby', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'date',
                    'options' => [
                        'id'  => __( 'ID', 'widgetkit-pro' ),
                        'date'  => __( 'Date', 'widgetkit-pro' ),
                        'title'  => __( 'Title', 'widgetkit-pro' ),
                        'popularity'  => __( 'Popularity', 'widgetkit-pro' ),
                        'rand'  => __( 'Rand', 'widgetkit-pro' ),
                        'Rating'  => __( 'Rating', 'widgetkit-pro' ),
                    ],
                ]
            );
            $this->add_control(
                'product_num_to_show',
                [
                    'label'   => __( 'Product to Show', 'widgetkit-pro' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 8,
                    'min'     => 1,
                    'max'     => 50,
                    'step'    => 1,
                ]
            );
        
        $this->end_controls_section();
#   endregion 

#   region Layout        
        /**
         * Layout
         */
        $this->start_controls_section(
            'section_control_layout',
            [
                'label' => __('Layout', 'widgetkit-pro'),
            ]
        );
            $this->add_control(
                'product_layout',
                [
                    'label'       => __( 'Layout', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'layout_1',
                    'options' => [
                        'layout_1'  => __( 'Layout 1', 'widgetkit-pro' ),
                        'layout_2'  => __( 'Layout 2', 'widgetkit-pro' ),
                    ],
                ]
            );
            $this->add_control(
                'product_layout_style',
                [
                    'label'       => __( 'Style', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'image_top',
                    'options' => [
                        'image_top'  => __( 'Image Top', 'widgetkit-pro' ),
                        'image_left'  => __( 'Image Left', 'widgetkit-pro' ),
                    ],
                    'condition' => [
                        'product_layout' => 'layout_1'
                    ],
                ]
            );
            $this->add_control(
                'product_column_image_top',
                [
                    'label'   => __( 'Column', 'widgetkit-pro' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 4,
                    'min'     => 1,
                    'max'     => 4,
                    'step'    => 1,
                    'condition' => [
                        'product_layout_style' => 'image_top'
                    ]
                ]
            );
            $this->add_control(
                'product_column_image_left',
                [
                    'label'   => __( 'Column', 'widgetkit-pro' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 2,
                    'min'     => 1,
                    'max'     => 4,
                    'step'    => 1,
                    'condition' => [
                        'product_layout_style' => 'image_left'
                    ]
                ]
            );
            $this->add_control(
                'layout_grid_gap',
                [
                    'label'   => esc_html__( 'Grid Gap', 'widgetkit-pro' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'size' =>30,
                    ],
                    'range'  => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .grid' => 'grid-gap: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();
#   endregion         

#   region meta
        $this->start_controls_section(
            'section_control_meta',
            [
                'label' => __('Meta', 'widgetkit-pro'),
            ]
        );
            $this->add_control(
                'show_category',
                [
                    'label' => __( 'Show Category', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'show_product_price',
                [
                    'label' => __( 'Show Price', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'show_product_rating',
                [
                    'label' => __( 'Show Rating', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'show_short_description',
                [
                    'label' => __( 'Show Excerpt', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'show_cart_button',
                [
                    'label' => __( 'Show Cart Button', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'cart_button_layout_style',
                [
                    'label'       => __( 'Cart Button', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'overlay',
                    'options' => [
                        'overlay'  => __( 'Overlay', 'widgetkit-pro' ),
                        'inside_content'  => __( 'Inside Content', 'widgetkit-pro' ),
                    ],
                    'condition' => [
                        'product_layout_style' => 'image_top',
                        'show_cart_button' => 'yes',
                        'product_layout' => 'layout_1',
                    ]
                ]
            );
        $this->end_controls_section();
#   endregion 




#   region header style
        /**
         * header
         */
        $this->start_controls_section(
            'section_style_header',
            [
                'label' => __( 'Header', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label' => __( 'Font', 'widgetkit-pro' ),
                    'name' => 'layout_header_typography',
                    'selector' => '{{WRAPPER}} .woo-layout-header',
                ]
            );
            $this->add_control(
                'layout-header-color',
                [
                    'label' => __( 'Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .woo-layout-header' => 'color: {{VALUE}}'
                    ],
                ]
            );
            $this->add_control(
                'header_bottom_spacing',
                [
                    'label' => __( 'Bottom Spacing', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 35,
                    ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ],
                    ],
                    'size_units' => [ 'px' ],
                    'selectors' => [
                        '{{WRAPPER}} .woo-layout-header' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();
#   endregion        

#   region image style
        $this->start_controls_section(
            'section_style_image',
            [
                'label' => __( 'Image', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                
            ]
        );
            $this->add_control(
                'image_overlay_color',
                [
                    'label' => __( 'Overlay Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .column:hover .product-thumb-wrapper a:before' => 'background: {{VALUE}}',
                    ],
                    'condition' => [
                        'product_layout' => 'layout_1'
                    ],
                ]
            );
            $this->add_control(
                'global_image_border_radius',
                [
                    'label'   => esc_html__( 'Image Radius', 'widgetkit-for-elementor' ),
                    'type'    => Controls_Manager::SLIDER,
                    'range'  => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .grid .column .tilt-element' => 'border-radius: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'product_layout' => 'layout_2'
                    ],
                ]
            );
            
        $this->end_controls_section();

#   end region

#   region title & description style
        /**
         * Title and Description
         */
        $this->start_controls_section(
            'section_style_content',
            [
                'label' => __( 'Title & Description', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'title_section',
                [
                'label' => __( 'Title ', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label' => __( 'Font', 'widgetkit-pro' ),
                    'name' => 'content_title_typography',
                    'selector' => '{{WRAPPER}} .column .product-content h4 a',
                ]
            );
            /**
             * tab start for title
             */
            $this->start_controls_tabs('section_title_style_tabs');
                /**
                 * Normal Tab
                 */
                $this->start_controls_tab(
                    'section_title_style_normal',
                    [
                        'label' => __( 'Normal', 'widgetkit-pro' ),
                    ]
                );
                $this->add_control(
                    'content_title_color',
                    [
                        'label' => __( 'Color', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#3d3d3d',
                        'selectors' => [
                            '{{WRAPPER}} .column .product-content h4 a' => 'color: {{VALUE}} ',
                        ],
                    ]
                );
                $this->end_controls_tab();
                /**
                 * Hover style
                 */
                $this->start_controls_tab(
                    'section_title_style_hover',
                    [
                        'label' => __( 'Hover', 'widgetkit-pro' ),
                    ]
                );
                $this->add_control(
                    'content_title_color_hover',
                    [
                        'label' => __( 'Color', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#7c7000',
                        'selectors' => [
                            '{{WRAPPER}} .column .product-content h4 a:hover' => 'color: {{VALUE}} ',
                        ],
                    ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();

            
    

            /**
             * Description
             */
            $this->add_control(
                'description_section',
                [
                'label' => __( 'Description', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label' => __( 'Font', 'widgetkit-pro' ),
                    'name' => 'content_excerpt_typography',
                    'selector' =>'{{WRAPPER}} .column .product-content .excerpt',
                ]
            );
            $this->add_control(
                'content_excerpt_color',
                [
                    'label' => __( 'Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#707070',
                    'selectors' => [
                        '{{WRAPPER}} .column .product-content .excerpt' => 'color: {{VALUE}}',
                    ],
                ]
            );
            
        
        $this->end_controls_section();
#   endregion 

#   region category style
        $this->start_controls_section(
            'section_style_category',
            [
                'label' => __( 'Category', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label' => __( 'Font', 'widgetkit-pro' ),
                    'name' => 'content_category_typography',
                    'selector' => '{{WRAPPER}} .column .product-content .cat-lists li a',
                ]
            );

            /**
             * Tab start for meta
             */
            $this->start_controls_tabs('section_meta_style_tabs');
            /**
             * Normal Tab
             */
            $this->start_controls_tab(
                'section_meta_style_normal',
                [
                    'label' => __( 'Normal', 'widgetkit-pro' ),
                ]
                );
                $this->add_control(
                    'content_category_color',
                    [
                        'label' => __( 'Color', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#707070',
                        'selectors' => [
                            '{{WRAPPER}} .column .product-content .cat-lists li a' => 'color: {{VALUE}}',
                        ],
                    ]
                );
                $this->end_controls_tab();
                /**
                 * Hover style
                 */
                $this->start_controls_tab(
                'section_meta_style_hover',
                [
                    'label' => __( 'Hover', 'widgetkit-pro' ),
                ]
                );
                $this->add_control(
                    'content_category_color_hover',
                    [
                        'label' => __( 'Color', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#7c7000',
                        'selectors' => [
                            '{{WRAPPER}} .column .product-content .cat-lists li a:hover' => 'color: {{VALUE}} ',
                        ],
                    ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();

        $this->end_controls_section();

#   endregion

#   region Pricing style
        /**
         * pricing
         */
        $this->start_controls_section(
            'section_style_pricing',
            [
                'label' => __( 'Pricing', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Font', 'widgetkit-pro' ),
                'name' => 'content_price_typography',
                'selector' => '{{WRAPPER}} .column .product-content .price, {{WRAPPER}} .recent-prodcut-layout_2 .column .amount',
            ]
        );
        $this->add_control(
            'content_price_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#7c7000',
                'selectors' => [
                    '{{WRAPPER}} .column .product-content .price, {{WRAPPER}} .recent-prodcut-layout_2 .column .amount ' => 'color: {{VALUE}} ',
                    '{{WRAPPER}} .recent-prodcut-layout_2 .column ins' => 'color: {{VALUE}} ',
                    '{{WRAPPER}} .recent-prodcut-layout_2 .column del' => 'color: {{VALUE}} ',
                ],
            ]
        );
        $this->add_control(
            'content_price_hover_color',
            [
                'label' => __( 'Hover Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .recent-prodcut-layout_2 .column .add_to_cart_inline:hover .amount ' => 'color: {{VALUE}} ',
                    '{{WRAPPER}} .recent-prodcut-layout_2 .column .add_to_cart_inline:hover del ' => 'color: {{VALUE}} ',
                    '{{WRAPPER}} .recent-prodcut-layout_2 .column .add_to_cart_inline:hover ins ' => 'color: {{VALUE}} ',
                ],
                'condition' => [
                    'product_layout' => 'layout_2'
                ],
            ]
        );
        
        $this->add_control(
            'product_on_sale',
            [
            'label' => __( 'Sale Badge', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Font', 'widgetkit-pro' ),
                'name' => 'product_sale_typography',
                'selector' => '{{WRAPPER}} .column .product-thumb .onsale',
            ]
        );
        $this->add_control(
            'sale_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .column .product-thumb .onsale' => 'color: {{VALUE}} ',
                ],
            ]
        );
        $this->add_control(
            'sale_background_color',
            [
                'label' => __( 'Background Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#EEB90E',
                'selectors' => [
                    '{{WRAPPER}} .column .product-thumb .onsale' => 'background-color: {{VALUE}} ',
                ],
            ]
        );
        $this->end_controls_section();
#   endregion 


#   region Button style
        /**
         * Button
         */
        $this->start_controls_section(
            'section_style_button',
            [
                'label' => __( 'Cart Button', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_cart_button' => 'yes'
                ]
            ]
        );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label' => __( 'Font', 'widgetkit-pro' ),
                    'name' => 'content_button_typography',
                    'selector' =>'{{WRAPPER}} .column .product-content a.add_to_cart_button, {{WRAPPER}} .column .product-content a.product_type_external, {{WRAPPER}} .column .product-content a.product_type_grouped, {{WRAPPER}} .column .product-content a.product_type_variable, {{WRAPPER}} .column .product-thumb .overlay a.button, {{WRAPPER}} .column .product-thumb .overlay a.product_type_external {{WRAPPER}} .column .product-thumb .overlay a.product_type_grouped',
                ]
            );

            $this->start_controls_tabs('add_to_cart_button_style');
                /**
                 * Normal
                 */
                $this->start_controls_tab(
                    'button_style_normal',
                    [
                        'label' => __( 'Normal', 'widgetkit-pro' ),
                    ]
                );
                $this->add_control(
                    'content_button_color',
                    [
                        'label' => __( 'Text', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#fff',
                        'selectors' => [
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column a.add_to_cart_button' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column a.product_type_external' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column a.product_type_grouped' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column a.product_type_variable' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_2 .column .wkp-product-cart-button .add_to_cart_inline a.button' => 'color: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'content_button_bg_color',
                    [
                        'label' => __( 'Background', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#EEB90E',
                        'selectors' => [
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column a.add_to_cart_button' => 'background: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column a.product_type_external' => 'background: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column a.product_type_grouped' => 'background: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column a.product_type_variable' => 'background: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_2 .column .wkp-product-cart-button .add_to_cart_inline' => 'background: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'button_hr',
                    [
                        'type' => \Elementor\Controls_Manager::DIVIDER,
                    ]
                );
                $this->add_group_control(
                    Group_Control_Border::get_type(), 
                    [
                        'name'          => 'Border',
                        'selector'      => '{{WRAPPER}} .recent-prodcut-layout_1 .column .product-content a.add_to_cart_button, {{WRAPPER}} .recent-prodcut-layout_1 .column .product-content a.product_type_external, {{WRAPPER}} .recent-prodcut-layout_1 .column .product-content a.product_type_variable, {{WRAPPER}} .recent-prodcut-layout_2 .column .wkp-product-cart-button .add_to_cart_inline',
                    ]
                );
                $this->add_control(
                    'cart_border_radius',
                    [
                        'label'   => esc_html__( 'Border Radius', 'widgetkit-for-elementor' ),
                        'type'    => Controls_Manager::SLIDER,
                        'default' => [
                            'size' =>2,
                        ],
                        'range'  => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column .product a.button' => 'border-radius: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .recent-prodcut-layout_2 .column .wkp-product-cart-button .add_to_cart_inline' => 'border-radius: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->end_controls_tab();
                /**
                 * hover
                 */
                $this->start_controls_tab(
                    'button_style_hover',
                    [
                        'label' => __( 'Hover', 'widgetkit-pro' ),
                    ]
                );
                $this->add_control(
                    'content_button_color_hover',
                    [
                        'label' => __( 'Button Text', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#7c7000',
                        'selectors' => [
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column a.add_to_cart_button:hover' => 'color: {{VALUE}} ',
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column a.product_type_external:hover' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column a.product_type_grouped:hover' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column a.product_type_variable:hover' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_2 .column .wkp-product-cart-button .add_to_cart_inline:hover a' => 'color: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'content_button_bg_color_hover',
                    [
                        'label' => __( 'Button Background', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#fff',
                        'selectors' => [
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column a.add_to_cart_button:hover' => 'background: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column a.product_type_external:hover' => 'background: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column a.product_type_grouped:hover' => 'background: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column a.product_type_variable:hover' => 'background: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_2 .column .wkp-product-cart-button .add_to_cart_inline:hover' => 'background: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'content_button_border_color_hover',
                    [
                        'label' => __( 'Button Border', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column .product-content a.add_to_cart_button:hover' => 'border-color: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column .product-content a.product_type_external:hover' => 'border-color: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_1 .column .product-content a.product_type_variable:hover' => 'border-color: {{VALUE}}',
                            '{{WRAPPER}} .recent-prodcut-layout_2 .column .wkp-product-cart-button .add_to_cart_inline:hover' => 'border-color: {{VALUE}}',
                        ],
                    ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();

            $this->add_responsive_control(
                'button_padding',
                [
                    'label'         => __('Padding', 'widgetkit-pro'),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => ['px','%'],
                    'separator'     => 'before',
                    'selectors'     => [
                        '{{WRAPPER}} .recent-prodcut-layout_1 .column .product a.button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .recent-prodcut-layout_2 .column .wkp-product-cart-button .add_to_cart_inline' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
                ]
            );
        $this->end_controls_section();
#   endregion         

#   region global option        
        $this->start_controls_section(
            'section_style_global_option',
            [
                'label' => __( 'Global Option', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'global_content_align',
                [
                    'label' => esc_html__( 'Alignment', 'widgetkit-for-elementor' ),
                    'type'  => Controls_Manager::CHOOSE,
                    'default'   => 'center',
                    'options' => [
                        'left'    => [
                            'title' => esc_html__( 'Left', 'widgetkit-for-elementor' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'widgetkit-for-elementor' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'widgetkit-for-elementor' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .grid .column .product-content' => 'text-align: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'content_bg_color',
                [
                    'label' => __( 'Background', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .column .product-content' => 'background: {{VALUE}}',
                    ],
                ]
            );
            
            
            $this->add_responsive_control(
                'content_padding',
                [
                    'label'         => __('Content Box Padding', 'widgetkit-pro'),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => ['px','%'],
                    'separator'     => 'before',
                    'selectors'     => [
                        '{{WRAPPER}} .column .product-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
                ]
            );
        $this->end_controls_section();
#   endregion 
        

    }


    protected function render()
    {
        $settings = $this->get_settings();
        $product_layout = widgetkit_pro_array_get($settings, 'product_layout');

        ?>

        <div id="woo-product-<?php echo $this->get_id(); ?>" class="woo-recent-product woo-product-<?php echo $this->get_id(); ?> recent-prodcut-<?php echo $product_layout; ?>">
            <?php 
            if( 'layout_2' === $product_layout ):
                include( plugin_dir_path( __FILE__ ) . '../layout/woo/recent-product-layout-2.php'); 
            else:
                include( plugin_dir_path( __FILE__ ) . '../layout/woo/recent-product.php'); 
            endif;
            ?>
        </div>
        <script>
            jQuery(function($){
                if(!$('body').hasClass('wkpro-woo-recent-products')){
                    $('body').addClass('wkpro-woo-recent-products');
                }
            });
        </script>

    <?php
    }
    protected function _content_template()
    {
    }
}
