<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Widgetkit_Pro_Woo_Products extends Widget_Base
{

    public function get_name()
    {
        return 'widgetkit-pro-woo-products';
    }

    public function get_title()
    {
        return __('Woo Products', 'widgetkit-pro');
    }

    public function get_icon()
    {
        return 'eicon-woocommerce';
    }

    public function get_categories()
    {
        return ['widgetkit_pro'];
    }

    /**
	 * A list of style that the widgets is depended in
	 **/
	public function get_style_depends() {
        return [
            // 'widgetkit_bs',
            'widgetkit_pro_default',
            'uikit',
        ];
    }
	/**
	 * A list of scripts that the widgets is depended in
	 **/
	public function get_script_depends() {
		return [ 
			'uikit-js',
			'uikit-icons',
		 ];
	}

    protected function _register_controls()
    {
        /**
         * get all product category
         */
        $product_cats = array();
        $terms = get_terms( array(
            'taxonomy' => 'product_cat',
            'hide_empty' => false,
        ) );
        foreach( $terms as $t ):
            $product_cats[$t->term_id] = $t->name;
        endforeach;
        /**
         * get all product
         */
        $product_name = array();
        $p_args = array(
            'post_type' => 'product',
            'orderby' =>'date',
            'order' => 'DESC'
        );
        $p_loop = new WP_Query( $p_args );
        if($p_loop->have_posts()): while($p_loop->have_posts()): $p_loop->the_post();
            $product_name[get_the_ID()] = get_the_title(get_the_ID());
        endwhile; wp_reset_query(); endif;

        /**
         * Header
         */
        $this->start_controls_section(
            'section_control_header',
            [
                'label' => __('Header', 'widgetkit-pro'),
            ]
        );
        
        $this->add_control(
            'product_layout_header',
            [
                'label'       => __( 'Header', 'widgetkit-pro' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Recent Product', 'widgetkit-pro' ),
                'placeholder' => __( 'Recent Product', 'widgetkit-pro' ),
            ]
        );
        $this->end_controls_section();
        /**
         * Layout
         */
        $this->start_controls_section(
            'section_control_layout',
            [
                'label' => __('Layout', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'product_layout_skin',
            [
                'label'       => __( 'Skin', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'classic',
                'options' => [
                    'modern'  => __( 'Skin 1', 'widgetkit-pro' ),
                    'classic'  => __( 'Skin 2', 'widgetkit-pro' ),
                    'skin3'  => __( 'Skin 3', 'widgetkit-pro' ),
                    'skin4'  => __( 'Skin 4', 'widgetkit-pro' ),
                    'skin5'  => __( 'Skin 5', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'product_layout_style',
            [
                'label'       => __( 'Layout', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'grid',
                'options' => [
                    'grid'  => __( 'Grid', 'widgetkit-pro' ),
                    'slider'  => __( 'Slider', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'product_column_grid',
            [
                'label'   => __( 'Column', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 4,
                'min'     => 1,
                'max'     => 6,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'product_layout_slider_grid_gap',
            [
                'label'       => __( 'Grid Gap', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'wk-grid-medium',
                'options' => [
                    'wk-grid-small'  => __( 'Small', 'widgetkit-pro' ),
                    'wk-grid-medium'  => __( 'Medium', 'widgetkit-pro' ),
                    'wk-grid-large'  => __( 'Large', 'widgetkit-pro' ),
                    'wk-grid-collapse'  => __( 'collapse', 'widgetkit-pro' ),
                ],
                'condition' => [
                    'product_layout_style' => 'slider'
                ]
            ]
        );
        
        $this->end_controls_section();


        /**
         * product Query 
         */
        $this->start_controls_section(
            'section_control_product',
            [
                'label' => __('Query', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'product_query_type',
            [
                'label'       => __( 'Type', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'all_products',
                'options' => [
                    'all_products'  => __( 'All Products', 'widgetkit-pro' ),
                    'custom_query'  => __( 'Custom Query', 'widgetkit-pro' ),
                    'manual_selection'  => __( 'Manual Selection', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'product_num_to_show',
            [
                'label'   => __( 'Number of Product to Show', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 8,
                'min'     => 1,
                'max'     => 50,
                'step'    => 1,
                'condition' => [
                    'product_query_type' =>['all_products','custom_query']
                ]
            ]
        );
        /**
         * custom query
         */
        $this->add_control(
            'product_category_filter_rule',
            [
                'label'       => __( 'Category Filter Rule', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'match_cat',
                'separator' => 'before',
                'options' => [
                    'match_cat'  => __( 'Match Category', 'widgetkit-pro' ),
                    'exclude_cat'  => __( 'Exclude Category', 'widgetkit-pro' ),
                ],
                'condition' => [
                    'product_query_type' => 'custom_query'
                ]
            ]
        );
        $this->add_control(
            'select_product_category',
            [
                'label'       => __( 'Select Categories', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT2,
                'default' => 'latest',
                'multiple' => true,
                'options' => $product_cats,
                'condition' => [
                    'product_query_type' => 'custom_query'
                ]
            ]
        );
        $this->add_control(
            'product_offset',
            [
                'label'   => __( 'Offset', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => '0',
                'min'     => 0,
                'max'     => 50,
                'step'    => 1,
                'separator' => 'before',
                'condition' => [
                    'product_query_type' =>['all_products','custom_query']
                ]
            ]
        );
        $this->add_control(
            'product_exclude_from_query',
            [
                'label'       => __( 'Exclude Product', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT2,
                'separator' => 'before',
                'multiple' => true,
                'options' => $product_name,
                'condition' => [
                    'product_query_type' =>['all_products','custom_query']
                ]
            ]
        );
        $this->add_control(
            'product_include_to_query',
            [
                'label'       => __( 'Choose Products', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT2,
                'separator' => 'before',
                'multiple' => true,
                'options' => $product_name,
                'condition' => [
                    'product_query_type' => 'manual_selection'
                ]
            ]
        );
        /**
         * advanced query option
         */
        $this->add_control(
            'section_title_advance',
            [
            'label' => __( 'Advance', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            ]
        );
        $this->add_control(
            'product_query_filterby',
            [
                'label'       => __( 'Filter By', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'latest',
                'options' => [
                    'latest'  => __( 'Latest', 'widgetkit-pro' ),
                    'featured'  => __( 'Featured', 'widgetkit-pro' ),
                    // 'best_selling'  => __( 'Best Selling', 'widgetkit-pro' ),
                    'sale'  => __( 'Sale', 'widgetkit-pro' ),
                    // 'top_rated'  => __( 'Top Rated', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'product_query_orderby',
            [
                'label'       => __( 'Orderby', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'id'  => __( 'ID', 'widgetkit-pro' ),
                    'date'  => __( 'Date', 'widgetkit-pro' ),
                    'title'  => __( 'Title', 'widgetkit-pro' ),
                    'popularity'  => __( 'Popularity', 'widgetkit-pro' ),
                    'rand'  => __( 'Rand', 'widgetkit-pro' ),
                    'Rating'  => __( 'Rating', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'product_query_order',
            [
                'label'       => __( 'Order', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'ASC'  => __( 'Asending', 'widgetkit-pro' ),
                    'DESC'  => __( 'Desending', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->end_controls_section();

        /**
         * Content 
         */
        $this->start_controls_section(
            'section_control_content',
            [
                'label' => __('Content', 'widgetkit-pro'),
            ]
        );
            $this->add_control(
                'show_cart_button',
                [
                    'label' => __( 'Show Cart Button', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'cart_button_layout_style',
                [
                    'label'       => __( 'Cart Button', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'overlay',
                    'options' => [
                        'overlay'  => __( 'Overaly', 'widgetkit-pro' ),
                        'inside_content'  => __( 'Inside Content', 'widgetkit-pro' ),
                    ],
                    'condition' => [
                        'show_cart_button' => 'yes',
                        'product_layout_skin' => 'classic'
                    ]
                ]
            );
            $this->add_control(
                'quick_view_button',
                [
                    'label'       => __( 'Quick View', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'show_category',
                [
                    'label' => __( 'Show Category', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'show_product_price',
                [
                    'label' => __( 'Show Price', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'show_product_sale_badge',
                [
                    'label' => __( 'Sale Badge', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'show_product_rating',
                [
                    'label' => __( 'Show Rating', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                    'condition' => [
                        'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                    ]
                ]
            );
            $this->add_control(
                'show_short_description',
                [
                    'label' => __( 'Show Excerpt', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                    'condition' => [
                        'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                    ]
                ]
            );
        $this->end_controls_section();
        /**
         * slider control 
         */
        $this->start_controls_section(
            'section_control_sale_badge',
            [
                'label' => __('Sale Badge', 'widgetkit-pro'),
                'condition' => [
                    'show_product_sale_badge' => 'yes'
                ]
            ]
        );
            $this->add_control(
                'custom_sale_badge_switcher',
                [
                    'label' => __( 'Custom Text', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'label_on' => __( 'Yes', 'widgetkit-pro' ),
                    'label_off' => __( 'No', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'custom_sale_badge_text_input',
                [
                    'label'       => __( 'Text', 'widgetkit-pro' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __( 'Sale!', 'widgetkit-pro' ),
                    'condition' => [
                        'custom_sale_badge_switcher' => 'yes'
                    ]
                ]
            );
        $this->end_controls_section();

        /**
         * slider control 
         */
        $this->start_controls_section(
            'section_control_control',
            [
                'label' => __('Control', 'widgetkit-pro'),
                'condition' => [
                    'product_layout_style' => 'slider'
                ]
            ]
        );
            $this->add_control(
                'section_title_navigation_arrow',
                [
                'label' => __( 'Navigation Arrow', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                ]
            );
            $this->add_control(
                'slider_navigation_arrow_position',
                [
                    'label'       => __( 'Arrow', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'inside',
                    'options' => [
                        'inside'  => __( 'Inside', 'widgetkit-pro' ),
                        'outside'  => __( 'Outside', 'widgetkit-pro' ),
                    ],
                ]
            );
            $this->add_control(
                'nav_arrow_view_on_hover',
                [
                    'label' => __( 'View on Hover', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                    'condition' => [
                        'slider_navigation_arrow_position' => 'inside'
                    ]
                ]
            );
            /**
             * navigation dot
             */
            $this->add_control(
                'section_title_navigation_dots',
                [
                'label' => __( 'Navigation Dots', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                ]
            );
            
            $this->add_control(
                'nav_dot_view',
                [
                    'label' => __( 'Display', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'section_title_navigation_other',
                [
                'label' => __( 'Others', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
                ]
            );
            $this->add_control(
                'slider_auto_play',
                [
                    'label' => __( 'Auto Play', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'slider_auto_play_interval',
                [
                    'label' => __( 'Autoplay Interval', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 4000,
                    ],
                    'range' => [
                        'px' => [
                            'min' => 100,
                            'max' => 10000,
                            'step' => 100,
                        ],
                    ],
                    'size_units' => [  ],
                    'condition' => [
                        'slider_auto_play' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'slider_pause_on_hover',
                [
                    'label' => __( 'Pause on Hover', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'label_on' => __( 'Yes', 'widgetkit-pro' ),
                    'label_off' => __( 'No', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                    'condition' => [
                        'slider_auto_play' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'slider_slides_on_set',
                [
                    'label' => __( 'Slides on Set', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'label_on' => __( 'Yes', 'widgetkit-pro' ),
                    'label_off' => __( 'No', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'slider_slides_loop',
                [
                    'label' => __( 'loop', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'label_on' => __( 'Yes', 'widgetkit-pro' ),
                    'label_off' => __( 'No', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
        $this->end_controls_section();

// #region Header style 

        /**
         * header
         */
        $this->start_controls_section(
            'section_style_header',
            [
                'label' => __( 'Header', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'layout-header-color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .woo-layout-header' => 'color: {{VALUE}}'
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'name' => 'layout_header_typography',
                'selector' => '{{WRAPPER}} .woo-layout-header',
            ]
        );
        $this->add_control(
            'single_product_header_align',
            [
                'label' => esc_html__( 'Alignment', 'widgetkit-for-elementor' ),
                'type'  => Controls_Manager::CHOOSE,
                'default'   => 'center',
                'options' => [
                    'left'    => [
                        'title' => esc_html__( 'Left', 'widgetkit-for-elementor' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'widgetkit-for-elementor' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'widgetkit-for-elementor' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .woo-layout-header' => 'text-align: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'header_bottom_spacing',
            [
                'label' => __( 'Bottom Spacing', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 35,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'separator' => 'before',
                'selectors' => [
					'{{WRAPPER}} .woo-layout-header' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
            ]
        );
        
        $this->end_controls_section();

// #endregion        

// #region title and description style

        /**
         * Title and Description
         */
        $this->start_controls_section(
            'section_style_content',
            [
                'label' => __( 'Title & Description', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_section',
            [
            'label' => __( 'Title ', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'name' => 'content_title_typography',
                'selector' => '{{WRAPPER}} .column .product-content h4 a',
            ]
        );
        /**
         * tab start for title
         */
        $this->start_controls_tabs('section_title_style_tabs');
            /**
             * Normal Tab
             */
            $this->start_controls_tab(
                'section_title_style_normal',
                [
                    'label' => __( 'Normal', 'widgetkit-pro' ),
                ]
            );
            $this->add_control(
                'content_title_color',
                [
                    'label' => __( 'Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#3d3d3d',
                    'selectors' => [
                        '{{WRAPPER}} .column .product-content h4 a' => 'color: {{VALUE}} ',
                    ],
                ]
            );
            $this->end_controls_tab();
            /**
             * Hover style
             */
            $this->start_controls_tab(
                'section_title_style_hover',
                [
                    'label' => __( 'Hover', 'widgetkit-pro' ),
                ]
            );
            $this->add_control(
                'content_title_color_hover',
                [
                    'label' => __( 'Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#7c7000',
                    'selectors' => [
                        '{{WRAPPER}} .column .product-content h4 a:hover' => 'color: {{VALUE}} ',
                    ],
                ]
            );
            $this->end_controls_tab();
            
        $this->end_controls_tabs();
        $this->add_control(
            'title_bottom_spacing',
            [
                'label' => __( 'Bottom Spacing', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                // 'default' => [
                //     'size' => 35,
                // ],
                'range' => [
                    'px' => [
                        'min' => -20,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'selectors' => [
					'{{WRAPPER}} .column .product-content h4' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
            ]
        );

        /**
         * Meta
         */
        $this->add_control(
            'meta_section',
            [
            'label' => __( 'Meta ', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'name' => 'content_category_typography',
                'selector' => '{{WRAPPER}} .column .product-content .cat-lists li a',
            ]
        );

        /**
         * Tab start for meta
         */
        $this->start_controls_tabs('section_meta_style_tabs');
        /**
         * Normal Tab
         */
        $this->start_controls_tab(
            'section_meta_style_normal',
            [
                'label' => __( 'Normal', 'widgetkit-pro' ),
            ]
            );
            $this->add_control(
                'content_category_color',
                [
                    'label' => __( 'Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#707070',
                    'selectors' => [
                        '{{WRAPPER}} .column .product-content .cat-lists li a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->end_controls_tab();
            /**
             * Hover style
             */
            $this->start_controls_tab(
            'section_meta_style_hover',
            [
                'label' => __( 'Hover', 'widgetkit-pro' ),
            ]
            );
            $this->add_control(
                'content_category_color_hover',
                [
                    'label' => __( 'Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#7c7000',
                    'selectors' => [
                        '{{WRAPPER}} .column .product-content .cat-lists li a:hover' => 'color: {{VALUE}} ',
                    ],
                ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'meta_bottom_spacing',
            [
                'label' => __( 'Bottom Spacing', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                // 'default' => [
                //     'size' => 20,
                // ],
                'range' => [
                    'px' => [
                        'min' => -20,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'selectors' => [
					'{{WRAPPER}} .column .product-content .cat-lists' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
            ]
        );
    

        /**
         * Description
         */
        $this->add_control(
            'description_section',
            [
            'label' => __( 'Description', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            'condition' => [
                'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
            ]
            ]
        );
        $this->add_control(
            'content_excerpt_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#707070',
                'selectors' => [
                    '{{WRAPPER}} .column .product-content .excerpt' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'name' => 'content_excerpt_typography',
                'selector' =>'{{WRAPPER}} .column .product-content .excerpt',
                'condition' => [
                    'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                ]
            ]
        );
        $this->add_control(
            'description_bottom_spacing',
            [
                'label' => __( 'Bottom Spacing', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                // 'default' => [
                //     'size' => 20,
                // ],
                'range' => [
                    'px' => [
                        'min' => -20,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'selectors' => [
					'{{WRAPPER}} .column .product-content .excerpt' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                ]
            ]
        );
        
        
        $this->end_controls_section();

// #endregion

// #region Pricing style       

        /**
         * pricing
         */
        $this->start_controls_section(
            'section_style_pricing',
            [
                'label' => __( 'Pricing', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'name' => 'content_price_typography',
                'selector' => '{{WRAPPER}} .column .product-content .price',
            ]
        );
        $this->add_control(
            'content_price_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#7c7000',
                'selectors' => [
                    '{{WRAPPER}} .column .product-content .price' => 'color: {{VALUE}} ',
                ],
            ]
        );
        
        $this->end_controls_section();
// #endregion

// #region sale badge
        $this->start_controls_section(
            'section_style_sale_badge',
            [
                'label' => __( 'Sale Badge', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_product_sale_badge' => 'yes'
                ]
            ]
        );
        // $this->add_control(
        //     'product_on_sale',
        //     [
        //     'label' => __( 'Product On Sale', 'widgetkit-pro' ),
        //     'type' => Controls_Manager::HEADING,
        //     'separator' => 'before',
        //     ]
        // );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'name' => 'product_sale_typography',
                'selector' => '{{WRAPPER}} .column .product-thumb .onsale',
            ]
        );
        $this->add_control(
            'sale_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .column .product-thumb .onsale' => 'color: {{VALUE}} ',
                ],
            ]
        );
        $this->add_control(
            'sale_background_color',
            [
                'label' => __( 'Background Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#EEB90E',
                'selectors' => [
                    '{{WRAPPER}} .column .product-thumb .onsale' => 'background-color: {{VALUE}} ',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(), 
            [
                'name'          => 'sale-border',
                'selector'      => '{{WRAPPER}} .column .product-thumb .onsale',
            ]
        );
        $this->add_control(
            'sale_border_radius',
            [
                'label'   => esc_html__( 'Border Radius', 'widgetkit-for-elementor' ),
                'type'    => Controls_Manager::SLIDER,
                'default' => [
                    'size' =>2,
                ],
                'range'  => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .column .product-thumb .onsale' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
// #endregion

// #region Button style

        /**
         * Button
         */
        $this->start_controls_section(
            'section_style_button',
            [
                'label' => __( 'Cart Button', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_cart_button' => 'yes'
                ]
            ]
        );
        $this->add_control(
            'add_custom_cart_icon',
            [
                'label' => __( 'Custom Icon', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => __( 'Show', 'widgetkit-pro' ),
                'label_off' => __( 'Hide', 'widgetkit-pro' ),
                'return_value' => 'yes',
                'condition' => [
                    'product_layout_skin' => ['modern', 'skin3', 'skin4', 'skin5', ]
                ]
            ]
        );
        $this->add_control(
            'cart_icon',
            [
                'label' => esc_html__( 'Icon', 'widgetkit-for-elementor' ),
                'type'              => Controls_Manager::ICONS,
                'fa4compatibility'  => 'feature_icon',
                'default'    =>  [
                    'value'     => 'fas fa-shopping-cart',
                    // 'library'   => 'fa-solid',
                ],
                'label_block'   => true,
                'condition' => [
                    'add_custom_cart_icon' => 'yes',
                    'product_layout_skin' => ['modern', 'skin3', 'skin4', 'skin5', ]

                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'name' => 'content_button_typography',
                'selector' =>'{{WRAPPER}} .column .product a.add_to_cart_button, {{WRAPPER}} .column .product a.product_type_external, {{WRAPPER}} .column .product .product_type_grouped',
            ]
        );
            $this->start_controls_tabs('add_to_cart_button_style');
                /**
                 * Normal
                 */
                $this->start_controls_tab(
                    'button_style_normal',
                    [
                        'label' => __( 'Normal', 'widgetkit-pro' ),
                    ]
                );
                $this->add_control(
                    'content_button_color',
                    [
                        'label' => __( 'Text', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#fff',
                        'selectors' => [
                            '{{WRAPPER}} .column a.button .wk-icon' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .column a.add_to_cart_button' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .column a.add_to_cart_button svg' => 'fill: {{VALUE}}',
                            '{{WRAPPER}} .column a.product_type_external' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .column a.product_type_external svg' => 'fill: {{VALUE}}',
                            '{{WRAPPER}} .column a.product_type_grouped' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .column a.product_type_grouped svg' => 'fill: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'content_button_bg_color',
                    [
                        'label' => __( 'Background', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#EEB90E',
                        'selectors' => [
                            '{{WRAPPER}} .column a.add_to_cart_button' => 'background: {{VALUE}}',
                            '{{WRAPPER}} .column a.product_type_external' => 'background: {{VALUE}}',
                            '{{WRAPPER}} .column a.product_type_grouped' => 'background: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'button_hr',
                    [
                        'type' => \Elementor\Controls_Manager::DIVIDER,
                    ]
                );
                $this->add_group_control(
                    Group_Control_Border::get_type(), 
                    [
                        'name'          => 'Border',
                        'selector'      => '{{WRAPPER}} .column .product a.button',
                        'condition' => [
                            'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                        ]
                    ]
                );
                $this->add_control(
                    'cart_border_radius',
                    [
                        'label'   => esc_html__( 'Border Radius', 'widgetkit-for-elementor' ),
                        'type'    => Controls_Manager::SLIDER,
                        'default' => [
                            'size' =>2,
                        ],
                        'range'  => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .column .product a.button' => 'border-radius: {{SIZE}}{{UNIT}};',
                        ],
                        'condition' => [
                            'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                        ]
                    ]
                );
                $this->end_controls_tab();
                /**
                 * hover
                 */
                $this->start_controls_tab(
                    'button_style_hover',
                    [
                        'label' => __( 'Hover', 'widgetkit-pro' ),
                    ]
                );
                $this->add_control(
                    'content_button_color_hover',
                    [
                        'label' => __( 'Button Text', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#7c7000',
                        'selectors' => [
                            '{{WRAPPER}} .column a.button:hover .wk-icon' => 'color: {{VALUE}} ',
                            '{{WRAPPER}} .column a.add_to_cart_button:hover' => 'color: {{VALUE}} ',
                            '{{WRAPPER}} .column a.add_to_cart_button:hover svg' => 'fill: {{VALUE}} ',
                            '{{WRAPPER}} .column a.product_type_external:hover' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .column a.product_type_external:hover svg' => 'fill: {{VALUE}}',
                            '{{WRAPPER}} .column a.product_type_grouped:hover' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .column a.product_type_grouped:hover svg' => 'fill: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'content_button_bg_color_hover',
                    [
                        'label' => __( 'Button Background', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#fff',
                        'selectors' => [
                            '{{WRAPPER}} .column a.add_to_cart_button:hover' => 'background: {{VALUE}}',
                            '{{WRAPPER}} .column a.product_type_external:hover' => 'background: {{VALUE}}',
                            '{{WRAPPER}} .column a.product_type_grouped:hover' => 'background: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'content_button_border_color_hover',
                    [
                        'label' => __( 'Button Border', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .column a.add_to_cart_button:hover' => 'border-color: {{VALUE}}',
                            '{{WRAPPER}} .column a.product_type_external:hover' => 'border-color: {{VALUE}}',
                        ],
                        'condition' => [
                            'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                        ]
                    ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_control(
                'cart_view_icon_width',
                [
                    'label'   => esc_html__( 'Icon Size', 'widgetkit-for-elementor' ),
                    'type'    => Controls_Manager::SLIDER,
                    'range'  => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                        ],
                    ],
                    'separator'     => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .column .product a.button i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .column .product a.button svg' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'product_layout_skin' => ['modern', 'skin3', 'skin4', 'skin5', ]
                    ]
                ]
            );
            $this->add_responsive_control(
                'cart_button_padding',
                [
                    'label'         => __('Padding', 'widgetkit-pro'),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => ['px'],
                    'selectors'     => [
                        '{{WRAPPER}} .woo-products .column a.button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};', 
                    ],
                    'condition' => [
                        'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                    ],
                ]
            );
            $this->add_responsive_control(
                'cart_button_margin',
                [
                    'label'         => __('Margin', 'widgetkit-pro'),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => ['px'],
                    'selectors'     => [
                        '{{WRAPPER}} .woo-products .column a.button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};', 
                    ],
                    'condition' => [
                        'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                    ],
                ]
            );
        $this->end_controls_section();

// #endregion        

// #region Quick View style 

        /**
         * Quick View Button
         */
        $this->start_controls_section(
            'section_style_qv_button',
            [
                'label' => __( 'Quick View', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'quick_view_button' => 'yes'
                ]
            ]
        );
        $this->add_control(
            'add_custom_icon',
            [
                'label' => __( 'Custom Icon', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => __( 'Show', 'widgetkit-pro' ),
                'label_off' => __( 'Hide', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'quick_view_icon',
            [
                'label' => esc_html__( 'Icon', 'widgetkit-for-elementor' ),
                'type'              => Controls_Manager::ICONS,
                'fa4compatibility'  => 'feature_icon',
                'default'    =>  [
                    'value'     => 'fa fa-eye',
                    'library'   => 'fa-solid',
                ],
                'label_block'   => true,
                'condition' => [
                    'add_custom_icon' => 'yes'
                ]
            ]
        );
        
        // $this->add_group_control(
        //     Group_Control_Typography::get_type(),
        //     [
        //         'label' => __( 'Typography', 'widgetkit-pro' ),
        //         'name' => 'content_qv_button_typography',
        //         'selector' =>'{{WRAPPER}} .column .product-content .wk-quick-view-button',
        //     ]
        // );
            $this->start_controls_tabs('qv_button_style');
                /**
                 * Normal
                 */
                $this->start_controls_tab(
                    'qv_button_style_normal',
                    [
                        'label' => __( 'Normal', 'widgetkit-pro' ),
                    ]
                );
                $this->add_control(
                    'content_qv_button_color',
                    [
                        'label' => __( 'Text', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#fff',
                        'selectors' => [
                            '{{WRAPPER}} .column .wk-quick-view-button' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .column .wk-quick-view-button svg' => 'fill: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'content_qv_button_bg_color',
                    [
                        'label' => __( 'Background', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#EEB90E',
                        'selectors' => [
                            '{{WRAPPER}} .column .wk-quick-view-button' => 'background: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'qv_button_hr',
                    [
                        'type' => \Elementor\Controls_Manager::DIVIDER,
                    ]
                );
                $this->add_group_control(
                    Group_Control_Border::get_type(), 
                    [
                        'name'          => 'qv_border',
                        'selector'      => '{{WRAPPER}} .column .wk-quick-view-button',
                        'condition' => [
                            'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                        ]
                    ]
                );
                $this->add_control(
                    'qv_border_radius',
                    [
                        'label'   => esc_html__( 'Border Radius', 'widgetkit-for-elementor' ),
                        'type'    => Controls_Manager::SLIDER,
                        'default' => [
                            'size' =>2,
                        ],
                        'range'  => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .column .wk-quick-view-button' => 'border-radius: {{SIZE}}{{UNIT}};',
                        ],
                        'condition' => [
                            'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                        ]
                    ]
                );
                $this->end_controls_tab();
                /**
                 * hover
                 */
                $this->start_controls_tab(
                    'qv_button_style_hover',
                    [
                        'label' => __( 'Hover', 'widgetkit-pro' ),
                    ]
                );
                $this->add_control(
                    'content_qv_button_color_hover',
                    [
                        'label' => __( 'Text', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#7c7000',
                        'selectors' => [
                            '{{WRAPPER}} .column .wk-quick-view-button:hover' => 'color: {{VALUE}} ',
                            '{{WRAPPER}} .column .wk-quick-view-button:hover svg' => 'fill: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'content_qv_button_bg_color_hover',
                    [
                        'label' => __( 'Background', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#fff',
                        'selectors' => [
                            '{{WRAPPER}} .column .wk-quick-view-button:hover' => 'background: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'content_qv_button_border_color_hover',
                    [
                        'label' => __( 'Button Border', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .column .wk-quick-view-button:hover' => 'border-color: {{VALUE}}',
                        ],
                        'condition' => [
                            'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                        ]
                    ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_control(
                'quick_view_icon_width',
                [
                    'label'   => esc_html__( 'Icon Size', 'widgetkit-for-elementor' ),
                    'type'    => Controls_Manager::SLIDER,
                    'range'  => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                        ],
                    ],
                    'separator'     => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .column .wk-quick-view-button i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .column .wk-quick-view-button svg' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'qv_button_padding',
                [
                    'label'         => __('Padding', 'widgetkit-pro'),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => ['px','%'],
                    
                    'selectors'     => [
                        '{{WRAPPER}} .column .wk-quick-view-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
                    'condition' => [
                        'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                    ]
                ]
            );
        $this->end_controls_section();

// #endregion        

// #region Navigation style 

        /**
         * Navigation
         */
        $this->start_controls_section(
            'section_style_navigation',
            [
                'label' => __( 'Navigation', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'product_layout_style' => 'slider'
                ]
            ]
        );
            $this->add_control(
                'section_heading_navigation_arrow',
                [
                'label' => __( 'Arrow', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                ]
            );
            
            $this->add_control(
                'navigation_arrow_width_height',
                [
                    'label'   => esc_html__( 'Size', 'widgetkit-for-elementor' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'size' =>35,
                    ],
                    'range'  => [
                        'px' => [
                            'min' => 10,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .woo-products .wk-slider .wk-slidenav' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'navigation_arrow_font_size',
                [
                    'label'   => esc_html__( 'Font Size', 'widgetkit-for-elementor' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'size' =>12,
                    ],
                    'range'  => [
                        'px' => [
                            'min' => 10,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .woo-products .wk-slider .wk-slidenav svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'navigation_arrow_color',
                [
                    'label' => __( 'Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#eeb90e',
                    'separator' => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .woo-products .wk-slider .wk-slidenav svg' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'navigation_arrow_background_color',
                [
                    'label' => __( 'Background', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#fff',
                    'selectors' => [
                        '{{WRAPPER}} .woo-products .wk-slider .wk-slidenav' => 'background: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'navigation_arrow_border_radius',
                [
                    'label'   => esc_html__( 'Border Radius', 'widgetkit-for-elementor' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'size' =>50,
                    ],
                    'range'  => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .woo-products .wk-slider .wk-slidenav' => 'border-radius: {{SIZE}}{{UNIT}};',
                    ],
                    'separator' => 'before'
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(), 
                [
                    'name'          => 'navigation_arrow_border',
                    'label' => __( 'Border', 'widgetkit-pro' ),
                    'selector'      => '{{WRAPPER}} .woo-products .wk-slider .wk-slidenav',
                ]
            );
            $this->add_control(
                'navigation_arrow_enable_box_shadow',
                [
                    'label' => __( 'Box Shadow', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'navigation_arrow_box-shadow',
                [
                    'label' => __( 'Box Shadow', 'widgetkit-pro' ),
                    'type' => Controls_Manager::BOX_SHADOW,
                    'default' => [
                        'color' => 'rgba(0,0,0,.08)',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .woo-products .wk-slider .wk-slidenav' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
                    ],
                    'condition' => [
                        'navigation_arrow_enable_box_shadow' => 'yes'
                    ]
                ]
            );
            
            /**
             * Dot
             */
            $this->add_control(
                'section_heading_navigation_dot',
                [
                'label' => __( 'Dot', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                ]
            );
            $this->add_control(
                'navigation_dot_background_color',
                [
                    'label' => __( 'Background', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => 'rgba(238,185,14,0.35)',
                    'selectors' => [
                        '{{WRAPPER}} .woo-products .wk-slider .wk-dotnav li a' => 'background: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'navigation_dot_active_background_color',
                [
                    'label' => __( 'Active Background', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#eeb90e',
                    'selectors' => [
                        '{{WRAPPER}} .woo-products .wk-slider .wk-dotnav li.wk-active a' => 'background: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'navigation_dot_margin-top',
                [
                    'label'   => esc_html__( 'Spacing Top', 'widgetkit-for-elementor' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'size' =>20,
                    ],
                    'range'  => [
                        'px' => [
                            'min' => -50,
                            'max' => 200,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .woo-products .wk-slider .wk-dotnav' => 'margin-top: {{SIZE}}{{UNIT}} !important ;',
                    ],
                ]
            );
        $this->end_controls_section();

// #endregion

// #region Single Product style 

        /**
         * Single Product style
         */
        $this->start_controls_section(
            'section_style_single_product_style',
            [
                'label' => __( 'Global Option', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                
            ]
        );
        
            $this->add_control(
                'single_product_content_align',
                [
                    'label' => esc_html__( 'Alignment', 'widgetkit-for-elementor' ),
                    'type'  => Controls_Manager::CHOOSE,
                    'default'   => 'center',
                    'options' => [
                        'left'    => [
                            'title' => esc_html__( 'Left', 'widgetkit-for-elementor' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'widgetkit-for-elementor' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'widgetkit-for-elementor' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                    ],
                    'condition' => [
                        'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .woo-products .column .product-content, {{WRAPPER}} .woo-products .wk-slider .column .product-content, {{WRAPPER}} .woo-products-skin-skin5 .column .product-content' => 'text-align: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'single_product_rating_color',
                [
                    'label' => __( 'Rating', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#EEB90E',
                    'selectors' => [
                        '{{WRAPPER}} .woo-products .column .star-rating, {{WRAPPER}} .woo-products .column .woocommerce-review-link' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                    ],
                ]
            );
            $this->add_control(
                'single_product_background_color',
                [
                    'label' => __( 'Background', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#fff',
                    'selectors' => [
                        '{{WRAPPER}} .woo-products-skin-modern .column .product-content' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .woo-products-skin-classic .column .product-content' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .woo-products-skin-skin3 .column .product-content' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .woo-products .wk-slider .column .product-content, {{WRAPPER}} .woo-products-skin-skin5 .column .product-content, {{WRAPPER}} .woo-products-skin-skin5 .column .product-column-wrapper .hover-content, {{WRAPPER}} .woo-products-skin-skin5 .column .wrap-product-in-hover' => 'background: {{VALUE}}',
                    ],
                    'condition' => [
                        'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_padding',
                [
                    'label'         => __('Content Box Padding', 'widgetkit-pro'),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => ['px'],
                    'selectors'     => [
                        '{{WRAPPER}} .woo-products .column .product-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};', 
                        '{{WRAPPER}} .woo-products-skin-skin5 .column .product-column-wrapper .hover-content' => 'padding: 0px {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};', 

                    ],
                    'condition' => [
                        'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin5', ]
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(), 
                [
                    'name'          => 'single_product_box_border',
                    'label' => __( 'Border', 'widgetkit-pro' ),
                    'selector'      => '{{WRAPPER}} .woo-products .wk-slider .column .product-column-wrapper, {{WRAPPER}} .woo-products .column .product-column-wrapper',
                    'condition' => [
                        'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin4' ]
                    ],
                ]
            );
            $this->add_control(
                'single_product_border_radius',
                [
                    'label'   => esc_html__( 'Border Radius', 'widgetkit-for-elementor' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'size' =>0,
                    ],
                    'range'  => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .column .product-column-wrapper' => 'border-radius: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .column .product-thumb' => 'border-radius: {{SIZE}}{{UNIT}} {{SIZE}}{{UNIT}} 0 0;',
                        '{{WRAPPER}} .column .product-content' => 'border-radius: 0 0 {{SIZE}}{{UNIT}} {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'product_layout_skin' => ['modern', 'classic', 'skin3', 'skin4' ]
                    ],
                ]
            );

            $this->add_control(
                'single_product_thumb_overlay',
                [
                    'label' => __( 'Overlay', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'separator' => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .woo-products .column:hover .product-thumb-wrapper a:before' => 'background: {{VALUE}}',
                    ],
                    'condition' => [
                        'product_layout_skin' => ['modern', 'classic', 'skin3', ]
                    ],
                ]
            );
            $this->add_control(
                'cart_and_quick_view_style_bar',
                [
                    'label' => __( 'Cart & Quick View', 'widgetkit-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'product_layout_skin' => ['skin3', 'skin4' ]
                    ],
                ]
            );
            $this->add_control(
                'cart_qv_bg',
                [
                    'label' => __( 'Background', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#fff',
                    'selectors' => [
                        '{{WRAPPER}} .woo-products-skin-skin3 .column .cart-button' => 'background: {{VALUE}}',
                        '{{WRAPPER}} .woo-products-skin-skin4 .column .cart-button' => 'background: {{VALUE}}',
                    ],
                    'condition' => [
                        'product_layout_skin' => ['skin3', 'skin4' ]
                    ],
                ]
            );
            $this->add_control(
                'cart_qv_enable_box_shadow',
                [
                    'label' => __( 'Box Shadow', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                    'condition' => [
                        'product_layout_skin' => ['skin3', 'skin4' ]
                    ],
                ]
            );
            $this->add_control(
                'cart_qv_box_shadow',
                [
                    'label' => __( 'Box Shadow', 'widgetkit-pro' ),
                    'type' => Controls_Manager::BOX_SHADOW,
                    'default' => [
                        'color' => 'rgba(0,0,0,.08)',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .woo-products-skin-skin3 .column .cart-button' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
                        '{{WRAPPER}} .woo-products-skin-skin4 .column .cart-button' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
                    ],
                    'condition' => [
                        'cart_qv_enable_box_shadow' => 'yes',
                        'product_layout_skin' => ['skin3', 'skin4' ]
                    ]
                ]
            );

            
        $this->end_controls_section();

// #endregion        

        /**
         * Quick View
         */
        // $this->start_controls_section(
        //     'section_style_single_product_quick_view',
        //     [
        //         'label' => __( 'Quick View', 'widgetkit-pro' ),
        //         'tab' => Controls_Manager::TAB_STYLE,
        //         'condition' => [
        //             'product_layout_style' => 'slider'
        //         ]
        //     ]
        // );
        //     $this->add_control(
        //         'quick_view_title',
        //         [
        //         'label' => __( 'Title', 'widgetkit-pro' ),
        //         'type' => Controls_Manager::HEADING,
        //         ]
        //     );
        //     $this->add_control(
        //         'quick_view_title_color',
        //         [
        //             'label' => __( 'Color', 'widgetkit-pro' ),
        //             'type' => Controls_Manager::COLOR,
        //             'default' => '#3d3d3d',
        //             'selectors' => [
        //                 '{{WRAPPER}} .wk-product-quick-view-modal h3' => 'color: {{VALUE}} ',
        //             ],
        //         ]
        //     );
        //     $this->add_group_control(
        //         Group_Control_Typography::get_type(),
        //         [
        //             'label' => __( 'Typography', 'widgetkit-pro' ),
        //             'name' => 'quick_view_title_typography',
        //             'selector' => '{{WRAPPER}} .wk-product-quick-view-modal h3',
        //         ]
        //     );
        //     /**
        //      * price
        //      */
        //     $this->add_control(
        //         'quick_view_price',
        //         [
        //         'label' => __( 'Price', 'widgetkit-pro' ),
        //         'type' => Controls_Manager::HEADING,
        //         'separator' => 'before',
        //         ]
        //     );
        //     $this->add_control(
        //         'quick_view_price_color',
        //         [
        //             'label' => __( 'Color', 'widgetkit-pro' ),
        //             'type' => Controls_Manager::COLOR,
        //             'default' => '#3d3d3d',
        //             'selectors' => [
        //                 '{{WRAPPER}} .wk-product-quick-view-modal .price' => 'color: {{VALUE}} ',
        //             ],
        //         ]
        //     );
        //     $this->add_group_control(
        //         Group_Control_Typography::get_type(),
        //         [
        //             'label' => __( 'Typography', 'widgetkit-pro' ),
        //             'name' => 'quick_view_price_typography',
        //             'selector' => '{{WRAPPER}} .wk-product-quick-view-modal .price',
        //         ]
        //     );
        //     /**
        //      * Button
        //      */
        //     $this->add_control(
        //         'quick_view_button',
        //         [
        //         'label' => __( 'Price', 'widgetkit-pro' ),
        //         'type' => Controls_Manager::HEADING,
        //         'separator' => 'before',
        //         ]
        //     );
        //     $this->add_control(
        //         'quick_view_button_color',
        //         [
        //             'label' => __( 'Color', 'widgetkit-pro' ),
        //             'type' => Controls_Manager::COLOR,
        //             'default' => '#3d3d3d',
        //             'selectors' => [
        //                 '{{WRAPPER}} .wk-product-quick-view-modal a.button' => 'color: {{VALUE}} ',
        //             ],
        //         ]
        //     );
        //     $this->add_group_control(
        //         Group_Control_Typography::get_type(),
        //         [
        //             'label' => __( 'Typography', 'widgetkit-pro' ),
        //             'name' => 'quick_view_button_typography',
        //             'selector' => '{{WRAPPER}} .wk-product-quick-view-modal a.button',
        //         ]
        //     );
        //     $this->add_control(
        //         'quick_view_button_bg_color',
        //         [
        //             'label' => __( 'Background', 'widgetkit-pro' ),
        //             'type' => Controls_Manager::COLOR,
        //             'default' => '#3d3d3d',
        //             'selectors' => [
        //                 '{{WRAPPER}} .wk-product-quick-view-modal a.button' => 'background: {{VALUE}} ',
        //             ],
        //         ]
        //     );
        //     /**
        //      * content
        //      */
        //     $this->add_control(
        //         'quick_view_content',
        //         [
        //         'label' => __( 'Content', 'widgetkit-pro' ),
        //         'type' => Controls_Manager::HEADING,
        //         'separator' => 'before',
        //         ]
        //     );
        //     $this->add_control(
        //         'quick_view_content_color',
        //         [
        //             'label' => __( 'Color', 'widgetkit-pro' ),
        //             'type' => Controls_Manager::COLOR,
        //             'default' => '#3d3d3d',
        //             'selectors' => [
        //                 '{{WRAPPER}} .wk-product-quick-view-modal' => 'color: {{VALUE}} ',
        //             ],
        //         ]
        //     );
        //     $this->add_group_control(
        //         Group_Control_Typography::get_type(),
        //         [
        //             'label' => __( 'Typography', 'widgetkit-pro' ),
        //             'name' => 'quick_view_content_typography',
        //             'selector' => '{{WRAPPER}} .wk-product-quick-view-modal',
        //         ]
        //     );
        
            
            
        // $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings();
        $layout_skin = widgetkit_pro_array_get($settings, 'product_layout_skin');

        ?>

        <div id="woo-products-<?php echo $this->get_id(); ?>" class="woocommerce woo-products woo-products-skin-<?php echo $layout_skin; ?> woo-products-<?php echo $this->get_id() ?>">
            <?php include( plugin_dir_path( __FILE__ ) . '../layout/woo/products/'.$layout_skin.'.php'); ?>
        </div>
        <script>
            jQuery(function($){
                if(!$('body').hasClass('wkpro-woo-products')){
                    $('body').addClass('wkpro-woo-products');
                }
            });
        </script>

    <?php
    }
    protected function _content_template()
    {
    }
}
