<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Widgetkit_Pro_Woo_Featured_Product extends Widget_Base
{

    public function get_name()
    {
        return 'widgetkit-pro-woo-featured-product';
    }

    public function get_title()
    {
        return __('Woo Featured Product', 'widgetkit-pro');
    }

    public function get_icon()
    {
        return 'eicon-post-navigation';
    }

    public function get_categories()
    {
        return ['widgetkit_pro'];
    }

    /**
	 * A list of style that the widgets is depended in
	 **/
	public function get_style_depends() {
        return [
            'widgetkit_bs',
            'widgetkit_pro_default',
        ];
    }
	/**
	 * A list of scripts that the widgets is depended in
	 **/
	public function get_script_depends() {
		return [ 
			'layout',
		 ];
	}

    protected function _register_controls()
    {
        /**
         * Header
         */
        $this->start_controls_section(
            'section_control_header',
            [
                'label' => __('Header', 'widgetkit-pro'),
            ]
        );
        
        $this->add_control(
            'product_layout_header',
            [
                'label'       => __( 'Header', 'widgetkit-pro' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Featured Product', 'widgetkit-pro' ),
                'placeholder' => __( 'Featured Product', 'widgetkit-pro' ),
            ]
        );
        $this->end_controls_section();

        /**
         * product 
         */
        $this->start_controls_section(
            'section_control_featured_product',
            [
                'label' => __('Query', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'product_num_to_show',
            [
                'label'   => __( 'Number of Product to Show', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 4,
                'min'     => 1,
                'max'     => 50,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'product_column',
            [
                'label'   => __( 'Column', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 4,
                'min'     => 1,
                'max'     => 6,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'featured_product_order',
            [
                'label'       => __( 'Order', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'ASC'  => __( 'Ascending', 'widgetkit-pro' ),
                    'DESC'  => __( 'Descending', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'product_layout_style',
            [
                'label'       => __( 'Style', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'image_top',
                'options' => [
                    'image_top'  => __( 'Image Top', 'widgetkit-pro' ),
                    'image_left'  => __( 'Image Left', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->end_controls_section();

        /**
         * header
         */
        $this->start_controls_section(
            'section_style_header',
            [
                'label' => __( 'Header', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Font', 'widgetkit-pro' ),
                'name' => 'section_title_typography',
                'selector' => '{{WRAPPER}} .multiple-layout .layout-title h4',
            ]
        );
        $this->add_control(
            'section_title_and_seperator_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .layout-header .layout-title h4' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .cat-post-list:before' => 'background: {{VALUE}} !important',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'header_underline_color',
            [
                'label' => __( 'Underline Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dynamic-layout .layout-header .layout-title:after' => 'background: {{VALUE}} !important',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
        

    }


    protected function render()
    {
        ?>

        <div id="woo-featured-product-<?php echo $this->get_id(); ?>" class="woo-featured-product woo-featured-product-<?php echo $this->get_id() ?>">
            <?php include( plugin_dir_path( __FILE__ ) . '../layout/woo/featured-product.php'); ?>
        </div>

    <?php
    }
    protected function _content_template()
    {
    }
}
