<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;

if (!defined('ABSPATH')) exit; // Exit if accessed directly
if(!function_exists('widgetkit_pro_array_get')) {
    function widgetkit_pro_array_get($array, $key, $default=null){
        if(!is_array($array)) return $default;
        return array_key_exists($key, $array) ? $array[$key] : $default;
    }
}

/**
 * magmax Layout
 * =============
 */
class Widgetkit_Pro_Tab_Between_Two_Category extends Widget_Base
{

    public function get_name()
    {
        return 'magmax-tab-between-two-category';
    }

    public function get_title()
    {
        return __('Tab Between Two Category', 'widgetkit-pro');
    }

    public function get_icon()
    {
        return 'eicon-tabs';
    }

    public function get_categories()
    {
        return ['widgetkit_pro'];
    }

    /**
     * A list of scripts that the widgets is depended in
     *
     * @since 1.3.0
     **/

//    public function get_script_depends() {
//        return [ 'magmax_test' ];
//    }


    protected function _register_controls()
    {
        $terms = get_terms( array(
            'taxonomy' => 'category',
            'hide_empty' => false,
        ) );
        $cat_names = array();
        foreach( $terms as $t ):
            $cat_names[$t->term_id] = $t->name;
        endforeach;

        /* slides content title subtitle button and button link */
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Layout', 'widgetkit-pro'),
            ]
        );

        $this->add_control(
            'query_type',
            [
                'label'       => __( 'Query Type', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'recent',
                'options' => [
                    'recent'  => __( 'Latest', 'widgetkit-pro' ),
                    'popular'  => __( 'Popular', 'widgetkit-pro' ),
                    'featured'  => __( 'Featured', 'widgetkit-pro' ),
                    'trending'  => __( 'Trending', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'first_cat_id',
            [
                'label' => __( 'Category List', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'options' => $cat_names,
            ]
        );
        $this->add_control(
            'second_cat_id',
            [
                'label' => __( 'Category List', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'options' => $cat_names,
            ]
        );

        $this->add_control(
            'post_num_to_show',
            [
                'label'   => __( 'Number of Post to Show', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 4,
                'min'     => 1,
                'max'     => 20,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'show_thumb',
            [
                'label' => __( 'Show Thumbnail', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'show_cat',
            [
                'label' => __( 'Show Category', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'show_meta',
            [
                'label' => __( 'Show Meta', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'show_border',
            [
                'label' => __( 'Show Border', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );


        $this->add_control(
            'regular_thumbnail_size',
            [
                'label'       => __( 'Thumbnail Size', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'large',
                'options' => [
                    'medium'  => __( 'Medium', 'widgetkit-pro' ),
                    'medium_large'  => __( 'Medium Large', 'widgetkit-pro' ),
                    'large'  => __( 'Large', 'widgetkit-pro' ),
                    'full'  => __( 'Full', 'widgetkit-pro' ),
                ],
                'condition' => [
                    'show_thumb' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'title_word',
            [
                'label'       => __( 'Title Word Count', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 7,
                'min'     => 5,
                'max'     => 100,
                'step'    => 1,
            ]
        );



        $this->end_controls_section();

        /**
         * Style tab
         * =============
         */
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
//        $this->add_group_control(
//            Group_Control_Typography::get_type(),
//            [
//                'label' => __( 'Section Title', 'widgetkit-pro' ),
//                'name' => 'section_title_typography',
//                'selector' => '{{WRAPPER}} .layout-title h4',
//            ]
//        );
        /**
         * Tab title Typography
         */
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Tab Title Typography', 'widgetkit-pro' ),
                'name' => 'header_highlight_post_title_typography',
                'selector' => '{{WRAPPER}} .nav-tabs li a',
            ]
        );
        /**
         * Regular title
         */
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Regular Post Title', 'widgetkit-pro' ),
                'name' => 'header_regular_post_title_typography',
                'selector' => '{{WRAPPER}} .cat-single-item .post-data .post-title h3',

            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'content_style',
            [
                'label' => __( 'Content', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_no_thumb_padding',
            [
                'label' => __( 'Content Padding', 'widgetkit-pro' ),
                'description' => __('Only works when thumbnail is switched off', 'widgetkit-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .static-post-tab .cat-single-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        /**
         * Custom Color
         */
        $this->add_control(
            'custom_color',
            [
                'label' => __( 'Custom Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Show custom color for content',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'header_highlighted_title_color',
            [
                'label' => __( 'Selected Headline Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .active-post-content a h3' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'header_regular_title_color',
            [
                'label' => __( 'Regular Title Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .regular-post .post-title h3' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'header_regular_meta_color',
            [
                'label' => __( 'Regular Meta Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .regular-post .post-meta span' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .regular-post .post-cat, {{WRAPPER}} .regular-post .post-cat a' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        $query_type = widgetkit_pro_array_get($settings, 'query_type');

        $first_cat_id = widgetkit_pro_array_get($settings, 'first_cat_id');
        $second_cat_id = widgetkit_pro_array_get($settings, 'second_cat_id');
        $query_post_type = widgetkit_pro_array_get($settings, 'query_type');
        $post_num_to_show = widgetkit_pro_array_get($settings, 'post_num_to_show');

        $show_thumb = widgetkit_pro_array_get($settings, 'show_thumb');
        $show_cat = widgetkit_pro_array_get($settings, 'show_cat');
        $show_meta = widgetkit_pro_array_get($settings, 'show_meta');
        $show_border = widgetkit_pro_array_get($settings, 'show_border');
        $regular_thumbnail_size = widgetkit_pro_array_get($settings, 'regular_thumbnail_size');
        $title_word = widgetkit_pro_array_get($settings, 'title_word');

        include( plugin_dir_path( __FILE__ ) . '../layout/static-category-tab/'.$query_type.'.php');
    }
    protected function _content_template()
    {
    }
}
