<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Widgetkit_Pro_Smart_List extends Widget_Base
{

    public function get_name()
    {
        return 'widgetkit-smart-list';
    }

    public function get_title()
    {
        return __('Smart List', 'widgetkit-pro');
    }

    public function get_icon()
    {
        return 'eicon-post-navigation';
    }

    public function get_categories()
    {
        return ['widgetkit_pro'];
    }

    /**
	 * A list of style that the widgets is depended in
	 **/
	public function get_style_depends() {
        return [
            'widgetkit_bs',
            'widgetkit_pro_default',
        ];
    }
	/**
	 * A list of scripts that the widgets is depended in
	 **/
	public function get_script_depends() {
		return [ 
			'layout',
		 ];
	}

    protected function _register_controls()
    {
        $terms = get_terms( array(
            'taxonomy' => 'category',
            'hide_empty' => false,
        ) );
        $cat_names = array();
        foreach( $terms as $t ):
            $cat_names[$t->term_id] = $t->name;
        endforeach;

        /**
         * Header
         */
        $this->start_controls_section(
            'section_control_header',
            [
                'label' => __('Header', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'layout_style',
            [
                'label'       => __( 'Layout', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'multiple-category-dynamic-carousel-layout-2',
                'options' => [
                    // 'multiple-category-dynamic-carousel-layout-1'  => __( 'Layout 1', 'widgetkit-pro' ),
                    'multiple-category-dynamic-carousel-layout-2'  => __( 'Layout 1', 'widgetkit-pro' ),
                    // 'multiple-category-dynamic-carousel-layout-3'  => __( 'Layout 3', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'multiple_layout_title',
            [
                'label'       => __( 'Title', 'widgetkit-pro' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Layout title text', 'widgetkit-pro' ),
                'placeholder' => __( 'Type your layout title text here', 'widgetkit-pro' ),
            ]
        );
        $this->end_controls_section();
        
        
        /**
         * Queries
         */
        $this->start_controls_section(
            'section_control_queries',
            [
                'label' => __('Queries', 'widgetkit-pro'),
                'class' => __('Multiple Category Dynamic Carousel', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'cat_multiple_id',
            [
                'label' => __( 'Category List', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT2,
                'options' => $cat_names,
                'multiple' => true,
            ]
        );
        $this->add_control(
            'post_num_to_show',
            [
                'label'   => __( 'Number of Post to Show', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 5,
                'min'     => -1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->end_controls_section();        
        
        /**
         * Primary Column
         */
        $this->start_controls_section(
            'section_control_primary_column',
            [
                'label' => __('Primary Column', 'widgetkit-pro'),
                'class' => __('Multiple Category Dynamic Carousel', 'widgetkit-pro'),
            ]
        );
        
        $this->add_control(
            'featured_thumbnail_size',
            [
                'label'       => __( 'Thumbnail Size', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'large',
                'options' => [
                    'medium'  => __( 'Medium', 'widgetkit-pro' ),
                    'medium_large'  => __( 'Medium Large', 'widgetkit-pro' ),
                    'large'  => __( 'Large', 'widgetkit-pro' ),
                    'full'  => __( 'Full', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'featured-post-min-height',
            [
                'label' => __( 'Image Min Height', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 200,
                        'max' => 1500,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .multiple-category-dynamic-carousel-layout-1 .featured-post .post-thumb a img' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .multiple-category-dynamic-carousel-layout-2 .featured-post .post-thumb a img' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .multiple-category-dynamic-carousel-layout-3 .featured-post .post-thumb a img' => 'height: {{SIZE}}{{UNIT}};',
                ]
            ]
        );
        $this->add_control(
            'featured_thumbnail_style',
            [
                'label'       => __( 'Content Position', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'tiles',
                'options' => [
                    'list'  => __( 'Title After Image', 'widgetkit-pro' ),
                    'tiles'  => __( 'Overlay', 'widgetkit-pro' ),
                ],
                'condition' => [
                    'layout_style' => ['multiple-category-dynamic-carousel-layout-1', 'multiple-category-dynamic-carousel-layout-2'],
                ]
            ]
        );
        $this->add_control(
            'section_heading_featured_content',
            [
            'label' => __( 'Content', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            ]
        );
        $this->add_control(
            'show_highlight_cat_tag',
            [
                'label' => __( 'Category', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'widgetkit-pro' ),
                'label_off' => __( 'Hide', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'show_featured_excerpt',
            [
                'label' => __( 'Excerpt', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'widgetkit-pro' ),
                'label_off' => __( 'Hide', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'featured_excerpt_word_count',
            [
                'label'       => __( 'Excerpt Word', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 7,
                'min'     => 5,
                'max'     => 100,
                'step'    => 1,
                'condition' => [
                    'show_featured_excerpt' => 'yes',
                ]
            ]
        );
        $this->end_controls_section();
        
        
        /**
         * Secondary Column
         */
        $this->start_controls_section(
            'section_control_secondary_column',
            [
                'label' => __('Secondary Column', 'widgetkit-pro'),
                'class' => __('Multiple Category Dynamic Carousel', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'regular_post_grid',
            [
                'label'       => __( 'Column', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => '2',
                'options' => [
                    '1'  => __( '1', 'widgetkit-pro' ),
                    '2'  => __( '2', 'widgetkit-pro' ),
                    '3'  => __( '3', 'widgetkit-pro' ),
                    '4'  => __( '4', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'grid-gap',
            [
                'label' => __( 'Column Gap', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 30,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                ],
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .multiple-category-dynamic-carousel-layout-2 .cat-post-list .cat-post-list-wrapper' => 'grid-gap: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .multiple-category-dynamic-carousel-layout-3 .cat-post-list .cat-post-list-wrapper' => 'grid-gap: {{SIZE}}{{UNIT}} !important;',
                ],
                'condition' => [
                    'layout_style' => ['multiple-category-dynamic-carousel-layout-2', 'multiple-category-dynamic-carousel-layout-3'],
                ]
            ]
        );
        $this->add_control(
            'section_heading_thumbnail',
            [
            'label' => __( 'Thumbnail', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            ]
        );
        $this->add_control(
            'show_regular_thumbnail',
            [
                'label' => __( 'Show Thumbnial', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'regular_thumbnail_size',
            [
                'label'       => __( 'Thumbnail Size', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'large',
                'options' => [
                    'medium'  => __( 'Medium', 'widgetkit-pro' ),
                    'medium_large'  => __( 'Medium Large', 'widgetkit-pro' ),
                    'large'  => __( 'Large', 'widgetkit-pro' ),
                    'full'  => __( 'Full', 'widgetkit-pro' ),
                ],
                'condition' => [
                    'show_regular_thumbnail' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'regular_post_style',
            [
                'label'       => __( 'Style', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'horizontal',
                'options' => [
                    'vertical'  => __( 'Image Top', 'widgetkit-pro' ),
                    'horizontal'  => __( 'Image Left', 'widgetkit-pro' ),
                ],
                'condition' => [
                    'show_regular_thumbnail' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'section_heading_meta',
            [
            'label' => __( 'Content', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            ]
        );
        $this->add_control(
            'title_word',
            [
                'label'       => __( 'Title Word Count', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 7,
                'min'     => 5,
                'max'     => 100,
                'step'    => 1,
                'condition' => [
                    'layout_style' => ['multiple-category-dynamic-carousel-layout-2', 'multiple-category-dynamic-carousel-layout-3'],
                ]
            ]
        );
        $this->add_control(
            'show_cat_tag',
            [
                'label' => __( 'Category', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'widgetkit-pro' ),
                'label_off' => __( 'Hide', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'show_regular_excerpt',
            [
                'label' => __( 'Excerpt', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'widgetkit-pro' ),
                'label_off' => __( 'Hide', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'regular_excerpt_word_count',
            [
                'label'       => __( 'Excerpt Word', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 7,
                'min'     => 5,
                'max'     => 100,
                'step'    => 1,
                'condition' => [
                    'show_regular_excerpt' => 'yes',
                ]
            ]
        );
        
        $this->end_controls_section();
        

        /* slides content title subtitle button and button link */
        // $this->start_controls_section(
        //     'section_tab',
        //     [
        //         'label' => __('Layout', 'widgetkit-pro'),
        //         'class' => __('Multiple Category Dynamic Carousel', 'widgetkit-pro'),
        //     ]
        // );
        
        // $this->end_controls_section();


        /**
         * header
         */
        $this->start_controls_section(
            'section_style_header',
            [
                'label' => __( 'Header', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'name' => 'section_title_typography',
                'selector' => '{{WRAPPER}} .multiple-layout .layout-title h4',
            ]
        );
        $this->add_control(
            'section_title_and_seperator_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .layout-header .layout-title h4' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .cat-post-list:before' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'header_underline_color',
            [
                'label' => __( 'Underline Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dynamic-layout .layout-header .layout-title:after' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'header-spacing-bottom',
            [
                'label' => __( 'Spacing Bottom', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -50,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .dynamic-layout .dynamic-cat-post-list' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        /**
         * Navigation
         */
        $this->start_controls_section(
            'section_style_navigation',
            [
                'label' => __( 'Navigation', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'navigation_show',
                [
                    'label' => __( 'Show', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Yes', 'widgetkit-pro' ),
                    'label_off' => __( 'No', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            /**
             * tabs normal
             */
            $this->start_controls_tabs( 'section_style_navigation_tab' );
                /**
                 * Normal style
                 */
                $this->start_controls_tab(
                    'navigation-style-normal',
                    [
                        'label' => __('Normal', 'widgetkit-pro'),
                    ]
                );
                $this->add_control(
                    'carousel_icon_color',
                    [
                        'label' => __( 'Icon', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .dynamic-multiple-category nav li' => 'color: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'carousel_bg_color',
                    [
                        'label' => __( 'Background', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .dynamic-multiple-category nav li' => 'background-color: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'carousel_disable_icon_color',
                    [
                        'label' => __( 'Disabled Icon', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .dynamic-multiple-category .first-page .multiple-cateogry-prev' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .dynamic-multiple-category .last-page .multiple-cateogry-next' => 'color: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'carousel_disable_bg_color',
                    [
                        'label' => __( 'Disabled Background', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .dynamic-multiple-category .first-page .multiple-cateogry-prev' => 'background-color: {{VALUE}}',
                            '{{WRAPPER}} .dynamic-multiple-category .last-page .multiple-cateogry-next' => 'background-color: {{VALUE}}',
                        ],
                    ]
                );
                
                $this->end_controls_tab();


                /**
                 * Hover Style
                 */
                $this->start_controls_tab(
                    'navigation-hover-normal',
                    [
                        'label' => __('Hover', 'widgetkit-pro'),
                    ]
                );
                $this->add_control(
                    'carousel_hover_icon_color',
                    [
                        'label' => __( 'Icon', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .dynamic-multiple-category nav li:hover' => 'color: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'navigation_hover_color',
                    [
                        'label' => __( 'Background', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .dynamic-multiple-category nav li:hover' => 'background: {{VALUE}} !important',
                        ],
                    ]
                );
                $this->end_controls_tab();
        
            $this->end_controls_tabs();
        
        $this->end_controls_section();

        /**
         * Primary Column style
         */
        $this->start_controls_section(
            'section_style_primary_column',
            [
                'label' => __( 'Primary Column', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        /**
         * featured meta
         */
        $this->add_control(
            'section_heading_style_meta',
            [
            'label' => __( 'Meta', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            ]
        );
        $this->add_control(
            'highlight_meta_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .featured-post .post-meta div' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .featured-post .post-cat, {{WRAPPER}} .featured-post .post-cat a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .featured-post .post-data .post-cat a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'name' => 'highlight_post_meta_typography',
                'selector' => '{{WRAPPER}} .featured-post .post-data .post-cat a, {{WRAPPER}} .featured-post .post-data .post-cat',
            ]
        );
        $this->add_control(
            'highlight_meta_hover_color',
            [
                'label' => __( 'Hover Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .featured-post .post-data .post-cat a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'featured-meta-spacing-bottom',
            [
                'label' => __( 'Spacing Bottom', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -50,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .featured-post .post-data .post-cat' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        /**
         * featured title
         */
        $this->add_control(
            'section_style_featured_heading_title',
            [
            'label' => __( 'Title', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            ]
        );
        $this->add_control(
            'highlight_title_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .featured-post .highlight-post-title h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'name' => 'highlight_post_title_typography',
                'selector' => '{{WRAPPER}} .featured-post .highlight-post-title h3',
            ]
        );
        $this->add_control(
            'highlight_title_hover_color',
            [
                'label' => __( 'Hover Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} a.highlight-post-title:hover h3' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'featured-title-spacing-bottom',
            [
                'label' => __( 'Spacing Bottom', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -50,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} a.highlight-post-title h3' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        /**
         * featured excerpt
         */
        $this->add_control(
            'section_heading_style_excerpt',
            [
            'label' => __( 'Excerpt', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            ]
        );
        $this->add_control(
            'highlight_excerpt_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .featured-post .post-excerpt' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'name' => 'highlight_post_excerpt_typography',
                'selector' => '{{WRAPPER}} .featured-post .post-excerpt',
            ]
        );
        $this->add_control(
            'featured-excerpt-spacing-bottom',
            [
                'label' => __( 'Spacing Bottom', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -50,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .featured-post .post-excerpt' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'style_heading_content',
            [
            'label' => __( 'Content', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            ]
        );
            $this->add_control(
                'featured-content-background',
                [
                    'label' => __( 'Background', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .featured-post .post-data' => 'background: {{VALUE}}',
                    ],
                    'condition' => [
                        'featured_thumbnail_style' => ['list'],
                    ]
                ]
            );
            $this->add_responsive_control(
                'featured-content-padding',
                [
                    'label' => esc_html__( 'Padding', 'widgetkit-pro' ),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors'  => [
                        '{{WRAPPER}} .featured-post .post-data' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();
        /**
         * Secondary Column style
         */
        $this->start_controls_section(
            'section_style_secondary_column',
            [
                'label' => __( 'Secondary Column', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        /**
         * secondary Meta
         */
        $this->add_control(
            'section_heading_secondary_meta',
            [
            'label' => __( 'Meta', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            ]
        );
        $this->add_control(
            'meta_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .regular-post .post-meta div' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .regular-post .post-data .post-cat' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .regular-post .post-data .post-cat a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'name' => 'regular_post_meta_typography',
                'selector' => '{{WRAPPER}} .regular-post .post-data .post-cat a, {{WRAPPER}} .regular-post .post-data .post-cat',
            ]
        );
        $this->add_control(
            'meta_hover_color',
            [
                'label' => __( 'Hover Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .regular-post .post-data .post-cat a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'secondary-meta-spacing-bottom',
            [
                'label' => __( 'Spacing Bottom', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -50,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .regular-post .post-data .post-cat' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        /**
         * secondary title
         */
        $this->add_control(
            'style_heading_title',
            [
            'label' => __( 'Title', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .regular-post-title h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'name' => 'regular_post_title_typography',
                'selector' => '{{WRAPPER}} .regular-post .regular-post-title h3',
            ]
        );
        $this->add_control(
            'title_hover_color',
            [
                'label' => __( 'Hover Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} a.regular-title:hover h3' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'secondary-title-spacing-bottom',
            [
                'label' => __( 'Spacing Bottom', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -50,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} a.regular-title h3' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        /**
         * secondary content
         */
        $this->add_control(
            'section_heading_secondary_excerpt',
            [
            'label' => __( 'Excerpt', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            ]
        );
        $this->add_control(
            'excerpt_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .regular-post .post-excerpt' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'name' => 'regular_post_excerpt_typography',
                'selector' => '{{WRAPPER}} .regular-post .post-excerpt',
            ]
        );
        /**
         * seperator
         */
        $this->add_control(
            'section_heading_secondary_seperator',
            [
            'label' => __( 'Seperator', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            ]
        );
        $this->add_control(
            'secondary-column-seperator_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dynamic-cat-post-list.horizontal .regular-post:before' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'style_heading_secondary_content',
            [
            'label' => __( 'Content', 'widgetkit-pro' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
            ]
        );
            $this->add_responsive_control(
                'regular-content-padding',
                [
                    'label' => esc_html__( 'Padding', 'widgetkit-pro' ),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'selectors'  => [
                        '{{WRAPPER}} .regular-post .post-data' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();
        /**
         * Seperator & Overlay
         */
        $this->start_controls_section(
            'section_style_seperator_and_overlay',
            [
                'label' => __( 'Seperator & Overlay', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'header_divider_color',
            [
                'label' => __( 'Header Divider', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dynamic-layout .layout-header:after' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'ajax_overlay_color',
            [
                'label' => __( 'Ajax Overlay Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dynamic-layout .dynamic-cat-post-list .ajax-content' => 'background: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'ajax_overlay_dot_color',
            [
                'label' => __( 'Ajax Overlay Dot Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dynamic-layout .ajax-content .lds-ellipsis div' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
        
        
        

        /**
         * Style tab
         * =============
         */
        // $this->start_controls_section(
        //     'section_style',
        //     [
        //         'label' => __( 'Typography', 'widgetkit-pro' ),
        //         'tab' => Controls_Manager::TAB_STYLE,
        //     ]
        // );
        // $this->add_control(
        //     'section_title',
        //     [
        //         'label' => __( 'Section Title', 'widgetkit-pro' ),
        //         'type' => Controls_Manager::HEADING,
        //         'separator' => 'before',
        //     ]
        // );
        
        // $this->add_control(
        //     'highlight_title',
        //     [
        //         'label' => __( 'Highlight Post Title', 'widgetkit-pro' ),
        //         'type' => Controls_Manager::HEADING,
        //         'separator' => 'before',
        //     ]
        // );
        
        // $this->add_control(
        //     'regular_title',
        //     [
        //         'label' => __( 'Regular Post Title', 'widgetkit-pro' ),
        //         'type' => Controls_Manager::HEADING,
        //         'separator' => 'before',
        //     ]
        // );
        
        // $this->end_controls_section();


        // $this->start_controls_section(
        //     'content_style',
        //     [
        //         'label' => __( 'Content', 'widgetkit-pro' ),
        //         'tab' => Controls_Manager::TAB_STYLE,
        //     ]
        // );
        // $this->add_control(
        //     'content_no_thumb_padding',
        //     [
        //         'label' => __( 'Content Padding', 'widgetkit-pro' ),
        //         'description' => __('Only works when regular post thumbnail is switched off', 'widgetkit-pro'),
        //         'type' => Controls_Manager::DIMENSIONS,
        //         'size_units' => [ 'px', '%', 'em' ],
        //         'selectors' => [
        //             '{{WRAPPER}} .regular-post .post-data' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        //         ],
        //     ]
        // );
        // $this->add_control(
        //     'custom_color',
        //     [
        //         'label' => __( 'Custom Color', 'widgetkit-pro' ),
        //         'type' => Controls_Manager::SWITCHER,
        //         'default' => '',
        //         'description' => 'Show custom color for content',
        //         'label_on' => __( 'Yes', 'widgetkit-pro' ),
        //         'label_off' => __( 'No', 'widgetkit-pro' ),
        //         'return_value' => 'yes',
        //     ]
        // );
        
        // $this->end_controls_section();



        $this->start_controls_section(
            'section_gradient',
            [
                'label' => __( 'Overlay', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_style' => ['multiple-category-dynamic-carousel-layout-1', 'multiple-category-dynamic-carousel-layout-2'],
                    'featured_thumbnail_style' => 'tiles'
                ],
            ]
        );
        $this->add_control(
            'overlay_style',
            [
                'label'       => __( 'Overlay Style', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'bg-overlay',
                'options' => [
                    'bg-overlay'  => __( 'Overlay', 'widgetkit-pro' ),
                    'bg-gradient'  => __( 'Gradient', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'background_overlay',
            [
                'label' => __( 'Background Overlay', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .multiple-category-dynamic-carousel-layout-1 .featured-post .post-thumb a:after' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .multiple-category-dynamic-carousel-layout-2 .featured-post .post-thumb a:after' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'overlay_style' => 'bg-overlay',
                ],
            ]
        );

        $this->add_control(
            'gradient_1',
            [
                'label' => __( 'Gradient', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .multiple-category-dynamic-carousel-layout-1 .featured-post .post-thumb a:after' => 'background: linear-gradient(180deg, rgba(0, 0, 0, 0.01) 40%, {{VALUE}} 90%)',
                    '{{WRAPPER}} .multiple-category-dynamic-carousel-layout-1 .featured-post:hover .post-thumb a:after' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .multiple-category-dynamic-carousel-layout-2 .featured-post .post-thumb a:after' => 'background: linear-gradient(180deg, rgba(0, 0, 0, 0.01) 40%, {{VALUE}} 90%)',
                    '{{WRAPPER}} .multiple-category-dynamic-carousel-layout-2 .featured-post:hover .post-thumb a:after' => 'background-color: {{VALUE}} ',
                ],
                'condition' => [
                    'overlay_style' => 'bg-gradient',
                ],
            ]
        );
        $this->add_control(
            'highlight_tiles_text_shadow',
            [
                'label' => __( 'Tiles Title Text Shadow', 'widgetkit-pro' ),
                'type' => Controls_Manager::TEXT_SHADOW,
                'selectors' => [
                    '{{WRAPPER}} .multiple-category-dynamic-carousel-layout-2.tiles .featured-post .post-title h3' => 'text-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{COLOR}};',
                ],
                'condition' => [
                    'overlay_style' => 'bg-gradient',
                ],
            ]
        );

        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings();
        $layout = widgetkit_pro_array_get($settings, 'layout_style');
        $layout_title = widgetkit_pro_array_get($settings, 'multiple_layout_title');

        $cat_id = widgetkit_pro_array_get($settings, 'cat_multiple_id');
        $cat_multiple_id = $cat_id ? join('_', $cat_id) : $cat_id;
        $featured_thumbnail_size = widgetkit_pro_array_get($settings, 'featured_thumbnail_size');
        $featured_thumbnail_style = widgetkit_pro_array_get($settings, 'featured_thumbnail_style');
        $show_regular_thumbnail = widgetkit_pro_array_get($settings, 'show_regular_thumbnail');
        $regular_thumbnail_size = widgetkit_pro_array_get($settings, 'regular_thumbnail_size');

        $post_num_to_show = widgetkit_pro_array_get($settings, 'post_num_to_show');
        $highlight_first_post = 'yes';
        $show_highlight_cat_tag = widgetkit_pro_array_get($settings, 'show_highlight_cat_tag');
        $show_featured_excerpt = widgetkit_pro_array_get($settings, 'show_featured_excerpt');
        $featured_excerpt_word_count = widgetkit_pro_array_get($settings, 'featured_excerpt_word_count');
        $show_cat_tag = widgetkit_pro_array_get($settings, 'show_cat_tag');
        $tax_term = get_term_meta($cat_id);
        $tax_tag_bg_color = widgetkit_pro_array_get($tax_term, 'magmax_tax_tag_bg_color')[0];
        $regular_post_grid = widgetkit_pro_array_get($settings, 'regular_post_grid');
        $regular_post_style = widgetkit_pro_array_get($settings, 'regular_post_style');
        $title_word = widgetkit_pro_array_get($settings, 'title_word');
        $show_regular_excerpt = widgetkit_pro_array_get($settings, 'show_regular_excerpt');
        $regular_excerpt_word_count = widgetkit_pro_array_get($settings, 'regular_excerpt_word_count');

        $navigation_show = widgetkit_pro_array_get($settings, 'navigation_show');


        if('multiple-category-dynamic-carousel-layout-2' == $layout):
            $layout_class = $layout.' '.$featured_thumbnail_style;
        endif;


        ?>

        <div id="dynamic-multiple-category-<?php echo $this->get_id(); ?>" class="dynamic-multiple-category <?php echo $layout .' '. $featured_thumbnail_style; ?> dynamic-<?php echo $this->get_id() ?>">
            <?php include( plugin_dir_path( __FILE__ ) . '../layout/dynamic-carousel/'. $layout .'.php'); ?>
        </div>
    <?php
    }
    protected function _content_template()
    {
    }
}
