<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * WidgetKit Pro Slider 
 *
 * Elementor WidgetKit Pro Slider
 *
 * @since 1.0.0
 */
class Widgetkit_Pro_Slider extends Widget_Base
{

    public function get_name()
    {
        return 'edukado-slider';
    }

    public function get_title()
    {
        return __('Slider Pro', 'edukado');
    }

    public function get_icon()
    {
        return 'eicon-post-slider';
    }

    public function get_categories()
    {
        return ['widgetkit_pro'];
    }

    /**
     * A list of scripts that the widgets is depended in
     *
     * @since 1.3.0
     **/
    // public function get_script_depends() {
    //     return ['imagesloaded', 'anime', 'slider-3'];
    // }

    protected function _register_controls(){
        /* slides content title subtitle button and button link */
        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Slider', 'edukado'),
            ]
        );
            $repeater = new Repeater();
            $repeater->add_control(
                'edukado_slider_image',
                [
                    'label' => esc_html__( 'Slider Image', 'edukado' ),
                    'type'  => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                ]
            );
            $repeater->add_control(
                'edukado_slider_title',
                [
                    'label'       => esc_html__( 'Title', 'edukado' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => esc_html__( 'We care your websites.', 'edukado' ),
                ]
            );
            $repeater->add_control(
                'edukado_slider_subtitle',
                [
                    'label'       => esc_html__( 'Subtitle', 'edukado' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => esc_html__( 'With elements pro you able to create different types of pages on your website.', 'edukado' ),
                ]
            );
            $repeater->add_control(
                'edukado_slider_button_text',
                [
                    'label'       => esc_html__( 'Button Text', 'edukado' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => esc_html__( 'Explore It', 'edukado' ),
                ]
            );
            $repeater->add_control(
                'edukado_slider_button_link',
                [
                    'label' => esc_html__( 'Button Link', 'edukado' ),
                    'type'  => Controls_Manager::URL,
                    'placeholder' => 'https://themesgrove.com',
                    'default' => [
                        'url' => 'https://themesgrove.com',
                    ],
                ]
            );


            $this->add_control(
                'edukado_slider',
                [
                    'label'      => esc_html__( 'Sliders', 'edukado' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields'     => array_values( $repeater->get_controls() ),
                    'show_label' => true,


                    'default'     => [
                        [
                            'edukado_slider_title'    => esc_html__( 'Get Ready', 'edukado' ),
                            'edukado_slider_subtitle' => 'Build Your Future With Us',
                            'edukado_slider_image'       => '',
                            'edukado_slider_button_text' => 'Contact Us',
                            'edukado_slider_button_link' => 'https://www.themesgrove.com',
             
                        ],
                        [
                            'edukado_slider_title'    => esc_html__( 'We Are', 'edukado' ),
                            'edukado_slider_subtitle' => 'Here To Help Your Career ',
                            'edukado_slider_image'     => '',
                            'edukado_slider_button_text' => 'Contact Us',
                            'edukado_slider_button_link' => 'https://www.themesgrove.com',
             
                        ]
                  ],
                    'title_field' => '{{{edukado_slider_title}}}',

                ]
            );
        $this->end_controls_section();


        /* style and typography and overlay color option */
        $this->start_controls_section(
            'slide_typography',
            [
                'label' => esc_html__( 'Title', 'edukado' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );


            $this->add_control(
                'title_color',
                [
                    'label'     => esc_html__( 'Color', 'edukado' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '#fff',
                    'selectors' => [
                        '{{WRAPPER}} .edukado-slide .slide__text-heading' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__( 'Typography', 'edukado' ),
                    'name'     => 'slide_title_typography',
                    'selector' => '{{WRAPPER}} .edukado-slide .slide__text-heading',
                    'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );

            $this->add_responsive_control(
                'edukado_slider_caption_position',
                    [
                        'label'  => esc_html__( 'Caption Height', 'edukado' ),
                        'type'   => Controls_Manager::SLIDER,
                        'default' => [
                            'size' => 220,
                        ],
                        'range'  => [
                            'px' => [
                                'min' =>200,
                                'max' => 1000,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .edukado-slide .slide__text' => 'bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ]
            );

            $this->add_responsive_control(
                'edukado_slider_caption_width',
                    [
                        'label'  => esc_html__( 'Caption Width', 'edukado' ),
                        'type'   => Controls_Manager::SLIDER,
                        'default' => [
                            'size' =>100,
                        ],
                        'range'  => [
                            '%' => [
                                'min' =>50,
                                'max' => 500,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .edukado-slide .slide__content' => 'width: {{SIZE}}%;',
                        ],
                    ]
            );



        $this->end_controls_section();




        $this->start_controls_section(
            'description_typography',
            [
                'label' => esc_html__( 'Subtitle', 'edukado' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'description_color',
                [
                    'label'     => esc_html__( 'Color', 'edukado' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '#fff',
                    'selectors' => [
                        '{{WRAPPER}} .edukado-slide .slide__text-desc' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__( 'Typography', 'edukado' ),
                    'name'     => 'slide_description_typography',
                    'selector' => '{{WRAPPER}} .edukado-slide .slide__text-desc',
                    'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );

            $this->add_responsive_control(
            'edukado_slider_description_spacing',
                [
                    'label'   => esc_html__( 'Speacing', 'edukado' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 25,
                    ],
                    'range'  => [
                        'px' => [
                            'min' => 10,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .edukado-slide .slide__text-desc' => 'margin: {{SIZE}}{{UNIT}} 0;',
                    ],
                ]
            );
        $this->end_controls_section();




        $this->start_controls_section(
            'edukado_slider_button_section',
            [
                'label' => esc_html__( 'Button', 'edukado' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );




         $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'     => esc_html__( 'Typography', 'edukado' ),
                    'name'      => 'edukado_slider_button_typography',
                    'selector'  => '{{WRAPPER}} .edukado-slide .slide__text-link',
                    'scheme'    => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );



    $this->start_controls_tabs( 'edukado_slider_tabs_button_style' );

    $this->start_controls_tab(
        'edukado_slider_button_normal',
          [
            'label' => esc_html__( 'Normal', 'edukado' ),
          ]
    );

        $this->add_control(
            'edukado_slider_button_text_color',
              [
                'label' => esc_html__( 'Text Color', 'edukado' ),
                'type'  => Controls_Manager::COLOR,
                'default'   => '#fff',
                'selectors' => [
                  '{{WRAPPER}} .edukado-slide .slide__text-link' => 'color: {{VALUE}};',
                ],
              ]
        );



        $this->add_responsive_control(
            'edukado_slider_button_border_height',
                [
                    'label'  => esc_html__( 'Border Height', 'edukado' ),
                    'type'   => Controls_Manager::SLIDER,
                    'default' => [
                        'size' =>3,
                    ],
                    'range'  => [
                        'px' => [
                            'min' => 2,
                            'max' =>5,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .edukado-slide .slide__text-link' => 'border-bottom: {{SIZE}}{{UNIT}} solid;',
                    ],
                ]
            );

        $this->add_control(
            'edukado_slider_btn_border_color',
            [
                'label' => esc_html__( 'Border Color', 'edukado' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#ddd',
                'selectors' => [
                    '{{WRAPPER}} .edukado-slide .slide__text-link' => 'border-color: {{VALUE}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'edukado_slider_button_border_gap',
                [
                    'label'  => esc_html__( 'Border Gap', 'edukado' ),
                    'type'   => Controls_Manager::SLIDER,
                    'default' => [
                        'size' =>5,
                    ],
                    'range'  => [
                        'px' => [
                            'min' => 10,
                            'max' =>50,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .edukado-slide .slide__text-link' => 'padding-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

    $this->add_responsive_control(
            'edukado_slider_button_spacing',
                [
                    'label'  => esc_html__( 'Button Specing', 'edukado' ),
                    'type'   => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 0,
                    ],
                    'range'  => [
                        'px' => [
                            'min' => 10,
                            'max' => 50,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .edukado-slide .slide__text-link' => 'margin: {{SIZE}}{{UNIT}} 0;',
                    ],
                ]
            );

    $this->end_controls_tab();

    $this->start_controls_tab(
        'edukado_slider_tab_button_hover',
            [
                'label' => esc_html__( 'Hover', 'edukado' ),
            ]
    );

    $this->add_control(
        'edukado_slider_hover_color',
            [
                'label' => esc_html__( 'Text Color', 'edukado' ),
                'type'  => Controls_Manager::COLOR,
                'default'   => '#fff',
                'selectors' => [
                  '{{WRAPPER}} .edukado-slide .slide__text-link:hover' => 'color: {{VALUE}};',
                ],
            ]
    );

    $this->add_control(
        'edukado_slider_button_border_hover_color',
            [
                'label' => esc_html__( 'Border Color', 'edukado' ),
                'type'  => Controls_Manager::COLOR,
                'default'   => ' #fff',
                'selectors' => [
                  '{{WRAPPER}} .edukado-slide .slide__text-link:hover' => 'border-color: {{VALUE}};',
                ],
            ]
    );


    $this->end_controls_tab();


    $this->end_controls_tabs();
    $this->end_controls_section();



    $this->start_controls_section(
        'edukado_slider_nav_section_style',
            [
                'label' => esc_html__( 'Navs', 'edukado' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'edukado_slider_nav_border',
                [
                    'label'  => esc_html__( 'Border', 'edukado' ),
                    'type'   => Controls_Manager::SLIDER,
                    'default' => [
                        'size' =>2,
                    ],
                    'range'  => [
                        'px' => [
                            'min' => 1,
                            'max' =>2,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .slider-container .slider-pagi__elem' => 'border: {{SIZE}}{{UNIT}} solid;',
                    ],
                ]
            );

            $this->add_control(
                'edukado_slider_nav_border_color',
                    [
                        'label' => esc_html__( 'Border Color', 'edukado' ),
                        'type'  => Controls_Manager::COLOR,
                        'default'   => '#fff',
                        'selectors' => [
                          '{{WRAPPER}} .slider-container .slider-pagi__elem' => 'border-color: {{VALUE}};',
                          '{{WRAPPER}}  .slider-container .slider-pagi__elem:before' => 'background:{{VALUE}};'
                        ],
                    ]
            );

        $this->add_control(
            'edukado_slider_nav_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'edukado' ),
                'type'  => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .slider-container .slider-pagi__elem,
                     {{WRAPPER}} .slider-container .slider-pagi__elem:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'edukado_slider_nav_spacing',
                [
                    'label'  => esc_html__( 'Speacing', 'edukado' ),
                    'type'   => Controls_Manager::SLIDER,
                    'default' => [
                        'size' =>15,
                    ],
                    'range'  => [
                        'px' => [
                            'min' => 10,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .slider-container .slider-pagi' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
            'image_overlay_section',
            [
                'label' => esc_html__( 'Overlay', 'edukado' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

             $this->add_responsive_control(
                'edukado_slider_height',
                    [
                        'label'  => esc_html__( 'Slider Height', 'edukado' ),
                        'type'   => Controls_Manager::SLIDER,
                        'default' => [
                            'size' => 700,
                        ],
                        'range'  => [
                            'px' => [
                                'min' => 500,
                                'max' => 1000,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .slider-container' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                    ]
            );
            $this->add_control(
                'edukado_slider_overlay_color',
                [
                    'label'     => esc_html__( 'Overaly Color', 'edukado' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => 'rgba(6,31,216,0.77)',
                    'selectors' => [
                        '{{WRAPPER}} .edukado-slide .slide__overlay-path' => 'fill: {{VALUE}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'edukado_slider_overlay_opacity',
                    [
                        'label'  => esc_html__( 'Opacity', 'edukado' ),
                        'type'   => Controls_Manager::SLIDER,
                        'default' => [
                            'size' =>0.8,
                        ],
                        'range'  => [
                            'px' => [
                                'min' => 0.1,
                                'max' => 1,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .edukado-slide .slide__overlay path' => 'opacity: {{SIZE}};',
                        ],
                    ]
            );

            $this->add_responsive_control(
                'edukado_slider_overlay_postion',
                    [
                        'label'  => esc_html__( 'Overaly Position', 'edukado' ),
                        'type'   => Controls_Manager::SLIDER,
                         'default' => [
                            'size' => 1000,
                        ],
                        'range'  => [
                            'px' => [
                                'min' => 700,
                                'max' => 1500,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .edukado-slide .slide__overlay' => 'min-height: {{SIZE}}{{UNIT}};',
                        ],
                    ]
            );
        $this->end_controls_section();


    }

    protected function render(){
        $sliders = $settings = $this->get_settings();
        $id = $this->get_id();?>

        <div class="slider-container">
       <!--      <div class="slider-control left inactive"></div>
            <div class="slider-control right"></div> -->
            <ul class="slider-pagi"></ul>
            <div class="slider">
                <?php $a = 0;?>
                <?php foreach($sliders['edukado_slider'] as $slider): ?>
                <div id="edukado-slider-<?php echo $id; ?>" class="edukado-slide slide-<?php echo $a;?> <?php echo ($a == 0) ? 'active': ''; ?>">
                    <div class="slide__bg" style="background-image: url(<?php echo esc_url( $slider['edukado_slider_image']['url']); ?>)"></div>
                    <div class="slide__content">
                        <svg class="slide__overlay" viewBox="0 0 720 405" preserveAspectRatio="xMaxYMax slice">
                        <path class="slide__overlay-path" d="M0,0 150,0 500,405 0,405" />
                        </svg>
                        <div class="slide__text">
                            <?php if($slider['edukado_slider_title']): ?>
                                <h2 class="slide__text-heading"><strong><?php echo  $slider['edukado_slider_title']; ?></strong></h2>
                            <?php endif; ?>

                            <?php if($slider['edukado_slider_subtitle']): ?>
                                <h2 class="slide__text-desc"><?php echo  $slider['edukado_slider_subtitle']; ?></h2>
                            <?php endif; ?>

                            <?php if($slider['edukado_slider_button_text']): ?>
                                <a href="<?php echo  $slider['edukado_slider_button_link']['url']; ?>" target="_blank" class="slide__text-link"><?php echo  $slider['edukado_slider_button_text']; ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                    <?php $a++; endforeach;  ?>
            </div>
        </div>


<script type="text/javascript">
(function( $ ){
    var $slider = $(".slider"),
    $slideBGs = $(".slide__bg"),
    diff = 0,
    curSlide = 0,
    numOfSlides = $(".edukado-slide").length - 1,
    animating = false,
    animTime = 500,
    autoSlideTimeout,
    autoSlideDelay = 10000,
    $pagination = $(".slider-pagi");

  function createBullets() {
    for (var i = 0; i < numOfSlides + 1; i++) {
      var $li = $("<li class='slider-pagi__elem'></li>");
      $li.addClass("slider-pagi__elem-" + i).data("page", i);
      if (!i) $li.addClass("active");
      $pagination.append($li);
    }
  }

  createBullets();

  function manageControls() {
    $(".slider-control").removeClass("inactive");
    if (!curSlide) $(".slider-control.left").addClass("inactive");
    if (curSlide === numOfSlides)
      $(".slider-control.right").addClass("inactive");
  }

  function autoSlide() {
    autoSlideTimeout = setTimeout(function() {
      curSlide++;
      if (curSlide > numOfSlides) curSlide = 0;
      changeSlides();
    }, autoSlideDelay);
  }

  autoSlide();

  function changeSlides(instant) {
    if (!instant) {
      animating = true;
      manageControls();
      $slider.addClass("animating");
      $slider.css("top");
      $(".edukado-slide").removeClass("active");
      $(".slide-" + curSlide).addClass("active");
      setTimeout(function() {
        $slider.removeClass("animating");
        animating = false;
      }, animTime);
    }
    window.clearTimeout(autoSlideTimeout);
    $(".slider-pagi__elem").removeClass("active");
    $(".slider-pagi__elem-" + curSlide).addClass("active");
    $slider.css("transform", "translate3d(" + -curSlide * 100 + "%,0,0)");
    $slideBGs.css("transform", "translate3d(" + curSlide * 50 + "%,0,0)");
    diff = 0;
    autoSlide();
  }

  function navigateLeft() {
    if (animating) return;
    if (curSlide > 0) curSlide--;
    changeSlides();
  }

  function navigateRight() {
    if (animating) return;
    if (curSlide < numOfSlides) curSlide++;
    changeSlides();
  }

  $(document).on("mousedown touchstart", ".slider", function(e) {
    if (animating) return;
    window.clearTimeout(autoSlideTimeout);
    var startX = e.pageX || e.originalEvent.touches[0].pageX,
      winW = $(window).width();
    diff = 0;

    $(document).on("mousemove touchmove", function(e) {
      var x = e.pageX || e.originalEvent.touches[0].pageX;
      diff = (startX - x) / winW * 70;
      if ((!curSlide && diff < 0) || (curSlide === numOfSlides && diff > 0))
        diff /= 2;
      $slider.css(
        "transform",
        "translate3d(" + (-curSlide * 100 - diff) + "%,0,0)"
      );
      $slideBGs.css(
        "transform",
        "translate3d(" + (curSlide * 50 + diff / 2) + "%,0,0)"
      );
    });
  });

  $(document).on("mouseup touchend", function(e) {
    $(document).off("mousemove touchmove");
    if (animating) return;
    if (!diff) {
      changeSlides(true);
      return;
    }
    if (diff > -8 && diff < 8) {
      changeSlides();
      return;
    }
    if (diff <= -8) {
      navigateLeft();
    }
    if (diff >= 8) {
      navigateRight();
    }
  });

  $(document).on("click", ".slider-control", function() {
    if ($(this).hasClass("left")) {
      navigateLeft();
    } else {
      navigateRight();
    }
  });

  $(document).on("click", ".slider-pagi__elem", function() {
    curSlide = $(this).data("page");
    changeSlides();
  });
}) (jQuery);
</script>


   <?php }


    // protected function _content_template()
    // {

    // }
}
