<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;

if (!defined('ABSPATH')) exit; // Exit if accessed directly
if(!function_exists('widgetkit_pro_array_get')) {
    function widgetkit_pro_array_get($array, $key, $default=null){
        if(!is_array($array)) return $default;
        return array_key_exists($key, $array) ? $array[$key] : $default;
    }
}

/**
 * magmax Layout_Single
 * =============
 */
class Widgetkit_Pro_Single_Post_by_ID extends Widget_Base
{

    public function get_name()
    {
        return 'magmax-layout-single';
    }

    public function get_title()
    {
        return __('Single Post by ID', 'widgetkit-pro');
    }

    public function get_icon()
    {
        return 'eicon-post-content';
    }

    public function get_categories()
    {
        return ['widgetkit_pro'];
    }

    /**
     * A list of scripts that the widgets is depended in
     *
     * @since 1.3.0
     **/
    /*
        public function get_script_depends() {
            return [ 'imagesloaded' ];
        }
    */

    protected function _register_controls()
    {
        $terms = get_terms( array(
            'taxonomy' => 'category',
            'hide_empty' => false,
        ) );
        $cat_names = array();
        foreach( $terms as $t ):
            $cat_names[$t->term_id] = $t->name;
        endforeach;

        /* slides content title subtitle button and button link */
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Layout_Single', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'layout_header_enable',
            [
                'label' => __( 'Layout_Single Header', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Layout_Single header disable or enable',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'layout_title',
            [
                'label'       => __( 'Title', 'widgetkit-pro' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Layout_Single title text', 'widgetkit-pro' ),
                'placeholder' => __( 'Type your layout title text here', 'widgetkit-pro' ),
                'condition' => [
                    'layout_header_enable' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'single_layout_style',
            [
                'label'       => __( 'Layout_Single Style', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'layout-1',
                'options' => [
                    'layout-single-1'  => __( 'Layout_Single 1', 'widgetkit-pro' ),
                    'layout-single-2'  => __( 'Layout_Single 2', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'single_post_id',
            [
                'label'   => __( 'Write your single post ID', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 5,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'single_post_style',
            [
                'label'       => __( 'Single Post style', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'horizontal',
                'options' => [
                    'vertical'  => __( 'Vertical', 'widgetkit-pro' ),
                    'horizontal'  => __( 'Horizontal', 'widgetkit-pro' ),
                ],
                'condition' => [
                    'single_layout_style' => 'layout-single-1',
                ]
            ]
        );
        $this->add_control(
            'single_post_show_thumbnail',
            [
                'label' => __( 'Show thumbnail', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Show excerpt in the post',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
                'condition' => [
                    'single_layout_style' => 'layout-single-1',
                ]
            ]
        );
        $this->add_control(
            'single_post_show_cat',
            [
                'label' => __( 'Show Category', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Show category tag above the title',
                'label_on' => __( 'Show', 'widgetkit-pro' ),
                'label_off' => __( 'Hide', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'single_post_show_excerpt',
            [
                'label' => __( 'Show Excerpt', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Show excerpt in the post',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'post_excerpt_word_count_layout_1',
            [
                'label'   => __( 'Post excerpt Word For Layout 1', 'widgetkit-pro' ),
                'description' => 'Show excerpt word in the post',
                'type'    => Controls_Manager::NUMBER,
                'default' => 10,
                'min'     => 10,
                'max'     => 100,
                'step'    => 1,
                'condition' => [
                    'single_post_show_excerpt' => 'yes',
                    'single_layout_style' => 'layout-single-1',
                ],
            ]
        );
        $this->add_control(
            'post-min-height',
            [
                'label' => __( 'Post Min Height', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 300,
                ],
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 1500,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .layout-single-2 .single-post-by-id.has-post-thumbnail' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .layout-single-2 .single-post-by-id.has-post-thumbnail .post-thumb img' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'single_layout_style' => 'layout-single-2',
                ],
            ]
        );
        $this->add_control(
            'post_excerpt_word_count_layout_2',
            [
                'label'   => __( 'Post excerpt Word For Layout 2', 'widgetkit-pro' ),
                'description' => 'Show excerpt word in the post',
                'type'    => Controls_Manager::NUMBER,
                'default' => 10,
                'min'     => 10,
                'max'     => 100,
                'step'    => 1,
                'condition' => [
                    'single_post_show_excerpt' => 'yes',
                    'single_layout_style' => 'layout-single-2',
                ],
            ]
        );

        $this->end_controls_section();

        /**
         * Style tab
         * =============
         */
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        /**
         * section title
         */
        $this->add_control(
            'section_title',
            [
                'label' => __( 'Section Title', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Section Title', 'widgetkit-pro' ),
                'name' => 'section_title_typography',
                'selector' => '{{WRAPPER}} .layout-title h3',
            ]
        );

        $this->add_control(
            'single_post_title',
            [
                'label' => __( 'Single Post Title', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'layout_style' => ['layout-single-1', 'layout-single-2'],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Title Typography', 'widgetkit-pro' ),
                'name' => 'single_post_title_typography',
                'selector' => '{{WRAPPER}} .single-post-by-id .single-post-title h3',
                'condition' => [
                    'single_layout_style' => ['layout-single-1', 'layout-single-2'],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Content Typography', 'widgetkit-pro' ),
                'name' => 'content__typography',
                'selector' => '{{WRAPPER}} .cat-post-list-wrapper .post-excerpt',

            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'content_style',
            [
                'label' => __( 'Content', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_padding_switcher',
            [
                'label' => __( 'Content Padding', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Custom padding option not for image',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'content_custom_padding',
            [
                'label' => __( 'Padding', 'widgetkit-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .single-post-by-id .post-data' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'content_padding_switcher' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'custom_color',
            [
                'label' => __( 'Custom Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Show custom color for content',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Title Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-post-by-id .single-post-title h3' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'layout_1_cat_color',
            [
                'label' => __( 'Category Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .layout-single-1 .post-cat a.cat-item' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                    'single_layout_style' => 'layout-single-1',
                ],
            ]
        );
        $this->add_control(
            'layout_1_cat_bgcolor',
            [
                'label' => __( 'Category Background Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .layout-single-1 .post-cat a.cat-item' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                    'single_layout_style' => 'layout-single-1',
                ],
            ]
        );
        $this->add_control(
            'layout_2_cat_color',
            [
                'label' => __( 'Category Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .layout-single-2 .post-cat a.cat-item' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                    'single_layout_style' => 'layout-single-2',
                ],
            ]
        );
        $this->add_control(
            'layout_2_cat_bgcolor',
            [
                'label' => __( 'Category Background Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .layout-single-2 .post-cat a.cat-item' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                    'single_layout_style' => 'layout-single-2',
                ],
            ]
        );
        $this->add_control(
            'meta_color',
            [
                'label' => __( 'Meta Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-meta div' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label' => __( 'Content Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-post-by-id .post-excerpt' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_gradient',
            [
                'label' => __( 'Gradient', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'single_layout_style' => 'layout-single-2',
                ],
            ]
        );
        $this->add_control(
            'overlay_style',
            [
                'label'       => __( 'Overlay Style', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'bg-overlay',
                'options' => [
                    'bg-overlay'  => __( 'Overlay', 'widgetkit-pro' ),
                    'bg-gradient'  => __( 'Gradient', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'background_overlay',
            [
                'label' => __( 'Background Overlay', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .layout-single-2 .single-post-by-id:before, .layout-single-2 .single-post-by-id.has-post-thumbnail:before,
                .layout-single-2 .single-post-by-id.no-post-thumbnail:before' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'overlay_style' => 'bg-overlay',
                ],
            ]
        );

        $this->add_control(
            'gradient_1',
            [
                'label' => __( 'Gradient 1', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .layout-single-2 .single-post-by-id:before, #layout-3 .regular-post.has-post-thumbnail:before,
                #layout-single-2 .regular-post.no-post-thumbnail:before' => 'background: linear-gradient(180deg, rgba(0, 0, 0, 0.01), {{VALUE}})',
                ],
                'condition' => [
                    'overlay_style' => 'bg-gradient',
                ],
            ]
        );

        $this->end_controls_section();


    }

    protected function render()
    {
        $settings = $this->get_settings();
        $layout = widgetkit_pro_array_get($settings, 'single_layout_style');
        $layout_header_enable = widgetkit_pro_array_get($settings, 'layout_header_enable');
        $layout_title = widgetkit_pro_array_get($settings, 'layout_title');

        $single_post_id = widgetkit_pro_array_get($settings, 'single_post_id');
        $single_post_style = widgetkit_pro_array_get($settings, 'single_post_style');
        $single_post_show_thumbnail = widgetkit_pro_array_get($settings, 'single_post_show_thumbnail');
        $single_post_show_cat = widgetkit_pro_array_get($settings, 'single_post_show_cat');
        $single_post_show_excerpt = widgetkit_pro_array_get($settings, 'single_post_show_excerpt');
        $post_excerpt_word_count_layout_1 = widgetkit_pro_array_get($settings, 'post_excerpt_word_count_layout_1');
        $post_excerpt_word_count_layout_2 = widgetkit_pro_array_get($settings, 'post_excerpt_word_count_layout_2');
        /**
         * term meta value
         * ================
         */
        $tax_term = get_term_meta($single_post_id);
        $tax_image = widgetkit_pro_array_get($tax_term, 'magmax_tax_image')[0];
        $tax_tag_bg_color = widgetkit_pro_array_get($tax_term, 'magmax_tax_tag_bg_color')[0];
        /**
         * Gradient
         * =========
         */
        $overlay_style = widgetkit_pro_array_get($settings, 'overlay_style');
        $bg_overlay = widgetkit_pro_array_get($settings, 'background_overlay');
        $gradient_1 = widgetkit_pro_array_get($settings, 'gradient_1');
        $gradient_2 = widgetkit_pro_array_get($settings, 'gradient_2');
    ?>
    <?php
        include( plugin_dir_path( __FILE__ ) . '../layout/'.$layout.'.php');
        ?>
    <?php
    }
    protected function _content_template()
    {
    }
}
