<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Text_Shadow;

if (!defined('ABSPATH')) exit; // Exit if accessed directly
if(!function_exists('widgetkit_pro_array_get')) {
    function widgetkit_pro_array_get($array, $key, $default=null){
        if(!is_array($array)) return $default;
        return array_key_exists($key, $array) ? $array[$key] : $default;
    }
}

/**
 * magmax Layout
 * =============
 */
class Widgetkit_Pro_Single_Category_Layout extends Widget_Base
{

    public function get_name()
    {
        return 'magmax-layout';
    }

    public function get_title()
    {
        return __('Single Category Layout', 'widgetkit-pro');
    }

    public function get_icon()
    {
        return 'eicon-posts-group';
    }

    public function get_categories()
    {
        return ['widgetkit_pro'];
    }

    /**
     * A list of scripts that the widgets is depended in
     *
     * @since 1.3.0
     **/
    /*
        public function get_script_depends() {
            return [ 'imagesloaded' ];
        }
    */

    protected function _register_controls()
    {
        $terms = get_terms( array(
            'taxonomy' => 'category',
            'hide_empty' => false,
        ) );
        $cat_names = array();
        foreach( $terms as $t ):
            $cat_names[$t->term_id] = $t->name;
        endforeach;

        /* slides content title subtitle button and button link */
        $this->start_controls_section(
            'section_header_tab',
            [
                'label' => __('Header', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'layout_header_enable',
            [
                'label' => __( 'Enable/Disable', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Header disable or enable',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'layout_title',
            [
                'label'       => __( 'Title', 'widgetkit-pro' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Title Text', 'widgetkit-pro' ),
                'placeholder' => __( 'Type your title text here', 'widgetkit-pro' ),
                'condition' => [
                    'layout_header_enable' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'layout_view_all_enable',
            [
                'label' => __( 'Enable View Button', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Show or hide view button',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
                'condition' => [
                    'layout_header_enable' => 'yes',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_contet_tab',
            [
                'label' => __('Content', 'widgetkit-pro'),
                'class' => __('Single Category layout', 'widgetkit-pro'),
            ]
        );


            $this->add_control(
                'cat_name',
                [
                    'label'       => __( 'Select Category', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => $cat_names,
                ]
            );

            $this->add_control(
                'post_num_to_show',
                [
                    'label'   => __( 'Post to Show', 'widgetkit-pro' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 5,
                    'min'     => 1,
                    'max'     => 10,
                    'step'    => 1,
                ]
            );

            $this->add_control(
                'show_cat_tag',
                [
                    'label' => __( 'Show Category', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'description' => 'Show category tag above the title',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );

            $this->add_control(
                'layout_style',
                [
                    'label'       => __( 'Style', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'layout-1',
                    'options' => [
                        'layout-1'  => __( 'Layout 1', 'widgetkit-pro' ),
                        'layout-2'  => __( 'Layout 2', 'widgetkit-pro' ),
                        'layout-3'  => __( 'Layout 3', 'widgetkit-pro' ),
                        'layout-4'  => __( 'Layout 4', 'widgetkit-pro' ),
                        'layout-5'  => __( 'Layout 5', 'widgetkit-pro' ),
                    ],
                ]
            );

            $this->add_control(
                'regular_post_grid',
                [
                    'label'       => __( 'Post Grid', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '1',
                    'options' => [
                        '1'  => __( '1', 'widgetkit-pro' ),
                        '2'  => __( '2', 'widgetkit-pro' ),
                        '3'  => __( '3', 'widgetkit-pro' ),
                        '4'  => __( '4', 'widgetkit-pro' ),
                    ],
                    'condition' => [
                        'layout_style' => ['layout-1', 'layout-3', 'layout-4'],
                    ]
                ]
            );
            $this->add_control(
                'regular_post_style',
                [
                    'label'       => __( 'Position', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'vertical',
                    'options' => [
                        'vertical'  => __( 'Vertical', 'widgetkit-pro' ),
                        'horizontal'  => __( 'Horizontal', 'widgetkit-pro' ),
                    ],
                    'condition' => [
                        'layout_style' => ['layout-1', 'layout-4'],
                    ]
                ]
            );

            // $this->add_control(
            //     'title_word',
            //     [
            //         'label'       => __( 'Title Word Count', 'widgetkit-pro' ),
            //         'type'    => Controls_Manager::NUMBER,
            //         'default' => 7,
            //         'min'     => 5,
            //         'max'     => 100,
            //         'step'    => 1,
            //         'condition' => [
            //             'layout_style' => 'layout-5',
            //         ]
            //     ]
            // );

            // $this->add_control(
            //     'featured-post-min-height',
            //     [
            //         'label' => __( 'Featured Post Min Height', 'widgetkit-pro' ),
            //         'type' => Controls_Manager::SLIDER,
            //         'default' => [
            //             'size' => 500,
            //         ],
            //         'range' => [
            //             'px' => [
            //                 'min' => 200,
            //                 'max' => 900,
            //                 'step' => 1,
            //             ],
            //         ],
            //         'size_units' => [ 'px' ],
            //         'selectors' => [
            //             '{{WRAPPER}} .cat-post-list-wrapper' => 'grid-template-rows: minmax({{SIZE}}{{UNIT}}, 1fr);',
            //         ],
            //         'condition' => [
            //             'highlight_first_post' => 'yes',
            //             'highlight_layout_style' => 'tiles',
            //             'layout_style' => ['layout-1', 'layout-4', 'layout-5'],
            //         ]
            //     ]
            // );



            $this->add_control(
                'regular_thumbnail_size',
                [
                    'label'       => __( 'Thumbnail Size', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'large',
                    'options' => [
                        'medium'  => __( 'Medium', 'widgetkit-pro' ),
                        'medium_large'  => __( 'Medium Large', 'widgetkit-pro' ),
                        'large'  => __( 'Large', 'widgetkit-pro' ),
                        'full'  => __( 'Full', 'widgetkit-pro' ),
                    ],
                ]
            );
            $this->add_control(
                'grid-gap',
                [
                    'label' => __( 'Items Gap', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'size' =>40,
                    ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 40,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 5,
                        ],
                    ],
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .post-grid-1 .cat-post-list-wrapper' => 'grid-gap: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .post-grid-2 .cat-post-list-wrapper' => 'grid-gap: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .post-grid-3 .cat-post-list-wrapper' => 'grid-gap: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .post-grid-4 .cat-post-list-wrapper' => 'grid-gap: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );


            $this->add_control(
                'show_excerpt',
                [
                    'label' => __( 'Show Excerpt', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'description' => 'Show excerpt in the highlight and regular post',
                    'label_on' => __( 'Yes', 'widgetkit-pro' ),
                    'label_off' => __( 'No', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );



        $this->end_controls_section();


        $this->start_controls_section(
            'section_highlight_post',
            [
                'label' => __('Highlight Post', 'widgetkit-pro'),
                'class' => __('Single category layout', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'highlight_first_post',
            [
                'label' => __( 'Highlight Post', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Highlight 1st post from the list',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'featured_thumbnail_size',
            [
                'label'       => __( 'Highlighted Thumbnail Size', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'large',
                'options' => [
                    'medium'  => __( 'Medium', 'widgetkit-pro' ),
                    'medium_large'  => __( 'Medium Large', 'widgetkit-pro' ),
                    'large'  => __( 'Large', 'widgetkit-pro' ),
                    'full'  => __( 'Full', 'widgetkit-pro' ),
                ],
                'condition' => [
                    'highlight_first_post' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'highlight_layout_style',
            [
                'label'       => __( 'Highlight Layout Style', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'list',
                'options' => [
                    'list'  => __( 'List', 'widgetkit-pro' ),
                    'tiles'  => __( 'Tiles', 'widgetkit-pro' ),
                ],
                'condition' => [
                    'highlight_first_post' => 'yes',
                    'layout_style' => ['layout-1', 'layout-2', 'layout-4', 'layout-5'],
                ]
            ]
        );

        $this->add_control(
            'show_highlight_cat_tag',
            [
                'label' => __( 'Category Tag for Highlight Post', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Show category tag for highlight post above the title',
                'label_on' => __( 'Show', 'widgetkit-pro' ),
                'label_off' => __( 'Hide', 'widgetkit-pro' ),
                'return_value' => 'yes',
                'condition' => [
                    'highlight_first_post' => 'yes',
                    'layout_style' => ['layout-1', 'layout-2', 'layout-4'],
                ]
            ]
        );


        $this->add_control(
            'highlight_excerpt_word_count',
            [
                'label'   => __( 'Highlight Post Word', 'widgetkit-pro' ),
                'description' => 'Show excerpt word in the highlight',
                'type'    => Controls_Manager::NUMBER,
                'default' => 10,
                'min'     => 10,
                'max'     => 100,
                'step'    => 1,
                'condition' => [
                    'show_excerpt' => 'yes',
                    'layout_style' => ['layout-1', 'layout-4'],
                ],
            ]
        );
        $this->add_control(
            'regular_excerpt_word_count',
            [
                'label'   => __( 'Regular Post Word', 'widgetkit-pro' ),
                'description' => 'Show excerpt word in the regular post',
                'type'    => Controls_Manager::NUMBER,
                'default' => 10,
                'min'     => 10,
                'max'     => 100,
                'step'    => 1,
                'condition' => [
                    'show_excerpt' => 'yes',
                    'layout_style' => ['layout-1','layout-4'],
                ],
            ]
        );
        $this->add_control(
            'excerpt_word_count',
            [
                'label'   => __( 'Excerpt Word Count', 'widgetkit-pro' ),
                'description' => 'Show excerpt word in the post',
                'type'    => Controls_Manager::NUMBER,
                'default' => 10,
                'min'     => 10,
                'max'     => 100,
                'step'    => 1,
                'condition' => [
                    'show_excerpt' => 'yes',
                    'layout_style' => 'layout-3',
                ],
            ]
        );


        // $this->add_control(
        //     'layout-5-featured-post-min-height',
        //     [
        //         'label' => __( 'Featured Post Min Height', 'widgetkit-pro' ),
        //         'type' => Controls_Manager::SLIDER,
        //         'default' => [
        //             'size' => 500,
        //         ],
        //         'range' => [
        //             'px' => [
        //                 'min' => 200,
        //                 'max' => 900,
        //                 'step' => 1,
        //             ],
        //         ],
        //         'size_units' => [ 'px' ],
        //         'selectors' => [
        //             '{{WRAPPER}} #layout-5 .featured-post .post-thumb >a  img.wp-post-image' => 'height: {{SIZE}}{{UNIT}}',
        //         ],
        //         'condition' => [
        //             'layout_style' => 'layout-5',
        //         ]
        //     ]
        // );

        $this->end_controls_section();


        

        /**
         * Style tab
         * =============
         */
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        /**
         * section title
         */
        $this->add_control(
            'section_title',
            [
                'label' => __( 'Section Title', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Section Title', 'widgetkit-pro' ),
                'name' => 'section_title_typography',
                'selector' => '{{WRAPPER}} .layout-title h4',
            ]
        );
        /**
         * highlight title
         */
        $this->add_control(
            'highlight_title',
            [
                'label' => __( 'Highlight Post Title', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Highlight Post Title', 'widgetkit-pro' ),
                'name' => 'highlight_post_title_typography',
                'selector' => '{{WRAPPER}} .featured-post .highlight-post-title h3',

            ]
        );
        /**
         * regular title
         */
        $this->add_control(
            'regular_title',
            [
                'label' => __( 'Regular Post Title', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Regular Post Title', 'widgetkit-pro' ),
                'name' => 'regular_post_title_typography',
                'selector' => '{{WRAPPER}} .regular-post .regular-post-title h3',

            ]
        );
        /**
         * content title
         */
        $this->add_control(
            'content_typography',
            [
                'label' => __( 'Content Typography', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Content Typography', 'widgetkit-pro' ),
                'name' => 'content__typography',
                'selector' => '{{WRAPPER}} .cat-post-list-wrapper .post-excerpt',

            ]
        );

        $this->end_controls_section();





        $this->start_controls_section(
            'section_padding',
            [
                'label' => __( 'Content Spacing', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_style' => 'layout-4',
                ],
            ]
        );
        $this->add_control(
            'content_custom_padding_switcher',
            [
                'label' => __( 'Custom Padding', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Add custom padding for content',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
                'condition' => [
                    'layout_style' => 'layout-4'
                ],
            ]
        );
        $this->add_control(
            'content_custom_padding_highlight',
            [
                'label' => __( 'Highlight Post Padding', 'widgetkit-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} #layout-4 .cat-post-list-wrapper .featured-post .post-data' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'content_custom_padding_switcher' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'content_custom_padding_regular',
            [
                'label' => __( 'Regular Post Padding', 'widgetkit-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} #layout-4 .cat-post-list-wrapper .regular-post .post-data' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'content_custom_padding_switcher' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();








        $this->start_controls_section(
            'content_style',
            [
                'label' => __( 'Content', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'custom_color',
            [
                'label' => __( 'Custom Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Show custom color for content',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'section_title_color',
            [
                'label' => __( 'Section Title Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .layout-title h4' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .layout-header ' => 'border-color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'view_all_bg_color',
            [
                'label' => __( 'View All Background Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .layout-header .view-all a' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'view_all_color',
            [
                'label' => __( 'View All Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .layout-header .view-all a' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'highlight_bg_color',
            [
                'label' => __( 'Highlight Background Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cat-post-list-wrapper .featured-post' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                    'layout_style' => 'layout-4',
                ],
            ]
        );
        $this->add_control(
            'regular_bg_color',
            [
                'label' => __( 'Regular Background Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cat-post-list-wrapper .regular-post' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                    'layout_style' => 'layout-4',
                ],
            ]
        );

        $this->add_control(
            'highlight_title_color',
            [
                'label' => __( 'Highlight Title Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .highlight-post-title h3' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'regular_title_color',
            [
                'label' => __( 'Regular Title Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .regular-post-title h3' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'highlight_meta_color',
            [
                'label' => __( 'Highlight Meta Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .featured-post .post-meta div' => 'color: {{VALUE}}',
                    '{{WRAPPER}} #layout-5 .featured-post .highlight-post-cat, {{WRAPPER}} #layout-5 .featured-post .highlight-post-cat a ' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'regular_meta_color',
            [
                'label' => __( 'Regular Meta Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .regular-post .post-meta div' => 'color: {{VALUE}}',
                    '{{WRAPPER}} #layout-5 .regular-post .post-cat, {{WRAPPER}} #layout-5 .regular-post .post-cat a ' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'highlight_content_color',
            [
                'label' => __( 'Highlight Content Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .featured-post  .post-excerpt' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'regular_content_color',
            [
                'label' => __( 'Regular Content Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .regular-post  .post-excerpt' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_gradient',
            [
                'label' => __( 'Gradient', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_style' => ['layout-3', 'layout-5'],
                ],
            ]
        );
        $this->add_control(
            'overlay_style',
            [
                'label'       => __( 'Overlay Style', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'bg-overlay',
                'options' => [
                    'bg-overlay'  => __( 'Overlay', 'widgetkit-pro' ),
                    'bg-gradient'  => __( 'Gradient', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'background_overlay',
            [
                'label' => __( 'Background Overlay', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #layout-3 .featured-post:before, #layout-3 .regular-post.has-post-thumbnail:before,
                #layout-3 .regular-post.no-post-thumbnail:before' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} #layout-5 .featured-post .post-thumb >a:before' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'overlay_style' => 'bg-overlay',
                ],
            ]
        );

        $this->add_control(
            'gradient_1',
            [
                'label' => __( 'Gradient 1', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #layout-3 .featured-post:before, {{WRAPPER}} #layout-3 .regular-post.has-post-thumbnail:before,
                    {{WRAPPER}} #layout-3 .regular-post.no-post-thumbnail:before' => 'background: linear-gradient(180deg, rgba(0, 0, 0, 0.01), {{VALUE}})',
                    '{{WRAPPER}} #layout-5 .featured-post .post-thumb >a:before' => 'background-image: linear-gradient(180deg, rgba(0, 0, 0, 0.01), {{VALUE}} 100%)',
                    '{{WRAPPER}} #layout-5 .featured-post:hover .post-thumb >a:before' => 'background-color: {{VALUE}} ',
                ],
                'condition' => [
                    'overlay_style' => 'bg-gradient',
                ],
            ]
        );
        $this->add_control(
            'highlight_tiles_text_shadow',
            [
                'label' => __( 'Tiles Title Text Shadow', 'widgetkit-pro' ),
                'type' => Controls_Manager::TEXT_SHADOW,
                'selectors' => [
                    '{{WRAPPER}} #layout-5 .highlight-post-style-tiles .featured-post .post-title h3' => 'text-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{COLOR}};',
                ],
                'condition' => [
                    'overlay_style' => 'bg-gradient',
                ],
            ]
        );

        $this->end_controls_section();


    }

    protected function render()
    {
        $settings = $this->get_settings();
        $layout = widgetkit_pro_array_get($settings, 'layout_style');
        $layout_header_enable = widgetkit_pro_array_get($settings, 'layout_header_enable');
        $layout_title = widgetkit_pro_array_get($settings, 'layout_title');
        $layout_view_all_enable = widgetkit_pro_array_get($settings, 'layout_view_all_enable');

        $cat_id = widgetkit_pro_array_get($settings, 'cat_name');
        $featured_thumbnail_size = widgetkit_pro_array_get($settings, 'featured_thumbnail_size');
        $regular_thumbnail_size = widgetkit_pro_array_get($settings, 'regular_thumbnail_size');

        $post_num_to_show = widgetkit_pro_array_get($settings, 'post_num_to_show');
        $highlight_first_post = widgetkit_pro_array_get($settings, 'highlight_first_post');
        $highlight_layout_style = widgetkit_pro_array_get($settings, 'highlight_layout_style');
        $show_highlight_cat_tag = widgetkit_pro_array_get($settings, 'show_highlight_cat_tag');
        $show_excerpt = widgetkit_pro_array_get($settings, 'show_excerpt');
        $highlight_excerpt_word_count = widgetkit_pro_array_get($settings, 'highlight_excerpt_word_count');
        $regular_excerpt_word_count = widgetkit_pro_array_get($settings, 'regular_excerpt_word_count');
        $excerpt_word_count = widgetkit_pro_array_get($settings, 'excerpt_word_count');
        $regular_post_grid = widgetkit_pro_array_get($settings, 'regular_post_grid');
        $regular_post_style = widgetkit_pro_array_get($settings, 'regular_post_style');
        $show_cat_tag = widgetkit_pro_array_get($settings, 'show_cat_tag');
        $title_word = widgetkit_pro_array_get($settings, 'title_word');
        /**
         * term meta value
         * ================
         */
        $tax_term = get_term_meta($cat_id);
        $tax_image = widgetkit_pro_array_get($tax_term, 'magmax_tax_image')[0];
        $tax_tag_bg_color = widgetkit_pro_array_get($tax_term, 'magmax_tax_tag_bg_color')[0];
        /**
         * Gradient
         * =========
         */
        $overlay_style = widgetkit_pro_array_get($settings, 'overlay_style');
        $bg_overlay = widgetkit_pro_array_get($settings, 'background_overlay');
        $gradient_1 = widgetkit_pro_array_get($settings, 'gradient_1');
        $gradient_2 = widgetkit_pro_array_get($settings, 'gradient_2');
    ?>
    <?php
        include( plugin_dir_path( __FILE__ ) . '../layout/single-category-layout/'.$layout.'.php');
        ?>
    <?php
    }
    protected function _content_template()
    {
    }
}
