<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Text_Shadow;

if (!defined('ABSPATH')) exit; // Exit if accessed directly
if(!function_exists('widgetkit_pro_array_get')) {
    function widgetkit_pro_array_get($array, $key, $default=null){
        if(!is_array($array)) return $default;
        return array_key_exists($key, $array) ? $array[$key] : $default;
    }
}

/**
 * magmax Layout
 * =============
 */
class Widgetkit_Pro_Single_Category_Carousel extends Widget_Base
{

    public function get_name()
    {
        return 'magmax-single-category-carousel';
    }

    public function get_title()
    {
        return __('Single Category Carousel', 'widgetkit-pro');
    }

    public function get_icon()
    {
        return 'eicon-posts-carousel';
    }

    public function get_categories()
    {
        return ['widgetkit_pro'];
    }

    /**
     * A list of scripts that the widgets is depended in
     *
     * @since 1.3.0
     **/
    /*
        public function get_script_depends() {
            return [ 'imagesloaded' ];
        }
    */

    protected function _register_controls()
    {
        $terms = get_terms( array(
            'taxonomy' => 'category',
            'hide_empty' => false,
        ) );
        $cat_names = array();
        foreach( $terms as $t ):
            $cat_names[$t->term_id] = $t->name;
        endforeach;

        /* slides content title subtitle button and button link */
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Layout', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'layout_header_enable',
            [
                'label' => __( 'Layout Header', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Layout header disable or enable',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'layout_title',
            [
                'label'       => __( 'Title', 'widgetkit-pro' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Layout title text', 'widgetkit-pro' ),
                'placeholder' => __( 'Type your layout title text here', 'widgetkit-pro' ),
                'condition' => [
                    'layout_header_enable' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'layout_style',
            [
                'label'       => __( 'Layout Style', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'carousel-layout-1',
                'options' => [
                    'carousel-layout-1'  => __( 'Layout 1', 'widgetkit-pro' ),
                    'carousel-layout-2'  => __( 'Layout 2', 'widgetkit-pro' ),
                    'carousel-layout-3'  => __( 'Layout 3', 'widgetkit-pro' ),
                    'carousel-layout-4'  => __( 'Layout 4', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'cat_name',
            [
                'label'       => __( 'Category List', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => $cat_names,
            ]
        );
        $this->add_control(
            'thumbnail_size',
            [
                'label'       => __( 'Thumbnail Size', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'large',
                'options' => [
                    'medium'  => __( 'Medium', 'widgetkit-pro' ),
                    'medium_large'  => __( 'Medium Large', 'widgetkit-pro' ),
                    'large'  => __( 'Large', 'widgetkit-pro' ),
                    'full'  => __( 'Full', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'column_gap',
            [
                'label' => __( 'Column Gap', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 1,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'condition' => [
                    'layout_style' => ['carousel-layout-1', 'carousel-layout-2'],
                ]
            ]
        );

        $this->add_control(
            'post_num_to_show',
            [
                'label'   => __( 'Number of Post to Show', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 5,
                'min'     => 1,
                'max'     => 20,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'regular_post_column',
            [
                'label'       => __( 'Post Column', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => '3',
                'options' => [
                    '1'  => __( '1', 'widgetkit-pro' ),
                    '2'  => __( '2', 'widgetkit-pro' ),
                    '3'  => __( '3', 'widgetkit-pro' ),
                    '4'  => __( '4', 'widgetkit-pro' ),
                    '5'  => __( '5', 'widgetkit-pro' ),
                    '6'  => __( '6', 'widgetkit-pro' ),
                ],
                'condition' => [
                    'layout_style' => ['carousel-layout-1', 'carousel-layout-2'],
                ]
            ]
        );
        $this->add_control(
            'regular_post_style',
            [
                'label'       => __( 'Regular Post Grid', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'horizontal',
                'options' => [
                    'vertical'  => __( 'Vertical', 'widgetkit-pro' ),
                    'horizontal'  => __( 'Horizontal', 'widgetkit-pro' ),
                ],
                'condition' => [
                    'layout_style' => 'carousel-layout-1',
                ]
            ]
        );
        $this->add_control(
            'show_cat_tag',
            [
                'label' => __( 'Category Tag', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Show category tag above the title',
                'label_on' => __( 'Show', 'widgetkit-pro' ),
                'label_off' => __( 'Hide', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'show_excerpt',
            [
                'label' => __( 'Show Excerpt', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Show excerpt in the highlight and regular post',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'regular_excerpt_word_count',
            [
                'label'   => __( 'Regular Post Word', 'widgetkit-pro' ),
                'description' => 'Show excerpt word in the regular post',
                'type'    => Controls_Manager::NUMBER,
                'default' => 10,
                'min'     => 10,
                'max'     => 100,
                'step'    => 1,
                'condition' => [
                    'show_excerpt' => 'yes',
                    'layout_style' => ['carousel-layout-1','carousel-layout-4'],
                ],
            ]
        );
        $this->add_control(
            'excerpt_word_count',
            [
                'label'   => __( 'Excerpt Word Count', 'widgetkit-pro' ),
                'description' => 'Show excerpt word in the post',
                'type'    => Controls_Manager::NUMBER,
                'default' => 10,
                'min'     => 10,
                'max'     => 100,
                'step'    => 1,
                'condition' => [
                    'show_excerpt' => 'yes',
                    'layout_style' => 'carousel-layout-3',
                ],
            ]
        );
        $this->add_control(
            'navigation_position',
            [
                'label'       => __( 'Navigation Position', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'top-right',
                'options' => [
                    'top-right'  => __( 'Top Right', 'widgetkit-pro' ),
                    'center-center'  => __( 'Center Center', 'widgetkit-pro' ),
                ],
                'condition' => [
                    'layout_style' => ['carousel-layout-1', 'carousel-layout-2'],
                ],
            ]
        );
        $this->add_control(
            'navigation-top-position',
            [
                'label' => __( 'Navigation Top Position', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 500,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .navigation-center-center .owl-nav' => 'top: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation_position' => 'center-center',
                ],
            ]
        );
        $this->add_control(
            'content-align',
            [
                'label' => __( 'Alignment', 'widgetkit-pro' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left'    => [
                        'title' => __( 'Left', 'widgetkit-pro' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'widgetkit-pro' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'widgetkit-pro' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .single-category-carousel-layout-3 .post-data' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'layout_style' => ['carousel-layout-3'],
                ],
            ]
        );
        $this->add_control(
            'dot-navigation-bottom-position',
            [
                'label' => __( 'Dot Navigation Bottom Position', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 300,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .single-category-carousel-layout-3 .owl-dots' => 'bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'layout_style' => ['carousel-layout-3'],
                ],
            ]
        );
        $this->add_control(
            'nav-dot-align',
            [
                'label' => __( 'Nav Dot Alignment', 'widgetkit-pro' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left'    => [
                        'title' => __( 'Left', 'widgetkit-pro' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'widgetkit-pro' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'condition' => [
                    'layout_style' => ['carousel-layout-3'],
                ],
            ]
        );
        $this->add_control(
            'post-min-height',
            [
                'label' => __( 'Post Min Height', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 500,
                ],
                'range' => [
                    'px' => [
                        'min' => 300,
                        'max' => 1500,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .single-category-carousel-layout-4 .cat-post-list .post-thumb-wrapper img' => 'min-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'layout_style' => ['carousel-layout-4'],
                ],
            ]
        );



        $this->end_controls_section();






        /**
         * Style tab
         * =============
         */
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        /**
         * section title
         */
        $this->add_control(
            'section_title',
            [
                'label' => __( 'Section Title', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Section Title', 'widgetkit-pro' ),
                'name' => 'section_title_typography',
                'selector' => '{{WRAPPER}} .layout-title h4',
            ]
        );
        /**
         * regular title
         */
        $this->add_control(
            'regular_title',
            [
                'label' => __( 'Regular Post Title', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Regular Post Title', 'widgetkit-pro' ),
                'name' => 'regular_post_title_typography',
                'selector' => '{{WRAPPER}} .regular-post .regular-post-title h3',

            ]
        );
        /**
         * content title
         */
        $this->add_control(
            'content_typography',
            [
                'label' => __( 'Content Typography', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Content Typography', 'widgetkit-pro' ),
                'name' => 'content__typography',
                'selector' => '{{WRAPPER}} .cat-post-list-wrapper .post-excerpt',

            ]
        );

        $this->end_controls_section();





        $this->start_controls_section(
            'section_padding',
            [
                'label' => __( 'Content Spacing', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_style' => ['carousel-layout-1', 'carousel-layout-3', 'carousel-layout-4'],
                ]
            ]
        );
        $this->add_control(
            'content_custom_padding_switcher',
            [
                'label' => __( 'Custom Padding', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Add custom padding for content',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
                'condition' => [
                    'layout_style' => ['carousel-layout-1', 'carousel-layout-3', 'carousel-layout-4'],
                ]
            ]
        );
        $this->add_control(
            'content_custom_padding_regular',
            [
                'label' => __( 'Regular Post Padding', 'widgetkit-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .regular-post-wrapper.vertical .post-data' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .regular-post-wrapper .post-data' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'content_custom_padding_switcher' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();








        $this->start_controls_section(
            'content_style',
            [
                'label' => __( 'Content', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'custom_color',
            [
                'label' => __( 'Custom Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Show custom color for content',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'section_title_color',
            [
                'label' => __( 'Section Title Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .layout-title h4' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .layout-header ' => 'border-color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'regular_bg_color',
            [
                'label' => __( 'Regular Background Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cat-post-list-wrapper .regular-post' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                    'layout_style' => ['carousel-layout-1', 'carousel-layout-3'],
                ],
            ]
        );

        $this->add_control(
            'regular_title_color',
            [
                'label' => __( 'Regular Title Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .regular-post-title h3' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'regular_meta_color',
            [
                'label' => __( 'Regular Meta Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .regular-post .post-meta div' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'regular_content_color',
            [
                'label' => __( 'Regular Content Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .regular-post  .post-excerpt' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'carousel_bg_color',
            [
                'label' => __( 'Carousel Background Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-category-carousel .owl-nav .owl-carousel-left' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .single-category-carousel .owl-nav .owl-carousel-right' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'carousel_icon_color',
            [
                'label' => __( 'Carousel Icon Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-category-carousel .owl-nav .owl-carousel-left' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .single-category-carousel .owl-nav .owl-carousel-right' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'carousel_hover_bg_color',
            [
                'label' => __( 'Carousel Hover Background Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-category-carousel .owl-nav .owl-carousel-left:hover' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .single-category-carousel .owl-nav .owl-carousel-right:hover' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'carousel_hover_icon_color',
            [
                'label' => __( 'Carousel Hover Icon Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-category-carousel .owl-nav .owl-carousel-left:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .single-category-carousel .owl-nav .owl-carousel-right:hover' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'enable_box_shadow',
            [
                'label' => __( 'Enable Box Shadow', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Enable Box Shadow',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'column_box_shadow',
            [
                'label' => __( 'Column Box Shadow', 'widgetkit-pro' ),
                'type' => Controls_Manager::BOX_SHADOW,
                'default' => [
                    'color' => 'rgba(0,0,0,.08)',
                ],
                'selectors' => [
                    '{{WRAPPER}} .single-category-carousel .regular-post-wrapper' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
                ],
                'condition' => [
                    'enable_box_shadow' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_gradient',
            [
                'label' => __( 'Gradient', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_style' => ['carousel-layout-2', 'carousel-layout-3', 'carousel-layout-4'],
                ],
            ]
        );
        $this->add_control(
            'overlay_style',
            [
                'label'       => __( 'Overlay Style', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'bg-overlay',
                'options' => [
                    'bg-overlay'  => __( 'Overlay', 'widgetkit-pro' ),
                    'bg-gradient'  => __( 'Gradient', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'background_overlay',
            [
                'label' => __( 'Background Overlay', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-category-carousel-layout-2 .regular-post .post-thumb a:after' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .single-category-carousel-layout-4 .regular-post .post-thumb a:after' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'overlay_style' => 'bg-overlay',
                ],
            ]
        );

        $this->add_control(
            'gradient_1',
            [
                'label' => __( 'Gradient 1', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-category-carousel-layout-2 .regular-post .post-thumb a:after' => 'background: linear-gradient(180deg, rgba(0, 0, 0, 0.01), {{VALUE}})',
                    '{{WRAPPER}} .single-category-carousel-layout-2 .regular-post:hover .post-thumb a:after' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .single-category-carousel-layout-4 .regular-post .post-thumb a:after' => 'background: linear-gradient(180deg, rgba(0, 0, 0, 0.01) 50%, {{VALUE}} 80%)',
                    '{{WRAPPER}} .single-category-carousel-layout-4 .regular-post:hover .post-thumb a:after' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'overlay_style' => 'bg-gradient',
                ],
            ]
        );
        $this->add_control(
            'highlight_tiles_text_shadow',
            [
                'label' => __( 'Tiles Title Text Shadow', 'widgetkit-pro' ),
                'type' => Controls_Manager::TEXT_SHADOW,
                'selectors' => [
                    '{{WRAPPER}} .single-category-carousel-layout-4 .regular-post .regular-title h3' => 'text-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{COLOR}};',
                ],
                'condition' => [
                    'overlay_style' => 'bg-gradient',
                ],
            ]
        );

        $this->end_controls_section();





        $this->start_controls_section(
            'section_navigation',
            [
                'label' => __( 'Navigation', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_style' => ['carousel-layout-3'],
                ],
            ]
        );
        $this->add_control(
            'nav_custom_color',
            [
                'label' => __( 'Nav Custom Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Show custom color for content',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'nav_dot_border_color',
            [
                'label' => __( 'Nav Dot Border Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-category-carousel-layout-3 .cat-post-list .owl-dots .owl-dot' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .single-category-carousel-layout-3 .cat-post-list .owl-dots .owl-dot.active' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'nav_custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'navigation_bg_color',
            [
                'label' => __( 'Navigation Background Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-category-carousel-layout-3 .cat-post-list .owl-dots' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'nav_custom_color' => 'yes',
                ],
            ]
        );





        $this->end_controls_section();


    }

    protected function render()
    {
        $settings = $this->get_settings();
        $layout = widgetkit_pro_array_get($settings, 'layout_style');
        $layout_header_enable = widgetkit_pro_array_get($settings, 'layout_header_enable');
        $layout_title = widgetkit_pro_array_get($settings, 'layout_title');

        $cat_id = widgetkit_pro_array_get($settings, 'cat_name');
        $thumbnail_size = widgetkit_pro_array_get($settings, 'thumbnail_size');
        $post_num_to_show = widgetkit_pro_array_get($settings, 'post_num_to_show');
        $show_excerpt = widgetkit_pro_array_get($settings, 'show_excerpt');
        $regular_excerpt_word_count = widgetkit_pro_array_get($settings, 'regular_excerpt_word_count');
        $excerpt_word_count = widgetkit_pro_array_get($settings, 'excerpt_word_count');
        $regular_post_column = widgetkit_pro_array_get($settings, 'regular_post_column');
        $regular_post_style = widgetkit_pro_array_get($settings, 'regular_post_style');
        $show_cat_tag = widgetkit_pro_array_get($settings, 'show_cat_tag');
        $column_gap = widgetkit_pro_array_get($settings, 'column_gap');
        $column_gap = $column_gap['size'];
        $navigation_position = widgetkit_pro_array_get($settings, 'navigation_position');
        $nav_dot_align = widgetkit_pro_array_get($settings, 'nav-dot-align');
        $id =  $this->get_id();
        /**
         * term meta value
         * ================
         */
        $tax_term = get_term_meta($cat_id);
        $tax_image = widgetkit_pro_array_get($tax_term, 'magmax_tax_image')[0];
        $tax_tag_bg_color = widgetkit_pro_array_get($tax_term, 'magmax_tax_tag_bg_color')[0];
        /**
         * Gradient
         * =========
         */
        $overlay_style = widgetkit_pro_array_get($settings, 'overlay_style');
        $bg_overlay = widgetkit_pro_array_get($settings, 'background_overlay');
        $gradient_1 = widgetkit_pro_array_get($settings, 'gradient_1');
        $gradient_2 = widgetkit_pro_array_get($settings, 'gradient_2');
    ?>
    <?php
        include( plugin_dir_path( __FILE__ ) . '../layout/carousel/'.$layout.'.php');
        ?>
    <?php
    }
    protected function _content_template()
    {
    }
}
