<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Background;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo Course Categeries
 *
 * @since 1.0.0
 */
class Widgetkit_Pro_Sensei_Course_Category extends Widget_Base {

	public function get_name() {
		return 'widgetkit-pro-sensei-course-category';
	}

	public function get_title() {
		return __( 'Sensei Categories', 'widgetkit-pro' );
	}

	public function get_icon() {
		return 'eicon-post-content';
	}

	public function get_categories() {
		return [ 'widgetkit_pro' ];
    }

    /**
	 * A list of style that the widgets is depended in
	 **/
	public function get_style_depends() {
        return [
            'widgetkit_pro_base',
            'widgetkit_pro_default',
            // 'owl-css',
        ];
    }
	/**
	 * A list of scripts that the widgets is depended in
	 **/
	public function get_script_depends() {
		return [ 
			// 'magnific-js',
            // 'owl-carousel',
            // 'wkp-learnpress',
        ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function _register_controls() {

        $cat = array();
        $terms = get_terms( array(
            'post_type' => 'course',
            'taxonomy' => 'course-category',
            'hide_empty' => false,
            'fields'   => 'id=>name'
        ) );
        foreach ($terms as $key => $value) {
            if(gettype($key) == 'integer'):
                $cat[$key] = ucwords($value);
            endif;
        }

#   region Query config        
        /**
         * Query
         */
		$this->start_controls_section(
			'section_query',
			[
				'label' => __( 'Query', 'widgetkit-pro' ),
			]
		);
            $this->add_control(
                'sensei_course_category_id',
                [
                    'label'       => __( 'Select Category', 'widgetkit-pro' ),
                    'type'        => Controls_Manager::SELECT,
                    'default'     => '',
                    'options' => $cat,
                ]
            );
            $this->add_control(
                'show_hide_sensei_categories_courses',
                [
                    'label' => __( 'Course Count', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
        $this->end_controls_section();
#   endregion        


#   region Icon config        
        /**
         * Query
         */
		$this->start_controls_section(
			'section_icon',
			[
				'label' => __( 'Icon', 'widgetkit-pro' ),
			]
		);
            $this->add_control(
                'sensei_category_add_icon',
                [
                    'label' => __( 'Add Icon', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'label_on' => __( 'Yes', 'widgetkit-pro' ),
                    'label_off' => __( 'No', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'sensei_category_icon',
                [
                    'label' => esc_html__( 'Choose', 'widgetkit-for-elementor' ),
                    'type'              => Controls_Manager::ICONS,
                    'default'    =>  [
                        'value'     => 'fas fa-book-open',
                        'library'   => 'fa-solid',
                    ],
                    'label_block'   => true,
                    'condition' => [
                        'sensei_category_add_icon' => 'yes'
                    ],
                ]
            );
        $this->end_controls_section();
#   endregion        


#   region image config        
        /**
         * Image
         */
        $this->start_controls_section(
            'section_image',
			[
                'label' => __( 'Image', 'widgetkit-pro' ),
            ]
        );
            $this->add_control(
                'image',
                [
                    'label' => __( 'Choose Image', 'widgetkit-pro' ),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'image', // Actually its `image_size`.
                    'label' => __( 'Image Size', 'widgetkit-pro' ),
                    'default' => 'large',
                ]
            );
            $this->add_responsive_control(
                'image_fixed_height',
                [
                    'label' => __( 'Height', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 900,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .sensei-course-categories img' => 'height: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .sensei-course-categories' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();
#   endregion            




#   region category style tab 
        $this->start_controls_section(
            'title_section_style',
                [
                    'label' => __( 'Category', 'widgetkit-pro' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );
            $this->add_control(
                'section_category_title',
                [
                'label' => __( 'Name', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                // 'separator' => 'before',
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                    [   
                        'label' => __( 'Typography', 'widgetkit-pro' ),
                        'name' => 'category_typography',
                        'selector' => '{{WRAPPER}} .sensei-course-categories .content-body .sensei-course-meta a .sensei-categories',
                        'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                    ]
            );
            $this->add_control(
                'category_color',
                [
                    'label'     => __( 'Color', 'widgetkit-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .sensei-course-categories .content-body .sensei-course-meta a .sensei-categories' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_control(
                'section_course_count',
                [
                    'label' => __( 'Course', 'widgetkit-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'show_hide_sensei_categories_courses' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                    [   
                        'label' => __( 'Typography', 'widgetkit-pro' ),
                        'name' => 'category_course_typography',
                        'selector' => '{{WRAPPER}} .sensei-course-categories .content-body .sensei-course-meta .sensei-course span',
                        'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                        'condition' => [
                            'show_hide_sensei_categories_courses' => 'yes'
                        ]
                    ]
            );
            $this->add_control(
                'category_course_color',
                [
                    'label'     => __( 'Color', 'widgetkit-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .sensei-course-categories .content-body .sensei-course-meta .sensei-course span' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                        'show_hide_sensei_categories_courses' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'category_course_spacing_top',
                [
                    'label'   => esc_html__( 'Top Spacing', 'widgetkit-pro' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'size' =>15,
                    ],
                    'range'  => [
                        'px' => [
                            'min' => -20,
                            'max' => 200,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .sensei-course-categories .content-body .sensei-course-meta .sensei-course' => 'margin-top: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_hide_sensei_categories_courses' => 'yes',
                    ],
                ]
            );
        $this->end_controls_section();
#   endregion    

// #region icon style

        /**
         * Icon
         */
        $this->start_controls_section(
            'section_style_icon',
            [
                'label' => __( 'Icon', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'sensei_category_add_icon' => 'yes'
                ]
            ]
        );
        
            $this->start_controls_tabs('cat_icon_style');
                /**
                 * Normal
                 */
                $this->start_controls_tab(
                    'cat_icon_style_normal',
                    [
                        'label' => __( 'Normal', 'widgetkit-pro' ),
                    ]
                );
                $this->add_control(
                    'cat_icon_color',
                    [
                        'label' => __( 'Color', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#EEB90E',
                        'selectors' => [
                            '{{WRAPPER}} .sensei-course-categories .sensei-course-meta .cat-icon i' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .sensei-course-categories .sensei-course-meta .cat-icon svg' => 'color: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'cat_icon_bg_color',
                    [
                        'label' => __( 'Background', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#fff',
                        'selectors' => [
                            '{{WRAPPER}} .sensei-course-categories .sensei-course-meta .cat-icon' => 'background: {{VALUE}}',
                            '{{WRAPPER}} .sensei-course-categories .sensei-course-meta .cat-icon' => 'background: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'cat_icon_hr',
                    [
                        'type' => \Elementor\Controls_Manager::DIVIDER,
                    ]
                );
                $this->add_group_control(
                    Group_Control_Border::get_type(), 
                    [
                        'name'          => 'cat_icon_border',
                        'selector'      => '{{WRAPPER}} .sensei-course-categories .sensei-course-meta .cat-icon',
                    ]
                );
                $this->add_control(
                    'cat_icon_border_radius',
                    [
                        'label'   => esc_html__( 'Border Radius', 'widgetkit-for-elementor' ),
                        'type'    => Controls_Manager::SLIDER,
                        'default' => [
                            'size' =>50,
                        ],
                        'range'  => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .sensei-course-categories .sensei-course-meta .cat-icon' => 'border-radius: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->end_controls_tab();
                /**
                 * hover
                 */
                $this->start_controls_tab(
                    'cat_icon_style_hover',
                    [
                        'label' => __( 'Hover', 'widgetkit-pro' ),
                    ]
                );
                $this->add_control(
                    'cat_icon_color_hover',
                    [
                        'label' => __( 'Color', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '',
                        'selectors' => [
                            '{{WRAPPER}} .sensei-course-categories .sensei-course-meta .cat-icon:hover' => 'color: {{VALUE}} ',
                        ],
                    ]
                );
                $this->add_control(
                    'cat_icon_bg_color_hover',
                    [
                        'label' => __( 'Background', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '',
                        'selectors' => [
                            '{{WRAPPER}} .sensei-course-categories .sensei-course-meta .cat-icon:hover' => 'background: {{VALUE}}',
                            
                        ],
                    ]
                );
                $this->add_control(
                    'cat_icon_border_color_hover',
                    [
                        'label' => __( 'Border', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .sensei-course-categories .sensei-course-meta .cat-icon:hover' => 'border-color: {{VALUE}}',
                            
                        ],
                    ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();

            $this->add_control(
                'cat_icon_font_size',
                [
                    'label'   => esc_html__( 'Icon Size', 'widgetkit-for-elementor' ),
                    'type'    => Controls_Manager::SLIDER,
                    'range'  => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                        ],
                    ],
                    'separator'     => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .sensei-course-categories .sensei-course-meta .cat-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .sensei-course-categories .sensei-course-meta .cat-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'cat_icon_padding',
                [
                    'label'         => __('Padding', 'widgetkit-pro'),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => ['px'],
                    'default' => [
                        'top' => '15',
                        'right' => '15',
                        'bottom' => '15',
                        'left' => '15',
                        'unit' => 'px',
                        'isLinked' => false,
                    ],
                    'selectors'     => [
                        '{{WRAPPER}} .sensei-course-categories .sensei-course-meta .cat-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};', 
                    ],
                ]
            );
            $this->add_responsive_control(
                'cat_icon_margin',
                [
                    'label'         => __('Margin', 'widgetkit-pro'),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => ['px'],
                    'default' => [
                        'top' => '',
                        'right' => '',
                        'bottom' => '15',
                        'left' => '',
                        'unit' => 'px',
                        'isLinked' => false,
                    ],
                    'selectors'     => [
                        '{{WRAPPER}} .sensei-course-categories .sensei-course-meta .cat-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};', 
                    ],
                ]
            );
        $this->end_controls_section();

// #endregion 

#   region image style tab
        /**
         * image style
         */
        $this->start_controls_section(
            'image_section_style',
            [
                'label' => __( 'Image', 'widgetkit-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'sensei_catogories_bg_color',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .sensei-course-categories:before',
                ]
            );
        $this->end_controls_section();
#   endregion

	}


	/**
	 * Render image widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @access protected
	 */
	protected function render() {
        $settings = $this->get_settings();
        ?>
		<div id="sensei-course-category-<?php echo $this->get_id(); ?>" class="sensei-course-category-element sensei-course-category-<?php echo $this->get_id(); ?>">
            <?php include( plugin_dir_path( __FILE__ ) . '../layout/sensei-course-category.php'); ?>
        </div>
        <?php 
    }
    
    protected function _content_template()
    {
    }

}
