<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;

if (!defined('ABSPATH')) exit; // Exit if accessed directly
if(!function_exists('widgetkit_pro_array_get')) {
    function widgetkit_pro_array_get($array, $key, $default=null){
        if(!is_array($array)) return $default;
        return array_key_exists($key, $array) ? $array[$key] : $default;
    }
}

/**
 * magmax Layout
 * =============
 */
class Widgetkit_Pro_Recent_Post_Carousel extends Widget_Base
{

    public function get_name()
    {
        return 'magmax-recent-post-carousel';
    }

    public function get_title()
    {
        return __('Recent Post Carousel', 'widgetkit-pro');
    }

    public function get_icon()
    {
        return 'eicon-posts-carousel';
    }

    public function get_categories()
    {
        return ['widgetkit_pro'];
    }

    /**
     * A list of scripts that the widgets is depended in
     *
     * @since 1.3.0
     **/

//    public function get_script_depends() {
//        return [ 'magmax_test' ];
//    }


    protected function _register_controls()
    {


        /* slides content title subtitle button and button link */
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Layout', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'layout_header_enable',
            [
                'label' => __( 'Layout_Single Header', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Layout_Single header disable or enable',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'layout_title',
            [
                'label'       => __( 'Title', 'widgetkit-pro' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Recent Post', 'widgetkit-pro' ),
                'placeholder' => __( 'Type your layout title text here', 'widgetkit-pro' ),
                'condition' => [
                    'layout_header_enable' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'layout_style',
            [
                'label'       => __( 'Layout Style', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'layout-1',
                'options' => [
                    'layout-1'  => __( 'Layout 1', 'widgetkit-pro' ),
                    'layout-2'  => __( 'Layout 2', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'query_post_type',
            [
                'label'       => __( 'Query Post Type', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'recent',
                'options' => [
                    'recent'  => __( 'Recent Post', 'widgetkit-pro' ),
                    'popular'  => __( 'Popular Post', 'widgetkit-pro' ),
                    'featured'  => __( 'Featured Post', 'widgetkit-pro' ),
                    'trending'  => __( 'Trending Post', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'post_column',
            [
                'label'   => __( 'Post Column', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 4,
                'min'     => 3,
                'max'     => 6,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'post_num_to_show',
            [
                'label'   => __( 'Number of Post to Show', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 4,
                'min'     => 3,
                'max'     => 20,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'cat_switcher',
            [
                'label' => __( 'Show Category', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Custom padding option not for image',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );


        $this->end_controls_section();

        /**
         * Style tab
         * =============
         */
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Section Title', 'widgetkit-pro' ),
                'name' => 'section_title_typography',
                'selector' => '{{WRAPPER}} .layout-title h4',
            ]
        );
        /**
         * regular title
         */
        $this->add_control(
            'regular_title',
            [
                'label' => __( 'Regular Post Title', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Regular Post Title', 'widgetkit-pro' ),
                'name' => 'regular_post_title_typography',
                'selector' => '{{WRAPPER}} .regular-post .post-title h3',

            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'content_style',
            [
                'label' => __( 'Content', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        /**
         * Custom Padding
         */
        $this->add_control(
            'content_padding_switcher',
            [
                'label' => __( 'Content Padding', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Custom padding option not for image',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'content_custom_padding',
            [
                'label' => __( 'Padding', 'widgetkit-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .regular-post .post-data' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'content_padding_switcher' => 'yes',
                ],
            ]
        );
        /**
         * box shadow
         */
        $this->add_control(
            'enable_post_box_shadow',
            [
                'label' => __( 'Enable Post Box Shadow', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Enable Box Shadow',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'post_box_shadow',
            [
                'label' => __( 'Box Shadow Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::BOX_SHADOW,
                'default' => [
                    'color' => 'rgba(0,0,0,.08)',
                ],
                'selectors' => [
                    '{{WRAPPER}} .cat-post-list-wrapper .regular-post' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
                ],
                'condition' => [
                    'enable_post_box_shadow' => 'yes',
                ],
            ]
        );
        /**
         * Custom Color
         */
        $this->add_control(
            'custom_color',
            [
                'label' => __( 'Custom Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Show custom color for content',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'section_title_color',
            [
                'label' => __( 'Section Title Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .layout-title h4' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'regular_title_color',
            [
                'label' => __( 'Regular Title Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .regular-post .post-title h3' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'regular_meta_color',
            [
                'label' => __( 'Regular Meta Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .regular-post .post-meta span' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'regular_post_bg_color',
            [
                'label' => __( 'Regular Post Background Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .regular-post' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        /**
         * carousel color
         */
        $this->add_control(
            'carousel_nav_bg_color',
            [
                'label' => __( 'Carousel Nav Background Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-carousel .owl-carousel-left, {{WRAPPER}} .post-carousel .owl-carousel-right' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'carousel_nav_hover_bg_color',
            [
                'label' => __( 'Carousel Nav Hover Background Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-carousel .owl-carousel-left:hover, {{WRAPPER}} .post-carousel .owl-carousel-right:hover' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'carousel_nav_icon_color',
            [
                'label' => __( 'Carousel Nave Icon Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-carousel .owl-carousel-left, {{WRAPPER}} .post-carousel .owl-carousel-right' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'carousel_nav_hover_icon_color',
            [
                'label' => __( 'Carousel Nav Hover Icon Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-carousel .owl-carousel-left:hover, {{WRAPPER}} .post-carousel .owl-carousel-right:hover' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        $layout = widgetkit_pro_array_get($settings, 'layout_style');
        $layout_header_enable = widgetkit_pro_array_get($settings, 'layout_header_enable');
        $layout_title = widgetkit_pro_array_get($settings, 'layout_title');

        $query_post_type = widgetkit_pro_array_get($settings, 'query_post_type');
        $post_column = widgetkit_pro_array_get($settings, 'post_column');
        $post_column_gap = widgetkit_pro_array_get($settings, 'post_column_gap');
        $post_num_to_show = widgetkit_pro_array_get($settings, 'post_num_to_show');
        $regular_post_style = widgetkit_pro_array_get($settings, 'regular_post_style');
        $show_cat_tag = widgetkit_pro_array_get($settings, 'cat_switcher');

    ?>
    <?php
        include( plugin_dir_path( __FILE__ ) . '../layout/recent-post-carousel.php');

        ?>

    <?php
    }
    protected function _content_template()
    {
    }
}
