<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Utils;

if (!defined('ABSPATH')) exit; // Exit if accessed directly
if(!function_exists('widgetkit_pro_array_get')) {
    function widgetkit_pro_array_get($array, $key, $default=null){
        if(!is_array($array)) return $default;
        return array_key_exists($key, $array) ? $array[$key] : $default;
    }
}

/**
 * magmax Layout
 * =============
 */
class Widgetkit_Pro_Posts_With_Load_More_Button extends Widget_Base
{

    public function get_name()
    {
        return 'magmax-posts-with-load-more-button';
    }

    public function get_title()
    {
        return __('Posts with Load More Button', 'widgetkit-pro');
    }

    public function get_icon()
    {
        return 'eicon-dual-button';
    }

    public function get_categories()
    {
        return ['widgetkit_pro'];
    }

    /**
     * A list of scripts that the widgets is depended in
     *
     * @since 1.3.0
     **/
    /*
        public function get_script_depends() {
            return [ 'imagesloaded' ];
        }
    */

    protected function _register_controls()
    {

        /* slides content title subtitle button and button link */
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Layout', 'widgetkit-pro'),
                'class' => __('Load More layout', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'single_layout_header_enable',
            [
                'label' => __( 'Layout Header', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Layout header disable or enable',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'single_layout_title',
            [
                'label'       => __( 'Title', 'widgetkit-pro' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Layout title text', 'widgetkit-pro' ),
                'placeholder' => __( 'Type your layout title text here', 'widgetkit-pro' ),
                'condition' => [
                    'single_layout_header_enable' => 'yes',
                ]
            ]
        );


        $this->add_control(
            'post_num_to_show',
            [
                'label'   => __( 'Number of Post to Show', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 5,
                'min'     => -1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'regular_thumbnail_size',
            [
                'label'       => __( 'Thumbnail Size', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'large',
                'options' => [
                    'medium'  => __( 'Medium', 'widgetkit-pro' ),
                    'medium_large'  => __( 'Medium Large', 'widgetkit-pro' ),
                    'large'  => __( 'Large', 'widgetkit-pro' ),
                    'full'  => __( 'Full', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'regular_post_style',
            [
                'label'       => __( 'Regular Post Grid', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'horizontal',
                'options' => [
                    'vertical'  => __( 'Vertical', 'widgetkit-pro' ),
                    'horizontal'  => __( 'Horizontal', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->add_control(
            'regular_post_grid',
            [
                'label'       => __( 'Regular Post Grid', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1'  => __( '1', 'widgetkit-pro' ),
                    '2'  => __( '2', 'widgetkit-pro' ),
                    '3'  => __( '3', 'widgetkit-pro' ),
                    '4'  => __( '4', 'widgetkit-pro' ),
                ],
                'condition' => [
                    'regular_post_style' => 'vertical',
                ]
            ]
        );
        $this->add_control(
            'single_post_link',
            [
                'label' => __( 'Show Full Article Link', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'description' => 'Show sinlge page article link',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'post_navigation_style',
            [
                'label'       => __( 'Post Navigation Style', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'load-more-button',
                'options' => [
                    'load-more-button'  => __( 'Load More Button', 'widgetkit-pro' ),
                    'pagination'  => __( 'Pagination', 'widgetkit-pro' ),
                ],
            ]
        );


        $this->end_controls_section();


        /**
         * Style tab
         * =============
         */
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'section_title',
            [
                'label' => __( 'Section Title', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Section Title', 'widgetkit-pro' ),
                'name' => 'section_title_typography',
                'selector' => '{{WRAPPER}} .load-more-posts-layout .layout-title h4',
            ]
        );
        $this->add_control(
            'regular_title',
            [
                'label' => __( 'Regular Post Title', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Regular Post Title', 'widgetkit-pro' ),
                'name' => 'regular_post_title_typography',
                'selector' => '{{WRAPPER}} .regular-post .regular-post-title h3',
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'content_style',
            [
                'label' => __( 'Content', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'custom_color',
            [
                'label' => __( 'Custom Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'description' => 'Show custom color for content',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Title Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .highlight-post-title h3, .regular-post-title h3' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'meta_color',
            [
                'label' => __( 'Meta Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-author, .post-date' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label' => __( 'Content Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cat-post-list .post-excerpt' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'custom_color' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings();
        $layout_header_enable = widgetkit_pro_array_get($settings, 'single_layout_header_enable');
        $layout_title = widgetkit_pro_array_get($settings, 'single_layout_title');
        $cat_id = widgetkit_pro_array_get($settings, 'cat_single_id');
        $regular_thumbnail_size = widgetkit_pro_array_get($settings, 'regular_thumbnail_size');
        $post_num_to_show = widgetkit_pro_array_get($settings, 'post_num_to_show');
        $highlight_first_post = widgetkit_pro_array_get($settings, 'highlight_first_post');
        $show_highlight_cat_tag = widgetkit_pro_array_get($settings, 'show_highlight_cat_tag');
        $show_cat_tag = widgetkit_pro_array_get($settings, 'show_cat_tag');
        $single_post_link = widgetkit_pro_array_get($settings, 'single_post_link');
        $tax_term = get_term_meta($cat_id);
        $tax_tag_bg_color = widgetkit_pro_array_get($tax_term, 'magmax_tax_tag_bg_color')[0];
        $regular_post_style = widgetkit_pro_array_get($settings, 'regular_post_style');
        $regular_post_grid = widgetkit_pro_array_get($settings, 'regular_post_grid');
        $post_navigation_style = widgetkit_pro_array_get($settings, 'post_navigation_style');

    ?>

        <div id="posts-with-load-more-button" class="posts-with-load-more-button">
            <?php include( plugin_dir_path( __FILE__ ) . '../layout/posts-with-load-more-button.php'); ?>
        </div>
    <?php
    }
    protected function _content_template()
    {
    }
}
