<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
// use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;

if (!defined('ABSPATH')) exit; // Exit if accessed directly
if(!function_exists('widgetkit_pro_array_get')) {
    function widgetkit_pro_array_get($array, $key, $default=null){
        if(!is_array($array)) return $default;
        return array_key_exists($key, $array) ? $array[$key] : $default;
    }
}

/**
 * magmax Layout
 * =============
 */
class Widgetkit_Pro_News_Ticker extends Widget_Base
{

    public function get_name()
    {
        return 'magmax-news-ticker';
    }

    public function get_title()
    {
        return __('News Ticker', 'widgetkit-pro');
    }

    public function get_icon()
    {
        return 'eicon-post-content';
    }

    public function get_categories()
    {
        return ['widgetkit_pro'];
    }

    /**
     * A list of scripts that the widgets is depended in
     *
     * @since 1.3.0
     **/
    /*
        public function get_script_depends() {
            return [ 'imagesloaded' ];
        }
    */

    protected function _register_controls()
    {

        /* slides content title subtitle button and button link */
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Layout', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'news_ticker_title',
            [
                'label'       => __( 'Title', 'widgetkit-pro' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'News Ticker', 'widgetkit-pro' ),
                'placeholder' => __( 'Type your layout title text here', 'widgetkit-pro' ),
            ]
        );

        $this->add_control(
            'layout_style',
            [
                'label'       => __( 'Style', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'layout-1',
                'options' => [
                    'layout-1'  => __( 'Layout 1', 'widgetkit-pro' ),
                ],
            ]
        );

        $this->add_control(
            'post_num_to_show',
            [
                'label'   => __( 'Post to Show', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 5,
                'min'     => 1,
                'max'     => 30,
                'step'    => 1,
            ]
        );


        $this->end_controls_section();



        $this->start_controls_section(
            'section_animation',
            [
                'label' => __( 'Animation', 'widgetkit-pro' ),
            ]
        );

        $this->add_control(
            'ticker_effect',
            [
                'label'       => __( 'Effect', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'default',
                'options' => [
                    'default'  => __( 'Default', 'widgetkit-pro' ),
                    'animate'  => __( 'Animate', 'widgetkit-pro' ),
                ],
            ]
        );

        $this->add_control(
            'animation_in_style',
            [
                'label'       => __( 'In', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'false',
                'options' => [
                    'false'  => __( 'Default', 'widgetkit-pro' ),
                    'fadeIn'  => __( 'Fade In', 'widgetkit-pro' ),
                    'fadeInDown'  => __( 'Fade In Down', 'widgetkit-pro' ),
                    'slideInLeft'  => __( 'Slide In Left', 'widgetkit-pro' ),
                    'slideInRight'  => __( 'Slide In Right', 'widgetkit-pro' ),
                    'slideInUp'  => __( 'Slide In Up', 'widgetkit-pro' ),
                    'slideInDown'  => __( 'Slide In Down', 'widgetkit-pro' ),
                    'zoomIn'  => __( 'Zoom In', 'widgetkit-pro' ),
                    'flipInX'  => __( 'Flip In', 'widgetkit-pro' ),
                ],
                 'condition' => [
                    'ticker_effect' => 'animate',
                ],
            ]
        );

        $this->add_control(
            'animation_out_style',
            [
                'label'       => __( 'Out', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'false',
                'options' => [
                    'false'  => __( 'Default', 'widgetkit-pro' ),
                    'fadeOut'  => __( 'Fade Out', 'widgetkit-pro' ),
                    'fadeOutDown'  => __( 'Fade Out Down', 'widgetkit-pro' ),
                    'slideOutLeft'  => __( 'Slide Out Left', 'widgetkit-pro' ),
                    'slideOutRight'  => __( 'Slide Out Right', 'widgetkit-pro' ),
                    'slideOutUp'  => __( 'Slide Out Up', 'widgetkit-pro' ),
                    'slideOutDown'  => __( 'Slide Out Down', 'widgetkit-pro' ),
                    'zoomOut'  => __( 'Zoom Out', 'widgetkit-pro' ),
                    'flipOutX'  => __( 'Flip Out', 'widgetkit-pro' ),
                ],
                 'condition' => [
                    'ticker_effect' => 'animate',
                ],
            ]
        );


        $this->end_controls_section();

        /**
         * Style tab
         * =============
         */
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Ticker', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'news_ticker_title_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .magmax-news-ticker-1  .ticker-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'name' => 'news_title_typography',
                'selector' => '{{WRAPPER}} .magmax-news-ticker-1  .ticker-title',
            ]
        );

        $this->add_control(
            'news_ticker_bg_color',
            [
                'label' => __( 'Bg Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .magmax-news-ticker-1  .ticker-title' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_heading',
            [
                'label' => esc_html__( 'Arrow', 'widgetkit-pro' ),
                'type'  => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'news_ticker_arrow_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .magmax-news-ticker .magmax-news-ticker-1 .ticker-title:before' => 'border-right-color: {{VALUE}}; border-bottom-color:{{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'border_heading',
            [
                'label' => esc_html__( 'Border', 'widgetkit-pro' ),
                'type'  => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'news_ticker_border_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .magmax-news-ticker-1  .ticker-title' => 'border-right: 2px solid {{VALUE}}',
                ],
            ]
        );



        $this->end_controls_section();


        $this->start_controls_section(
            'content_style',
            [
                'label' => __( 'Content', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'regular_title_color',
            [
                'label' => __( 'Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .magmax-news-post-ticker-wrapper .ticker-post-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Typography', 'widgetkit-pro' ),
                'name' => 'news_ticker_post_title_typography',
                'selector' => '{{WRAPPER}} .magmax-news-post-ticker-wrapper .ticker-post-title',
            ]
        );
        $this->add_control(
            'news_ticker_content_bg_color',
            [
                'label' => __( 'Background Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .magmax-news-ticker' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'news_ticker_content_space',
            [
                'label' => esc_html__( 'Padding', 'widgetkit-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .magmax-news-ticker' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_control(
            'news_ticker_content_autoplay',
            [
                'label'   => __( 'Auto Play Time Out', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 3000,
                'min'     => 1000,
                'max'     => 5000,
                'step'    =>50,
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'section_nav_style',
            [
                'label' => esc_html__( 'Nav', 'widgetkit-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'news_ticker_nav_enable',
            [
                'label'     => esc_html__( 'Enable/Disable', 'widgetkit-pro' ),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'yes',
                'yes'    => esc_html__( 'True', 'widgetkit-pro' ),
                'no'     => esc_html__( 'False', 'widgetkit-pro' ),
            ]
        );


        $this->add_control(
            'news_ticker_nav_icon_color',
            [
                'label'     => esc_html__( 'Icon Color', 'widgetkit-pro' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .magmax-news-post-ticker-wrapper .owl-carousel-left, 
                     {{WRAPPER}} .magmax-news-post-ticker-wrapper .owl-carousel-right' => 'color:{{VALUE}};',
                ],
                'condition' => [
                    'news_ticker_nav_enable' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'news_ticker_nav_icon_bg_color',
            [
                'label'     => esc_html__( 'Icon Bg Color', 'widgetkit-pro' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .magmax-news-ticker .magmax-news-post-ticker-wrapper .owl-nav .owl-carousel-left, 
                     {{WRAPPER}} .magmax-news-ticker .magmax-news-post-ticker-wrapper .owl-nav .owl-carousel-right' => 'background:{{VALUE}};',
                ],
                'condition' => [
                    'news_ticker_nav_enable' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'news_ticker_nav_icon_hover_color',
            [
                'label'     => esc_html__( 'Hover Color', 'widgetkit-pro' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .magmax-news-post-ticker-wrapper .owl-carousel-left:hover i, 
                    {{WRAPPER}} .magmax-news-post-ticker-wrapper .owl-carousel-right:hover i' => 'color: {{VALUE}};',

                ],
                'condition' => [
                    'news_ticker_nav_enable' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'news_ticker_nav_icon_hover_bg_color',
            [
                'label'     => esc_html__( 'Hover Background Color', 'widgetkit-pro' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .magmax-news-post-ticker-wrapper .owl-carousel-left:hover, 
                    {{WRAPPER}} .magmax-news-post-ticker-wrapper .owl-carousel-right:hover' => 'background: {{VALUE}} !important; border-color:{{VALUE}} !important;',
                ],
                'condition' => [
                    'news_ticker_nav_enable' => 'yes',
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'  => 'news_ticker_nav_border',
                'label' => esc_html__( 'Border', 'widgetkit-pro' ),
                'placeholder' => '1px',
                'default'     => '1px',
                'selector'    => 
                '{{WRAPPER}} .magmax-news-ticker .magmax-news-post-ticker-wrapper .owl-nav .owl-carousel-left, 
                {{WRAPPER}} .magmax-news-ticker .magmax-news-post-ticker-wrapper .owl-nav .owl-carousel-right',
                'separator' => 'before',
                'condition' => [
                    'news_ticker_nav_enable' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'news_ticker_nav_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'widgetkit-pro' ),
                'type'  => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .magmax-news-ticker .magmax-news-post-ticker-wrapper .owl-nav .owl-carousel-left' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .magmax-news-ticker .magmax-news-post-ticker-wrapper .owl-nav .owl-carousel-right' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'news_ticker_nav_enable' => 'yes',
                ],
            ]
        );


    $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings();
        $layout_title = widgetkit_pro_array_get($settings, 'news_ticker_title');
        $layout = widgetkit_pro_array_get($settings, 'layout_style');
        $post_num_to_show = widgetkit_pro_array_get($settings, 'post_num_to_show');

        /**
         * Include layout
         */
        include( plugin_dir_path( __FILE__ ) . '../layout/news-ticker/'.$layout.'.php');

    }
    protected function _content_template()
    {
    }
}
