<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Utils;
use Elementor\Group_Control_Box_Shadow;

if (!defined('ABSPATH')) exit; 

class Widgetkit_Pro_LP_Course_Tab extends Widget_Base
{

    public function get_name()
    {
        return 'widgetkit-pro-lp-course-tab';
    }

    public function get_title()
    {
        return __('LearnPress Course Tab', 'widgetkit-pro');
    }

    public function get_icon()
    {
        return 'eicon-post-content';
    }

    public function get_categories()
    {
        return ['widgetkit_pro'];
    }

    /**
	 * A list of style that the widgets is depended in
	 **/
	public function get_style_depends() {
        return [
            'widgetkit_pro_base',
            'widgetkit_pro_default',
            'owl-css',
        ];
    }
	/**
	 * A list of scripts that the widgets is depended in
	 **/
	public function get_script_depends() {
		return [ 
			'magnific-js',
            'owl-carousel',
            'wkp-learnpress',
        ];
	}

    protected function _register_controls()
    {
        $terms = get_terms( array(
            'post_type' => 'lp_course',
            'taxonomy' => 'course_category',
            'hide_empty' => false,
        ) );
        $cat_names = array();
        
        if(class_exists('LearnPress')): 
            foreach( $terms as $t ):
                $cat_names[$t->slug] = $t->name;
            endforeach;
        endif;

        /**
         * Query
         */
		$this->start_controls_section(
			'section_query',
			[
				'label' => __( 'Query', 'widgetkit-pro' ),
			]
        );
            $this->add_control(
                'cat_dynamic_multiple_id',
                [
                    'label' => __( 'Category', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SELECT2,
                    'options' => $cat_names,
                    'multiple' => true,
                ]
            );
            
            $this->add_control(
                'post_num_to_show',
                [
                    'label'   => __( 'Course to Show', 'widgetkit-pro' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 5,
                    'min'     => -1,
                    'max'     => 100,
                    'step'    => 1,
                ]
            );
        $this->end_controls_section();
        /**
         * Layout
         */
        $this->start_controls_section(
			'section_layout',
			[
				'label' => __( 'Layout', 'widgetkit-pro' ),
			]
        );
            $this->add_control(
                'lp_course_tab_style',
                [
                    'label'     => esc_html__( 'Style', 'widgetkit-pro' ),
                    'type'      => Controls_Manager::SELECT,
                    'default'   => 'style_1',
                    'options'   => [
                        'style_1'   => esc_html__( 'Screen 1', 'widgetkit-pro' ),
                        'style_2'   => esc_html__( 'Screen 2', 'widgetkit-pro' ),
                    ],

                ]
            );
            $this->add_control(
                'posts_column',
                [
                    'label' => __('Column', 'widgetkit-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '4',
                    'options' => [
                        '2' => __('6 Column', 'widgetkit-pro'),
                        '3' => __('4 Column', 'widgetkit-pro'),
                        '4' => __('3 Column', 'widgetkit-pro'),
                        '6' => __('2 Column', 'widgetkit-pro'),
                        '12' => __('1 Column', 'widgetkit-pro'),
                    ],
                ]
            );
            $this->add_control(
                'course_thumbnail_size',
                [
                    'label'       => __( 'Image Size', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'large',
                    'options' => [
                        'medium'  => __( 'Medium', 'widgetkit-pro' ),
                        'medium_large'  => __( 'Medium Large', 'widgetkit-pro' ),
                        'large'  => __( 'Large', 'widgetkit-pro' ),
                        'full'  => __( 'Full', 'widgetkit-pro' ),
                    ],
                ]
            );
            $this->add_control(
                'hide_tab_menu',
                [
                    'label' => __( 'Hide Tab Menu', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
        $this->end_controls_section();
        /**
         * title and description
         */
        $this->start_controls_section(
			'section_title_description',
			[
				'label' => __( 'Title & Description', 'widgetkit-pro' ),
			]
        );
            $this->add_control(
                'show_course_description',
                [
                    'label' => __( 'Description', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'description_word_count',
                [
                    'label' => __('Word Count', 'widgetkit-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 15,
                    'min' => -1,
                    'max' => 150,
                    'step' => 1,
                    'condition' => [
                        'show_course_description' => 'yes',
                    ],
                ]
            );
        $this->end_controls_section();
        /**
         * Meta
         */
        $this->start_controls_section(
			'section_meta',
			[
				'label' => __( 'Meta', 'widgetkit-pro' ),
			]
        );
            $this->add_control(
                'lp_course_author',
                [
                    'label' => __( 'Instructor', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                    'condition' => [
                        'lp_course_tab_style' => 'style_2'
                    ]
                ]
            );
            $this->add_control(
                'lp_course_rating',
                [
                    'label' => __( 'Rating', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                    // 'condition' => [
                    //     'lp_course_tab_style' => 'style_2'
                    // ]
                ]
            );
            $this->add_control(
                'lp_course_cat',
                [
                    'label' => __( 'Categories', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'lp_course_enroll',
                [
                    'label' => __( 'Enroll Count', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                    // 'condition' => [
                    //     'lp_course_tab_style' => 'style_2'
                    // ]
                ]
            );
            $this->add_control(
                'lp_course_duration',
                [
                    'label' => __( 'Duration', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                    'condition' => [
                        'lp_course_tab_style' => 'style_2'
                    ]
                ]
            );
            $this->add_control(
                'lp_course_price',
                [
                    'label' => __( 'Price', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            
        $this->end_controls_section();
        /**
         * Options
         */
        $this->start_controls_section(
			'section_options',
			[
				'label' => __( 'Options', 'widgetkit-pro' ),
			]
        );
            $this->add_control(
                'active_carousel',
                [
                    'label' => __( 'Active Carousel', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            
            $this->add_control(
                'carousel_nav_visible',
                [
                    'label' => __( 'Nav Always Visible', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                    'condition' => [
                        'active_carousel' => 'yes',
                    ],
                ]
            );
        $this->end_controls_section();
        


        






        // $this->add_control(
        //     'excerpt_title_word',
        //     [
        //         'label' => __('Excerpt Title Word', 'widgetkit-pro'),
        //         'type' => Controls_Manager::NUMBER,
        //         'default' => 7,
        //         'min' => 1,
        //         'max' => 50,
        //         'step' => 1,
        //     ]
        // );

        // $this->add_responsive_control(
        //     'fixed_height',
        //     [
        //         'label' => __( 'Fixed Height', 'widgetkit-pro' ),
        //         'type' => Controls_Manager::SLIDER,
        //         'range' => [
        //             'px' => [
        //                 'min' => 0,
        //                 'max' => 600,
        //             ],
        //         ],
        //         'selectors' => [
        //             '{{WRAPPER}} article.learnpress-course-tab-course' => 'max-height: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
        //         ],
        //     ]
        // );

        // $this->end_controls_section();
        
//  # region title and descriptoin
        /**
         * Title
         */
        $this->start_controls_section(
            'title_section_style',
                [
                    'label' => __( 'Title & Description', 'widgetkit-pro' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );
            $this->add_control(
                'style_heading_title',
                [
                'label' => __( 'Title', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Color', 'widgetkit-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .learnpress-course-tab-course a.course-title-link' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .learnpress-course-tab-style-2 .course-entry-title a' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                    [   
                        'label' => __( 'Typography', 'widgetkit-pro' ),
                        'name' => 'title_typography',
                        'selector' => '{{WRAPPER}} .learnpress-course-tab-course a.course-title-link, {{WRAPPER}} .learnpress-course-tab-style-2 .course-entry-title a',
                        'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                    ]
            );
            $this->add_control(
                'title_hover_color',
                [
                    'label'     => __( 'Hover', 'widgetkit-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .learnpress-course-tab-course a.course-title-link:hover' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .learnpress-course-tab-style-2 .course-entry-title a:hover' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'title_spacing_bottom',
                [
                    'label' => __( 'Spacing Bottom', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .learnpress-course-tab-wrapper .wkp-entry-header' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .learnpress-course-tab-style-2 .course-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'style_heading_description',
                [
                'label' => __( 'Description', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                ]
            );
            $this->add_control(
                'description_color',
                [
                    'label'     => __( 'Color', 'widgetkit-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .learnpress-course-tab-course .course-card-description' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .learnpress-course-tab-style-2 .wkp-entry-content p' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                    [   
                        'label' => __( 'Typography', 'widgetkit-pro' ),
                        'name' => 'description_typography',
                        'selector' => '{{WRAPPER}} .learnpress-course-tab-course .course-card-description, {{WRAPPER}} .learnpress-course-tab-style-2 .wkp-entry-content p',
                        'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                    ]
            );
            $this->add_responsive_control(
                'desc_spacing_top',
                [
                    'label' => __( 'Spacing Top', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .learnpress-course-tab-wrapper .wkp-entry-content' => 'margin-top: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .learnpress-course-tab-style-2 .wkp-entry-content p' => 'margin-top: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();
//  #endregion
        
//  #region meta for screen 1        
        /**
         * Meta
         */
        $this->start_controls_section(
            'meta_section_style',
            [
                'label' => __( 'Meta', 'widgetkit-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'lp_course_tab_style' => 'style_1'
                ]
            ]
            );
                /**
                 * Category
                 */
                $this->add_control(
                    'style_heading_category',
                    [
                        'label' => __( 'Category', 'widgetkit-pro' ),
                        'type' => Controls_Manager::HEADING,
                    ]
                );
                $this->add_control(
                    'category_color',
                    [
                        'label'     => __( 'Color', 'widgetkit-pro' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} article.learnpress-course-tab-course .course-details .cat-links a' => 'color: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                        [   
                            'label' => __( 'Typography', 'widgetkit-pro' ),
                            'name' => 'category_typography',
                            'selector' => '{{WRAPPER}} article.learnpress-course-tab-course .course-details .cat-links a',
                            'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                        ]
                );
                $this->add_control(
                    'category_background_color',
                    [
                        'label'     => __( 'Background', 'widgetkit-pro' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} article.learnpress-course-tab-course .course-details .cat-links a' => 'background: {{VALUE}};',
                        ],
                    ]
                );
                /**
                 * price
                 */
                $this->add_control(
                    'style_heading_price',
                    [
                    'label' => __( 'Price', 'widgetkit-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    ]
                );
                $this->add_control(
                    'price_color',
                    [
                        'label'     => __( 'Color', 'widgetkit-pro' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} article.learnpress-course-tab-course .course-details span.addon-price' => 'color: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                        [   
                            'label' => __( 'Typography', 'widgetkit-pro' ),
                            'name' => 'price_typography',
                            'selector' => '{{WRAPPER}} article.learnpress-course-tab-course .course-details span.addon-price',
                            'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                        ]
                );
                $this->add_control(
                    'price_background_color',
                    [
                        'label'     => __( 'Background', 'widgetkit-pro' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} article.learnpress-course-tab-course .course-details span.addon-price' => 'background: {{VALUE}};',
                        ],
                    ]
                );
                /**
                 * enroll student
                 */
                $this->add_control(
                    'style_heading_student',
                    [
                    'label' => __( 'Student', 'widgetkit-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    ]
                );
                $this->add_control(
                    'student_color',
                    [
                        'label'     => __( 'Color', 'widgetkit-pro' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} article.learnpress-course-tab-course .course-details .post-view' => 'color: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                        [   
                            'label' => __( 'Typography', 'widgetkit-pro' ),
                            'name' => 'student_typography',
                            'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                            'selector' => '{{WRAPPER}} article.learnpress-course-tab-course .course-details .post-view',
                        ]
                );
        $this->end_controls_section();
//  #endregion

//  # region author for screen 2    
        $this->start_controls_section(
            'section_style_course_author',
            [
                'label' => __( 'Author', 'widgetkit-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'lp_course_tab_style' => 'style_2'
                ]
            ]
        );
            $this->add_control(
                'lp_author_color',
                [
                    'label' => __( 'Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .author-wrapper .course-author-name' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'lp_course_author_typography',
                    'selector' => '{{WRAPPER}} .author-wrapper .course-author-name',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );
            $this->add_control(
                'lp_course_author_image_border_radius',
                [
                    'label'   => esc_html__( 'Image Border Radius', 'widgetkit-for-elementor' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'size' =>50,
                    ],
                    'range'  => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .learnpress-course-tab-style-2 .author-wrapper img' => 'border-radius: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'lp_author_margin',
                [
                    'label'         => __('Margin', 'widgetkit-pro'),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => ['px','%'],
                    
                    'selectors'     => [
                        '{{WRAPPER}} .learnpress-course-list-style-2 .author-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
                ]
            );
        $this->end_controls_section();
//  #endregion   

//  # region Rating for screen 2    
        $this->start_controls_section(
            'section_style_course_rating',
            [
                'label' => __( 'Rating', 'widgetkit-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                // 'condition' => [
                //     'lp_course_tab_style' => 'style_2'
                // ]
            ]
        );
            $this->add_control(
                'lp_rating_blank_star_color',
                [
                    'label' => __( 'Blank Star Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .learnpress-course-tab-element .rating .star-rating:before' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'lp_rating_star_color',
                [
                    'label' => __( 'Star Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .learnpress-course-tab-element .rating .star-rating span:before' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'lp_rating_text_color',
                [
                    'label' => __( 'Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rating .lp-course-rate-wapper' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'lp_course_rating_typography',
                    'selector' => '{{WRAPPER}} .rating .lp-course-rate-wapper .lp-course-rate li',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );
            $this->add_responsive_control(
                'lp_rating_margin',
                [
                    'label'         => __('Margin', 'widgetkit-pro'),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => ['px','%'],
                    
                    'selectors'     => [
                        '{{WRAPPER}}  article .rating' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
                    'condition' => [
                        'lp_course_tab_style' => 'style_1'
                    ]
                ]
            );
        $this->end_controls_section();
//  #endregion 

//  # region category for screen 2       
        $this->start_controls_section(
            'section_style_course_category',
            [
                'label' => __( 'Category', 'widgetkit-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'lp_course_tab_style' => 'style_2'
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'lp_cat_typography',
                'selector' => '{{WRAPPER}} .edumodo-course-1 article.tx-course .course-details .course-meta .post-date a, .edumodo-lp-course-1 .lp-cat .cat-links a, {{WRAPPER}} .course-cat ul li a',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

            $this->start_controls_tabs('lp_cat_style');
                /**
                 * Normal
                 */
                $this->start_controls_tab(
                    'lp_cat_style_normal',
                    [
                        'label' => __( 'Normal', 'widgetkit-pro' ),
                    ]
                );
                $this->add_control(
                    'lp_cat_color',
                    [
                        'label' => __( 'Color', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#fff',
                        'selectors' => [
                            '{{WRAPPER}} .course-cat ul li a' => 'color: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'lp_cat_bg_color',
                    [
                        'label' => __( 'Background', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#EEB90E',
                        'selectors' => [
                            '{{WRAPPER}} .course-cat ul li' => 'background: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'lp_cat_hr',
                    [
                        'type' => \Elementor\Controls_Manager::DIVIDER,
                    ]
                );
                $this->add_group_control(
                    Group_Control_Border::get_type(), 
                    [
                        'name'          => 'lp_cat_border',
                        'selector'      => '{{WRAPPER}} .course-cat ul li',
                    ]
                );
                $this->add_control(
                    'lp_cat_border_radius',
                    [
                        'label'   => esc_html__( 'Border Radius', 'widgetkit-for-elementor' ),
                        'type'    => Controls_Manager::SLIDER,
                        'default' => [
                            'size' =>2,
                        ],
                        'range'  => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .course-cat ul li' => 'border-radius: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->end_controls_tab();
                /**
                 * hover
                 */
                $this->start_controls_tab(
                    'lp_cat_style_hover',
                    [
                        'label' => __( 'Hover', 'widgetkit-pro' ),
                    ]
                );
                $this->add_control(
                    'lp_cat_color_hover',
                    [
                        'label' => __( 'Color', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#7c7000',
                        'selectors' => [
                            '{{WRAPPER}} .course-cat ul li:hover a' => 'color: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'lp_cat_bg_color_hover',
                    [
                        'label' => __( 'Background', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#fff',
                        'selectors' => [
                            '{{WRAPPER}} .course-cat ul li:hover' => 'background: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'lp_cat_border_color_hover',
                    [
                        'label' => __( 'Border', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .course-cat ul li:hover' => 'border-color: {{VALUE}}',
                        ],
                    ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();

            $this->add_responsive_control(
                'lp_cat_padding',
                [
                    'label'         => __('Padding', 'widgetkit-pro'),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => ['px','%'],
                    'separator'     => 'before',
                    'selectors'     => [
                        '{{WRAPPER}} .course-cat ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
                ]
            );
            $this->add_responsive_control(
                'lp_cat_margin',
                [
                    'label'         => __('Margin', 'widgetkit-pro'),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => ['px','%'],
                    
                    'selectors'     => [
                        '{{WRAPPER}} .course-cat ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
                ]
            );
        $this->end_controls_section();
//  #endregion    

//  # region enroll user for screen 2     
        $this->start_controls_section(
            'section_style_course_enroll',
            [
                'label' => __( 'Enroll', 'widgetkit-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'lp_course_tab_style' => 'style_2'
                ]
            ]
        );
            $this->add_control(
                'course_enroll_color',
                [
                    'label'     => __( 'Color', 'widgetkit-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '',
                    'selectors' => [
                        '{{WRAPPER}} .edumodo-course-1 article.tx-course .course-details .course-meta .post-view i, .type-tx-course article.tx-course .course-details .course-meta .post-view i' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .edumodo-course-1 article.tx-course .course-details .course-meta .post-view, .type-tx-course article.tx-course .course-details .course-meta .post-view' => 'color: {{VALUE}};',

                        '{{WRAPPER}} .edumodo-lp-course-1 .course-meta.addons-course-meta span.post-view' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .course-meta .course-user' => 'color: {{VALUE}};',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'lp_enroll_typography',
                    'selector' => '{{WRAPPER}} .edumodo-lp-course-1 .course-meta span.post-view, {{WRAPPER}} .course-meta .course-user',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );
            $this->add_control(
                'enroll_icon_color',
                [
                    'label'     => __( 'Icon Color', 'widgetkit-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '',
                    'selectors' => [
                        '{{WRAPPER}} .course-meta .enroll-student .meta-icon i' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .course-meta .enroll-student .meta-icon svg' => 'fill: {{VALUE}};',
                    ]
                ]
            );
            $this->add_control(
                'lp_enroll_add_custom_icon',
                [
                    'label' => __( 'Custom Icon', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
            $this->add_control(
                'lp_enroll_icon',
                [
                    'label' => esc_html__( 'Icon', 'widgetkit-for-elementor' ),
                    'type'              => Controls_Manager::ICONS,
                    'default'    =>  [
                        'value'     => 'fa fa-eye',
                        'library'   => 'fa-solid',
                    ],
                    'label_block'   => true,
                    'condition' => [
                        'lp_enroll_add_custom_icon' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'lp_enroll_icon_width',
                [
                    'label'   => esc_html__( 'Icon Size', 'widgetkit-for-elementor' ),
                    'type'    => Controls_Manager::SLIDER,
                    'range'  => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                        ],
                    ],
                    'separator'     => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .course-meta .enroll-student .meta-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .course-meta .enroll-student .meta-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'lp_enroll_add_custom_icon' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'lp_enroll_icon_spacing_right',
                [
                    'label'   => esc_html__( 'Icon Spacing', 'widgetkit-for-elementor' ),
                    'type'    => Controls_Manager::SLIDER,
                    'range'  => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                        ],
                    ],
                    'separator'     => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .course-meta .enroll-student .meta-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .course-meta .enroll-student .meta-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();
//  #endregion  

//  # region course duration  for screen 2    
        $this->start_controls_section(
            'section_style_course_duration',
            [
                'label' => __( 'Duration', 'widgetkit-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'lp_course_tab_style' => 'style_2'
                ]
            ]
        );
        $this->add_control(
            'lp_duration_color',
            [
                'label'     => __( 'Color', 'widgetkit-pro' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .course-meta .duraton .course-duration' => 'color: {{VALUE}};',
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'lp_duration_typography',
                'selector' => '{{WRAPPER}} .course-meta .duraton .course-duration',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        $this->add_control(
            'duration_icon_color',
            [
                'label'     => __( 'Icon Color', 'widgetkit-pro' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .course-meta .duraton .meta-icon i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .course-meta .duraton .meta-icon svg' => 'fill: {{VALUE}};',
                ]
            ]
        );
        $this->add_control(
            'lp_duration_custom_icon',
            [
                'label' => __( 'Custom Icon', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => __( 'Show', 'widgetkit-pro' ),
                'label_off' => __( 'Hide', 'widgetkit-pro' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'lp_duration_icon',
            [
                'label' => esc_html__( 'Icon', 'widgetkit-for-elementor' ),
                'type'              => Controls_Manager::ICONS,
                'default'    =>  [
                    'value'     => 'fa fa-eye',
                    'library'   => 'fa-solid',
                ],
                'label_block'   => true,
                'condition' => [
                    'lp_duration_custom_icon' => 'yes'
                ]
            ]
        );
            $this->add_control(
                'lp_duration_icon_width',
                [
                    'label'   => esc_html__( 'Icon Size', 'widgetkit-for-elementor' ),
                    'type'    => Controls_Manager::SLIDER,
                    'range'  => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                        ],
                    ],
                    'separator'     => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .course-meta .duraton .meta-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .course-meta .duraton .meta-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'lp_duration_custom_icon' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'lp_duration_icon_spacing_right',
                [
                    'label'   => esc_html__( 'Icon Spacing', 'widgetkit-for-elementor' ),
                    'type'    => Controls_Manager::SLIDER,
                    'range'  => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                        ],
                    ],
                    'separator'     => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .course-meta .duraton .meta-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .course-meta .duraton .meta-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();
//  #endregion   

//  # region price for screen 2        
        $this->start_controls_section(
            'section_style_course_price',
            [
                'label' => __( 'Price', 'widgetkit-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'lp_course_tab_style' => 'style_2'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'lp_price_typography',
                'selector' => '{{WRAPPER}} .edumodo-course-1 article.tx-course span.addon-price, .edumodo-lp-course-1 span.addon-price, {{WRAPPER}} .course-meta .course-price',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );


            $this->start_controls_tabs('lp_price_style');
                /**
                 * Normal
                 */
                $this->start_controls_tab(
                    'lp_price_style_normal',
                    [
                        'label' => __( 'Normal', 'widgetkit-pro' ),
                    ]
                );
                $this->add_control(
                    'content_lp_price_color',
                    [
                        'label' => __( 'Color', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#fff',
                        'selectors' => [
                            '{{WRAPPER}} .course-meta .course-price' => 'color: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'content_lp_price_bg_color',
                    [
                        'label' => __( 'Background', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#EEB90E',
                        'selectors' => [
                            '{{WRAPPER}} .course-meta .course-price' => 'background: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'lp_price_hr',
                    [
                        'type' => \Elementor\Controls_Manager::DIVIDER,
                    ]
                );
                $this->add_group_control(
                    Group_Control_Border::get_type(), 
                    [
                        'name'          => 'lp_price_border',
                        'selector'      => '{{WRAPPER}} .course-meta .course-price',
                    ]
                );
                $this->add_control(
                    'lp_price_border_radius',
                    [
                        'label'   => esc_html__( 'Border Radius', 'widgetkit-for-elementor' ),
                        'type'    => Controls_Manager::SLIDER,
                        'default' => [
                            'size' =>2,
                        ],
                        'range'  => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .course-meta .course-price' => 'border-radius: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->end_controls_tab();
                /**
                 * hover
                 */
                $this->start_controls_tab(
                    'lp_price_style_hover',
                    [
                        'label' => __( 'Hover', 'widgetkit-pro' ),
                    ]
                );
                $this->add_control(
                    'content_lp_price_color_hover',
                    [
                        'label' => __( 'Color', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#7c7000',
                        'selectors' => [
                            '{{WRAPPER}} .course-meta .course-price:hover' => 'color: {{VALUE}} ',
                        ],
                    ]
                );
                $this->add_control(
                    'content_lp_price_bg_color_hover',
                    [
                        'label' => __( 'Background', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#fff',
                        'selectors' => [
                            '{{WRAPPER}} .course-meta .course-price:hover' => 'background: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'content_lp_price_border_color_hover',
                    [
                        'label' => __( 'Border', 'widgetkit-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .course-meta .course-price:hover' => 'border-color: {{VALUE}}',
                        ],
                    ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_responsive_control(
                'lp_price_padding',
                [
                    'label'         => __('Padding', 'widgetkit-pro'),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => ['px','%'],
                    'selectors'     => [
                        '{{WRAPPER}} .course-meta .course-price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
                ]
            );
        $this->end_controls_section();
//  #endregion

//  # region meta user for screen 2       
        $this->start_controls_section(
            'section_style_course_meta',
            [
                'label' => __( 'Meta', 'widgetkit-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'lp_course_tab_style' => 'style_2'
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(), 
            [
                'name'          => 'lp_course_meta_border',
                'selector'      => '{{WRAPPER}} .course-meta',
            ]
        );
        $this->add_control(
            'lp_meta__bg_color',
            [
                'label' => __( 'Background', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .course-meta' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'lp_course_meta_padding',
            [
                'label'         => __('Padding', 'widgetkit-pro'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px','%'],
                'selectors'     => [
                    '{{WRAPPER}} .course-meta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
            ]
        );
        $this->add_responsive_control(
            'lp_course_meta_margin',
            [
                'label'         => __('Margin', 'widgetkit-pro'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px','%'],
                'selectors'     => [
                    '{{WRAPPER}} .course-meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
            ]
        );
        $this->end_controls_section();
//  #endregion  

//  # region navigation & overlay style
        /**
         * Navigation & overlay
         */
        $this->start_controls_section(
            'style_section_navigation_overlay',
                [
                    'label' => __( 'Navigation & Overlay', 'widgetkit-pro' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );
            /**
             * Navigation
             */
            $this->add_control(
                'style_heading_navigation',
                [
                'label' => __( 'Navigation', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                ]
            );
            $this->add_responsive_control(
                'tab_align',
                [
                    'label'   => __('Alignment', 'widgetkit-pro'),
                    'type'    => Controls_Manager::CHOOSE,
                    'default' => 'center',
                    'selectors' => [
                        '{{WRAPPER}} .learnpress-course-tab-cat-wrapper' => 'text-align: {{UNIT}};',
                    ],
                    'options' => [
                        'left'   => [
                            'title' => __('Left', 'widgetkit-pro'),
                            'icon'  => 'fa fa-align-left',
                        ],
                        'center' => [
                            'title' => __('Center', 'widgetkit-pro'),
                            'icon'  => 'fa fa-align-center',
                        ],
                        'right'  => [
                            'title' => __('Right', 'widgetkit-pro'),
                            'icon'  => 'fa fa-align-right',
                        ],
                    ],

                ]
            );
            $this->add_control(
                'navigation_seperator_color',
                [
                    'label'     => __( 'Seperator', 'widgetkit-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'separator' => 'after',
                    'selectors' => [
                        '{{WRAPPER}} .learnpress-course-tab-wrapper .learnpress-course-tab-cat-wrapper' => 'border-bottom-color: {{VALUE}};',
                    
                    ],
                ]
            );
            $this->add_control(
                'tab_color',
                [
                    'label'     => __( 'Color', 'widgetkit-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .learnpress-course-tab-wrapper .cat-item ' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .learnpress-course-tab-body .owl-nav .owl-carousel-left, .learnpress-course-tab-body .owl-nav .owl-carousel-right' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                    [   
                        'label' => __( 'Typography', 'widgetkit-pro' ),
                        'name' => 'tab_typography',
                        'selector' => '{{WRAPPER}} .learnpress-course-tab-wrapper .multiple-cat .cat-item',
                        'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                    ]
            );
            $this->add_control(
                'tab_active_color',
                [
                    'label'     => __( 'Active Color', 'widgetkit-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .learnpress-course-tab-wrapper .multiple-cat .cat-item.active' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .learnpress-course-tab-wrapper .multiple-cat .cat-item:hover' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .learnpress-course-tab-body .owl-nav .owl-carousel-left:hover, .learnpress-course-tab-body .owl-nav .owl-carousel-right:hover' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .learnpress-course-tab-wrapper .multiple-cat .cat-item.active:after' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'tab_spacing_bottom',
                [
                    'label' => __( 'Spacing Bottom', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'separator' => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .learnpress-course-tab-wrapper .lp-course-tab-nav' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'tab_cat_spacing',
                [
                    'label' => __( 'Inner Spacing', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 80,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .learnpress-course-tab-wrapper .multiple-cat .cat-item' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            /**
             * overlay
             */
            $this->add_control(
                'style_heading_Overlay',
                [
                'label' => __( 'Overlay', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                ]
            );
            $this->add_control(
                'tab_loding_color',
                [
                    'label'     => __( 'Loading Overlay', 'widgetkit-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .learnpress-course-tab-wrapper .ajax-content' => 'background-color: {{VALUE}};',
                    
                    ],
                ]
            );
        $this->end_controls_section();
//  #endregion

//  # region single course
        /**
         * Single Course
         */
        $this->start_controls_section(
            'section_wapper_style',
                [
                    'label' => __( 'Single Course', 'widgetkit-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                ]
            );
            $this->add_control(
                'layout_background_color',
                [
                    'label' => __( 'Background', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#f7f7f7',
                    'selectors' => [
                        '{{WRAPPER}}  article.learnpress-course-tab-course .course-details' => 'background-color: {{VALUE}};',
                        '{{WRAPPER}}  article.learnpress-course-tab-course .course-content-body' => 'background-color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(), 
                [
                    'name'          => 'Border',
                    'selector'      => '{{WRAPPER}} article.learnpress-course-tab-course',
                ]
            );
            // $this->add_control(
            //     'layout_border_radius',
            //     [
            //         'label' => __( 'Border Radius', 'widgetkit-pro' ),
            //         'type' => Controls_Manager::SLIDER,
            //         'range' => [
            //             'px' => [
            //                 'min' => 0,
            //                 'max' => 100,
            //             ],
            //         ],
            //         'selectors' => [
            //             '{{WRAPPER}} article.learnpress-course-tab-course' => 'border-radius: {{SIZE}}{{UNIT}};',
            //         ],
            //     ]
            // );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'body_box_shadow',
                    'selector' => '{{WRAPPER}} article.learnpress-course-tab-course',
                ]
            );
            $this->add_responsive_control(
                'style_course_padding',
                [
                    'label' => esc_html__( 'Padding', 'widgetkit-pro' ),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'selectors'  => [
                        '{{WRAPPER}} article.learnpress-course-tab-course .course-details' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} article.learnpress-course-tab-course .course-content-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'default' => [
                        'top' => '15',
                        'right' => '15',
                        'bottom' => '10',
                        'left' => '15',
                        'unit' => 'px',
                        'isLinked' => false,
                    ],
                ]
            );

        $this->end_controls_section();
//  #endregion


        // $this->start_controls_section(
        //     'price_section_style',
        //         [
        //             'label' => __( 'Price', 'widgetkit-pro' ),
        //             'tab'   => Controls_Manager::TAB_STYLE,
        //         ]
        //     );


        // $this->end_controls_section();

        // $this->start_controls_section(
        //     'rating_section_style',
        //         [
        //             'label' => __( 'Rating', 'widgetkit-pro' ),
        //             'tab'   => Controls_Manager::TAB_STYLE,
        //         ]
        //     );

        //     $this->add_control(
        //         'rating_color',
        //         [
        //             'label'     => __( 'Rating Color', 'widgetkit-pro' ),
        //             'type'      => Controls_Manager::COLOR,
        //             'selectors' => [
        //                 '{{WRAPPER}} article.learnpress-course-tab-course .star-rating span:before' => 'color: {{VALUE}};',
        //             ],
        //         ]
        //     );

        // $this->end_controls_section();

		
    }


    protected function render()
    {
        $settings = $this->get_settings();
        $lp_course_style = widgetkit_pro_array_get($settings, 'lp_course_tab_style');
        ?>

        <div id="learnpress-course-tab-<?php echo $this->get_id(); ?>" class="learnpress-course-tab-element learnpress-course-tab-<?php echo $this->get_id(); ?>">
            <?php //include( plugin_dir_path( __FILE__ ) . '../layout/learnpress/course-tab.php'); ?>
            <?php 
            if($lp_course_style == 'style_1'):
                include( plugin_dir_path( __FILE__ ) . '../layout/learnpress/course-tab.php'); 
            else:
                include( plugin_dir_path( __FILE__ ) . '../layout/learnpress/course-tab-2.php'); 
            endif;
            
            ?>
        </div>

    <?php
    }

    protected function _content_template()
    {
    }

}
