<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Background;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Edumodo Course Categeries
 *
 * @since 1.0.0
 */
class Widgetkit_Pro_LP_Course_Category extends Widget_Base {

	public function get_name() {
		return 'widgetkit-pro-lp-course-category';
	}

	public function get_title() {
		return __( 'Learnpress Categories', 'widgetkit-pro' );
	}

	public function get_icon() {
		return 'eicon-post-content';
	}

	public function get_categories() {
		return [ 'widgetkit_pro' ];
    }

    /**
	 * A list of style that the widgets is depended in
	 **/
	public function get_style_depends() {
        return [
            'widgetkit_pro_base',
            'widgetkit_pro_default',
            // 'owl-css',
        ];
    }
	/**
	 * A list of scripts that the widgets is depended in
	 **/
	public function get_script_depends() {
		return [ 
			// 'magnific-js',
            // 'owl-carousel',
            // 'wkp-learnpress',
        ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function _register_controls() {

        $cat = array();
        $terms = get_terms( array(
            'post_type' => 'lp_course',
            'taxonomy' => 'course_category',
            'hide_empty' => false,
            'fields'   => 'id=>name'
        ) );

        foreach ($terms as $key => $value) {
		//    $cat[ucwords()] = ;
		//    $cat[$key] = $value;
            $cat[$key] = $value;
        }
    
        /**
         * Query
         */
		$this->start_controls_section(
			'section_query',
			[
				'label' => __( 'Query', 'widgetkit-pro' ),
			]
		);
            $this->add_control(
                'lp_course_category_id',
                [
                    'label'       => __( 'Select Category', 'widgetkit-pro' ),
                    'type'        => Controls_Manager::SELECT,
                    'default'     => '',
                    'options' => $cat,
                ]
            );
            $this->add_control(
                'show_hide_lp_categories_courses',
                [
                    'label' => __( 'Course Count', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
        $this->end_controls_section();

        /**
         * Image
         */
        $this->start_controls_section(
            'section_image',
			[
                'label' => __( 'Image', 'widgetkit-pro' ),
            ]
        );
            $this->add_control(
                'image',
                [
                    'label' => __( 'Choose Image', 'widgetkit-pro' ),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'image', // Actually its `image_size`.
                    'label' => __( 'Image Size', 'widgetkit-pro' ),
                    'default' => 'large',
                ]
            );
            $this->add_responsive_control(
                'image_fixed_height',
                [
                    'label' => __( 'Height', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 900,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .lp-course-categories img' => 'height: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .lp-course-categories' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();






        $this->start_controls_section(
            'title_section_style',
                [
                    'label' => __( 'Category', 'widgetkit-pro' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );
            $this->add_control(
                'section_category_title',
                [
                'label' => __( 'Name', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                // 'separator' => 'before',
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                    [   
                        'label' => __( 'Typography', 'widgetkit-pro' ),
                        'name' => 'category_typography',
                        'selector' => '{{WRAPPER}} .lp-course-categories .content-body .lp-course-meta a .lp-categories',
                        'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                    ]
            );
            $this->add_control(
                'category_color',
                [
                    'label'     => __( 'Color', 'widgetkit-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .lp-course-categories .content-body .lp-course-meta a .lp-categories' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_control(
                'section_course_count',
                [
                    'label' => __( 'Course', 'widgetkit-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'show_hide_lp_categories_courses' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                    [   
                        'label' => __( 'Typography', 'widgetkit-pro' ),
                        'name' => 'category_course_typography',
                        'selector' => '{{WRAPPER}} .lp-course-categories .content-body .lp-course-meta .lp-course span',
                        'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                        'condition' => [
                            'show_hide_lp_categories_courses' => 'yes'
                        ]
                    ]
            );
            $this->add_control(
                'category_course_color',
                [
                    'label'     => __( 'Color', 'widgetkit-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .lp-course-categories .content-body .lp-course-meta .lp-course span' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                        'show_hide_lp_categories_courses' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'category_course_spacing_top',
                [
                    'label'   => esc_html__( 'Top Spacing', 'widgetkit-pro' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'size' =>15,
                    ],
                    'range'  => [
                        'px' => [
                            'min' => -20,
                            'max' => 200,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .lp-course-categories .content-body .lp-course-meta .lp-course' => 'margin-top: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_hide_lp_categories_courses' => 'yes',
                    ],
                ]
            );
        $this->end_controls_section();

        /**
         * image style
         */
        $this->start_controls_section(
            'image_section_style',
            [
                'label' => __( 'Image', 'widgetkit-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'lp_catogories_bg_color',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .lp-course-categories:before',
                ]
            );
        $this->end_controls_section();


	}


	/**
	 * Render image widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @access protected
	 */
	protected function render() {
        $settings = $this->get_settings();
        // $lp_course_style = widgetkit_pro_array_get($settings, 'lp_course_tab_style');
        ?>
		<div id="learnpress-course-category-<?php echo $this->get_id(); ?>" class="learnpress-course-category-element learnpress-course-category-<?php echo $this->get_id(); ?>">
            <?php include( plugin_dir_path( __FILE__ ) . '../layout/learnpress/course-category.php'); ?>
            <?php 
            // if($lp_course_style == 'style_1'):
            //     include( plugin_dir_path( __FILE__ ) . '../layout/learnpress/course-tab.php'); 
            // else:
            //     include( plugin_dir_path( __FILE__ ) . '../layout/learnpress/course-tab-2.php'); 
            // endif;
            
            ?>
        </div>
        <?php 
    }
    
    protected function _content_template()
    {
    }

}
