<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Utils;
use Elementor\Group_Control_Box_Shadow;

if (!defined('ABSPATH')) exit; 

class Widgetkit_Pro_LearnDash_Course_List extends Widget_Base
{
    public $learndash_core = 'sfwd-lms/sfwd_lms.php';

    public function get_name()
    {
        return 'widgetkit-pro-learndash-course';
    }

    public function get_title()
    {
        return __('LearnDash Course List', 'widgetkit-pro');
    }

    public function get_icon()
    {
        return 'eicon-post-content';
    }

    public function get_categories()
    {
        return ['widgetkit_pro'];
    }

    /**
	 * A list of style that the widgets is depended in
	 **/
	public function get_style_depends() {
        return [
            'widgetkit_bs',
            'widgetkit_pro_default',
        ];
    }
	/**
	 * A list of scripts that the widgets is depended in
	 **/
	public function get_script_depends() {
		return [ 
			// 'animate-text',
			'layout',
		 ];
	}

	protected function _register_controls() {

        $cat_names = array();

        if(apply_filters('wkpro_check_plugin', $this->learndash_core) && class_exists('SFWD_LMS')):
            $terms = get_terms(array(
                'post_type' => 'sfwd-courses',
                'taxonomy' => 'ld_course_category',
                'hide_empty' => true,
            ));
            foreach ($terms as $t):
                $cat_names[$t->slug] = $t->name;
            endforeach;
        endif;

#   region Query         
        /**
         * Query
         */
		$this->start_controls_section(
			'section_query',
			[
				'label' => __( 'Query', 'widgetkit-pro' ),
			]
		);
            $this->add_control(
                'cat_dynamic_multiple_id',
                [
                    'label' => __('Select Category', 'widgetkit-pro'),
                    'type' => Controls_Manager::SELECT2,
                    'options' => $cat_names,
                    'multiple' => true,
                ]
            );
            $this->add_control(
                'order',
                [
                    'label' => __('Order', 'widgetkit-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'ASC',
                    'options' => [
                        'ASC' => __('Ascending', 'widgetkit-pro'),
                        'DESC' => __('Descending', 'widgetkit-pro'),
                    ],
                ]
            );
            $this->add_control(
                'orderby',
                [
                    'label' => __('Order By', 'widgetkit-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'date',
                    'options' => [
                        'title' => __('Title', 'widgetkit-pro'),
                        'name' => __('Name', 'widgetkit-pro'),
                        'date' => __('Date', 'widgetkit-pro'),
                        'rand' => __('Random', 'widgetkit-pro'),
                    ],
                ]
            );  
            $this->add_control(
                'post_num_to_show',
                [
                    'label' => __('Course to Show', 'widgetkit-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 3,
                    'min' => 1,
                    'max' => 50,
                    'step' => 1,
                ]
            );
        $this->end_controls_section();
#   endregion         

#   region Layout
        /**
         * Layout
         */
        $this->start_controls_section(
            'section_layout',
            [
                'label' => __( 'Layout', 'widgetkit-pro' ),
            ]
        );
            $this->add_control(
                'posts_column',
                [
                    'label' => __('Columns', 'widgetkit-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '4',
                    'options' => [
                        '2' => __('6 Columns', 'widgetkit-pro'),
                        '3' => __('4 Columns', 'widgetkit-pro'),
                        '4' => __('3 Columns', 'widgetkit-pro'),
                        '6' => __('2 Columns', 'widgetkit-pro'),
                        '12' => __('1 Columns', 'widgetkit-pro'),
                    ],
                ]
            );
        $this->end_controls_section(); 
#   endregion    

#   region Title & description
        /**
         * title & description
         */
        $this->start_controls_section(
            'section_title_description',
            [
                'label' => __( 'Title & Description', 'widgetkit-pro' ),
            ]
        );
            $this->add_control(
                'excerpt_desc_word',
                [
                    'label' => __('Description Length', 'widgetkit-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 7,
                    'min' => 1,
                    'max' => 50,
                    'step' => 1,
                ]
            );
        $this->end_controls_section(); 
#   endregion  

#   region Meta
        /**
         * Meta
         */
        $this->start_controls_section(
            'section_meta',
            [
                'label' => __( 'Meta', 'widgetkit-pro' ),
            ]
        );
            $this->add_control(
                'read_more_button',
                [
                    'label' => __( 'Button', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'label_on' => __( 'Show', 'widgetkit-pro' ),
                    'label_off' => __( 'Hide', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                ]
            );
        $this->end_controls_section(); 
#   endregion    

        
#   region title & description style

        $this->start_controls_section(
            'section_wapper_style',
            [
                'label' => __('Title & Description', 'widgetkit-pro'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            /**
             * Title
             */
            $this->add_control(
                'style_heading_title',
                [
                'label' => __( 'Title', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label' => __('Typography', 'widgetkit-pro'),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .widgetkit-ld-courses .ld_course_grid .wk-entry-title',
                    'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                ]
            );

            $this->start_controls_tabs('title_style_tabs');
                /**
                 * Normal
                 */
                $this->start_controls_tab(
                    'title_style_normal_tab',
                    [
                        'label' => __('Normal', 'widgetkit-pro'),
                    ]
                );
                    $this->add_control(
                        'title_color',
                        [
                            'label' => __('Color', 'widgetkit-pro'),
                            'type' => Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .widgetkit-ld-courses .ld_course_grid .wk-entry-title a' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab(); 
                /**
                 * hover
                 */
                $this->start_controls_tab(
                    'title_style_hover_tab',
                    [
                        'label' => __('Hover', 'widgetkit-pro'),
                    ]
                );
                    $this->add_control(
                        'title_hover_color',
                        [
                            'label' => __('Color', 'widgetkit-pro'),
                            'type' => Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .widgetkit-ld-courses .ld_course_grid .wk-entry-title:hover a' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab(); // Hover Tab end
            $this->end_controls_tabs();
            $this->add_responsive_control(
                'title_spacing_bottom',
                [
                    'label' => __( 'Spacing Bottom', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .widgetkit-ld-courses  .wk-entry-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            /**
             * Content
             */
            $this->add_control(
                'style_heading_description',
                [
                'label' => __( 'Description', 'widgetkit-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                ]
            );
                $this->add_control(
                    'content_color',
                    [
                        'label' => __('Color', 'widgetkit-pro'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .widgetkit-ld-courses .ld-entry-content' => 'color: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'label' => __('Typography', 'widgetkit-pro'),
                        'name' => 'content_typography',
                        'selector' => '{{WRAPPER}} .widgetkit-ld-courses .ld-entry-content',
                        'scheme' => Scheme_Typography::TYPOGRAPHY_3,
                    ]
                );
                $this->add_responsive_control(
                    'desc_spacing_bottom',
                    [
                        'label' => __( 'Spacing Bottom', 'widgetkit-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .widgetkit-ld-courses  .ld-entry-content' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                
        $this->end_controls_section();
#   endregion         

#   region price style
    $this->start_controls_section(
        'section_style_price',
        [
            'label' => __( 'Price ', 'widgetkit-pro' ),
            'tab' => Controls_Manager::TAB_STYLE,
        ]
    );
        $this->add_control(
            'price_color',
            [
                'label' => __('Color', 'widgetkit-pro'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .widgetkit-ld-courses .course .ld_course_grid_price' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __('Typography', 'widgetkit-pro'),
                'name' => 'price_typography',
                'selector' => '{{WRAPPER}} .ld_course_grid_price',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        $this->add_control(
            'price_bg_color',
            [
                'label' => __('Background', 'widgetkit-pro'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ld_course_grid_price' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .ld_course_grid_price:before' => 'border-top: 4px solid {{VALUE}}; border-right: 4px solid {{VALUE}}',
                
                ],
            ]
        );
    $this->end_controls_section();
#   endregion 

#   region Button style
        $this->start_controls_section(
            'section_button_style',
            [
                'label' => __( 'Button', 'widgetkit-pro' ),
                 'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        /**
         * Button
         */
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __('Button Typography', 'widgetkit-pro'),
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .course .ld_course_grid_button a.btn',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );

        $this->start_controls_tabs('button_style_tabs');

        $this->start_controls_tab(
            'button_style_normal_tab',
            [
                'label' => __('Normal', 'widgetkit-pro'),
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => __('Color', 'widgetkit-pro'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .ld_course_grid_button .btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_color',
            [
                'label' => __('Background', 'widgetkit-pro'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .ld_course_grid_button .btn-primary' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_border_color',
            [
                'label' => __('Border', 'widgetkit-pro'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .ld_course_grid_button .btn-primary' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab(); // Normal Tab end

        $this->start_controls_tab(
            'button_style_hover_tab',
            [
                'label' => __('Hover', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'button_hover_text_color',
            [
                'label' => __('Color', 'widgetkit-pro'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .ld_course_grid_button .btn-primary:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_hover_background',
            [
                'label' => __('Background', 'widgetkit-pro'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .ld_course_grid_button .btn-primary:hover' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_hover_border_color',
            [
                'label' => __('Border', 'widgetkit-pro'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .ld_course_grid_button .btn-primary:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab(); // Hover Tab end

        $this->end_controls_tabs();

        $this->add_control(
            'padding_hr',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'button-border-width',
            [
                'label'   => esc_html__( 'Border Width', 'widgetkit-pro' ),
                'type'    => Controls_Manager::SLIDER,
                'default' => [
                    'size' =>2,
                ],
                'range'  => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .ld_course_grid .ld_course_grid_button .btn-primary' => 'border-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'button-border-radius',
            [
                'label'   => esc_html__( 'Radius', 'widgetkit-pro' ),
                'type'    => Controls_Manager::SLIDER,
                'default' => [
                    'size' =>50,
                ],
                'range'  => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .ld_course_grid .ld_course_grid_button .btn-primary' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'single_course_btn_padding',
            [
                'label' => esc_html__( 'Padding', 'widgetkit-pro' ),
                'type'  => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .ld_course_grid .ld_course_grid_button .btn-primary' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '7',
                    'right' => '20',
                    'bottom' => '7',
                    'left' => '20',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
            ]
        );

        $this->end_controls_section();
#   endregion         

#   region global option style
        
        $this->start_controls_section(
            'section_single_course_style',
            [
                'label' => __( 'Global option', 'widgetkit-pro' ),
                 'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_responsive_control(
                'single_course_align',
                [
                    'label' => esc_html__( 'Alignment', 'widgetkit-for-elementor' ),
                    'type'  => Controls_Manager::CHOOSE,
                    'default'   =>'left' ,
                    'options'   => [
                        'left'    => [
                            'title' => esc_html__( 'Left', 'widgetkit-for-elementor' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'widgetkit-for-elementor' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'widgetkit-for-elementor' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .ld_course_grid article.course' => 'text-align: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_control(
                'single_course_background',
                [
                    'label' => __('Background', 'widgetkit-pro'),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .ld_course_grid .caption' => 'Background: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Border::get_type(), 
                [
                'name'          => 'Border',
                'selector'      => '{{WRAPPER}} .ld_course_grid article.course',
                ]
            );
            $this->add_control(
                'enable_box_shadow',
                [
                    'label' => __( 'Enable Box Shadow', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'label_on' => __( 'Yes', 'widgetkit-pro' ),
                    'label_off' => __( 'No', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                    
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                    [
                        'name'    => 'item_box_shadow',
                        'label'     => esc_html__( 'Normal Box Shadow', 'widgetkit-pro' ),
                        'exclude' => [
                            'box_shadow_position',
                        ],
                        'selector' => '{{WRAPPER}} .ld_course_grid article.course',
                        'condition' => [
                            'enable_box_shadow' => 'yes',
                        ],
                    ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                    [
                        'name'    => 'item_hover_box_shadow',
                        'label'     => esc_html__( 'Hover Box Shadow', 'widgetkit-pro' ),
                        'exclude' => [
                            'box_shadow_position',
                        ],
                        'selector' => '{{WRAPPER}} .ld_course_grid article.course:hover',
                        'condition' => [
                            'enable_box_shadow' => 'yes',
                        ],
                    ]
            );
            $this->add_responsive_control(
                'single_course_padding',
                [
                    'label' => esc_html__( 'Padding', 'widgetkit-pro' ),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'selectors'  => [
                        '{{WRAPPER}} .ld_course_grid .caption' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'default' => [
                        'top' => '30',
                        'right' => '30',
                        'bottom' => '30',
                        'left' => '30',
                        'unit' => 'px',
                        'isLinked' => true,
                    ],
                ]
            );
            $this->add_responsive_control(
                'single_course_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'widgetkit-pro' ),
                    'type'  => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors'  => [
                        '{{WRAPPER}} .ld_course_grid article.course' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow:hidden;',
                    ],
                ]
            );
        $this->end_controls_section();
#   endregion 

	}

    protected function render()
    {
        
        ?>

        <?php include( plugin_dir_path( __FILE__ ) . '../layout/learndash-course-list.php'); ?>

    <?php
    }

    protected function _content_template()
    {
    }

}
