<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;

if (!defined('ABSPATH')) exit; 

class Widgetkit_Pro_Headline_Slider extends Widget_Base
{

    public function get_name()
    {
        return 'widgetkit-pro-headline-slider';
    }

    public function get_title()
    {
        return __('Headline Slider', 'widgetkit-pro');
    }

    public function get_icon()
    {
        return 'eicon-thumbnails-right';
    }

    public function get_categories()
    {
        return ['widgetkit_pro'];
    }

    /**
	 * A list of style that the widgets is depended in
	 **/
	public function get_style_depends() {
        return [
            'widgetkit_bs',
            'widgetkit_pro_default',
        ];
    }
	/**
	 * A list of scripts that the widgets is depended in
	 **/
	public function get_script_depends() {
		return [ 
			'layout',
		 ];
	}


    protected function _register_controls()
    {
        $terms = get_terms( array(
            'taxonomy' => 'category',
            'hide_empty' => false,
        ) );
        $cat_names = array();
        foreach( $terms as $t ):
            $cat_names[$t->term_id] = $t->name;
        endforeach;

        /* slides content title subtitle button and button link */
        /**
         * Layout
         */
        $this->start_controls_section(
            'section_control_layout',
            [
                'label' => __('Layout', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'layout_style',
            [
                'label'       => __( 'Layout Style', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'layout-2',
                'options' => [
                    // 'layout-1'  => __( 'Layout 1', 'widgetkit-pro' ),
                    'layout-2'  => __( 'Layout 1', 'widgetkit-pro' ),
                ],
            ]
        );
        $this->end_controls_section();
        
        /**
         * Queries
         */
        $this->start_controls_section(
            'section_control_queries',
            [
                'label' => __('Queries', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'cat_name',
            [
                'label'       => __( 'Category List', 'widgetkit-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => $cat_names,
            ]
        );
        $this->add_control(
            'post_num_to_show',
            [
                'label'   => __( 'Number of Post to Show', 'widgetkit-pro' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 5,
                'min'     => 2,
                'max'     => 10,
                'step'    => 1,
            ]
        );
        $this->end_controls_section();

        /**
         * Headlines
         */
        $this->start_controls_section(
            'section_control_headline',
            [
                'label' => __('Headlines', 'widgetkit-pro'),
            ]
        );
        $this->add_control(
            'show_meta',
            [
                'label' => __( 'Show Meta', 'widgetkit-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Yes', 'widgetkit-pro' ),
                'label_off' => __( 'No', 'widgetkit-pro' ),
                'return_value' => 'yes',
                'condition' => [
                    'layout_style' => 'layout-2',
                ],
            ]
        );
        $this->add_control(
            'grid-gap',
            [
                'label' => __( 'Inner Spacing', 'widgetkit-pro' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 0,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                ],
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .post-list-wrapper, {{WRAPPER}} .regular-post' => 'grid-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /**
         * Primary column style
         */
        $this->start_controls_section(
            'section_style_primary',
            [
                'label' => __( 'Priamry Column', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Title Font', 'widgetkit-pro' ),
                'name' => 'selected_title_typography',
                'selector' => '{{WRAPPER}} .post-content span.dynamic-post-title',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Meta Font', 'widgetkit-pro' ),
                'name' => 'primary_title_typography',
                'selector' => '{{WRAPPER}} .post-content .wkp-post-meta',
            ]
        );
        /**
         * primary column tab
         */
        $this->start_controls_tabs('style_tab_primary_column');
            /**
             * Normal
             */
            $this->start_controls_tab(
                'primary_column_normal',
                [
                    'label' => __( 'Normal', 'widgetkit-pro' ),
                ]
            );
            $this->add_control(
                'highlight_title_color_normal',
                [
                    'label' => __( 'Title Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#fff',
                    'selectors' => [
                        '{{WRAPPER}} .post-content span.dynamic-post-title' => 'color: {{VALUE}}',
                    ],
                    
                ]
            );
            $this->end_controls_tab();
            /**
             * Hover
             */
            $this->start_controls_tab(
                'primary_column_hover',
                [
                    'label' => __( 'Hover', 'widgetkit-pro' ),
                ]
            );
            $this->add_control(
                'highlight_title_color_hover',
                [
                    'label' => __( 'Title Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#EEB90E',
                    'selectors' => [
                        '{{WRAPPER}} .post-content span.dynamic-post-title:hover' => 'color: {{VALUE}}',
                    ],
                    
                ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        
        $this->end_controls_section();
        
        /**
         * secondary column style
         */
        $this->start_controls_section(
            'section_style_secondary',
            [
                'label' => __( 'Secondary Column', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Title Font', 'widgetkit-pro' ),
                'name' => 'regular_post_title_typography',
                'selector' => '{{WRAPPER}} .regular-post .regular-post-title .layout-2-title-wrapper h3, {{WRAPPER}} .regular-post .regular-post-wrapper.active .regular-post-title .layout-2-title-wrapper h3',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Icon', 'widgetkit-pro' ),
                'name' => 'regular_icon_typography',
                'selector' => '{{WRAPPER}} .regular-post .regular-post-title span.icon-wrapper',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => __( 'Meta Font', 'widgetkit-pro' ),
                'name' => 'regular_post_meta_typography',
                'selector' => '{{WRAPPER}} .regular-post .regular-post-title .wkp-post-meta',
            ]
        );
        /**
         * secondary column tab
         */
        $this->start_controls_tabs('style_tab_secondary_column');
            /**
             * Normal
             */
            $this->start_controls_tab(
                'secondary_column_normal',
                [
                    'label' => __( 'Normal', 'widgetkit-pro' ),
                ]
            );
            $this->add_control(
                'title_bg_color',
                [
                    'label' => __( 'Background', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dynamic-category-tab-wrapper .regular-post-wrapper' => 'background-color: {{VALUE}}',
                    ],
                    
                ]
            );
            $this->add_control(
                'title_text_color',
                [
                    'label' => __( 'Title Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dynamic-category-tab-wrapper .post-title h3' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .dynamic-category-tab-wrapper .post-title span.icon-wrapper' => 'color: {{VALUE}}',
                    ],
                    
                ]
            );
            $this->add_control(
                'title_meta_color',
                [
                    'label' => __( 'Meta Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .dynamic-category-tab-wrapper .wkp-post-meta div' => 'color: {{VALUE}}',
                    ],
                    
                ]
            );
            $this->add_control(
                'box_shadow_hr',
                [
                    'type' => \Elementor\Controls_Manager::DIVIDER,
                ]
            );
            $this->add_control(
                'enable_box_shadow',
                [
                    'label' => __( 'Enable Box Shadow', 'widgetkit-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => '',
                    'description' => 'Enable Box Shadow',
                    'label_on' => __( 'Yes', 'widgetkit-pro' ),
                    'label_off' => __( 'No', 'widgetkit-pro' ),
                    'return_value' => 'yes',
                    
                ]
            );
            $this->add_control(
                'title_box_shadow',
                [
                    'label' => __( 'Title Box Shadow', 'widgetkit-pro' ),
                    'type' => Controls_Manager::BOX_SHADOW,
                    'default' => [
                        'color' => 'rgba(0,0,0,.08)',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .dynamic-category-tab-wrapper .regular-post-wrapper' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
                    ],
                    'condition' => [
                        'enable_box_shadow' => 'yes',
                    ],
                ]
            );
            $this->end_controls_tab();
            /**
             * Active
             */
            $this->start_controls_tab(
                'secondary_column_hover',
                [
                    'label' => __( 'Active', 'widgetkit-pro' ),
                ]
            );
            $this->add_control(
                'title_active_bg_color',
                [
                    'label' => __( 'Background', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#EEB90E',
                    'selectors' => [
                        '{{WRAPPER}} .dynamic-category-tab-wrapper .regular-post-wrapper.active' => 'background-color: {{VALUE}}',
                        '{{WRAPPER}} .dynamic-category-tab-wrapper .regular-post-wrapper:hover' => 'background-color: {{VALUE}}',
                    ],
                    
                ]
            );
            $this->add_control(
                'title_active_text_color',
                [
                    'label' => __( 'Title Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#fff',
                    'selectors' => [
                        '{{WRAPPER}} .dynamic-category-tab-wrapper .regular-post-wrapper.active .post-title h3' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .dynamic-category-tab-wrapper .regular-post-wrapper.active .post-title span.icon-wrapper' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .dynamic-category-tab-wrapper .regular-post-wrapper:hover .post-title h3' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .dynamic-category-tab-wrapper .regular-post-wrapper:hover .post-title span.icon-wrapper' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .dynamic-category-tab-wrapper a:hover' => 'color: {{VALUE}} !important',
                        '{{WRAPPER}} .dynamic-category-tab-wrapper a:hover h3' => 'color: {{VALUE}} !important',
                    ],
                    
                ]
            );
            $this->add_control(
                'title_active_meta_color',
                [
                    'label' => __( 'Meta Color', 'widgetkit-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '#fff',
                    'selectors' => [
                        '{{WRAPPER}} .dynamic-category-tab-wrapper .regular-post-wrapper.active .wkp-post-meta div' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .dynamic-category-tab-wrapper .regular-post-wrapper:hover .wkp-post-meta div' => 'color: {{VALUE}}',
                    ],
                    
                ]
            );
            // $this->add_control(
            //     'title_bg_hover_color',
            //     [
            //         'label' => __( 'Title Hover Background Color', 'widgetkit-pro' ),
            //         'type' => Controls_Manager::COLOR,
            //         'selectors' => [
            //             '{{WRAPPER}} .dynamic-category-tab-wrapper .regular-post-wrapper:hover' => 'background-color: {{VALUE}}',
            //         ],
                    
            //     ]
            // );
            // $this->add_control(
            //     'title_hover_title_color',
            //     [
            //         'label' => __( 'Title Hover Color', 'widgetkit-pro' ),
            //         'type' => Controls_Manager::COLOR,
            //         'selectors' => [
            //             '{{WRAPPER}} .dynamic-category-tab-wrapper .regular-post-wrapper:hover .post-title h3' => 'color: {{VALUE}}',
            //             '{{WRAPPER}} .dynamic-category-tab-wrapper .regular-post-wrapper:hover .post-title span.icon-wrapper' => 'color: {{VALUE}}',
            //             '{{WRAPPER}} .dynamic-category-tab-wrapper a:hover' => 'color: {{VALUE}} !important',
            //             '{{WRAPPER}} .dynamic-category-tab-wrapper a:hover h3' => 'color: {{VALUE}} !important',
            //         ],
                    
            //     ]
            // );
            // $this->add_control(
            //     'title_hover_text_color',
            //     [
            //         'label' => __( 'Title Hover Text Color', 'widgetkit-pro' ),
            //         'type' => Controls_Manager::COLOR,
            //         'selectors' => [
            //             '{{WRAPPER}} .dynamic-category-tab-wrapper .regular-post-wrapper:hover .post-title h3' => 'color: {{VALUE}}',
            //             '{{WRAPPER}} .dynamic-category-tab-wrapper .regular-post-wrapper:hover .post-title span.icon-wrapper' => 'color: {{VALUE}}',
            //         ],
                    
            //     ]
            // );
            // $this->add_control(
            //     'title_hover_meta_color',
            //     [
            //         'label' => __( 'Title Hover Meta Color', 'widgetkit-pro' ),
            //         'type' => Controls_Manager::COLOR,
            //         'selectors' => [
            //         ],
                    
            //     ]
            // );
            $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
        
        /**
         * Seperator and Overlay
         */
        $this->start_controls_section(
            'content_style_seperator_overlay',
            [
                'label' => __( 'Seperator & Overlay', 'widgetkit-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'overlay_color',
            [
                'label' => __( 'Overlay Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dynamic-category-tab .post-content .tab-post-thumb a:after' => 'background: linear-gradient(180deg, rgba(0, 0, 0, 0.01), {{VALUE}})',
                ],
                
            ]
        );
        
        
        $this->add_control(
            'ajax_overlay_color',
            [
                'label' => __( 'Ajax Overlay Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dynamic-category-tab-wrapper .ajax-content' => 'background: {{VALUE}} !important',
                ],
                
            ]
        );
        $this->add_control(
            'ajax_overlay_dot_color',
            [
                'label' => __( 'Ajax Overlay Dot Color', 'widgetkit-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dynamic-category-tab-wrapper .ajax-content .lds-ellipsis div' => 'background: {{VALUE}}',
                ],
                
            ]
        );
        
        $this->end_controls_section();

        /**
         * Style tab
         * =============
         */
        // $this->start_controls_section(
        //     'section_style',
        //     [
        //         'label' => __( 'Typography', 'widgetkit-pro' ),
        //         'tab' => Controls_Manager::TAB_STYLE,
        //     ]
        // );
        /**
         * regular title
         */
        // $this->add_control(
        //     'regular_title',
        //     [
        //         'label' => __( 'Regular Post Title', 'widgetkit-pro' ),
        //         'type' => Controls_Manager::HEADING,
        //         'separator' => 'before',
        //     ]
        // );
        
        // $this->end_controls_section();


        // $this->start_controls_section(
        //     'content_style',
        //     [
        //         'label' => __( 'Content', 'widgetkit-pro' ),
        //         'tab' => Controls_Manager::TAB_STYLE,
        //     ]
        // );

        // $this->add_control(
        //     'custom_color',
        //     [
        //         'label' => __( 'Custom Color', 'widgetkit-pro' ),
        //         'type' => Controls_Manager::SWITCHER,
        //         'default' => '',
        //         'description' => 'Show custom color for content',
        //         'label_on' => __( 'Yes', 'widgetkit-pro' ),
        //         'label_off' => __( 'No', 'widgetkit-pro' ),
        //         'return_value' => 'yes',
        //     ]
        // );
        
        // $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings();

        $layout = widgetkit_pro_array_get($settings, 'layout_style');
        $cat_id = widgetkit_pro_array_get($settings, 'cat_name');
        $show_meta = widgetkit_pro_array_get($settings, 'show_meta');
        $post_num_to_show = widgetkit_pro_array_get($settings, 'post_num_to_show');

        /**
         * term meta value
         * ================
         */
        $tax_term = get_term_meta($cat_id);
        $tax_image = widgetkit_pro_array_get($tax_term, 'magmax_tax_image')[0];
        $tax_tag_bg_color = widgetkit_pro_array_get($tax_term, 'magmax_tax_tag_bg_color')[0];

    ?>
    <?php
        if('layout-1' == $layout){
            include( plugin_dir_path( __FILE__ ) . '../layout/dynamic-category-tab.php');
        }else{
            include( plugin_dir_path( __FILE__ ) . '../layout/layout-2-dynamic-category-tab.php');
        }

        ?>
        <script>
            jQuery(function($){
                /**
                 * Dynamic Category Tab
                 * ====================
                 */
                if( $('#<?php echo $this->get_id(); ?> .regular-post-wrapper').hasClass('active') )
                {
                    var handle = $('#<?php echo $this->get_id(); ?> .regular-post .regular-post-wrapper.active').each(function(){ $(this).parent().attr('id') });
                    $(handle).each(function(){
                        dynamicTabData($(this));
                    });
                }
                $('.dynamic-category-tab .regular-post-wrapper').on('click', function(e){
                    var parentID = $(this).parent().attr('id');
                    var rootID = '#dynamic-category-tab-' + parentID;

                    e.preventDefault(); // prevent execute
                    $(rootID).find('.regular-post-wrapper').removeClass('active'); // remove existing content
                    $(this).addClass('active'); // add active class to existing item

                    dynamicTabData($(this));
                });

                function dynamicTabData($handle){
                    var parentID = $handle.parent().attr('id');
                    var rootID = '#dynamic-category-tab-' + parentID;
                    var postID = $handle.attr('data-id');

                    $.ajax({
                        url: ajaxpagination.ajaxurl,
                        type: 'post',
                        data: {
                            action: 'dynamic_category_tab',
                            postID: postID
                        },
                        beforeSend: function() {
                            $(rootID).find('.post-content .tab-post-thumb').append( '<div class="ajax-content"><div class="lds-ellipsis"><div></div><div></div><div></div><div></div></div></div>' );
                        },
                        success: function( html ) {
                            $(rootID).find('.post-content .tab-post-thumb').remove();
                            $(rootID).find('.post-list-wrapper .post-content').append(html);
                        },
                        error: function(e) {
                            console.log(e);
                        }
                    });
                    return false;
                }
            });
        </script>

    <?php
    }

    protected function _content_template()
    {
    }
}
