<?php
/*
Plugin Name: WidgetKit Pro 
Description: Huge collection of pro quality element or section for use in Elementor page builder,which you help to create any kind of complicated design without coding.  Elementor Page Builder must be installed and activated.
Version: 1.6
Text Domain: widgetkit-pro
Author: Themesgrove
Author URI: https://themesgrove.com
Plugin URI: http://widgetkit.themesgrove.com/
License: GPL3
License URI: https://www.gnu.org/licenses/gpl-3.0.txt
@package  WidgetKit_Pro
Domain Path: /languages
*/

    if( !defined( 'ABSPATH' ) ) exit; 
    define('WKP_VERSION', '1.6');
    define('WKP_FILE', __FILE__);
    define('WKP_URL', plugins_url('/', __FILE__ ) );
    define('WKP_CORE_ROOT', plugin_dir_path( __FILE__ ) );
    define('WKP_PATH', plugin_dir_path( __FILE__ ) );
    define('WKP_PLACEHOLDER_URL', WKP_URL.'dist/images/placeholder.jpg' );


    class WidgetKit_Pro {
        public $woocommerce_main_file = 'woocommerce/woocommerce.php';
        
        
        public function activate(){
            flush_rewrite_rules();
        }
        public function deactivate(){
            flush_rewrite_rules();
        }
        public function __construct() {
            add_action( 'init', [ $this, 'wkpro_load_update_files'] );
            add_action( 'plugins_loaded', array( $this, 'plugin_setup' ) );
            add_action( 'elementor/init', array( $this, 'elementor_init' ) );
            add_action( 'init', array( $this, 'elementor_resources' ), -999 );
            add_action( 'init', [ $this, 'wkp_register_wc_hooks' ], 5 );

        }
        public function plugin_setup(){
            require_once(WKP_PATH. 'inc/widgetkit-pro-filter.php');
            WKFE_PRO_Filter_Pro::init();

            if(is_admin()){
                $this->check_dependency();
            }
        }
        public function wkpro_load_update_files(){
            require_once(WKP_PATH. 'inc/update_notification.php');
            WKFE_PRO_Update_Notification::init();
        }
        

        public function load_admin_files() {
            require_once WKP_CORE_ROOT . '/admin/admin-init.php';
            require_once WKP_CORE_ROOT . '/admin/includes/system-info.php';
        }
        public function elementor_init(){
            require_once(WKP_PATH. 'inc/elementor-integration.php');
            require_once(WKP_PATH. 'inc/elements.php');
        }
        public function elementor_resources() {
            require_once ( WKP_PATH . 'inc/register-resources.php' );
            WKP_Resources::init();
        }
        public function wkp_register_wc_hooks() {
            if ( ! function_exists( 'get_plugins' ) ) {
                require_once ABSPATH . 'wp-admin/includes/plugin.php';
            }
            $installed_plugins = get_plugins();
            $site_has_woocommerce = isset($installed_plugins[$this->woocommerce_main_file]);
            if($site_has_woocommerce && class_exists( 'WooCommerce' )){
                wc()->frontend_includes();
            }
        }
        public function check_dependency(){
            require_once(WKP_PATH. 'inc/dependency.php');
            WKP_Dependency::init();
        }

    }

    if (class_exists('WidgetKit_Pro')) {
        $widgetkit_pro = new WidgetKit_Pro();
    }

    register_activation_hook( __FILE__, array($widgetkit_pro, 'activate' ));
    register_deactivation_hook( __FILE__, array($widgetkit_pro, 'deactivate' ));