<?php

if( ! defined( 'ABSPATH' ) ) exit();

class WKP_Resources{

    private static $instance;
    public static function init(){
        if(null === self::$instance ){
            self::$instance = new self;
        }
        return self::$instance;
    }

    public function __construct(){
        // add_action( 'elementor/preview/enqueue_styles', array( $this, 'widgetkit_enqueue_preview_styles' ) );
        add_action( 'elementor/frontend/after_register_styles', array( $this, 'widgetkit_pro_register_frontend_styles' ) );
        add_action( 'elementor/frontend/after_register_scripts', array( $this, 'widgetkit_register_frontend_scripts' ) );
    }
    
    public function widgetkit_pro_register_frontend_styles(){

        wp_register_style( 'widgetkit_pro_base', WKP_URL.'dist/css/base.css', array(), WKP_VERSION, 'all');
        wp_register_style( 'widgetkit_pro_default', WKP_URL.'dist/css/default.css', array(), WKP_VERSION, 'all');
        wp_register_style( 'owl-css', WKP_URL.'dist/css/owl.carousel.min.css', array(), WKP_VERSION, 'all');
        wp_register_style( 'animate-css', WKP_URL.'dist/css/animate.css', array(), WKP_VERSION, 'all');
        wp_register_style( 'fontawesome', WKP_URL.'dist/css/font-awesome.min.css', array(), WKP_VERSION, 'all');
        wp_register_style( 'widgetkit_pro_demo', WKP_URL.'dist/css/plugin-demo.css', array(), WKP_VERSION, 'all');
        // wp_register_style( 'widgetkit_main', WKP_URL.'/assets/css/widgetkit.css', array(), WKP_VERSION, 'all');
        
    }
    
    public function widgetkit_enqueue_preview_styles() {
        wp_enqueue_style('owl-css');
        wp_enqueue_style('animate-css');
        wp_enqueue_style('fontawesome');
        wp_enqueue_style('ionsicon');
    }

    public function widgetkit_register_frontend_scripts(){

        wp_register_script( 'bootstarp-js', WKP_URL. 'dist/js/bootstrap.js', array('jquery'), WKP_VERSION, true);
        wp_register_script( 'magnific-js', WKP_URL. 'dist/js/jquery.magnific-popup.js', array('jquery'), WKP_VERSION, true);
        wp_register_script( 'owl-carousel', WKP_URL. 'dist/js/owl.carousel.min.js', array('jquery'), WKP_VERSION, true);
        wp_register_script( 'modernizr', WKP_URL. 'dist/js/modernizr.custom.86080.js', array('jquery'), WKP_VERSION, true);
        wp_register_script( 'elementor', WKP_URL. 'dist/js/elementor.js', array('jquery'), WKP_VERSION, true);
        wp_register_script( 'layout', WKP_URL. 'dist/js/layout.js', array('jquery'), WKP_VERSION, true);
        wp_register_script( 'wkp-learnpress', WKP_URL. 'dist/js/wkp_learnpress.js', array('jquery'), WKP_VERSION, true);
        wp_register_script( 'love', WKP_URL. 'dist/js/love.js', array('jquery'), WKP_VERSION, true);
        wp_register_script( 'learndash_dynamic_category', WKP_URL. 'dist/js/learndash_dynamic_category.js', array('jquery'), WKP_VERSION, true);
        wp_register_script( 'sensei_dynamic_category', WKP_URL. 'dist/js/sensei_dynamic_category.js', array('jquery'), WKP_VERSION, true);
        wp_register_script( 'wk-pro-js', WKP_URL. 'dist/js/widgetkit-pro.js', array('jquery'), WKP_VERSION, true);
        wp_register_script( 'wk-pro-tilt-js', WKP_URL. 'dist/js/tilt.jquery.min.js', array('jquery'), WKP_VERSION, true);
        wp_localize_script( 'layout', 'ajaxpagination', array(
            'ajaxurl' => admin_url( 'admin-ajax.php' ),
        ));
        
    }

}
