<?php
// namespace Elementor;

// function wigetkit_pro_elementor_init(){
//     Plugin::instance()->elements_manager->add_category(
//         'widgetkit_pro',
//         [
//             'title'  => __('Widgetkit Pro', 'widgetkit-pro'),
//             'icon'   => 'eicon-font'
//         ],
//         1
//     );
// }
// add_action('elementor/init','Elementor\wigetkit_pro_elementor_init');


// if (!function_exists('widgetkit_pro_widgetkit_pro_array_get')) {
//     function widgetkit_pro_widgetkit_pro_array_get($array, $key, $default = null)
//     {
//         if (!is_array($array)) return $default;
//         return array_key_exists($key, $array) ? $array[$key] : $default;
//     }
// }

// add_filter( 'widget_text', 'do_shortcode' );

if(!function_exists('widgetkit_pro_array_get')) {
    function widgetkit_pro_array_get($array, $key, $default=null){
        if(!is_array($array)) return $default;
        return array_key_exists($key, $array) ? $array[$key] : $default;
    }
}
if(!function_exists('widgetkit_pro_get_woo_product_gallery')) {
    function widgetkit_pro_get_woo_product_gallery($product_id){
        $product = new WC_product($product_id);
        $attachment_ids = $product->get_gallery_image_ids();
        $gallery_urls = [];
        foreach( $attachment_ids as $attachment_id ) 
        {
          // Display the image URL

            $original_image_url = wp_get_attachment_url( $attachment_id );
            array_push($gallery_urls, $original_image_url);
          // Display Image instead of URL
        //   echo wp_get_attachment_image($attachment_id, 'full');

        }
        return $gallery_urls;
    }
}

/**
 * Dynamic category
 * =================
 */
add_action( 'wp_ajax_nopriv_dynamicCat', 'dynamic_cat' );
add_action( 'wp_ajax_dynamicCat', 'dynamic_cat' );
if(! function_exists('dynamic_cat')){
    function dynamic_cat(){
        $cat_id = $_REQUEST['term_id'];
        $number_of_post_to_show = $_REQUEST['pn'];
        
        $dataStyle = $_REQUEST['dataStyle'];
        $primayThumbSize = $_REQUEST['primayThumbSize'];
        $primaryContentPosition = $_REQUEST['primaryContentPosition'];
        $primaryMeta = $_REQUEST['primaryMeta'];
        $primaryExcerpt = $_REQUEST['primaryExcerpt'];
        $primaryExcerptLength = $_REQUEST['primaryExcerptLength'];
        $seondaryColumn = $_REQUEST['seondaryColumn'];
        $secondaryImagePosition = $_REQUEST['secondaryImagePosition'];
        $secondaryThumbSize = $_REQUEST['secondaryThumbSize'];
        $secondaryMeta = $_REQUEST['secondaryMeta'];
        $secondaryExcerpt = $_REQUEST['secondaryExcerpt'];
        $secondaryExcerptLength = $_REQUEST['secondaryExcerptLength'];


        $tax_term = get_term_meta($cat_id);
        // $tax_tag_bg_color = widgetkit_pro_array_get($tax_term, 'magmax_tax_tag_bg_color')[0];
        /**
         * Argument
         * for query post
         * ================
         */
        $count = 0;
        $args = array(
            'cat' => $cat_id,
            'post_type' =>  'post',
            'posts_per_page' => $number_of_post_to_show,
        );
        

        $query = new WP_Query($args);
        ?>
        <div
            data-style="<?php echo $dataStyle; ?>"
            data-primayThumbSize="<?php echo $primayThumbSize; ?>"
            data-primaryContentPosition="<?php echo $primaryContentPosition; ?>"
            data-primaryMeta="<?php echo $primaryMeta; ?>"
            data-primaryExcerpt="<?php echo $primaryExcerpt; ?>"
            data-primaryExcerptLength="<?php echo $primaryExcerptLength; ?>"
            data-seondaryColumn="<?php echo $seondaryColumn; ?>"
            data-secondaryImagePosition="<?php echo $secondaryImagePosition; ?>"
            data-secondaryThumbSize="<?php echo $secondaryThumbSize; ?>"
            data-secondaryMeta="<?php echo $secondaryMeta; ?>"
            data-secondaryExcerpt="<?php echo $secondaryExcerpt; ?>"
            data-secondaryExcerptLength="<?php echo $secondaryExcerptLength; ?>"
            class="cat-post-list dynamic-cat-post-list animated fadeIn <?php echo 'layout-'.$dataStyle; ?> <?php echo 'grid-'.$seondaryColumn; ?> <?php echo 'regular-grid-'.$secondaryImagePosition; ?>">
            <?php
            if($query->have_posts()):
                ?>
                <div class="cat-post-list-wrapper <?php echo 'featured-style-'. $primaryContentPosition; ?>">
    
                    <?php
                    while($query->have_posts()):
                        $query->the_post();
                        ?>
                        <?php if($count == 0): ?>
                        <div class="featured-post" style="grid-row: span <?php echo $number_of_post_to_show - 1 ;?>">
                            <?php
                                if($primaryContentPosition === 'before-image'){
                                    ?>
                                    <div class="post-data">
                                        <div class="post-title">
                                            <a href="<?php the_permalink(); ?>" class="highlight-post-title highlight-title">
                                                <h3><?php the_title(); ?></h3>
                                            </a>
                                        </div>
                                        <?php if($primaryMeta):?>
                                            <div class="wkp-post-meta">
                                                <div class="post-author"><?php echo get_the_author(); ?></div>
                                                <div class="seperator"> <span><?php esc_html_e('|', 'magmax'); ?></span></div>
                                                <div class="post-date"><?php echo get_the_date(); ?></div>
                                            </div>
                                        <?php endif;?>
                                    </div>
                                    <?php
                                }
                            ?>
                            <?php if(has_post_thumbnail()): ?>
                                <div class="post-thumb">
                                    <a href="<?php the_permalink() ?>">
                                        <?php the_post_thumbnail($primaryThumbnailSize); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                            <?php if( $primaryContentPosition == 'overlay' || $primaryContentPosition == 'after-image' ): ?>
                            <div class="post-data">
                                <div class="post-title">
                                    <a href="<?php the_permalink(); ?>" class="highlight-post-title highlight-title">
                                        <h3><?php the_title(); ?></h3>
                                    </a>
                                </div>
                                <?php if($primaryMeta):?>
                                    <div class="wkp-post-meta">
                                        <div class="post-author"><?php echo get_the_author(); ?></div>
                                        <div class="seperator"> <span><?php esc_html_e('|', 'magmax'); ?></span></div>
                                        <div class="post-date"><?php echo get_the_date(); ?></div>
                                    </div>
                                <?php endif; ?>
                                <?php if($primaryExcerpt):?>
                                    <div class="post-excerpt">
                                        <?php echo wp_trim_words(get_the_excerpt(), $primaryExcerptLength, ''); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>
    
                            <?php if($primaryExcerpt && $primaryContentPosition === 'before-image' ):?>
                                <div class="post-excerpt">
                                <?php echo wp_trim_words(get_the_excerpt(), $primaryExcerptLength, ''); ?>
                                </div>
                            <?php endif; ?>
                            
                        </div>
                    <?php else: ?>
                        <div class="regular-post">
                            <div class="regular-post-wrapper">
                                <?php if(has_post_thumbnail()): ?>
                                    <div class="post-thumb col-md-4">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php the_post_thumbnail($secondaryThumbnailSize ); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                                <div class="post-data col-md-8">
                                    <div class="post-title">
                                        <a href="<?php the_permalink(); ?>" class="regular-post-title regular-title">
                                            <h3><?php the_title(); ?></h3>
                                        </a>
                                    </div>
                                    <?php if($secondaryMeta):?>
                                    <div class="wkp-post-meta">
                                        <div class="post-author"><?php echo get_the_author(); ?></div>
                                        <div class="seperator"> <span><?php esc_html_e('|', 'magmax'); ?></span></div>
                                        <div class="post-date"><?php echo get_the_date(); ?></div>
                                    </div>
                                    <?php endif;?>
                                    <?php if($secondaryExcerpt):?>
                                        <div class="post-excerpt">
                                        <?php echo wp_trim_words(get_the_excerpt(), $secondaryExcerptLength, ''); ?>
                                        </div>
                                    <?php endif;?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                        <?php
                        $count++;
                    endwhile;
                    wp_reset_postdata();
                    ?>
                </div>
                <?php
            endif;
            ?>
        </div>
        <!--cat-post-list-->
        <?php
        //wp_reset_query();
        die();
    }
}



/**
 * smart list element
 * ===================
 * Multiple category
 * ajax pagination
 * ==================
 */
add_action( 'wp_ajax_nopriv_multiple_cateogry_ajax_pagination', 'multiple_category_ajax_pagination' );
add_action( 'wp_ajax_multiple_cateogry_ajax_pagination', 'multiple_category_ajax_pagination' );
if(! function_exists('multiple_category_ajax_pagination')){
    function multiple_category_ajax_pagination() {
        $count = 0;
        $paged = $_POST['page'] ? $_POST['page'] : 1;
        $layout = $_POST['layout'];
        $grid = $_POST['grid'];
        $grid_style = $_POST['gridStyle'];
        $highlightFirstPost = $_POST['highlightFirstPost'];
        $highlightCatTag = $_POST['highlightCatTag'];
        $show_regular_thumbnail = $_POST['regularThumbnail'];
        $regularCatTag = $_POST['regularCatTag'];
        $featuredThumbSize = $_POST['featuredThumbSize'];
        $regularThumbSize = $_POST['regularThumbSize'];
        $regularTitleWordCount = $_POST['regularTitleWordCount'];
        $section_id = $_POST['sectionId'];
        $cat_id = $_POST['catID'];
        $cat_multiple_id = explode('_', $cat_id);
        $post_num_to_show = $_POST['postNumber'];
        $showFeaturedExcerpt = $_POST['showFeaturedExcerpt'];
        $featuredExcerptWordCount = $_POST['featuredExcerptWordCount'];
        $showRegularExcerpt = $_POST['showRegularExcerpt'];
        $regularExcerptWordCount = $_POST['regularExcerptWordCount'];

        $args = array(
            'category__in' => $cat_multiple_id,
            'posts_per_page' => $post_num_to_show,
            'paged' => $paged,
            'post_type' => 'post'
        );
        $query = new WP_Query($args);
        ?>

        <nav class="multiple-category-navigation <?php echo ($paged == $query->max_num_pages) ? 'last-page' : ''; ?> <?php echo ($paged == 1) ? 'first-page': ''; ?>">
            <ul data-page="<?php echo $paged; ?>"
                class="multiple-category-navigation-wrapper"

                data-sectionId="<?php echo $section_id; ?>"
                data-catId="<?php echo $cat_id; ?>"
                data-highlightFirstPost="<?php echo $highlightFirstPost; ?>"
                data-regularThumbnail="<?php echo $show_regular_thumbnail; ?>"
                data-highlightCatTag="<?php echo $highlightCatTag; ?>"
                data-regularCatTag="<?php echo $regularCatTag; ?>"
                data-postNumber="<?php echo $post_num_to_show; ?>"
                data-featuredThumbSize="<?php echo $featuredThumbSize; ?>"
                data-regularThumbSize="<?php echo $regularThumbSize; ?>"
                data-regularTitleWordCount="<?php echo $regularTitleWordCount; ?>"
                data-showFeaturedExcerpt="<?php echo $showFeaturedExcerpt; ?>"
                data-featuredExcerptWordCount="<?php echo $featuredExcerptWordCount; ?>"
                data-showRegularExcerpt="<?php echo $showRegularExcerpt; ?>"
                data-regularExcerptWordCount="<?php echo $regularExcerptWordCount; ?>"
            >

                <li class="multiple-cateogry-prev">
                    <span><i class="fa fa-angle-left"></i></span>
                </li>
                <li class="multiple-cateogry-next">
                    <span><i class="fa fa-angle-right"></i></span>
                </li>
            </ul>
        </nav>

        <div data-layout="<?php echo $layout; ?>" data-grid="<?php echo $grid; ?>" data-style="<?php echo $grid_style; ?>"
             class="cat-post-list dynamic-cat-post-list <?php echo 'grid-'.$grid; ?> <?php echo $grid_style; ?>">
            <?php if($query->have_posts()): ?>
                <div class="cat-post-list-wrapper">
                    <?php while($query->have_posts()): $query->the_post(); ?>
                        <?php if($count == 0 && ($highlightFirstPost == 'yes')): ?>
                            <div class="featured-post">

                                <?php if(has_post_thumbnail()): ?>
                                    <div class="post-thumb">
                                        <a href="<?php the_permalink() ?>">
                                            <?php the_post_thumbnail($featuredThumbSize); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                                <div class="post-data">
                                    <?php if(('multiple-category-dynamic-carousel-layout-2' == $layout) || ('multiple-category-dynamic-carousel-layout-3' == $layout)): ?>
                                        <?php if($highlightCatTag): ?>
                                        <div class="post-cat">
                                            <?php magmax_limited_cateory_with_seperator_for_elements(get_the_ID()); ?>
                                        </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <div class="post-title">
                                        <a href="<?php the_permalink(); ?>" class="highlight-post-title highlight-title">
                                            <h3><?php the_title(); ?></h3>
                                        </a>
                                    </div>
                                    <div class="post-meta">
                                        <div class="post-author"><?php echo get_the_author(); ?></div>
                                        <div class="seperator"> <span><?php esc_html_e('|', 'magmax'); ?></span></div>
                                        <div class="post-date"><?php echo get_the_date(); ?></div>
                                    </div>
                                    <?php if($showFeaturedExcerpt):?>
                                        <div class="post-excerpt">
                                            <?php echo wp_trim_words(get_the_excerpt(), $featuredExcerptWordCount, '');?>
                                        </div>  
                                    <?php endif;?>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="regular-post">
                                <div class="regular-post-wrapper animated fadeIn">
                                    <?php if(has_post_thumbnail() && ('yes' == $show_regular_thumbnail)): ?>
                                        <div class="post-thumb">
                                            <a href="<?php the_permalink(); ?>">
                                                <?php the_post_thumbnail($regularThumbSize ); ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>

                                    <div class="post-data">
                                        <?php if(('multiple-category-dynamic-carousel-layout-2' == $layout) || ('multiple-category-dynamic-carousel-layout-3' == $layout)): ?>
                                            <?php if($regularCatTag): ?>
                                                <div class="post-cat">
                                                    <?php magmax_limited_cateory_with_seperator_for_elements(get_the_ID()); ?>
                                                </div>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <div class="post-title">
                                            <a href="<?php the_permalink(); ?>" class="regular-post-title regular-title">
                                                <?php if(('multiple-category-dynamic-carousel-layout-2' == $layout) || ('multiple-category-dynamic-carousel-layout-3' == $layout)): ?>
                                                    <h3>
                                                        <?php magmax_title($regularTitleWordCount); ?>
                                                    </h3>
                                                <?php else: ?>
                                                    <h3>
                                                        <?php the_title(); ?>
                                                    </h3>
                                                <?php endif; ?>
                                            </a>
                                        </div>
                                        <div class="post-meta">
                                            <div class="post-author"><?php echo get_the_author(); ?></div>
                                            <div class="seperator"> <span><?php esc_html_e('|', 'magmax'); ?></span></div>
                                            <div class="post-date"><?php echo get_the_date(); ?></div>
                                        </div>
                                        <?php if($showRegularExcerpt):?>
                                        <div class="post-excerpt">
                                            <?php echo wp_trim_words(get_the_excerpt(), $regularExcerptWordCount, '');?>
                                        </div>
                                        <?php endif;?>
                                    </div>

                                </div>
                            </div>
                        <?php endif; ?>
                        <?php $count++; endwhile; wp_reset_postdata(); ?>
                </div>
            <?php endif; ?>
        </div>
        <?php //wp_reset_query(); ?>
        <?Php
        die();
    }
}


/**
 * Single category
 * dynamic tab
 * ================
 */
add_action('wp_ajax_dynamic_category_tab', 'magmax_dynamic_category_tab');
add_action('wp_ajax_nopriv_dynamic_category_tab', 'magmax_dynamic_category_tab');
if(! function_exists('magmax_dynamic_category_tab')){
    function magmax_dynamic_category_tab(){
        $post_id = $_POST['postID'];
        $args = array(
            'p' => $post_id,
            'orderby'	=> 'date',
            'order'		=> 'DESC',
            'post_type' =>  'post',
        );
        $query = new WP_Query($args);
        if($query->have_posts()):
            while($query->have_posts()):
                $query->the_post();
        ?>
            <div class="tab-post-thumb">
                <?php
                /**
                 * filter the content
                 * and get the first video
                 * from the content
                 */
                $content = apply_filters( 'the_content', get_the_content() );
                $video = false;
                /**
                 * Only get video from the content if a playlist isn't present.
                 */
                if (false === strpos($content, 'wp-playlist-script')) {
                    $video = get_media_embedded_in_content($content, array('video', 'object', 'embed', 'iframe'));
                }
                ?>
                <?php
                /**
                 * If there is video
                 * then pick the first one
                 * for the thumbnail
                 */
                if($video):
                    ?>
                    <div class="tab-video-thumbnail">
                        <div class="tab-entry-video">
                            <?php
                            echo wp_kses($video[0], array(
                                'iframe'	=> array(
                                    'src'             => array(),
                                    'height'          => array(),
                                    'width'           => array(),
                                    'frameborder'     => array(),
                                    'allowfullscreen' => array(),
                                ),
                            ));
                            ?>
                        </div>
                    </div>
                <?php else: ?>
                    <?php
                    /**
                     * If there is no image in the content
                     * then pick the featured image
                     * for the thumbnail
                     */
                    if (has_post_thumbnail()):
                        ?>
                            <a href="<?php the_permalink(); ?>">
                                <?php the_post_thumbnail('full'); ?>
                                <span class="dynamic-post-title">
                                    <?php the_title(); ?>
                                </span>
                            </a>
                    <?php else: ?>
                        <a href="<?php the_permalink(); ?>">
                            <img src="<?php echo esc_url(WKP_PLACEHOLDER_URL); ?>" alt="">
                            <span class="dynamic-post-title">
                                <?php the_title(); ?>
                            </span>
                        </a>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        <?php
            endwhile;
            //wp_reset_postdata();
        endif;
        die;
    }
}


if(! function_exists('magmax_limited_cateory_with_seperator_for_elements')){
    function magmax_limited_cateory_with_seperator_for_elements($post_id, $cat_count = 2){
        $post_terms = get_the_terms($post_id, 'category');
        $slice_post_term = array_slice($post_terms, 0, $cat_count);
        $term_array = [];
        foreach($slice_post_term as $p):
            ?>
            <?php $term_array[] = '<a class="cat-item" href="'.  get_term_link($p->term_id) .'">'.ucfirst($p->name) .'</a>'; ?>
            <?php
        endforeach;
        echo implode( ' | ', $term_array );
    }
}

/**
 * function magmax_title()
 * @param $words optional
 * how many words you want to display
 * in the title
 */
if(! function_exists('magmax_title')){
    function magmax_title($words = -1){
        $title = wp_trim_words(get_the_title(), $num_words = $words, $more = '');
        echo esc_html($title);
    }
}
/*
 * Learndash Dynamic courses category added by sumon
 * =================
 */

add_action( 'wp_ajax_nopriv_learndashDynamicCat', 'learndash_dynamic_cat' );
add_action( 'wp_ajax_learndashDynamicCat', 'learndash_dynamic_cat' );
if(! function_exists('learndash_dynamic_cat')){
    function learndash_dynamic_cat(){
        $cat_id = $_REQUEST['term_id'];
        $post_num_to_show = $_REQUEST['pn'];
        $regularThumbSize = $_REQUEST['rts'];
        $coursePrice = $_REQUEST['coursePrice'];
        $courseDesc = $_REQUEST['courseDesc'];
        $courseButton = $_REQUEST['courseButton'];
        $courseHeight = $_REQUEST['courseHeight'];
        $postsColumn = $_REQUEST['postsColumn'];
        $activeCarousel = $_REQUEST['activeCarousel'];
        /**
         * Argument
         * for query post
         * ================
         */
        $count = 0;
        $args = array(
            'post_type' =>  'sfwd-courses',
            'posts_per_page' => $post_num_to_show,
            'tax_query' => array(
                array(
                    'taxonomy' => 'ld_course_category',
                    'field' => 'term_id',
                    'terms'    => $cat_id
                ),
            ),
        );

        $query = new WP_Query($args);
        ?>
        <div
            data-coursePrice="<?php echo $coursePrice; ?>"
            data-courseDesc="<?php echo $courseDesc; ?>"
            data-courseButton="<?php echo $courseButton; ?>"
            data-postsColumn="<?php echo $postsColumn; ?>"
            data-activeCarousel="<?php echo $activeCarousel; ?>"
            class="cat-post-list dynamic-cat-post-list animated fadeIn">
            <div id="lp-dynamic-course-carousel" class="<?php echo $activeCarousel ? 'lp-dynamic-course-active owl-carousel' : ''; ?>">
                <?php

                if($query->have_posts()):
                    while($query->have_posts()):
                        $query->the_post();


                  global $post; $post_id = $post->ID;
                  $course_id = $post_id;
                  $user_id   = get_current_user_id();
                  $current_id = $post->ID;

                  $enable_video = get_post_meta( $post->ID, '_learndash_course_grid_enable_video_preview', true );
                  $embed_code   = get_post_meta( $post->ID, '_learndash_course_grid_video_embed_code', true );
                  $button_text  = get_post_meta( $post->ID, '_learndash_course_grid_custom_button_text', true );

                  // Retrive oembed HTML if URL provided
                  if ( preg_match( '/^http/', $embed_code ) ) {
                      $embed_code = wp_oembed_get( $embed_code, array( 'height' => 600, 'width' => 400 ) );
                  }

                  $button_text = isset( $button_text ) && ! empty( $button_text ) ? $button_text : __( 'See more...', 'widgetkit-pro' );

                  $button_text = apply_filters( 'learndash_course_grid_custom_button_text', $button_text, $post_id );

                  $options = get_option('sfwd_cpt_options');
                  $currency = null;

                  if ( ! is_null( $options ) ) {
                      if ( isset($options['modules'] ) && isset( $options['modules']['sfwd-courses_options'] ) && isset( $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'] ) )
                      $currency = $options['modules']['sfwd-courses_options']['sfwd-courses_paypal_currency'];
                  }

                  if( is_null( $currency ) )
                      $currency = 'USD';

                  $course_options = get_post_meta($post_id, "_sfwd-courses", true);
                  $price = $course_options && isset($course_options['sfwd-courses_course_price']) ? $course_options['sfwd-courses_course_price'] : __( 'Free', 'widgetkit-pro' );
                  $short_description = @$course_options['sfwd-courses_course_short_description'];

                  $has_access   = sfwd_lms_has_access( $course_id, $user_id );
                  $is_completed = learndash_course_completed( $user_id, $course_id );

                  if( $price == '' )
                      $price .= __( 'Free', 'widgetkit-pro' );

                  if ( is_numeric( $price ) ) {
                      if ( $currency == "USD" )
                          $price = '$' . $price;
                      else
                          $price .= ' ' . $currency;
                  }

                  $class       = '';
                  $ribbon_text = '';

                  if ( $has_access && ! $is_completed ) {
                      $class = 'ld_course_grid_price ribbon-enrolled';
                      $ribbon_text = __( 'Enrolled', 'widgetkit-pro' );
                  } elseif ( $has_access && $is_completed ) {
                      $class = 'ld_course_grid_price';
                      $ribbon_text = __( 'Completed', 'widgetkit-pro' );
                  } else {
                      $class = ! empty( $course_options['sfwd-courses_course_price'] ) ? 'ld_course_grid_price price_' . $currency : 'ld_course_grid_price free';
                      $ribbon_text = $price;
                  }

                        ?>
 
                      <div class="<?php echo $activeCarousel ? 'col-md-12 ': '' ;?>  col-sm-<?php echo $postsColumn; ?>">
                      <article id="post-<?php the_ID(); ?>" <?php post_class('course'); ?>>
                          

                      <?php if ($post->post_type == 'sfwd-courses' && $coursePrice && has_post_thumbnail()): ?>
                      <div class="<?php echo esc_attr($class); ?>">
                          <?php echo esc_attr($ribbon_text); ?>
                      </div>
                      <?php endif;?>

                      <?php if (1 == $enable_video && !empty($embed_code)): ?>
                          <div class="ld_course_grid_video_embed">
                          <?php echo $embed_code; ?>
                          </div>
                          <?php elseif (has_post_thumbnail()): ?>
                          <a href="<?php the_permalink();?>">
                              <?php the_post_thumbnail('course-thumb');?>
                          </a>
                      <?php endif;?>
                    
                        <div class="ld-caption">

                            <h3 class="wk-entry-title">
                                <a class="course-title-link" href="<?php the_permalink();?>">
                                    <?php the_title();?>
                                </a>
                            </h3>

                          <?php if(!empty($short_description) && $courseDesc) { ?>
                          <p class="ld-entry-content"><?php echo htmlspecialchars_decode( do_shortcode( $short_description ) ); ?></p>
                          <?php  } ?>

                        <?php if($courseButton): ?>
                            <p class="ld_course_grid_button"><a class="btn btn-primary" role="button" href="<?php the_permalink()?>" rel="bookmark"><?php esc_html_e( $button_text, 'widgetkit-pro' ); ?></a></p>
                        <?php endif; ?>

                        </div>

                      </article><!-- #post-## -->
                        </div>
                        <?php
                        $count++;
                    endwhile; wp_reset_postdata();
                endif;

                ?>
            </div>
        </div>
        <!--cat-post-list-->
        <?php
        //wp_reset_query();
        die();
    }
}

/**
 * LearnPress course tab
 * =====================
 */
add_action( 'wp_ajax_nopriv_learnpressCourseTab', 'learnpress_course_tab' );
add_action( 'wp_ajax_learnpressCourseTab', 'learnpress_course_tab' );
if(! function_exists('learnpress_course_tab')){
    function learnpress_course_tab(){
        $cat_id = $_REQUEST['term_id'];
        $post_num_to_show = $_REQUEST['pn'];
        $regularThumbSize = $_REQUEST['rts'];
        $coursePrice = $_REQUEST['coursePrice'];
        $courseCategory = $_REQUEST['courseCategory'];
        $postsColumn = $_REQUEST['postsColumn'];
        $activeCarousel = $_REQUEST['activeCarousel'];
        $showCourseDescription = $_REQUEST['showCourseDescription'];
        $descriptionWordCount = $_REQUEST['descriptionWordCount'];
        $lpCourseStyle = $_REQUEST['lpCourseStyle'];
        $lpEnrollIcon = $_REQUEST['lpEnrollIcon'] ? $_REQUEST['lpEnrollIcon'] : '';
        $lpDurationIcon = $_REQUEST['lpDurationIcon'] ? $_REQUEST['lpDurationIcon'] : '';
        $lpcourseAuthor = $_REQUEST['lpcourseAuthor'] ? $_REQUEST['lpcourseAuthor'] : '';
        $lpcourseRating = $_REQUEST['lpcourseRating'] ? $_REQUEST['lpcourseRating'] : '';
        $lpcourseEnroll = $_REQUEST['lpcourseEnroll'] ? $_REQUEST['lpcourseEnroll'] : '';
        $lpcourseDuration = $_REQUEST['lpcourseDuration'] ? $_REQUEST['lpcourseDuration'] : '';
        /**
         * Argument
         * for query post
         * ================
         */
        $count = 0;
        $args = array(
            'post_type' =>  'lp_course',
            'posts_per_page' => $post_num_to_show,
            'tax_query' => array(
                array(
                    'taxonomy' => 'course_category',
                    'field' => 'term_id',
                    'terms'    => $cat_id
                ),
            ),
        );

        $query = new WP_Query($args);
        ?>
        <div
            data-lpcourseAuthor="<?php echo $lpcourseAuthor; ?>"
            data-lpcourseRating="<?php echo $lpcourseRating; ?>"
            data-lpcourseEnroll="<?php echo $lpcourseEnroll; ?>"
            data-lpcourseDuration="<?php echo $lpcourseDuration; ?>"
            data-coursePrice="<?php echo $coursePrice; ?>"
            data-courseCategory="<?php echo $courseCategory; ?>"
            data-postsColumn="<?php echo $postsColumn; ?>"
            data-showCourseDescription="<?php echo $showCourseDescription; ?>"
            data-descriptionWordCount="<?php echo $descriptionWordCount; ?>"
            data-activeCarousel="<?php echo $activeCarousel; ?>"
            data-lpCourseStyle="<?php echo $lpCourseStyle; ?>"
            data-lpEnrollIcon="<?php echo $lpEnrollIcon; ?>"
            data-lpDurationIcon="<?php echo $lpDurationIcon; ?>"
            class="learnpress-course-tab-content cat-post-list dynamic-cat-post-list animated fadeIn">
            <div id="lp-dynamic-course-carousel" class="<?php echo $activeCarousel ? 'lp-dynamic-course-active owl-carousel' : 'wkp-lp-course-tab-grid'; ?>">
                <?php

                if($query->have_posts()):
                    while($query->have_posts()):
                        $query->the_post();
                        $lp_cat_list = get_the_terms(get_the_ID(), 'course_category');
                        ?>
 
                        <div class="wkp-lp-single-course <?php echo $activeCarousel ? 'col-md-12 ': '' ;?>  col-sm-<?php echo $postsColumn; ?>">
                            <?php if($lpCourseStyle == 'style_1'): ?>
                                <article  class="learnpress-course-tab-course">
                                    <!-- course thumbnail -->
                                    <?php if ( has_post_thumbnail() ):?>
                                        <figure class="course-thumbnail">
                                            <a href="<?php the_permalink(); ?>">
                                                <?php  the_post_thumbnail($regularThumbSize);?>
                                            </a>
                                        </figure>
                                        <?php else: ?>
                                            <figure class="course-thumbnail">
                                                <a href="<?php the_permalink();?>">
                                                    <img src="<?php echo esc_url(WKP_PLACEHOLDER_URL); ?>" alt="widgetitpro-placeholder">
                                                </a>
                                            </figure>
                                    <?php endif; ?>
                                    <!-- course content -->
                                    <div class="course-details">
                                        <!-- title -->
                                        <header class="wkp-entry-header">
                                            <h4 class="course-entry-title">
                                                <a class="course-title-link" href="<?php the_permalink();?>">
                                                    <?php the_title(); ?>
                                                </a>
                                            </h4>
                                        </header>

                                        <div class="course-meta addons-course-meta">
                                            <div class="price-and-cat">
                                                <!-- price -->
                                                <?php if($coursePrice == 'yes'): ?>
                                                    <?php $course = LP_Global::course();?>
                                                    <?php if ( $price_html = $course->get_price_html() ) : ?>
                                                        <span class="addon-price">
                                                            <?php echo $price_html; ?>
                                                            <?php if ( $course->get_origin_price() != $course->get_price() ) : ?>
                                                                <?php $origin_price_html = $course->get_origin_price_html(); ?>
                                                                <span class="addon-origin-price"><?php echo $origin_price_html; ?></span>
                                                            <?php endif ?>
                                                        </span>
                                                    <?php endif;?>
                                                <?php endif; ?>
                                                <!-- category -->
                                                <?php if($courseCategory == 'yes'): ?>
                                                    <span class="post-date">
                                                    <?php learn_press_course_categories(); ?>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                            <div class="enroll-student">
                                                <!-- enrolled student -->
                                                <?php if($lpcourseEnroll): ?>
                                                    <?php  $lp_students = get_post_meta(get_the_ID(), '_lp_students'); ?>
                                                    <span class="post-view">
                                                        <i class="fas fa-users"></i><?php echo esc_html($lp_students[0]);  ?>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                            
                                            
            
                                        </div>

                                        <?php if($lpcourseRating): ?>
                                        <div class="rating">
                                            <!-- //rating -->
                                            <?php
                                                $course_id       = get_the_ID();
                                                $course_rate_res = learn_press_get_course_rate( $course_id, false );
                                                $course_rate     = $course_rate_res['rated'];
                                                $total           = $course_rate_res['total'];
                                            ?>

                                            <?php //if($showRating == 'yes' or $averageRating == 'yes'):  ?>
                                                <div class="lp-course-rate-wapper">
                                                    <ul class="lp-course-rate clearfix">
                                                        <li>
                                                        <?php //if($showRating == 'yes'):  ?>
                                                            <?php echo '<div class="star-rating" title="'.sprintf(__( 'Rated %s out of 5', 'widgetkit-pro' ), $course_rate).'"><span style="width:'.( ( $course_rate / 5 ) * 100 ) . '%"><strong itemprop="ratingValue" class="rating">'.$course_rate.'</strong> '.__( 'out of 5', 'widgetkit-pro' ).'</span></div>'; ?>
                                                        <?php //endif; ?>
                                                        <?php //if($averageRating == 'yes'):  ?>
                                                                <?php printf( __( ' %1.2f ', 'widgetkit-pro'), $course_rate ); ?>
                                                                <?php //printf( _n( ' %d )', '%d )', $total, 'widgetkit-pro' ), $total ); ?>
                                                        <?php //endif; ?>
                                                        </li>
                                                    </ul> 
                                                </div>
                                            <?php //endif; ?>
                                        </div>
                                        <?php endif; ?>


                                        <?php if($showCourseDescription):?>
                                            <div class="wkp-entry-content">
                                                <p>
                                                    <?php esc_html_e(wp_trim_words( get_the_content(), $descriptionWordCount, ''), 'widgetkit-pro'); ?>
                                                </p>
                                            </div>
                                        <?php endif;?>

                                    </div>


                                </article>
                            <?php else:?>
                                <article  class="learnpress-course-tab-course">
                                    <figure class="lp-course-thumbnail">
                                        <!-- course thumbnail -->
                                        <div class="lp-img">
                                            <?php if ( has_post_thumbnail() ): ?>
                                            <a href="<?php the_permalink(); ?>">
                                                <?php the_post_thumbnail($regularThumbSize);?>
                                            </a>
                                            <?php else:?>
                                            <a href="<?php the_permalink(); ?>">
                                                <img src="<?php echo esc_url(WKP_PLACEHOLDER_URL); ?>" alt="widgetitpro-placeholder">
                                            </a>
                                            <?php endif; ?>
                                        </div>
                                        
                                    </figure>

                                    <div class="course-content-body">
                                        <div class="course-author-and-rating">
                                            <?php if($lpcourseAuthor): ?>
                                                <div class="author">
                                                    <!-- couser instructor -->
                                                    <?php //if($show_hide_lp_instructor == 'yes'): ?>
                                                        <div class="author-wrapper">
                                                            <div class="course-author-img"><?php echo get_avatar( get_the_author_meta( 'ID' ), 55 ); ?></div>
                                                            <div class="course-author-name"><?php echo get_the_author_meta( 'display_name'); ?></div>
                                                        </div>
                                                    <?php //endif; ?>
                                                </div>
                                            <?php endif; ?>
                                            
                                            <?php if($lpcourseRating): ?>
                                            <div class="rating">
                                                <!-- //rating -->
                                                <?php
                                                    $course_id       = get_the_ID();
                                                    $course_rate_res = learn_press_get_course_rate( $course_id, false );
                                                    $course_rate     = $course_rate_res['rated'];
                                                    $total           = $course_rate_res['total'];
                                                ?>

                                                <?php //if($showRating == 'yes' or $averageRating == 'yes'):  ?>
                                                    <div class="lp-course-rate-wapper">
                                                        <ul class="lp-course-rate clearfix">
                                                            <li>
                                                            <?php //if($showRating == 'yes'):  ?>
                                                                <?php echo '<div class="star-rating" title="'.sprintf(__( 'Rated %s out of 5', 'widgetkit-pro' ), $course_rate).'"><span style="width:'.( ( $course_rate / 5 ) * 100 ) . '%"><strong itemprop="ratingValue" class="rating">'.$course_rate.'</strong> '.__( 'out of 5', 'widgetkit-pro' ).'</span></div>'; ?>
                                                            <?php //endif; ?>
                                                            <?php //if($averageRating == 'yes'):  ?>
                                                                    <?php printf( __( ' %1.2f ', 'widgetkit-pro'), $course_rate ); ?>
                                                                    <?php //printf( _n( ' %d )', '%d )', $total, 'widgetkit-pro' ), $total ); ?>
                                                            <?php //endif; ?>
                                                            </li>
                                                        </ul> 
                                                    </div>
                                                <?php //endif; ?>
                                            </div>
                                            <?php endif; ?>
                                        </div>   
                                        <!-- course title -->
                                        <div class="course-title">
                                            <h4 class="course-entry-title">
                                                <a href="<?php the_permalink();?>">
                                                    <?php the_title(); ?>                        
                                                </a>
                                            </h4>       
                                        </div>
                                        <!-- course category -->
                                        <?php if($courseCategory): ?>
                                        <div class="course-cat">
                                            <?php //if($lp_course_cat == 'yes'): ?>
                                                <ul class="lp-cat">
                                                    <?php if($lp_cat_list): foreach($lp_cat_list as $cat): ?>
                                                        <li>
                                                            <a href="<?php echo get_term_link($cat->term_id); ?>">
                                                                <?php echo $cat->name; ?>
                                                            </a>
                                                        </li>
                                                    <?php endforeach; endif; ?>
                                                </ul>
                                            <?php //endif; ?>
                                        </div>
                                        <?php endif; ?>
                                        <!-- couse excerpt -->
                                        <?php if ($showCourseDescription):?>
                                            <div class="wkp-entry-content">
                                                <p><?php esc_html_e(wp_trim_words( get_the_content(), $descriptionWordCount, ''), 'widgetkit-pro'); ?></p>
                                            </div>
                                        <?php endif; ?> 
                                        <!-- course meta data -->
                                        <div class="course-meta addons-course-meta">
                                            <!-- enrolled student -->
                                            <?php if($lpcourseEnroll): ?>
                                            <div class="enroll-student">
                                                <?php //if($lp_course_students_er == 'yes'): ?>
                                                    <?php  $lp_students = get_post_meta(get_the_ID(), '_lp_students'); ?>
                                                    <span class="meta-icon">
                                                        <?php if($add_custom_enroll_icon):?>
                                                            <?php Icons_Manager::render_icon( $lpEnrollIcon, [ 'aria-hidden' => 'true', 'class' => 'custon-enroll-icon' ] ); ?>
                                                        <?php else: ?>
                                                            <?php include(WKP_PATH. 'dist/images/avatar.svg'); ?>
                                                        <?php endif;?>
                                                    </span>
                                                    <span class="course-user"><?php echo esc_html($lp_students[0]);  ?></span>
                                                <?php //endif; ?>
                                            </div>
                                            <?php endif; ?>
                                            <!-- duration -->
                                            <?php if($lpcourseDuration): ?>
                                            <div class="duraton">
                                                <?php  $lp_duration = get_post_meta(get_the_ID(), '_lp_duration'); ?>
                                                <span class="meta-icon">
                                                    <?php if($add_custom_duration_icon):?>
                                                        <?php Icons_Manager::render_icon( $lpDurationIcon, [ 'aria-hidden' => 'true', 'class' => 'custon-duration-icon' ] ); ?>
                                                    <?php else: ?>
                                                        <?php include(WKP_PATH. 'dist/images/time.svg'); ?>
                                                    <?php endif;?>
                                                </span>
                                                <span class="course-duration"><?php echo esc_html($lp_duration[0]);  ?></span>
                                            </div>
                                            <?php endif; ?>
                                            <!-- lesson -->
                                            <!-- <div class="lesson">
                                                <span class="course-lesson-count">
                                                    <i class="fas fa-users"></i><?php //echo esc_html($lp_students[0]);  ?>
                                                </span>
                                            </div> -->
                                            <!-- course price -->
                                            <?php if($coursePrice): ?>
                                                <div class="course-price">
                                                    <?php 
                                                    //if($lp_course_price == 'yes'): ?>
                                                        <?php $course = LP_Global::course();
                                                        if ( $price_html = $course->get_price_html() ): ?>
                                                            <span class="addon-price">
                                                                <?php echo $price_html; ?>
                                                                <?php if ( $course->get_origin_price() != $course->get_price() ) : ?>
                                                                    <?php $origin_price_html = $course->get_origin_price_html(); ?>
                                                                    <span class="addon-origin-price"><?php echo $origin_price_html; ?></span>
                                                                <?php endif; ?>
                                                            </span>

                                                        <?php 
                                                        endif;
                                                    //endif; ?>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                                                    
                                    </div>
                                </article>
                            <?php endif;?>
                        </div>
                        <?php
                        $count++;
                    endwhile; wp_reset_postdata();
                else:
                    ?>
                    <h3 class="no-course">You have no course on this category. Please add some course on this category</h3>
                    <?php
                endif;

                ?>
            </div>
        </div>
        <!--cat-post-list-->
        <?php
        //wp_reset_query();
        die();
    }
}

/*
 * Sensei Dynamic 
 * courses category 
 * =================
 */

add_action( 'wp_ajax_nopriv_senseiDynamicCat', 'sensei_dynamic_cat' );
add_action( 'wp_ajax_senseiDynamicCat', 'sensei_dynamic_cat' );
if(! function_exists('sensei_dynamic_cat')){

    function sensei_dynamic_cat(){
        $wkp_placeholder_image = WKP_URL . 'dist/images/placeholder.jpg';
        $cat_id = $_REQUEST['term_id'];
        $post_num_to_show = $_REQUEST['pn'];
        $regularThumbSize = $_REQUEST['rts'];

        $showInstructor = $_REQUEST['showInstructor'];
        $showMeta = $_REQUEST['showMeta'];
        $showDescription = $_REQUEST['showDescription'];
        $excerptWord = $_REQUEST['excerptWord'];
        $showLesson = $_REQUEST['showLesson'];
        $enrollButton = $_REQUEST['enrollButton'];

        $postsColumn = $_REQUEST['postsColumn'];
        $activeCarousel = $_REQUEST['activeCarousel'];
        $senseiLessonCustomIcon = $_REQUEST['senseiLessonCustomIcon'];
        $senseiLessonIcon = $_REQUEST['senseiLessonIcon'];
        /**
         * Argument
         * for query post
         * ================
         */
        $count = 0;
        $args = array(
            'post_type' =>  'course',
            'posts_per_page' => $post_num_to_show,
            'tax_query' => array(
                array(
                    'taxonomy' => 'course-category',
                    'field' => 'term_id',
                    'terms'    => $cat_id
                ),
            ),
        );

        $query = new WP_Query($args);
        ?>
        <div
            data-showInstructor="<?php echo $showInstructor; ?>"
            data-showMeta="<?php echo $showMeta; ?>"
            data-showDescription="<?php echo $showDescription; ?>"
            data-excerptWord="<?php echo $excerptWord; ?>"
            data-showLesson="<?php echo $showLesson; ?>"
            data-enrollButton="<?php echo $enrollButton; ?>"

            data-postsColumn="<?php echo $postsColumn; ?>"
            data-activeCarousel="<?php echo $activeCarousel; ?>"
            data-senseiLessonCustomIcon="<?php echo $senseiLessonCustomIcon; ?>"
            class="dynamic-category-conten cat-post-list dynamic-cat-post-list animated fadeIn">

            <div class="hidden-data" style="display:none">
                <?php echo htmlspecialchars_decode(stripslashes($senseiLessonIcon)); ?>
            </div>
            
            <div id="sensei-dynamic-course-carousel" class="wkp-sensei-course-tab-content-wrapper <?php echo $activeCarousel ? 'sensei-dynamic-course-active owl-carousel' : ''; ?>">
                <?php

                if($query->have_posts()):
                    while($query->have_posts()):
                        $query->the_post();

                        ?>
 
                        <div class="sensei-single-courses  <?php echo $activeCarousel ? 'col-md-12 ': '' ;?>  col-sm-<?php echo $postsColumn; ?>">
                            <article id="post-<?php the_ID(); ?>" <?php post_class('sensei-single-course'); ?>>
                                <?php //if ( has_post_thumbnail() ):?>
                                    <figure class="sensei-course-thumbnail">
                                        <div class="sensei-img">
                                            <?php if ( has_post_thumbnail() ):?>
                                                <a href="<?php the_permalink(); ?>">
                                                    <?php  the_post_thumbnail();?>
                                                </a>
                                            <?php else: ?>
                                                <a href="<?php the_permalink() ?>">
                                                    <img src="<?php echo esc_url($wkp_placeholder_image);?>" alt="">
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    <?php if($showInstructor == 'yes'): ?>
                                        <div class="author-wrapper">
                                            <div class="tx-author-img"><?php echo get_avatar( get_the_author_meta( 'ID' ), 55 ); ?></div>
                                        </div>
                                    <?php endif; ?>
                                    </figure>
                                <?php //endif; ?>

                                <div class="course-content-body">

                                    <header class="wkp-entry-header">
                                        <h4 class="course-entry-title">
                                            <a href="<?php the_permalink();?>">
                                                <?php echo ucfirst(get_the_title(get_the_ID())); ?>                       
                                            </a>
                                        </h4>       
                                    </header><!-- .entry-header -->
                                    
                                    <?php if($showMeta):?>
                                        <div class="post-cat">
                                            <ul>
                                            <?php 
                                            $course_cats = get_the_terms(get_the_ID(), 'course-category');
                                            foreach($course_cats as $cat):
                                            ?>
                                                <li><?php echo $cat->name; ?></li>
                                            <?php endforeach;?>
                                            </ul>
                                        </div>
                                    <?php endif;?>

                                    <?php if ($showDescription && $excerptWord):?>
                                        <div class="wkp-entry-content">
                                            <p><?php esc_html_e(wp_trim_words( get_the_excerpt(), $excerptWord, ''), 'widgetkit-pro'); ?></p>
                                        </div><!-- .entry-content -->
                                    <?php endif; ?>

                                    <footer class="wkp-entry-footer">
                                        <div class="footer-body">
                                            <?php if($showLesson): ?>
                                                <span class="sensei-enroll">
                                                    <?php if( $senseiLessonCustomIcon ): ?>
                                                        <?php echo htmlspecialchars_decode(stripslashes($senseiLessonIcon)); ?>
                                                    <?php else: ?>
                                                        <i class="fas fa-play-circle"></i>
                                                    <?php endif;?>
                                                    <?php echo Sensei()->course->course_lesson_count( get_the_ID() ) . '&nbsp;' . esc_html__( 'Lessons', 'widgetkit-pro' ); ?>
                                                </span>
                                            <?php endif; ?>
                                            <?php if($enrollButton): ?>
                                            <span class="sensei-enroll-btn">
                                                <a href="<?php the_permalink();?>"><?php esc_html_e('Enroll', 'widgetkit-pro') ?></a>   
                                            </span>
                                            <?php endif; ?>
                                        </div><!-- .entry-meta -->
                                    </footer>
                                </div><!-- .course details -->

                            </article><!-- #post-## -->
                        </div>
                        <?php
                        $count++;
                    endwhile; wp_reset_postdata();
                endif;

                ?>
            </div>
        </div>
        <!--cat-post-list-->
        <?php
        //wp_reset_query();
        die();
    }
}