<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Widgetkit Pro Class
 *
 * Register new elementor widget.
 *
 * @since 1.0.0
 */
class Widgetkit_Pro_Elements {

	public function __construct() {
		$this->add_actions();
	}

	private function add_actions() {
		require_once  WKP_PATH . '/inc/helper-functions.php';
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'on_widgets_registered' ] );
	}

	public function on_widgets_registered() {
		$this->includes();
		$this->widgetkit_pro_register_widget();
	}

	private function includes() {
        $element_files = glob(WKP_PATH . '/widgets/elements/*.php');
        foreach ($element_files as $file) {
            require $file;
        }
	}

	private function widgetkit_pro_register_widget() {

		$wk_enable_status = is_plugin_active('widgetkit-for-elementor/widgetkit-for-elementor.php');

		$wkpro_default_keys = [
			'wkpro-post-tab',
			'wkpro-post-carousel',
			'wkpro-post-list',
			'wkpro-grid-slider',
			'wkpro-headline-slider',
		];
		$widgetkit_woo_keys = [
	        'wke-woo-product',
	        'wke-woo-product-carousel',
	        'wke-woo-categories',
	        'wke-woo-recent-product',
	    ];

	    $widgetkit_ld_keys = [
	        'wke-ld-course-list',
	        'wke-ld-course-tab',
	    ];

	    $widgetkit_lp_keys = [
	        'wke-lp-course-list',
	        'wke-lp-course-tab',
	        'wke-lp-course-category',
	    ];
	    
	    $widgetkit_sensei_keys = [
	        'wke-sensei-course-list',
	        'wke-sensei-course-tab',
	        'wke-sensei-course-category',
		];
		
		$widgetkit_pro_default_settings = array_fill_keys( $wkpro_default_keys, true );
		$widgetkit_pro_default_woo_settings = array_fill_keys( $widgetkit_woo_keys, true ); 
		$widgetkit_pro_default_ld_settings = array_fill_keys( $widgetkit_ld_keys, true ); 
		$widgetkit_pro_default_lp_settings = array_fill_keys( $widgetkit_lp_keys, true ); 
		$widgetkit_pro_default_sensei_settings = array_fill_keys( $widgetkit_sensei_keys, true ); 

		$check_component_active = get_option( 'widgetkit_pro_save_settings', $widgetkit_pro_default_settings );

		$wkpro_get_keys = get_option( 'widgetkit_save_settings', $widgetkit_pro_default_settings );
		$wkpro_get_woo_keys = get_option( 'widgetkit_save_woo_settings', $widgetkit_pro_default_woo_settings );
		$wkpro_get_ld_keys = get_option( 'widgetkit_save_ld_settings', $widgetkit_pro_default_ld_settings );
		$wkpro_get_lp_keys = get_option( 'widgetkit_save_lp_settings', $widgetkit_pro_default_lp_settings );
		$wkpro_get_sensei_keys = get_option( 'widgetkit_save_sensei_settings', $widgetkit_pro_default_sensei_settings );

		// $wkpro_get_keys = get_option( 'widgetkit_save_settings');
		// $wkpro_get_woo_keys = get_option( 'widgetkit_save_woo_settings');
		// $wkpro_get_ld_keys = get_option( 'widgetkit_save_ld_settings');
		// $wkpro_get_lp_keys = get_option( 'widgetkit_save_lp_settings');
		// $wkpro_get_sensei_keys = get_option( 'widgetkit_save_sensei_settings');
		
		if($wkpro_get_keys && $wk_enable_status):
			if(widgetkit_pro_array_get($wkpro_get_keys, 'wkpro-post-tab')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_Post_Tab() );
			endif;
			if(widgetkit_pro_array_get($wkpro_get_keys, 'wkpro-post-carousel')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_Post_Carousel() );
			endif;
			if(widgetkit_pro_array_get($wkpro_get_keys, 'wkpro-post-list')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_Smart_List() );
			endif;
			if(widgetkit_pro_array_get($wkpro_get_keys, 'wkpro-grid-slider')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_Grid_Slider() );
			endif;
			if(widgetkit_pro_array_get($wkpro_get_keys, 'wkpro-headline-slider')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_Headline_Slider() );
			endif;
		endif;
		

		
		/**
		 * WooCommerce
		 */
		if($wkpro_get_woo_keys && $wk_enable_status):
			if(widgetkit_pro_array_get($wkpro_get_woo_keys, 'wke-woo-product')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_Woo_Products() );
			endif;
			if(widgetkit_pro_array_get($wkpro_get_woo_keys, 'wke-woo-product-carousel')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_Woo_Product_Carousel() );
			endif;
			if(widgetkit_pro_array_get($wkpro_get_woo_keys, 'wke-woo-categories')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_Woo_Categories() );
			endif;
			if(widgetkit_pro_array_get($wkpro_get_woo_keys, 'wke-woo-recent-product')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_Woo_Recent_Product() );
			endif;
		endif;
		// \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_Woo_Featured_Product() );
		/**
		 * LearnDash
		 */
		if($wkpro_get_ld_keys && $wk_enable_status):
			if(widgetkit_pro_array_get($wkpro_get_ld_keys, 'wke-ld-course-list')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_LearnDash_Course_List());
			endif;
			if(widgetkit_pro_array_get($wkpro_get_ld_keys, 'wke-ld-course-tab')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_LearnDash_Course_Tab() );
			endif;
		endif;
		/**
		 * LearnPress
		 */
		if($wkpro_get_lp_keys && $wk_enable_status):
			if(widgetkit_pro_array_get($wkpro_get_lp_keys, 'wke-lp-course-list')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_LP_Course_List());
			endif;
			if(widgetkit_pro_array_get($wkpro_get_lp_keys, 'wke-lp-course-tab')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_LP_Course_Tab());
			endif;
			if(widgetkit_pro_array_get($wkpro_get_lp_keys, 'wke-lp-course-category')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_LP_Course_Category());
			endif;
		endif;
		/**
		 * Sensei
		 */
		if($wkpro_get_sensei_keys && $wk_enable_status):
			if(widgetkit_pro_array_get($wkpro_get_sensei_keys, 'wke-sensei-course-list')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_Sensei_Course_List());
			endif;
			if(widgetkit_pro_array_get($wkpro_get_sensei_keys, 'wke-sensei-course-tab')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_Sensei_Course_Tab());
			endif;
			if(widgetkit_pro_array_get($wkpro_get_sensei_keys, 'wke-sensei-course-category')):
				\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgetkit_Pro_Sensei_Course_Category());
			endif;
		endif;
	
	}
}

new Widgetkit_Pro_Elements();
