<?php

if( ! defined( 'ABSPATH' ) ) exit();

class WKP_Dependency{

    private static $instance;
    public static function init(){
        if(null === self::$instance ){
            self::$instance = new self;
        }
        return self::$instance;
    }
    public function __construct(){
        if (!did_action('elementor/loaded')) {
            add_action( 'admin_notices', array($this, 'check_dependend_plugin_elementor') );
        }
        add_action( 'admin_notices', array($this, 'check_dependend_plugin_widgetkit') );
    }

    public function check_dependend_plugin_elementor(){
        if (!current_user_can('activate_plugins')) {
            return;
        }
        $elementor_main_file = 'elementor/elementor.php';

        if(! $this->get_all_plugin_in_my_site($elementor_main_file)){
            /**
             * if plugin not found
             */
            $activation_url = wp_nonce_url(self_admin_url('update.php?action=install-plugin&plugin=elementor'), 'install-plugin_elementor');
            $message = sprintf(__('<strong>Widgetkit Pro</strong> requires <strong>Elementor</strong> plugin to be installed and activated. Please install <strong>Elementor</strong> to continue.', 'widgetkit-pro'), '<strong>', '</strong>');
            $button_text = __('Install Elementor Now', 'widgetkit-pro');
        }else{
            /**
             * if found
             */
            $activation_url = wp_nonce_url('plugins.php?action=activate&amp;plugin=' . $elementor_main_file . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $elementor_main_file);
            $message = __('<strong>Widgetkit Pro</strong> requires <strong>Elementor</strong> plugin to be active. Please activate Elementor to continue.', 'widgetkit-pro');
            $button_text = __('Activate Elementor Now', 'widgetkit-pro');
        }
        $button = '<p><a href="' . $activation_url . '" class="button-primary">' . $button_text . '</a></p>';
        printf('<div class="error"><p>%1$s</p>%2$s</div>', __($message), $button);
    }
    /**
     * check widgetkit 
     */
    public function check_dependend_plugin_widgetkit(){
        if (!current_user_can('activate_plugins')) {
            return;
        }
        $widgetkit_main_file = 'widgetkit-for-elementor/widgetkit-for-elementor.php';

        if(! $this->get_all_plugin_in_my_site($widgetkit_main_file)){
            /**
             * if plugin not found
             */
            $activation_url = wp_nonce_url(self_admin_url('update.php?action=install-plugin&plugin=widgetkit-for-elementor'), 'install-plugin_widgetkit-for-elementor');
            $message = sprintf(__('<strong>WidgetKit Pro</strong> requires <strong>All-in-One Addons for Elementor - WidgetKit</strong> plugin to be installed and activated. Please install <strong>All-in-One Addons for Elementor - WidgetKit</strong> to continue.', 'widgetkit-pro'), '<strong>', '</strong>');
            $button_text = __('Install Now', 'widgetkit-pro');
            $button = '<p><a href="' . $activation_url . '" class="button-primary">' . $button_text . '</a></p>';
            printf('<div class="error"><p>%1$s</p>%2$s</div>', __($message), $button);
        }else{
            /**
             * if found
             */
            if(!is_plugin_active($widgetkit_main_file)):
            $activation_url = wp_nonce_url('plugins.php?action=activate&amp;plugin=' . $widgetkit_main_file . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $widgetkit_main_file);
            $message = __('<strong>Widgetkit Pro</strong> requires <strong>All-in-One Addons for Elementor - WidgetKit</strong> plugin to be active. Please activate Elementor to continue.', 'widgetkit-pro');
            $button_text = __('Activate Now', 'widgetkit-pro');
            $button = '<p><a href="' . $activation_url . '" class="button-primary">' . $button_text . '</a></p>';
            printf('<div class="error"><p>%1$s</p>%2$s</div>', __($message), $button);
            endif;
        }
    }

    public function get_all_plugin_in_my_site($plugin_base_name){
        $installed_plugins = get_plugins();
        return isset($installed_plugins[$plugin_base_name]);
    }



}