<?php 

class Widgetkit_Pro_Admin {


// Widgets keys

    //  public $widgetkit_free_elements_keys = [
    //     'widget-slider-animation', 
    //     'widget-slider-content-animation', 
    //     'widget-slider-box-animation', 
    //     'widget-portfolio',
    //     'widget-pricing-single', 
    //     'widget-pricing-icon', 
    //     'widget-pricing-tab', 
    //     'widget-testimonial-single',
    //     'widget-testimonial-center',
    //     'widget-team-overlay',
    //     'widget-team-verticle-icon',
    //     'widget-team-round',
    //     'widget-team-animation',
    //     'widget-blog-carousel',
    //     'widget-blog-sidebar',
    //     'widget-blog-revert',
    //     'widget-blog-hover-animation',
    //     'widget-blog-image',
    //     'widget-countdown',
    //     'widget-animation-text',
    //     'widget-post-carousel',
    //     'widget-button',
    //     'widget-hover-image',
    //     'widget-feature-box',
    //     'widget-social-share-animation',
    //     'widget-social-share-collapse',
    // ];

    public $widgetkit_pro_elements_keys = [
        'Widgetkit_Pro_Slider',
        'Widget_Dynamic_Category_Tab', 
        'Widget_Dynamic_Header_Tab', 
        'Widget_Dynamic_Layout', 
        'Widget_Element_Title',
        'Widget_List_Layout', 
        'Widget_Multiple_Category_with_Dynamic_Carousel', 
        'Widget_News_Ticker', 
        'Widget_Posts_With_Load_More_Button',
        'Widget_Recent_Post_Carousel',
        'Widget_Recent_Post_Layout',
        'Widget_Recent_Post_Slider',
        'Widget_Single_Category_Carousel',
        'Widget_Single_Category_Layout',
        'Widget_Single_Category_with_Dynamic_Carousel',
        'Widget_Single_Post_by_ID',
        'Widget_Social_Icon',
        'Widget_Tab_Between_Two_Category',
        'Widget_Tiles_Layout',
    ];

	// Default settings
    //private $widgetkit_free_default_settings;
	private $widgetkit_pro_default_settings;
	// Switch settings
    //private $widgetkit_free_settings;
	private $widgetkit_pro_settings;
    // Switch get settings
    //private $widgetkit_free_get_settings;
    private $widgetkit_pro_get_settings;


/**
 * Register construct
 */
	public function __construct() {

        //$this->includes();
        $this->init_hooks();

    }


/**
 * Register a custom opitons.
 */
	function widgetkit_pro_admin_options(){
	    add_menu_page( 

	        'Admin Menu',
	        __( 'Widgetkit Pro', 'widgetkit-pro' ),
	        'manage_options',
	        'widgetkit-pro-settings',
	        array($this, 'display_settings_pages'),
	        plugins_url('/assets/images/menu-icon.png', __FILE__ ), 100
	    ); 
	}

	



/**
 * Register all hooks
 */
    public function init_hooks() {

        // Build admin main menu
        add_action('admin_menu', array($this, 'widgetkit_pro_admin_options'));
        // Build admin notice
        //add_action('admin_notices', array($this, 'switch_lite_welcome_admin_notice'));
        // Build admin script
        add_action('init', array( $this, 'widgetkit_pro_admin_page_scripts' ) );
        // Build admin view and save
        add_action( 'wp_ajax_widgetkit_free_save_admin_addons_settings', array( $this, 'widgetkit_free_sections_with_ajax') );

        add_action( 'wp_ajax_widgetkit_pro_save_admin_addons_settings', array( $this, 'widgetkit_pro_sections_with_ajax') );
    }


/**
 * Register scripts
 */
    public function widgetkit_pro_admin_page_scripts () {
    	// admin css
        wp_enqueue_style( 'widgetkit-pro-admin',  plugins_url('/assets/css/admin.css', __FILE__  ));

        // sweetalart css
        wp_enqueue_style( 'widgetkit-pro-sweetalert2-css', plugins_url('/assets/css/sweetalert2.min.css', __FILE__ ));

        // Admin script
        wp_enqueue_script('widgetkit-pro-elementor-admin-js', plugins_url('/assets/js/admin.js', __FILE__) , array('jquery','jquery-ui-tabs'), '1.0' , true );

        // Core script
        wp_enqueue_script( 'widgetkit-pro-sweet-js',  plugins_url('/assets/js/core.js', __FILE__), array( 'jquery' ), '1.0', true );

        // Sweetalert2 script
		wp_enqueue_script( 'widgetkit-pro-sweetalert2-js', plugins_url('/assets/js/sweetalert2.min.js', __FILE__), array( 'jquery', 'widgetkit-pro-sweet-js' ), '1.0', true );
    }

    /**
 * Register display view
 */

    public function display_settings_pages() {

        $js_info = array(
			'ajaxurl' => admin_url( 'admin-ajax.php' )
		);
		wp_localize_script( 'widgetkit-pro-elementor-admin-js', 'settings', $js_info );
       
	   // $this->widgetkit_free_default_settings = array_fill_keys( $this->widgetkit_free_elements_keys, true );
        $this->widgetkit_pro_default_settings = array_fill_keys( $this->widgetkit_pro_elements_keys, true );
       
        //$this->widgetkit_free_get_settings = get_option( 'widgetkit_free_save_settings', $this->widgetkit_free_default_settings );
	    $this->widgetkit_pro_get_settings = get_option( 'widgetkit_pro_save_settings', $this->widgetkit_pro_default_settings );
       
      // $widgetkit_free_new_settings = array_diff_key( $this->widgetkit_free_default_settings, $this->widgetkit_free_get_settings );
	   $widgetkit_pro_new_settings = array_diff_key( $this->widgetkit_pro_default_settings, $this->widgetkit_pro_get_settings );
       
	   // if( ! empty( $widgetkit_free_new_settings ) ) {
	   // 	$widgetkit_free_updated_settings = array_merge( $this->widgetkit_free_get_settings, $widgetkit_free_new_settings );
	   // 	update_option( 'widgetkit_free_save_settings', $widgetkit_free_updated_settings );
	   // }

        if( ! empty( $widgetkit_pro_new_settings ) ) {
        $widgetkit_pro_updated_settings = array_merge( $this->widgetkit_pro_get_settings, $widgetkit_pro_new_settings );
        update_option( 'widgetkit_pro_save_settings', $widgetkit_pro_updated_settings );
       }


	  // $this->widgetkit_free_get_settings = get_option( 'widgetkit_free_save_settings', $this->widgetkit_pro_default_settings );

        $this->widgetkit_pro_get_settings = get_option( 'widgetkit_pro_save_settings', $this->widgetkit_pro_default_settings );

?>


    <div class="wrap">
        <div class="response-wrap"></div>
            <div class="widgetkit-header-wrapper">
                <div class="widgetkit-title-left">
                    <h1 class="widgetkit-title-main"><?php echo esc_html__('WidgetKit Pro', 'widgetkit-pro'); ?></h1>
                    <h3 class="widgetkit-title-sub">Thank you for using WidgetKit. This plugin has been developed by <a target="_blank" href="https://themesgrove.com/">Themesgrove</a> and we hope you enjoy using it.</h3>
                </div>
            </div>
            <div class="widgetkit-settings-tabs">
                <ul class="widgetkit-settings-tabs-list">
                    <li><a class="widgetkit-tab-list-item" href="#widgetkit-pro-about">About</a></li>
          <!--           <li><a class="widgetkit-tab-list-item" href="#widgetkit-free-elements">Free Elements</a></li> -->
                    <li><a class="widgetkit-tab-list-item" href="#widgetkit-pro-elements">Pro Elements</a></li>
                    <li><a class="widgetkit-tab-list-item" href="#widgetkit-pro-info">Info</a></li>
                </ul>
                <div id="widgetkit-pro-about" class="widgetkit-settings-tab">
                    <div class="widgetkit-row">
                        <div class="widgetkit-col-half">
                            <div class="widgetkit-about-panel">
                                <div class="widgetkit-icon-container">
                                    <i class="dashicons dashicons-editor-help"></i>
                                </div>
                                <div class="widgetkit-text-container">
                                    <h4>What is Widgetkit Pro?</h4>
                                    <p>WidgetKit is a completely free tool that enhances your pagebuilding experience with Elementor pagebuilder. It doesn't matter whether you are building simple or complex site, if you can imagine it you can built it with Widgetkit.</p>
                                </div>
                            </div>
                        </div>
                        <div class="widgetkit-col-half">
                            <div class="widgetkit-about-panel">
                                <div class="widgetkit-icon-container">
                                    <i class="dashicons dashicons-media-document"></i>
                                </div>
                                <div class="widgetkit-text-container">
                                    <h4>Documentation</h4>
                                    <p>It’s highly recommended to check out documentation and FAQ before using this plugin. <a target="_blank" href="https://themesgrove.com/">Click Here </a> for more details.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="widgetkit-row">
                        <div class="widgetkit-col-half">
                            <div class="widgetkit-about-panel">
                                <div class="widgetkit-icon-container">
                                    <i class="dashicons dashicons-format-chat"></i>
                                </div>
                                <div class="widgetkit-text-container">
                                    <h4>Need Any Help?</h4>
                                    <p>Feel free to join us in our <a target="_blank" href="https://www.facebook.com/themesgrove/">Facebook Group</a> and our <a target="_blank" href="https://themesgrove.com/forum/">Community Forums</a> if you need more help using the plugin.</p>
                                </div>
                            </div>
                        </div>
                        <div class="widgetkit-col-half">
                            <div class="widgetkit-about-panel">
                                <div class="widgetkit-icon-container">
                                    <i class="dashicons dashicons-update"></i>
                                </div>
                                <div class="widgetkit-text-container">
                                    <h4>Keep Updated</h4>
                                    <p>Join our Newsletter to get more info about our products updates. <a target="_blank" href="https://themesgrove.com/wordpress-themes/">Click Here</a> to Join Now.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

        



      <form action="" method="POST" id="widgetkit-pro-settings" name="widgetkit-pro-settings">


            <div id="widgetkit-pro-elements" class="widgetkit-settings-tab">

                <table class="widgetkit-elements-table">
                    <tbody>
                        <tr>
                        <th><?php echo esc_html__('Slider Pro', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widgetkit_Pro_Slider" name="Widgetkit_Pro_Slider" <?php checked(1, $this->widgetkit_pro_get_settings['Widgetkit_Pro_Slider'], true) ?>>
                                    <span class="rectangle round"></span>
                            </label>
                            </td>
                            <th><?php echo esc_html__('Dynamic Category Tab', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_Dynamic_Category_Tab" name="Widget_Dynamic_Category_Tab" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_Dynamic_Category_Tab'], true) ?>>
                                    <span class="rectangle round"></span>
                            </label>
                            </td>

                            <th><?php echo esc_html__('Header Tab', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_Dynamic_Header_Tab" name="Widget_Dynamic_Header_Tab" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_Dynamic_Header_Tab'], true) ?>>
                                    <span class="rectangle round"></span>
                                </label>
                            </td>

                            <th><?php echo esc_html__('Dynamic Layout', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_Dynamic_Layout" name="Widget_Dynamic_Layout" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_Dynamic_Layout'], true) ?>>
                                    <span class="rectangle round"></span>
                                </label>
                            </td>

                            <th><?php echo esc_html__('Element Title', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_Element_Title" name="Widget_Element_Title" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_Element_Title'], true) ?>>
                                    <span class="rectangle round"></span>
                                </label>
                            </td> 
                        </tr>
                        
                        
                        <tr>
                            <th><?php echo esc_html__('List Layout', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_List_Layout" name="Widget_List_Layout" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_List_Layout'], true) ?>>
                                    <span class="rectangle round"></span>
                            </label>
                            </td>
                            <th><?php echo esc_html__('Multiple Category with Dynamic Carousel', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_Multiple_Category_with_Dynamic_Carousel" name="Widget_Multiple_Category_with_Dynamic_Carousel" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_Multiple_Category_with_Dynamic_Carousel'], true) ?>>
                                    <span class="rectangle round"></span>
                                </label>
                            </td>


                            <th><?php echo esc_html__('News Ticker', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_News_Ticker" name="Widget_News_Ticker" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_News_Ticker'], true) ?>>
                                    <span class="rectangle round"></span>
                                </label>
                            </td>

                            <th><?php echo esc_html__('Posts with Load More Button', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_Posts_With_Load_More_Button" name="Widget_Posts_With_Load_More_Button" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_Posts_With_Load_More_Button'], true) ?>>
                                    <span class="rectangle round"></span>
                                </label>
                            </td>   

                        </tr>
                        
                        <tr>

                            <th><?php echo esc_html__('Recent Post Carousel', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_Recent_Post_Carousel" name="Widget_Recent_Post_Carousel" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_Recent_Post_Carousel'], true) ?>>
                                    <span class="rectangle round"></span>
                            </label>
                            </td>

                            <th><?php echo esc_html__('Recent Post Layout', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_Recent_Post_Layout" name="Widget_Recent_Post_Layout" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_Recent_Post_Layout'], true) ?>>
                                    <span class="rectangle round"></span>
                                </label>
                            </td>

                            <th><?php echo esc_html__('Recent Post Slider', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_Recent_Post_Slider" name="Widget_Recent_Post_Slider" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_Recent_Post_Slider'], true) ?>>
                                    <span class="rectangle round"></span>
                                </label>
                            </td>

                            <th><?php echo esc_html__('Single Category Carousel', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_Single_Category_Carousel" name="Widget_Single_Category_Carousel" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_Single_Category_Carousel'], true) ?>>
                                    <span class="rectangle round"></span>
                                </label>
                            </td>


                        </tr>


                        <tr>
                           <th><?php echo esc_html__('Single Category Layout', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_Single_Category_Layout" name="Widget_Single_Category_Layout" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_Single_Category_Layout'], true) ?>>
                                    <span class="rectangle round"></span>
                                </label>
                            </td>


                            <th><?php echo esc_html__('Single Category with Dynamic Carousel', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_Single_Category_with_Dynamic_Carousel" name="Widget_Single_Category_with_Dynamic_Carousel" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_Single_Category_with_Dynamic_Carousel'], true) ?>>
                                    <span class="rectangle round"></span>
                                </label>
                            </td>


                            <th><?php echo esc_html__('Single Post by ID', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_Single_Post_by_ID" name="Widget_Single_Post_by_ID" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_Single_Post_by_ID'], true) ?>>
                                    <span class="rectangle round"></span>
                                </label>
                            </td>


                            <th><?php echo esc_html__('Social Icon', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_Social_Icon" name="Widget_Social_Icon" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_Social_Icon'], true) ?>>
                                    <span class="rectangle round"></span>
                                </label>
                            </td>

                        </tr>
                        
                        
                        <tr>
                            <th><?php echo esc_html__('Tab Between 2 Category', 'widgetkit-pro'); ?></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="Widget_Tab_Between_Two_Category" name="Widget_Tab_Between_Two_Category" <?php checked(1, $this->widgetkit_pro_get_settings['Widget_Tab_Between_Two_Category'], true) ?>>
                                    <span class="rectangle round"></span>
                                </label>
                            </td>

                        </tr>
                        
                        
                        
                    </tbody>
                </table>
                <input type="submit" value="Save Settings" class="button widgetkit-btn widgetkit-save-button">
                    
            </div>
                    </form>

            <div id="widgetkit-pro-info" class="widgetkit-settings-tab">
                <div class="widgetkit-row">
                   <h3><?php echo esc_html__('System setup information useful for debugging purposes.','widgetkit-pro');?></h3>
                   <div class="widgetkit-system-info-container">
                       <?php 
                        echo nl2br(widgetkit_pro_get_sysinfo()); 
                       ?>
                   </div>
                </div>
            </div>
            <div>
                <p>Did you like our plugin? Please<a href="https://wordpress.org/support/plugin/widgetkit-for-elementor/reviews/#new-post" target="_blank"> Click Here to Rate it ★★★★★</a></p>
            </div>

    </div>
<?php

    }



/**
 * Register sections
 */
    // public function widgetkit_free_sections_with_ajax() {

    //     if( isset( $_POST['fields'] ) ) {
    //         parse_str( $_POST['fields'], $settings );
    //     }else {
    //         return;
    //     }

    //     $this->widgetkit_free_settings = array(
    //         // Slider Animation 
    //         'widget-slider-animation'     => intval( $settings['widget-slider-animation'] ? 1 : 0 ),
    //         // Slider Content Animation 
    //         'widget-slider-content-animation'  => intval( $settings['widget-slider-content-animation'] ? 1 : 0 ),
    //         // Slider Box Animation 
    //         'widget-slider-box-animation'  => intval( $settings['widget-slider-box-animation'] ? 1 : 0 ),


    //         // Portfolio
    //         'widget-portfolio'          => intval( $settings['widget-portfolio'] ? 1 : 0 ),
    //         // Feature section
    //         'widget-feature-box'        => intval( $settings['widget-feature-box'] ? 1 : 0 ),

    //         // Animation Text
    //         'widget-animation-text'     => intval( $settings['widget-animation-text'] ? 1 : 0 ),
    //         // Countdown
    //         'widget-countdown'          => intval( $settings['widget-countdown'] ? 1 : 0 ),


    //         // Pricing Single
    //         'widget-pricing-single'     => intval( $settings['widget-pricing-single'] ? 1 : 0 ),
    //         // Pricing Icon
    //         'widget-pricing-icon'       => intval( $settings['widget-pricing-icon'] ? 1 : 0 ),
    //         // Pricing Tab
    //         'widget-pricing-tab'        => intval( $settings['widget-pricing-tab'] ? 1 : 0 ),


    //         // Team Round
    //         'widget-team-round'         => intval( $settings['widget-team-round'] ? 1 : 0 ),
    //         // Team Animation
    //         'widget-team-animation'     => intval( $settings['widget-team-animation'] ? 1 : 0 ),
    //         // Team Verticle Icon
    //         'widget-team-verticle-icon' => intval( $settings['widget-team-verticle-icon'] ? 1 : 0 ),
    //         // Team Overlay
    //         'widget-team-overlay'       => intval( $settings['widget-team-overlay'] ? 1 : 0 ),


    //         // Button
    //         'widget-button'             => intval( $settings['widget-button'] ? 1 : 0 ),
    //         // Hover Image
    //         'widget-hover-image'        => intval( $settings['widget-hover-image'] ? 1 : 0 ),
    //         // Post Carousel
    //         'widget-post-carousel'      => intval( $settings['widget-post-carousel'] ? 1 : 0 ),


    //          // Blog Revert
    //         'widget-blog-revert'        => intval( $settings['widget-blog-revert'] ? 1 : 0 ),
    //         // Blog Hover Animation
    //         'widget-blog-hover-animation'     => intval( $settings['widget-blog-hover-animation'] ? 1 : 0 ),
    //         // Blog Image
    //         'widget-blog-image'          => intval( $settings['widget-blog-image'] ? 1 : 0 ),
    //         // Blog carousel
    //         'widget-blog-carousel'       => intval( $settings['widget-blog-carousel'] ? 1 : 0 ),
    //         // Blog Sidebar
    //         'widget-blog-sidebar'        => intval( $settings['widget-blog-sidebar'] ? 1 : 0 ),


    //         // Testimonial Single
    //         'widget-testimonial-single'  => intval( $settings['widget-testimonial-single'] ? 1 : 0 ),
    //         // Testimonial Center
    //         'widget-testimonial-center'   => intval( $settings['widget-testimonial-center'] ? 1 : 0 ),

    //         // Social Share Animation
    //         'widget-social-share-animation'  => intval( $settings['widget-social-share-animation'] ? 1 : 0 ),
    //         // Social Share collapse
    //         'widget-social-share-collapse'   => intval( $settings['widget-social-share-collapse'] ? 1 : 0 ),
    //     );
    //     update_option( 'widgetkit_free_save_settings', $this->widgetkit_free_settings );
        
    //     return true;
    //     die();


    // }


/**
 * Register sections
 */
    public function widgetkit_pro_sections_with_ajax() {

        if( isset( $_POST['fields'] ) ) {
            parse_str( $_POST['fields'], $settings );
        }else {
            return;
        }

        $this->widgetkit_pro_settings = array(
        	// Slider Animation 
            'Widget_Dynamic_Category_Tab'     => intval( $settings['Widget_Dynamic_Category_Tab'] ? 1 : 0 ),
            // Slider Content Animation 
            'Widget_Dynamic_Header_Tab'  => intval( $settings['Widget_Dynamic_Header_Tab'] ? 1 : 0 ),
            // Slider Box Animation 
            'Widget_Dynamic_Layout'  => intval( $settings['Widget_Dynamic_Layout'] ? 1 : 0 ),


            // Portfolio
            'Widget_Element_Title'          => intval( $settings['Widget_Element_Title'] ? 1 : 0 ),
            // Feature section
            'Widget_List_Layout'        => intval( $settings['Widget_List_Layout'] ? 1 : 0 ),

            // Animation Text
            'Widget_Multiple_Category_with_Dynamic_Carousel'     => intval( $settings['Widget_Multiple_Category_with_Dynamic_Carousel'] ? 1 : 0 ),
            // Countdown
            'Widget_News_Ticker'          => intval( $settings['Widget_News_Ticker'] ? 1 : 0 ),


            // Pricing Single
            'Widget_Posts_With_Load_More_Button'     => intval( $settings['Widget_Posts_With_Load_More_Button'] ? 1 : 0 ),
            // Pricing Icon
            'Widget_Recent_Post_Carousel'       => intval( $settings['Widget_Recent_Post_Carousel'] ? 1 : 0 ),
            // Pricing Tab
            'Widget_Recent_Post_Layout'        => intval( $settings['Widget_Recent_Post_Layout'] ? 1 : 0 ),


            // Team Round
            'Widget_Recent_Post_Slider'         => intval( $settings['Widget_Recent_Post_Slider'] ? 1 : 0 ),
            // Team Animation
            'Widget_Single_Category_Carousel'     => intval( $settings['Widget_Single_Category_Carousel'] ? 1 : 0 ),
            // Team Verticle Icon
            'Widget_Single_Category_Layout' => intval( $settings['Widget_Single_Category_Layout'] ? 1 : 0 ),
            // Team Overlay
            'Widget_Single_Category_with_Dynamic_Carousel'       => intval( $settings['Widget_Single_Category_with_Dynamic_Carousel'] ? 1 : 0 ),


            // Button
            'Widget_Single_Post_by_ID'             => intval( $settings['Widget_Single_Post_by_ID'] ? 1 : 0 ),
            // Hover Image
            'Widget_Social_Icon'        => intval( $settings['Widget_Social_Icon'] ? 1 : 0 ),
            // Post Carousel
            'Widget_Tab_Between_Two_Category'      => intval( $settings['Widget_Tab_Between_Two_Category'] ? 1 : 0 ),


             // Blog Revert
            'Widget_Tiles_Layout'        => intval( $settings['Widget_Tiles_Layout'] ? 1 : 0 ),
        );
        update_option( 'widgetkit_pro_save_settings', $this->widgetkit_pro_settings );
        
        return true;
        die();


    }

}


new Widgetkit_Pro_Admin;