<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Edumodo
 */

    // Global Options
    global $edumodo_options;
    // Prefix
    $prefix = '_edumodo_';
    $post_id = edumodo_get_id();

    // social enable
    $soical_enable = $edumodo_options['enable-social'];
    // Social url
    $facebook_url = $edumodo_options['facebook'];
    $twitter_url = $edumodo_options['twitter'];
    $instagram_url = $edumodo_options['instagram'];
    $linkedin_url = $edumodo_options['linkedin'];
    // $gogle_plus_url = $edumodo_options['gogle_plus'];
    $youtube_url = $edumodo_options['youtube'];
    $skype_url = $edumodo_options['skype'];
    $snapchat_url = $edumodo_options['snapchat'];
    $whatsapp_url = $edumodo_options['whatsapp'];

    // footer copyright
    $footer_option   = edumodo_array_get($edumodo_options, 'edumodo-footer-layout') ? $edumodo_options['edumodo-footer-layout'] : '';
    $edumodo_credit_switcher   = edumodo_array_get($edumodo_options, 'edumodo-credit-switcher') ? $edumodo_options['edumodo-credit-switcher'] : '';
    $edumodo_user_copyright_text   = edumodo_array_get($edumodo_options, 'edumodo-user-copyright-text') ? $edumodo_options['edumodo-user-copyright-text'] : '';


?>

    </div><!-- #content -->

                <?php ?>
                    <section id="footer" class="footer">
                        <div class="container">
                            <div class="row">
                                <div class="footer-sidebar-1">
                                    <div class="col-lg-12 center-widget">
                                        <div class="sidebar-king-body">

                                        <?php if(dynamic_sidebar('footer-sidebar-1')); ?>
                                            <?php if ($soical_enable == '1'):?>
                                                <div class="social-icon">
                                                    <?php if ($facebook_url):?>
                                                        <a class="facebook" target="_blank" href="<?php echo esc_url($facebook_url); ?>">
                                                            <i class="glyph-icon flaticon-facebook-logo"></i>
                                                        </a>
                                                    <?php endif; ?>

                                                    <?php if ($twitter_url):?>
                                                        <a class="twitter" target="_blank" href="<?php echo esc_url($twitter_url); ?>">
                                                            <i class="glyph-icon flaticon-twitter"></i>
                                                        </a>
                                                    <?php endif; ?>
    
                                                    <?php if ($instagram_url):?>
                                                        <a class="instagram" target="_blank" href="<?php echo esc_url($instagram_url); ?>">
                                                            <i class="glyph-icon flaticon-instagram-1"></i>
                                                        </a>
                                                    <?php endif; ?>

                                                    <?php if ($linkedin_url):?>
                                                        <a class="linkedin" target="_blank" href="<?php echo esc_url($linkedin_url); ?>">
                                                            <i class="glyph-icon flaticon-linkedin-logo"></i>
                                                        </a>
                                                    <?php endif; ?>

                                                    <?php if ($whatsapp_url):?>
                                                        <a class="whatsapp" target="_blank" href="<?php echo esc_url($whatsapp_url); ?>">
                                                            <i class="glyph-icon flaticon-whatsapp-logo"></i>
                                                        </a>
                                                    <?php endif; ?>

                                                    <?php if ($youtube_url):?>
                                                        <a class="youtube" target="_blank" href="<?php echo esc_url($youtube_url); ?>">
                                                            <i class="glyph-icon flaticon-youtube-logo"></i>
                                                        </a>
                                                    <?php endif; ?>

                                                    <?php if ($skype_url):?>
                                                        <a class="skype" target="_blank" href="<?php echo esc_url($skype_url); ?>">
                                                            <i class="glyph-icon flaticon-skype-logo"></i>
                                                        </a>
                                                    <?php endif; ?>

                                                    <?php if ($snapchat_url):?>
                                                        <a class="snapchat" target="_blank" href="<?php echo esc_url($snapchat_url); ?>">
                                                            <i class="glyph-icon flaticon-snapchat"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endif; ?>
                                            </div>
   
                            <div class="col-md-12 text-center">
                            <?php 
                                if ($edumodo_credit_switcher) : ?>

                                <div class="edumodo-credit-wrapper">
                                    <div class="copyright-info">
                                        <a href="<?php echo esc_url( __( 'https://wordpress.org/', 'edumodo' ) ); ?>"><?php printf( esc_html__( 'Proudly powered by %s', 'edumodo' ), 'WordPress' ); ?></a>
                                        <span class="sep"> | </span>
                                        <?php printf( esc_html__( 'Theme: %1$s by %2$s.', 'edumodo' ), 'edumodo', '<a href="https://themesgrove.com/">Themesgrove.com</a>' ); ?>
                                    </div><!-- .site-info -->
                                </div> 

                                <?php else : ?>
                                    <?php if ($edumodo_user_copyright_text): ?>
                                        <div class="user-credit">
                                            <?php echo wp_kses($edumodo_user_copyright_text, wp_kses_allowed_html('post')); ?>
                                        </div>       
                                    <?php endif ?>
                                <?php endif; ?>

                            </div><!-- .site-info -->

         
                                    </div><!--col-lg -->
                                </div> <!--end of footer-1-->
                            </div>   <!--end of row-->
                        </div>  <!--end of container-->
                    </section> <!-- end of footer section-->
                <?php //endif; ?>

                </div><!-- #page -->
                </div>  <!-- tx-site-content-inner -->
                </div>  <!-- tx-site-content -->
                </div>  <!-- tx-site-pusher -->
            </div>  <!-- tx-site-container -->
        <?php wp_footer(); ?>
    </body>
</html>
