<?php

/*

Plugin Name: Edumodo Recent Post
Plugin URI:https://www.themexpert.com/wordpress-plugins
Description:Recent Post widget to your theme
Version:1.0.0
Author:ThemeXpert
Author URI:https://www.themexpert.com

*/

class edumodo_recent_posts extends WP_Widget{
public	function __construct(){
		parent::__construct(false, $name=esc_html__('Edumodo Recent Post', 'edumodo'));

	}


function form( $instance ) {
       $defaults = array(
           'title' => '-1'
       );


     	if (isset( $instance[ 'title' ] )) {
		   $title = $instance[ 'title' ];
		}

		if ( isset($instance[ 'postno' ]) ) {
		   $postno = $instance[ 'postno' ];
		}

	    if ( isset($instance[ 'thumbWidth' ]) ) {
	       $thumbWidth = $instance[ 'thumbWidth' ];
	    }
		if ( isset($instance[ 'thumbHeight' ]) ) {
			$thumbHeight = $instance[ 'thumbHeight' ];
		}

       // markup for form 
       ?>
       <p>
           <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e('Title:', 'edumodo');?></label><br>
           <input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php if(isset($title)) echo esc_attr($title);?>">
        </p>
     	<p>
			<label for="<?php echo $this->get_field_id('postno');?>"><?php esc_html_e('No of post to show', 'edumodo')?> </label>
			<br>
			<input type="text" class="widefat"
			       id="<?php echo $this->get_field_id('postno');?>"
			       name="<?php echo $this->get_field_name('postno');?>"
			       value="<?php if(isset($postno)) echo esc_attr($postno);?>">
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('thumbWidth');?>"><?php echo esc_html__('Thumbnail width: in px (ex. 70px)', 'edumodo'); ?> </label>
			<br>
			<input type="text" class="widefat"
			       id="<?php echo $this->get_field_id('thumbWidth');?>"
			       name="<?php echo $this->get_field_name('thumbWidth');?>"
			       value="<?php if(isset($thumbWidth)) echo esc_attr($thumbWidth);?>">
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('thumbHeight');?>"><?php echo esc_html__('Thumbnail height: in px (ex. 70px)', 'edumodo'); ?> </label>
			<br>
			<input type="text" class="widefat"
			       id="<?php echo $this->get_field_id('thumbHeight');?>"
			       name="<?php echo $this->get_field_name('thumbHeight');?>"
			       value="<?php if(isset($thumbHeight)) echo esc_attr($thumbHeight);?>">
		</p>

   

       <?php
   }


public	function update( $new_instance, $old_instance){
	$instance = $old_instance;
	$instance['title'] = strip_tags($new_instance['title']);
	$instance['postno'] = strip_tags( $new_instance['postno'] );
    $instance['thumbWidth'] = $new_instance['thumbWidth'];
    $instance['thumbHeight'] = $new_instance['thumbHeight'];
	return $instance;

}

public	function widget($args, $instance){

extract($args);
extract($instance);


		?>

        <section class="widget edumodo-widget">
        	<h3 class="widget-title"><?php echo esc_html($instance['title']); ?></h3>

        	   <?php 
	        	    $height =   $thumbHeight;
			        $width =  $thumbWidth;
                    $query_args = array(
	                    'order'                 => 'order',
						'orderby'               => 'orderby',
						'posts_per_page'        => $instance['postno'],
						'ignore_sticky_posts'    => 1
                    );
                    $query = new Wp_Query($query_args);
                    while($query->have_posts()) : $query->the_post();
        	   ?>

	        	<div class="media">
					<div class="widget-img pull-left">
						<a href="<?php the_permalink(); ?>">
							<?php 
								// check if the post has a Post Thumbnail assigned to it.
								if ( has_post_thumbnail() ) {
									the_post_thumbnail(array($width, $height ));
								}
					        ?>
						</a>
					</div>
					<div class="blog-details media-body">
						<h6 class="post-heading"> 
						    <a href="<?php the_permalink();?>"> 
							  	<?php echo wp_trim_words( get_the_title(),4, "" ); // post title ?>
						    </a>
						</h6>

					    <div class="entry-meta">
							<?php echo date(get_option('date_format')); ?>
						</div><!-- .entry-meta -->
					</div>
				</div>
			<?php endwhile; wp_reset_postdata(); ?>
        </section>


	<?php

	}

}

add_action('widgets_init', function(){
	register_widget('edumodo_recent_posts');
})
?>